/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.network;

import com.mojang.logging.LogUtils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.z2six.featheredfriend.menu.SealBreakGate;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public record BreakSealPacket(int slotHint, long seed, String recipientUUID, String dateText, String senderName) implements CustomPacketPayload
{
    private static final Logger LOG = LogUtils.getLogger();
    public static final CustomPacketPayload.Type<BreakSealPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"break_seal"));
    public static final StreamCodec<RegistryFriendlyByteBuf, BreakSealPacket> STREAM_CODEC = StreamCodec.of(BreakSealPacket::encode, BreakSealPacket::decode);

    private static void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull BreakSealPacket p) {
        try {
            buf.writeVarInt(p.slotHint);
            buf.writeLong(p.seed);
            buf.writeUtf(p.recipientUUID != null ? p.recipientUUID : "", 256);
            buf.writeUtf(p.dateText != null ? p.dateText : "", 512);
            buf.writeUtf(p.senderName != null ? p.senderName : "", 256);
        }
        catch (Throwable t) {
            LOG.error("[BreakSealPacket] encode failed", t);
        }
    }

    @NotNull
    private static BreakSealPacket decode(@NotNull RegistryFriendlyByteBuf buf) {
        try {
            int slotHint = buf.readVarInt();
            long seed = buf.readLong();
            String recUuid = buf.readUtf(256);
            String date = buf.readUtf(512);
            String sender = buf.readUtf(256);
            return new BreakSealPacket(slotHint, seed, recUuid, date, sender);
        }
        catch (Throwable t) {
            LOG.error("[BreakSealPacket] decode failed; returning safe defaults", t);
            return new BreakSealPacket(-1, 0L, "", "", "");
        }
    }

    @NotNull
    public CustomPacketPayload.Type<BreakSealPacket> type() {
        return TYPE;
    }

    public static void handle(@NotNull BreakSealPacket p, @NotNull ServerPlayer serverPlayer) {
        try {
            boolean replaced;
            if (serverPlayer == null) {
                LOG.error("[BreakSealPacket] handle: serverPlayer is null");
                return;
            }
            LOG.info("[BreakSealPacket] handle: player={} slotHint={} seed={} recipientUUID='{}' date='{}' sender='{}'", new Object[]{serverPlayer.getGameProfile().getName(), p.slotHint(), p.seed(), BreakSealPacket.safeLog(p.recipientUUID()), BreakSealPacket.safeLog(p.dateText()), BreakSealPacket.safeLog(p.senderName())});
            AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
            if (!(abstractContainerMenu instanceof SealBreakGate)) {
                LOG.warn("[BreakSealPacket] handle: player {} containerMenu does not implement SealBreakGate (is {}); ignoring", (Object)serverPlayer.getGameProfile().getName(), (Object)(serverPlayer.containerMenu != null ? serverPlayer.containerMenu.getClass().getName() : "null"));
                return;
            }
            SealBreakGate sealGate = (SealBreakGate)abstractContainerMenu;
            IdentifiedStack target = BreakSealPacket.findTargetSealedScroll(serverPlayer, p);
            if (target == null) {
                LOG.warn("[BreakSealPacket] handle: could not find matching sealed scroll for player {}; ignoring", (Object)serverPlayer.getGameProfile().getName());
                return;
            }
            LOG.info("[BreakSealPacket] handle: matched sealed scroll at {} (item={})", (Object)target.locationDescription, (Object)BuiltInRegistries.ITEM.getKey((Object)target.stack.getItem()));
            Item openedItem = BreakSealPacket.resolveItemByPath("scroll_opened");
            Item sealedItem = BreakSealPacket.resolveItemByPath("scroll_sealed");
            if (openedItem == null || openedItem == Items.AIR) {
                LOG.error("[BreakSealPacket] scroll_opened not found in registry; aborting conversion");
                return;
            }
            if (sealedItem == null || sealedItem == Items.AIR) {
                LOG.error("[BreakSealPacket] scroll_sealed not found in registry; aborting conversion");
                return;
            }
            if (target.stack.getItem() != sealedItem) {
                LOG.warn("[BreakSealPacket] Matched stack item is not scroll_sealed (got {}); aborting conversion", (Object)BuiltInRegistries.ITEM.getKey((Object)target.stack.getItem()));
                return;
            }
            ItemStack opened = new ItemStack((ItemLike)openedItem, 1);
            boolean copied = BreakSealPacket.copySealedScrollDataWithoutAttachments(target.stack, opened);
            if (!copied) {
                LOG.warn("[BreakSealPacket] Failed to copy SealedScroll data (without attachments). Proceeding with opened scroll anyway.");
            }
            if (!(replaced = BreakSealPacket.replaceStackAtLocation(serverPlayer, target, opened))) {
                LOG.error("[BreakSealPacket] Failed to replace sealed scroll with opened scroll at {}; aborting", (Object)target.locationDescription);
                return;
            }
            try {
                sealGate.markSealBroken("BreakSealPacket");
            }
            catch (Throwable tMark) {
                LOG.error("[BreakSealPacket] Failed to mark SealBreakGate seal broken; attachments may not deliver", tMark);
            }
            LOG.info("[BreakSealPacket] Conversion complete for player {}: scroll_sealed -> scroll_opened at {}", (Object)serverPlayer.getGameProfile().getName(), (Object)target.locationDescription);
        }
        catch (Throwable t) {
            LOG.error("[BreakSealPacket] handle failed", t);
        }
    }

    private static IdentifiedStack findTargetSealedScroll(@NotNull ServerPlayer player, @NotNull BreakSealPacket p) {
        try {
            Item sealedItem = BreakSealPacket.resolveItemByPath("scroll_sealed");
            if (sealedItem == null || sealedItem == Items.AIR) {
                LOG.error("[BreakSealPacket] findTargetSealedScroll: scroll_sealed not found");
                return null;
            }
            IdentifiedStack hinted = BreakSealPacket.findBySlotHint(player, p, sealedItem);
            if (hinted != null) {
                return hinted;
            }
            IdentifiedStack scanned = BreakSealPacket.scanAllForFingerprint(player, p, sealedItem);
            if (scanned != null) {
                return scanned;
            }
            return null;
        }
        catch (Throwable t) {
            LOG.error("[BreakSealPacket] findTargetSealedScroll failed", t);
            return null;
        }
    }

    private static IdentifiedStack findBySlotHint(@NotNull ServerPlayer player, @NotNull BreakSealPacket p, @NotNull Item sealedItem) {
        try {
            int hint = p.slotHint();
            if (hint == 36) {
                ItemStack s = player.getMainHandItem();
                if (BreakSealPacket.matchesFingerprintSealedScroll(s, p, sealedItem)) {
                    return new IdentifiedStack(s, Location.MAIN_HAND, -1, "MAIN_HAND(36)");
                }
                LOG.debug("[BreakSealPacket] Slot hint MAIN_HAND did not match fingerprint");
                return null;
            }
            if (hint == 37) {
                ItemStack s = player.getOffhandItem();
                if (BreakSealPacket.matchesFingerprintSealedScroll(s, p, sealedItem)) {
                    return new IdentifiedStack(s, Location.OFF_HAND, -1, "OFF_HAND(37)");
                }
                LOG.debug("[BreakSealPacket] Slot hint OFF_HAND did not match fingerprint");
                return null;
            }
            if (hint >= 0 && hint < player.getInventory().items.size()) {
                ItemStack s = (ItemStack)player.getInventory().items.get(hint);
                if (BreakSealPacket.matchesFingerprintSealedScroll(s, p, sealedItem)) {
                    return new IdentifiedStack(s, Location.INVENTORY, hint, "INVENTORY(" + hint + ")");
                }
                LOG.debug("[BreakSealPacket] Slot hint INVENTORY({}) did not match fingerprint", (Object)hint);
                return null;
            }
            return null;
        }
        catch (Throwable t) {
            LOG.error("[BreakSealPacket] findBySlotHint failed", t);
            return null;
        }
    }

    private static IdentifiedStack scanAllForFingerprint(@NotNull ServerPlayer player, @NotNull BreakSealPacket p, @NotNull Item sealedItem) {
        try {
            ItemStack main = player.getMainHandItem();
            if (BreakSealPacket.matchesFingerprintSealedScroll(main, p, sealedItem)) {
                return new IdentifiedStack(main, Location.MAIN_HAND, -1, "MAIN_HAND(scan)");
            }
            ItemStack off = player.getOffhandItem();
            if (BreakSealPacket.matchesFingerprintSealedScroll(off, p, sealedItem)) {
                return new IdentifiedStack(off, Location.OFF_HAND, -1, "OFF_HAND(scan)");
            }
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                ItemStack s = (ItemStack)player.getInventory().items.get(i);
                if (!BreakSealPacket.matchesFingerprintSealedScroll(s, p, sealedItem)) continue;
                return new IdentifiedStack(s, Location.INVENTORY, i, "INVENTORY(scan:" + i + ")");
            }
            return null;
        }
        catch (Throwable t) {
            LOG.error("[BreakSealPacket] scanAllForFingerprint failed", t);
            return null;
        }
    }

    private static boolean matchesFingerprintSealedScroll(@NotNull ItemStack stack, @NotNull BreakSealPacket p, @NotNull Item sealedItem) {
        try {
            boolean ok;
            if (stack.isEmpty()) {
                return false;
            }
            if (stack.getItem() != sealedItem) {
                return false;
            }
            CustomData cd = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag root = cd.copyTag();
            if (root == null || root.isEmpty()) {
                return false;
            }
            if (!root.contains("SealedScroll", 10)) {
                return false;
            }
            CompoundTag seal = root.getCompound("SealedScroll");
            long seed = 0L;
            try {
                if (seal.contains("Seed")) {
                    seed = seal.getLong("Seed");
                }
            }
            catch (Throwable ignored) {
                seed = 0L;
            }
            String recUuid = "";
            String dateText = "";
            String senderName = "";
            try {
                if (seal.contains("RecipientUUID")) {
                    recUuid = seal.getString("RecipientUUID");
                }
            }
            catch (Throwable ignored) {
                recUuid = "";
            }
            try {
                if (seal.contains("DateText")) {
                    dateText = seal.getString("DateText");
                }
            }
            catch (Throwable ignored) {
                dateText = "";
            }
            try {
                if (seal.contains("SenderName")) {
                    senderName = seal.getString("SenderName");
                }
            }
            catch (Throwable ignored) {
                senderName = "";
            }
            boolean bl = ok = seed == p.seed() && BreakSealPacket.safeEq(recUuid, p.recipientUUID()) && BreakSealPacket.safeEq(dateText, p.dateText()) && BreakSealPacket.safeEq(senderName, p.senderName());
            if (!ok) {
                LOG.debug("[BreakSealPacket] Fingerprint mismatch on candidate stack: seed={} recUuid='{}' date='{}' sender='{}' vs packet seed={} recUuid='{}' date='{}' sender='{}'", new Object[]{seed, BreakSealPacket.safeLog(recUuid), BreakSealPacket.safeLog(dateText), BreakSealPacket.safeLog(senderName), p.seed(), BreakSealPacket.safeLog(p.recipientUUID()), BreakSealPacket.safeLog(p.dateText()), BreakSealPacket.safeLog(p.senderName())});
            }
            return ok;
        }
        catch (Throwable t) {
            LOG.error("[BreakSealPacket] matchesFingerprintSealedScroll failed", t);
            return false;
        }
    }

    private static boolean replaceStackAtLocation(@NotNull ServerPlayer player, @NotNull IdentifiedStack identified, @NotNull ItemStack replacement) {
        try {
            if (replacement.isEmpty()) {
                LOG.error("[BreakSealPacket] replaceStackAtLocation: replacement is EMPTY; refusing");
                return false;
            }
            switch (identified.location.ordinal()) {
                case 0: {
                    player.setItemInHand(InteractionHand.MAIN_HAND, replacement);
                    return true;
                }
                case 1: {
                    player.setItemInHand(InteractionHand.OFF_HAND, replacement);
                    return true;
                }
                case 2: {
                    int idx = identified.invIndex;
                    if (idx < 0 || idx >= player.getInventory().items.size()) {
                        LOG.error("[BreakSealPacket] replaceStackAtLocation: invalid inventory index {}", (Object)idx);
                        return false;
                    }
                    player.getInventory().items.set(idx, (Object)replacement);
                    return true;
                }
            }
            LOG.error("[BreakSealPacket] replaceStackAtLocation: unknown location {}", (Object)identified.location);
            return false;
        }
        catch (Throwable t) {
            LOG.error("[BreakSealPacket] replaceStackAtLocation failed", t);
            return false;
        }
    }

    private static boolean copySealedScrollDataWithoutAttachments(@NotNull ItemStack sealed, @NotNull ItemStack opened) {
        try {
            CustomData sealedCd = (CustomData)sealed.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag sealedRoot = sealedCd.copyTag();
            if (sealedRoot == null || sealedRoot.isEmpty()) {
                LOG.warn("[BreakSealPacket] Sealed stack has no CUSTOM_DATA; nothing to copy");
                return false;
            }
            if (!sealedRoot.contains("SealedScroll", 10)) {
                LOG.warn("[BreakSealPacket] Sealed stack CUSTOM_DATA missing SealedScroll; nothing to copy");
                return false;
            }
            CompoundTag sealedSeal = sealedRoot.getCompound("SealedScroll");
            if (sealedSeal == null) {
                LOG.warn("[BreakSealPacket] SealedScroll compound is null; nothing to copy");
                return false;
            }
            CompoundTag openedRoot = new CompoundTag();
            CompoundTag openedSeal = sealedSeal.copy();
            if (openedSeal.contains("Attachments")) {
                try {
                    openedSeal.remove("Attachments");
                    LOG.info("[BreakSealPacket] Removed Attachments from opened scroll SealedScroll compound");
                }
                catch (Throwable tRem) {
                    LOG.error("[BreakSealPacket] Failed to remove Attachments key from SealedScroll copy", tRem);
                }
            }
            openedRoot.put("SealedScroll", (Tag)openedSeal);
            opened.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)openedRoot));
            LOG.debug("[BreakSealPacket] Copied SealedScroll data (without attachments) onto opened scroll");
            return true;
        }
        catch (Throwable t) {
            LOG.error("[BreakSealPacket] copySealedScrollDataWithoutAttachments failed", t);
            return false;
        }
    }

    private static Item resolveItemByPath(@NotNull String path) {
        try {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)path);
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            if (item == null) {
                LOG.error("[BreakSealPacket] resolveItemByPath: item {} is null", (Object)id);
                return Items.AIR;
            }
            if (item == Items.AIR) {
                LOG.warn("[BreakSealPacket] resolveItemByPath: item {} returned as AIR", (Object)id);
            }
            return item;
        }
        catch (Throwable t) {
            LOG.error("[BreakSealPacket] resolveItemByPath failed for path='{}'", (Object)path, (Object)t);
            return Items.AIR;
        }
    }

    private static boolean safeEq(String a, String b) {
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        return a.equals(b);
    }

    private static String safeLog(String s) {
        if (s == null) {
            return "null";
        }
        if (s.length() <= 120) {
            return s;
        }
        return s.substring(0, 120) + "...";
    }

    private static final class IdentifiedStack {
        final ItemStack stack;
        final Location location;
        final int invIndex;
        final String locationDescription;

        IdentifiedStack(ItemStack stack, Location location, int invIndex, String desc) {
            this.stack = stack;
            this.location = location;
            this.invIndex = invIndex;
            this.locationDescription = desc;
        }
    }

    private static enum Location {
        MAIN_HAND,
        OFF_HAND,
        INVENTORY;

    }
}

