/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.neoforge.menu;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.z2six.featheredfriend.menu.SealBreakGate;
import net.z2six.featheredfriend.registry.FFNeoForgeMenus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ScrollViewMenu
extends AbstractContainerMenu
implements SealBreakGate {
    private static final Logger LOG = LogUtils.getLogger();
    private static final int ATTACHMENT_SLOT_COUNT = 9;
    public static final int ATTACHMENT_START = 0;
    public static final int ATTACHMENT_END = 8;
    public static final int PLAYER_INV_START = 9;
    public static final int PLAYER_INV_END = 35;
    public static final int HOTBAR_START = 36;
    public static final int HOTBAR_END = 44;
    private final Inventory playerInventory;
    private final List<ItemStack> attachmentSnapshot = new ArrayList<ItemStack>();
    private boolean attachmentSnapshotLoaded = false;
    private final Container attachmentContainer = new SimpleContainer(9);
    private boolean attachmentsDeliveredThisSession = false;
    private ItemStack sourceScrollStackSnapshot = ItemStack.EMPTY;
    private boolean sealBrokenThisSession = false;

    public ScrollViewMenu(int containerId, @NotNull Inventory playerInventory) {
        super(FFNeoForgeMenus.SCROLL_VIEW_MENU.get(), containerId);
        int y;
        int x;
        this.playerInventory = playerInventory;
        String playerName = "unknown";
        boolean clientSide = true;
        try {
            if (playerInventory.player != null) {
                playerName = playerInventory.player.getGameProfile().getName();
                clientSide = playerInventory.player.level().isClientSide;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOG.info("[ScrollViewMenu] Constructed containerId={} player={} side={}", new Object[]{containerId, playerName, clientSide ? "CLIENT" : "SERVER"});
        for (int i = 0; i < 9; ++i) {
            x = 8 + i * 18;
            y = 17;
            this.addSlot(new Slot(this.attachmentContainer, i, x, y){

                public boolean mayPlace(@NotNull ItemStack stack) {
                    return false;
                }

                public boolean mayPickup(@NotNull Player player) {
                    return player != null && !player.level().isClientSide && ScrollViewMenu.this.sealBrokenThisSession;
                }
            });
        }
        for (int row = 0; row < 3; ++row) {
            int y2 = 49 + row * 18;
            for (int col = 0; col < 9; ++col) {
                int index = col + row * 9 + 9;
                int x2 = 8 + col * 18;
                this.addSlot(new Slot((Container)playerInventory, index, x2, y2));
            }
        }
        for (int col = 0; col < 9; ++col) {
            x = 8 + col * 18;
            y = 107;
            this.addSlot(new Slot((Container)playerInventory, col, x, y));
        }
        LOG.debug("[ScrollViewMenu] Slot layout: attachment[{}..{}], inv[{}..{}], hotbar[{}..{}]", new Object[]{0, 8, 9, 35, 36, 44});
        try {
            if (playerInventory.player != null && !playerInventory.player.level().isClientSide) {
                this.loadAttachmentSnapshotFromHeldScroll(playerInventory.player);
                this.syncContainerFromSnapshot();
            } else {
                LOG.info("[ScrollViewMenu] Constructor: skipping snapshot load (client-side or null player)");
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewMenu] Constructor snapshot load failed", t);
        }
    }

    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    public Container getAttachmentContainer() {
        return this.attachmentContainer;
    }

    public boolean hasAnyAttachmentsInContainer() {
        try {
            for (int i = 0; i < 9; ++i) {
                ItemStack s = this.attachmentContainer.getItem(i);
                if (s == null || s.isEmpty()) continue;
                return true;
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewMenu] hasAnyAttachmentsInContainer failed", t);
        }
        return false;
    }

    @Override
    public void markSealBroken(@NotNull String reason) {
        try {
            if (this.sealBrokenThisSession) {
                LOG.debug("[ScrollViewMenu] markSealBroken: already true; ignoring (reason={}) containerId={}", (Object)reason, (Object)this.containerId);
                return;
            }
            this.sealBrokenThisSession = true;
            LOG.info("[ScrollViewMenu] Seal marked broken (reason={}) containerId={} player={}", new Object[]{reason, this.containerId, this.playerInventory != null && this.playerInventory.player != null ? ScrollViewMenu.safePlayerName(this.playerInventory.player) : "null"});
            try {
                this.syncContainerFromSnapshot();
            }
            catch (Throwable syncErr) {
                LOG.error("[ScrollViewMenu] markSealBroken: syncContainerFromSnapshot failed", syncErr);
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewMenu] markSealBroken failed", t);
        }
    }

    public boolean stillValid(@NotNull Player player) {
        boolean valid;
        boolean bl = valid = player != null && !player.isRemoved();
        if (!valid) {
            LOG.info("[ScrollViewMenu] stillValid=false (player null/removed) containerId={}", (Object)this.containerId);
        }
        return valid;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        try {
            ItemStack empty = ItemStack.EMPTY;
            if (player == null) {
                LOG.warn("[ScrollViewMenu] quickMoveStack: player is null");
                return empty;
            }
            if (!this.sealBrokenThisSession) {
                LOG.debug("[ScrollViewMenu] quickMoveStack: seal not broken -> ignore index={}", (Object)index);
                return empty;
            }
            if (index < 0 || index >= this.slots.size()) {
                LOG.warn("[ScrollViewMenu] quickMoveStack: index {} outside slots size {}", (Object)index, (Object)this.slots.size());
                return empty;
            }
            Slot slot = (Slot)this.slots.get(index);
            if (slot == null || !slot.hasItem()) {
                return empty;
            }
            ItemStack stackInSlot = slot.getItem();
            ItemStack original = stackInSlot.copy();
            if (index >= 0 && index <= 8) {
                if (!this.moveItemStackTo(stackInSlot, 9, 45, true)) {
                    return empty;
                }
                try {
                    this.syncSnapshotFromContainer();
                }
                catch (Throwable syncErr) {
                    LOG.error("[ScrollViewMenu] quickMoveStack: syncSnapshotFromContainer failed", syncErr);
                }
            } else {
                return empty;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            slot.onTake(player, stackInSlot);
            return original;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewMenu] quickMoveStack failed (index={})", (Object)index, (Object)t);
            return ItemStack.EMPTY;
        }
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        try {
            if (player == null) {
                LOG.warn("[ScrollViewMenu] removed: player is null (containerId={})", (Object)this.containerId);
                return;
            }
            boolean clientSide = player.level().isClientSide;
            LOG.info("[ScrollViewMenu] removed() fired containerId={} player={} side={} sealBroken={} deliveredAlready={} snapshotLoaded={} snapshotSize={} carriedEmpty={}", new Object[]{this.containerId, ScrollViewMenu.safePlayerName(player), clientSide ? "CLIENT" : "SERVER", this.sealBrokenThisSession, this.attachmentsDeliveredThisSession, this.attachmentSnapshotLoaded, this.attachmentSnapshot.size(), this.getCarried().isEmpty()});
            if (clientSide) {
                return;
            }
            if (!this.sealBrokenThisSession) {
                LOG.info("[ScrollViewMenu] removed: seal not broken -> skipping attachment delivery containerId={} player={}", (Object)this.containerId, (Object)ScrollViewMenu.safePlayerName(player));
                this.attachmentSnapshot.clear();
                this.clearAttachmentContainerServerSide();
                return;
            }
            if (this.attachmentsDeliveredThisSession) {
                LOG.info("[ScrollViewMenu] removed: already delivered this session -> skip (containerId={})", (Object)this.containerId);
                this.attachmentSnapshot.clear();
                this.clearAttachmentContainerServerSide();
                return;
            }
            this.attachmentsDeliveredThisSession = true;
            if (!this.attachmentSnapshotLoaded) {
                LOG.info("[ScrollViewMenu] removed: late snapshot load attempt (containerId={})", (Object)this.containerId);
                this.loadAttachmentSnapshotFromHeldScroll(player);
                this.syncContainerFromSnapshot();
            }
            try {
                this.syncSnapshotFromContainer();
            }
            catch (Throwable syncErr) {
                LOG.error("[ScrollViewMenu] removed: syncSnapshotFromContainer failed", syncErr);
            }
            if (this.attachmentSnapshot.isEmpty()) {
                LOG.info("[ScrollViewMenu] removed: no attachments to deliver (containerId={})", (Object)this.containerId);
                this.clearAttachmentContainerServerSide();
                return;
            }
            int attemptedStacks = 0;
            int fullyAddedStacks = 0;
            int droppedStacks = 0;
            for (int i = 0; i < this.attachmentSnapshot.size(); ++i) {
                ItemStack stack = this.attachmentSnapshot.get(i);
                if (stack == null || stack.isEmpty()) continue;
                ++attemptedStacks;
                ItemStack remaining = stack.copy();
                LOG.info("[ScrollViewMenu] Deliver attempt i={} -> {} x{}", new Object[]{i, BuiltInRegistries.ITEM.getKey((Object)remaining.getItem()), remaining.getCount()});
                boolean addedAll = ScrollViewMenu.tryAddWholeStack(player, remaining);
                if (addedAll) {
                    ++fullyAddedStacks;
                    LOG.info("[ScrollViewMenu] Deliver success i={} -> added to inventory: {} x{}", new Object[]{i, BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), stack.getCount()});
                    continue;
                }
                if (!remaining.isEmpty()) {
                    boolean dropped = ScrollViewMenu.dropOrSpawnAtPlayer(player, remaining);
                    if (dropped) {
                        ++droppedStacks;
                        LOG.info("[ScrollViewMenu] Deliver fallback i={} -> dropped remainder: {} x{}", new Object[]{i, BuiltInRegistries.ITEM.getKey((Object)remaining.getItem()), remaining.getCount()});
                        continue;
                    }
                    LOG.warn("[ScrollViewMenu] Deliver fallback i={} -> FAILED to drop remainder: {} x{} (lost unless another system recovers it)", new Object[]{i, BuiltInRegistries.ITEM.getKey((Object)remaining.getItem()), remaining.getCount()});
                    continue;
                }
                ++fullyAddedStacks;
                LOG.info("[ScrollViewMenu] Deliver partial i={} -> remainder empty; effectively fully added", (Object)i);
            }
            LOG.info("[ScrollViewMenu] removed: attemptedStacks={} fullyAddedStacks={} droppedStacks={} player={} sourceScrollItem={} containerId={}", new Object[]{attemptedStacks, fullyAddedStacks, droppedStacks, ScrollViewMenu.safePlayerName(player), !this.sourceScrollStackSnapshot.isEmpty() ? BuiltInRegistries.ITEM.getKey((Object)this.sourceScrollStackSnapshot.getItem()) : "none", this.containerId});
            this.attachmentSnapshot.clear();
            this.clearAttachmentContainerServerSide();
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewMenu] removed failed", t);
        }
    }

    private void syncContainerFromSnapshot() {
        try {
            for (int i = 0; i < 9; ++i) {
                ItemStack snap;
                ItemStack s = ItemStack.EMPTY;
                if (i < this.attachmentSnapshot.size() && (snap = this.attachmentSnapshot.get(i)) != null && !snap.isEmpty()) {
                    s = snap.copy();
                }
                this.attachmentContainer.setItem(i, s);
            }
            if (this.attachmentSnapshot.size() > 9) {
                LOG.warn("[ScrollViewMenu] syncContainerFromSnapshot: snapshotSize={} > {} (extra attachments hidden but preserved for delivery-on-close)", (Object)this.attachmentSnapshot.size(), (Object)9);
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewMenu] syncContainerFromSnapshot failed", t);
        }
    }

    private void syncSnapshotFromContainer() {
        try {
            if (!this.attachmentSnapshotLoaded) {
                this.attachmentSnapshotLoaded = true;
            }
            for (int i = 0; i < 9; ++i) {
                ItemStack newVal;
                ItemStack c = this.attachmentContainer.getItem(i);
                ItemStack itemStack = newVal = c != null && !c.isEmpty() ? c.copy() : ItemStack.EMPTY;
                if (i < this.attachmentSnapshot.size()) {
                    this.attachmentSnapshot.set(i, newVal);
                    continue;
                }
                this.attachmentSnapshot.add(newVal);
            }
            ArrayList<ItemStack> rebuilt = new ArrayList<ItemStack>(this.attachmentSnapshot.size());
            for (int i = 0; i < this.attachmentSnapshot.size(); ++i) {
                ItemStack s = this.attachmentSnapshot.get(i);
                if (s == null || s.isEmpty()) continue;
                rebuilt.add(s);
            }
            this.attachmentSnapshot.clear();
            this.attachmentSnapshot.addAll(rebuilt);
            LOG.debug("[ScrollViewMenu] syncSnapshotFromContainer: snapshotSize now {}", (Object)this.attachmentSnapshot.size());
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewMenu] syncSnapshotFromContainer failed", t);
        }
    }

    private void clearAttachmentContainerServerSide() {
        try {
            for (int i = 0; i < 9; ++i) {
                this.attachmentContainer.setItem(i, ItemStack.EMPTY);
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewMenu] clearAttachmentContainerServerSide failed", t);
        }
    }

    private void loadAttachmentSnapshotFromHeldScroll(@NotNull Player player) {
        try {
            this.attachmentSnapshot.clear();
            this.attachmentSnapshotLoaded = true;
            ItemStack hand = player.getMainHandItem();
            if (hand == null || hand.isEmpty()) {
                hand = player.getOffhandItem();
            }
            if (hand == null || hand.isEmpty()) {
                LOG.info("[ScrollViewMenu] Snapshot load: both hands empty (containerId={})", (Object)this.containerId);
                this.sourceScrollStackSnapshot = ItemStack.EMPTY;
                return;
            }
            this.sourceScrollStackSnapshot = hand.copy();
            LOG.info("[ScrollViewMenu] Snapshot load: reading from hand item={} count={} containerId={}", new Object[]{BuiltInRegistries.ITEM.getKey((Object)hand.getItem()), hand.getCount(), this.containerId});
            CustomData customData = (CustomData)hand.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag root = customData.copyTag();
            if (root == null || root.isEmpty()) {
                LOG.info("[ScrollViewMenu] Snapshot load: CUSTOM_DATA root missing/empty");
                return;
            }
            if (!root.contains("SealedScroll", 10)) {
                LOG.info("[ScrollViewMenu] Snapshot load: SealedScroll compound missing");
                return;
            }
            CompoundTag seal = root.getCompound("SealedScroll");
            if (!seal.contains("Attachments", 9)) {
                LOG.info("[ScrollViewMenu] Snapshot load: Attachments list missing");
                return;
            }
            ListTag list = seal.getList("Attachments", 10);
            if (list == null || list.isEmpty()) {
                LOG.info("[ScrollViewMenu] Snapshot load: Attachments list empty");
                return;
            }
            int parsed = 0;
            for (int i = 0; i < list.size(); ++i) {
                ItemStack rebuilt;
                CompoundTag stackTag = list.getCompound(i);
                if (stackTag == null || stackTag.isEmpty() || (rebuilt = ScrollViewMenu.rebuildStackFromAttachmentTag(stackTag)).isEmpty()) continue;
                this.attachmentSnapshot.add(rebuilt);
                ++parsed;
                LOG.info("[ScrollViewMenu] Snapshot load: parsed i={} -> {} x{} hasCustomData={}", new Object[]{i, BuiltInRegistries.ITEM.getKey((Object)rebuilt.getItem()), rebuilt.getCount(), rebuilt.has(DataComponents.CUSTOM_DATA)});
            }
            LOG.info("[ScrollViewMenu] Snapshot load complete: parsed={} snapshotSize={} containerId={}", new Object[]{parsed, this.attachmentSnapshot.size(), this.containerId});
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewMenu] loadAttachmentSnapshotFromHeldScroll failed", t);
        }
    }

    @NotNull
    private static ItemStack rebuildStackFromAttachmentTag(@NotNull CompoundTag tag) {
        try {
            if (!tag.contains("id")) {
                return ItemStack.EMPTY;
            }
            String idStr = tag.getString("id");
            if (idStr == null || idStr.isBlank()) {
                return ItemStack.EMPTY;
            }
            ResourceLocation id = ResourceLocation.tryParse((String)idStr);
            if (id == null) {
                LOG.warn("[ScrollViewMenu] rebuildStackFromAttachmentTag: invalid item id '{}'", (Object)idStr);
                return ItemStack.EMPTY;
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            if (item == null || item == Items.AIR) {
                LOG.warn("[ScrollViewMenu] rebuildStackFromAttachmentTag: item '{}' not found (AIR); skipping", (Object)id);
                return ItemStack.EMPTY;
            }
            int count = 1;
            try {
                if (tag.contains("Count")) {
                    count = tag.getInt("Count");
                }
            }
            catch (Throwable ignored) {
                count = 1;
            }
            if (count <= 0) {
                count = 1;
            }
            ItemStack stack = new ItemStack((ItemLike)item, count);
            try {
                CompoundTag cd;
                if (tag.contains("CustomData", 10) && (cd = tag.getCompound("CustomData")) != null && !cd.isEmpty()) {
                    stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)cd.copy()));
                }
            }
            catch (Throwable tCd) {
                LOG.error("[ScrollViewMenu] rebuildStackFromAttachmentTag: failed to apply CustomData for item '{}'", (Object)id, (Object)tCd);
            }
            return stack;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewMenu] rebuildStackFromAttachmentTag failed", t);
            return ItemStack.EMPTY;
        }
    }

    private static boolean tryAddWholeStack(@NotNull Player player, @NotNull ItemStack stack) {
        try {
            if (stack.isEmpty()) {
                return true;
            }
            boolean addedSome = player.addItem(stack);
            if (!addedSome) {
                LOG.info("[ScrollViewMenu] tryAddWholeStack: inventory rejected entire stack: {} x{}", (Object)BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), (Object)stack.getCount());
                return false;
            }
            if (stack.isEmpty()) {
                return true;
            }
            LOG.info("[ScrollViewMenu] tryAddWholeStack: partial insert, remainder now {} x{}", (Object)BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), (Object)stack.getCount());
            return false;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewMenu] tryAddWholeStack failed; leaving stack as remainder to be dropped", t);
            return false;
        }
    }

    private static boolean dropOrSpawnAtPlayer(@NotNull Player player, @NotNull ItemStack stack) {
        try {
            if (stack.isEmpty()) {
                return true;
            }
            ItemEntity ent = null;
            try {
                ent = player.drop(stack, false);
            }
            catch (Throwable tDrop) {
                LOG.error("[ScrollViewMenu] player.drop failed; will attempt manual spawn", tDrop);
                ent = null;
            }
            if (ent != null) {
                LOG.info("[ScrollViewMenu] dropOrSpawnAtPlayer: dropped via player.drop entityId={} {} x{}", new Object[]{ent.getId(), BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), stack.getCount()});
                return true;
            }
            return ScrollViewMenu.spawnItemEntityAtPlayer(player, stack);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewMenu] dropOrSpawnAtPlayer failed", t);
            return false;
        }
    }

    private static boolean spawnItemEntityAtPlayer(@NotNull Player player, @NotNull ItemStack stack) {
        try {
            if (stack.isEmpty()) {
                return true;
            }
            Level level = player.level();
            if (level == null) {
                return false;
            }
            ItemEntity ent = new ItemEntity(level, player.getX(), player.getY() + 0.5, player.getZ(), stack);
            try {
                ent.setNoPickUpDelay();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            boolean ok = level.addFreshEntity((Entity)ent);
            if (!ok) {
                LOG.warn("[ScrollViewMenu] spawnItemEntityAtPlayer: addFreshEntity returned false for {} x{}", (Object)BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), (Object)stack.getCount());
            } else {
                LOG.info("[ScrollViewMenu] spawnItemEntityAtPlayer: spawned entityId={} {} x{}", new Object[]{ent.getId(), BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), stack.getCount()});
            }
            return ok;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewMenu] spawnItemEntityAtPlayer failed", t);
            return false;
        }
    }

    @NotNull
    private static String safePlayerName(@NotNull Player player) {
        try {
            return player.getGameProfile().getName();
        }
        catch (Throwable t) {
            return "unknown";
        }
    }
}

