/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.neoforge.menu;

import com.mojang.logging.LogUtils;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.z2six.featheredfriend.menu.ScrollAttachmentProvider;
import net.z2six.featheredfriend.registry.FFNeoForgeMenus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ScrollSealingMenu
extends AbstractContainerMenu
implements ScrollAttachmentProvider {
    private static final Logger LOG = LogUtils.getLogger();
    private static final int ATTACHMENT_SLOT_COUNT = 9;
    public static final int ATTACHMENT_START = 0;
    public static final int ATTACHMENT_END = 8;
    public static final int PLAYER_INV_START = 9;
    public static final int PLAYER_INV_END = 35;
    public static final int HOTBAR_START = 36;
    public static final int HOTBAR_END = 44;
    private final Container attachmentContainer;
    private final Inventory playerInventory;
    private boolean suppressAttachmentRefundOnClose = false;
    private String clientDateText = "";
    private String clientRecipientText = "";
    private String clientMessageText = "";
    private String clientSignatureText = "";
    private String clientRecipientUUID = "";
    private boolean clientSkipIntroAnimation = false;

    public ScrollSealingMenu(int containerId, Inventory playerInventory) {
        super(FFNeoForgeMenus.SCROLL_SEALING_MENU.get(), containerId);
        int y;
        int x;
        this.playerInventory = playerInventory;
        this.attachmentContainer = new SimpleContainer(9);
        LOG.debug("[ScrollSealingMenu] Creating menu id={} for player={}", (Object)containerId, (Object)playerInventory.player.getGameProfile().getName());
        for (int i = 0; i < 9; ++i) {
            x = 8 + i * 18;
            y = 17;
            this.addSlot(new Slot(this.attachmentContainer, i, x, y));
        }
        for (int row = 0; row < 3; ++row) {
            int y2 = 49 + row * 18;
            for (int col = 0; col < 9; ++col) {
                int index = col + row * 9 + 9;
                int x2 = 8 + col * 18;
                this.addSlot(new Slot((Container)playerInventory, index, x2, y2));
            }
        }
        for (int col = 0; col < 9; ++col) {
            x = 8 + col * 18;
            y = 107;
            this.addSlot(new Slot((Container)playerInventory, col, x, y));
        }
        LOG.debug("[ScrollSealingMenu] Slot layout: attachment[{}..{}], inv[{}..{}], hotbar[{}..{}]", new Object[]{0, 8, 9, 35, 36, 44});
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void setClientRecipientUUID(String uuid) {
        this.clientRecipientUUID = uuid != null ? uuid : "";
    }

    public String getClientRecipientUUID() {
        return this.clientRecipientUUID;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        try {
            ItemStack empty = ItemStack.EMPTY;
            if (index < 0 || index >= this.slots.size()) {
                LOG.warn("[ScrollSealingMenu] quickMoveStack: index {} outside slots size {}", (Object)index, (Object)this.slots.size());
                return empty;
            }
            Slot slot = (Slot)this.slots.get(index);
            if (slot == null || !slot.hasItem()) {
                return empty;
            }
            ItemStack stackInSlot = slot.getItem();
            ItemStack original = stackInSlot.copy();
            if (index >= 0 && index <= 8) {
                if (!this.moveItemStackTo(stackInSlot, 9, 45, true)) {
                    return empty;
                }
            } else if (index >= 9 && index <= 44) {
                if (!this.moveItemStackTo(stackInSlot, 0, 9, false)) {
                    return empty;
                }
            } else {
                LOG.warn("[ScrollSealingMenu] quickMoveStack: index {} outside known ranges", (Object)index);
                return empty;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            slot.onTake(player, stackInSlot);
            return original;
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingMenu] quickMoveStack failed for index={}", (Object)index, (Object)t);
            return ItemStack.EMPTY;
        }
    }

    public void removed(Player player) {
        super.removed(player);
        try {
            if (player == null) {
                LOG.warn("[ScrollSealingMenu] removed: player is null, skipping attachment refund");
                return;
            }
            if (player.level().isClientSide) {
                return;
            }
            if (this.suppressAttachmentRefundOnClose) {
                LOG.debug("[ScrollSealingMenu] removed: suppressAttachmentRefundOnClose=true, skipping attachment refund");
                for (int i = 0; i < 9; ++i) {
                    this.attachmentContainer.setItem(i, ItemStack.EMPTY);
                }
                return;
            }
            LOG.debug("[ScrollSealingMenu] removed: refunding attachment items to player={}", (Object)player.getGameProfile().getName());
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.attachmentContainer.getItem(i);
                if (stack.isEmpty()) continue;
                this.attachmentContainer.setItem(i, ItemStack.EMPTY);
                boolean added = player.addItem(stack);
                if (added) continue;
                player.drop(stack, false);
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingMenu] removed failed while refunding attachments", t);
        }
    }

    @Override
    public int getAttachmentSlotCount() {
        return 9;
    }

    @Override
    @NotNull
    public ItemStack getAttachmentStack(int index) {
        try {
            if (index < 0 || index >= 9) {
                LOG.warn("[ScrollSealingMenu] getAttachmentStack: index {} out of range 0..{}", (Object)index, (Object)8);
                return ItemStack.EMPTY;
            }
            ItemStack stack = this.attachmentContainer.getItem(index);
            return stack != null ? stack : ItemStack.EMPTY;
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingMenu] getAttachmentStack failed for index={}", (Object)index, (Object)t);
            return ItemStack.EMPTY;
        }
    }

    @Override
    public void clearAttachmentSlot(int index) {
        try {
            if (index < 0 || index >= 9) {
                LOG.warn("[ScrollSealingMenu] clearAttachmentSlot: index {} out of range 0..{}", (Object)index, (Object)8);
                return;
            }
            this.attachmentContainer.setItem(index, ItemStack.EMPTY);
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingMenu] clearAttachmentSlot failed for index={}", (Object)index, (Object)t);
        }
    }

    @Override
    public void setSuppressAttachmentRefundOnClose(boolean suppress) {
        if (this.suppressAttachmentRefundOnClose != suppress) {
            LOG.debug("[ScrollSealingMenu] setSuppressAttachmentRefundOnClose: {} -> {}", (Object)this.suppressAttachmentRefundOnClose, (Object)suppress);
        }
        this.suppressAttachmentRefundOnClose = suppress;
    }

    @Override
    public boolean isSuppressAttachmentRefundOnClose() {
        return this.suppressAttachmentRefundOnClose;
    }

    public Container getAttachmentContainer() {
        return this.attachmentContainer;
    }

    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    public String getClientDateText() {
        return this.clientDateText;
    }

    public void setClientDateText(String clientDateText) {
        String safe;
        String string = safe = clientDateText != null ? clientDateText : "";
        if (!safe.equals(this.clientDateText)) {
            LOG.debug("[ScrollSealingMenu] setClientDateText '{}'", (Object)safe);
        }
        this.clientDateText = safe;
    }

    public String getClientRecipientText() {
        return this.clientRecipientText;
    }

    public void setClientRecipientText(String clientRecipientText) {
        String safe;
        String string = safe = clientRecipientText != null ? clientRecipientText : "";
        if (!safe.equals(this.clientRecipientText)) {
            LOG.debug("[ScrollSealingMenu] setClientRecipientText '{}'", (Object)safe);
        }
        this.clientRecipientText = safe;
    }

    public String getClientMessageText() {
        return this.clientMessageText;
    }

    public void setClientMessageText(String clientMessageText) {
        String safe;
        String string = safe = clientMessageText != null ? clientMessageText : "";
        if (!safe.equals(this.clientMessageText)) {
            LOG.debug("[ScrollSealingMenu] setClientMessageText (len={})", (Object)safe.length());
        }
        this.clientMessageText = safe;
    }

    public String getClientSignatureText() {
        return this.clientSignatureText;
    }

    public void setClientSignatureText(String clientSignatureText) {
        String safe;
        String string = safe = clientSignatureText != null ? clientSignatureText : "";
        if (!safe.equals(this.clientSignatureText)) {
            LOG.debug("[ScrollSealingMenu] setClientSignatureText '{}'", (Object)safe);
        }
        this.clientSignatureText = safe;
    }

    public boolean isClientSkipIntroAnimation() {
        return this.clientSkipIntroAnimation;
    }

    public void setClientSkipIntroAnimation(boolean clientSkipIntroAnimation) {
        if (this.clientSkipIntroAnimation != clientSkipIntroAnimation) {
            LOG.debug("[ScrollSealingMenu] setClientSkipIntroAnimation {}", (Object)clientSkipIntroAnimation);
        }
        this.clientSkipIntroAnimation = clientSkipIntroAnimation;
    }
}

