/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.item;

import com.mojang.logging.LogUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.z2six.featheredfriend.platform.Services;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class UnsealedScrollItem
extends Item {
    private static final Logger LOG = LogUtils.getLogger();

    public UnsealedScrollItem(@NotNull Item.Properties properties) {
        super(properties);
        LOG.debug("[UnsealedScrollItem] Created instance with properties {}", (Object)properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        try {
            if (!level.isClientSide && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                LOG.debug("[UnsealedScrollItem] Player {} used unsealed scroll in hand {} \u2013 opening sealing screen", (Object)serverPlayer.getGameProfile().getName(), (Object)hand);
                Services.PLATFORM.openScrollSealingScreen(serverPlayer);
            }
        }
        catch (Throwable t) {
            LOG.error("[UnsealedScrollItem] Failed to open scroll sealing screen", t);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }
}

