/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.item;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.z2six.featheredfriend.platform.Services;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SealStampItem
extends Item {
    private static final Logger LOG = LogUtils.getLogger();
    private static final String NBT_SEAL_ROOT = "SealStamp";
    private static final String NBT_OWNER = "Owner";
    private static final String NBT_SEED = "Seed";
    private static final String NBT_SLICES = "Slices";
    private static final String NBT_SHAPESET = "ShapeSet";

    public SealStampItem(@NotNull Item.Properties properties) {
        super(properties);
        LOG.debug("[SealStampItem] Constructed");
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        try {
            if (level.isClientSide) {
                LOG.debug("[SealStampItem] use() on client; returning SUCCESS (no logic client-side)");
                return InteractionResultHolder.success((Object)stack);
            }
            if (!(player instanceof ServerPlayer)) {
                LOG.warn("[SealStampItem] use() called on non-ServerPlayer on logical server; returning PASS");
                return InteractionResultHolder.pass((Object)stack);
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean etched = SealStampItem.isEtched(stack);
            LOG.debug("[SealStampItem] use() on server for {}. Etched={}", (Object)serverPlayer.getGameProfile().getName(), (Object)etched);
            if (etched) {
                LOG.info("[SealStampItem] Stamp is already etched; future behaviour will seal scrolls, etc.");
                return InteractionResultHolder.success((Object)stack);
            }
            LOG.info("[SealStampItem] Opening Seal Stamp carving GUI (placeholder) for player={}", (Object)serverPlayer.getGameProfile().getName());
            Services.PLATFORM.openSealStampScreen(serverPlayer);
            return InteractionResultHolder.success((Object)stack);
        }
        catch (Throwable t) {
            LOG.error("[SealStampItem] use() failed; returning PASS to avoid crashes", t);
            return InteractionResultHolder.pass((Object)stack);
        }
    }

    public static boolean isEtched(@NotNull ItemStack stack) {
        try {
            CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            if (customData.isEmpty()) {
                LOG.debug("[SealStampItem] isEtched: no CustomData on stack");
                return false;
            }
            CompoundTag root = customData.copyTag();
            if (root == null || !root.contains(NBT_SEAL_ROOT)) {
                LOG.debug("[SealStampItem] isEtched: no '{}' compound found", (Object)NBT_SEAL_ROOT);
                return false;
            }
            CompoundTag sealTag = root.getCompound(NBT_SEAL_ROOT);
            if (sealTag.isEmpty()) {
                LOG.debug("[SealStampItem] isEtched: '{}' compound is empty", (Object)NBT_SEAL_ROOT);
                return false;
            }
            boolean hasOwner = sealTag.contains(NBT_OWNER);
            boolean hasSeed = sealTag.contains(NBT_SEED);
            boolean hasSlices = sealTag.contains(NBT_SLICES);
            boolean hasSet = sealTag.contains(NBT_SHAPESET);
            boolean etched = hasOwner && hasSeed && hasSlices && hasSet;
            LOG.debug("[SealStampItem] isEtched: owner={} seed={} slices={} shapeset={} -> {}", new Object[]{hasOwner, hasSeed, hasSlices, hasSet, etched});
            return etched;
        }
        catch (Throwable t) {
            LOG.error("[SealStampItem] isEtched: failed, treating as unetched", t);
            return false;
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        try {
            if (SealStampItem.isEtched(stack)) {
                tooltip.add((Component)Component.literal((String)"\u00a77Etched seal"));
            } else {
                tooltip.add((Component)Component.literal((String)"\u00a77Uncarved"));
            }
        }
        catch (Throwable t) {
            LOG.error("[SealStampItem] appendHoverText failed", t);
        }
    }
}

