/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.item;

import com.mojang.logging.LogUtils;
import org.slf4j.Logger;

public class SealStampCarveLogic {
    private static final Logger LOG = LogUtils.getLogger();
    private static final int TOTAL_TICKS = 20;
    private static final int[] BURST_TICKS = new int[]{2, 6, 12, 18};
    private boolean carving = false;
    private int elapsedTicks = 0;
    private int burstsFired = 0;
    private long seed = 0L;
    private int slices = 0;
    private int style = 0;

    public void beginCarve(long seed, int slices, int style) {
        try {
            this.carving = true;
            this.elapsedTicks = 0;
            this.burstsFired = 0;
            this.seed = seed;
            this.slices = slices;
            this.style = style;
            LOG.debug("[SealStampCarveLogic] beginCarve: seed={} slices={} style={}", new Object[]{seed, slices, style});
        }
        catch (Throwable t) {
            LOG.error("[SealStampCarveLogic] beginCarve failed", t);
            this.carving = false;
        }
    }

    public void tick(Callback callback) {
        if (!this.carving) {
            return;
        }
        if (callback == null) {
            LOG.warn("[SealStampCarveLogic] tick called with null callback; aborting carve");
            this.carving = false;
            return;
        }
        try {
            ++this.elapsedTicks;
            while (this.burstsFired < BURST_TICKS.length && this.elapsedTicks >= BURST_TICKS[this.burstsFired]) {
                int index = this.burstsFired++;
                try {
                    callback.onBurst(index);
                }
                catch (Throwable t) {
                    LOG.error("[SealStampCarveLogic] onBurst callback failed for index={}", (Object)index, (Object)t);
                }
            }
            if (this.elapsedTicks >= 20) {
                this.carving = false;
                try {
                    callback.onFinished(this.seed, this.slices, this.style);
                }
                catch (Throwable t) {
                    LOG.error("[SealStampCarveLogic] onFinished callback failed", t);
                }
            }
        }
        catch (Throwable t) {
            LOG.error("[SealStampCarveLogic] tick failed", t);
            this.carving = false;
        }
    }

    public boolean isCarving() {
        return this.carving;
    }

    public int getElapsedTicks() {
        return this.elapsedTicks;
    }

    public static interface Callback {
        public void onBurst(int var1);

        public void onFinished(long var1, int var3, int var4);
    }
}

