/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.item;

import com.mojang.logging.LogUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.z2six.featheredfriend.platform.Services;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ScrollViewItem
extends Item {
    private static final Logger LOG = LogUtils.getLogger();

    public ScrollViewItem(@NotNull Item.Properties properties) {
        super(properties);
        LOG.debug("[ScrollViewItem] Constructed with properties={}", (Object)properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        try {
            if (level.isClientSide) {
                LOG.debug("[ScrollViewItem] use() on client; returning SUCCESS (no server logic)");
                return InteractionResultHolder.success((Object)stack);
            }
            if (!(player instanceof ServerPlayer)) {
                LOG.warn("[ScrollViewItem] use() called on non-ServerPlayer on logical server; returning PASS");
                return InteractionResultHolder.pass((Object)stack);
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LOG.info("[ScrollViewItem] Opening scroll view GUI for player={} hand={} item={}", new Object[]{serverPlayer.getGameProfile().getName(), hand, stack.getItem().toString()});
            Services.PLATFORM.openScrollViewScreen(serverPlayer);
            return InteractionResultHolder.success((Object)stack);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewItem] use() failed; returning PASS to avoid crashes", t);
            return InteractionResultHolder.pass((Object)stack);
        }
    }
}

