/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.integration.jei;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.z2six.featheredfriend.client.gui.EnderPearlInventoryScreen;
import net.z2six.featheredfriend.client.gui.ScrollSealingScreen;
import net.z2six.featheredfriend.client.gui.ScrollViewScreen;
import net.z2six.featheredfriend.client.gui.SealStampScreen;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@EventBusSubscriber(modid="featheredfriend", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public final class JeiOverlayHider {
    private static final Logger LOG = LogUtils.getLogger();
    private static volatile Object jeiRuntime = null;
    private static volatile Boolean previousOverlayState = null;
    private static volatile boolean overlayHiddenForOurScreen = false;
    private static volatile boolean loggedMissingRuntime = false;

    private JeiOverlayHider() {
    }

    public static void setRuntime(@NotNull Object runtime) {
        try {
            jeiRuntime = runtime;
            loggedMissingRuntime = false;
            LOG.debug("[JeiOverlayHider] JEI runtime received: {}", (Object)runtime.getClass().getName());
        }
        catch (Throwable t) {
            LOG.error("[JeiOverlayHider] Failed to store JEI runtime", t);
        }
    }

    @SubscribeEvent
    public static void onClientTick(@NotNull ClientTickEvent.Post event) {
        try {
            boolean isOurScreen;
            if (jeiRuntime == null) {
                if (!loggedMissingRuntime) {
                    LOG.debug("[JeiOverlayHider] JEI runtime is null; overlay will not be modified yet");
                    loggedMissingRuntime = true;
                }
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                return;
            }
            boolean bl = isOurScreen = mc.screen instanceof ScrollSealingScreen || mc.screen instanceof SealStampScreen || mc.screen instanceof EnderPearlInventoryScreen || mc.screen instanceof ScrollViewScreen;
            if (isOurScreen) {
                JeiOverlayHider.hideOverlayIfNeeded();
            } else {
                JeiOverlayHider.restoreOverlayIfNeeded();
            }
        }
        catch (Throwable t) {
            LOG.error("[JeiOverlayHider] onClientTick failed", t);
        }
    }

    private static void hideOverlayIfNeeded() {
        if (overlayHiddenForOurScreen) {
            return;
        }
        try {
            Object overlay = JeiOverlayHider.getIngredientOverlay(jeiRuntime);
            if (overlay == null) {
                return;
            }
            VisibilityMethods methods = JeiOverlayHider.findVisibilityMethods(overlay);
            if (methods.setter == null) {
                LOG.debug("[JeiOverlayHider] No suitable visibility setter found on JEI overlay; cannot hide it safely");
                return;
            }
            if (methods.getter != null) {
                try {
                    Object old = methods.getter.invoke(overlay, new Object[0]);
                    if (old instanceof Boolean) {
                        Boolean b;
                        previousOverlayState = b = (Boolean)old;
                        LOG.debug("[JeiOverlayHider] Recorded previous JEI overlay state: {}", (Object)b);
                    }
                }
                catch (Throwable t) {
                    LOG.error("[JeiOverlayHider] Failed to invoke visibility getter on overlay", t);
                }
            }
            methods.setter.invoke(overlay, Boolean.FALSE);
            overlayHiddenForOurScreen = true;
            LOG.debug("[JeiOverlayHider] JEI ingredient overlay hidden for FeatheredFriend GUI using setter '{}'", (Object)methods.setter.getName());
        }
        catch (Throwable t) {
            LOG.error("[JeiOverlayHider] Failed to hide JEI overlay", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreOverlayIfNeeded() {
        if (!overlayHiddenForOurScreen) {
            return;
        }
        try {
            Object overlay = JeiOverlayHider.getIngredientOverlay(jeiRuntime);
            if (overlay == null) {
                LOG.debug("[JeiOverlayHider] Overlay instance is null during restore; clearing state");
                overlayHiddenForOurScreen = false;
                previousOverlayState = null;
                return;
            }
            VisibilityMethods methods = JeiOverlayHider.findVisibilityMethods(overlay);
            if (methods.setter == null) {
                LOG.debug("[JeiOverlayHider] No suitable visibility setter found during restore; clearing state");
                overlayHiddenForOurScreen = false;
                previousOverlayState = null;
                return;
            }
            boolean newState = previousOverlayState != null ? previousOverlayState : true;
            try {
                methods.setter.invoke(overlay, newState);
                LOG.debug("[JeiOverlayHider] JEI ingredient overlay restored to {} using setter '{}'", (Object)newState, (Object)methods.setter.getName());
            }
            catch (Throwable t) {
                LOG.error("[JeiOverlayHider] Failed to invoke visibility setter on overlay during restore", t);
            }
        }
        catch (Throwable t) {
            LOG.error("[JeiOverlayHider] Failed to restore JEI overlay", t);
        }
        finally {
            overlayHiddenForOurScreen = false;
            previousOverlayState = null;
        }
    }

    private static Object getIngredientOverlay(@NotNull Object runtime) {
        try {
            Method getOverlay;
            Class<?> runtimeClass = runtime.getClass();
            try {
                getOverlay = runtimeClass.getMethod("getIngredientListOverlay", new Class[0]);
            }
            catch (NoSuchMethodException ignored) {
                LOG.debug("[JeiOverlayHider] getIngredientListOverlay() not found on JEI runtime class {}", (Object)runtimeClass.getName());
                return null;
            }
            Object overlay = getOverlay.invoke(runtime, new Object[0]);
            if (overlay == null) {
                LOG.debug("[JeiOverlayHider] JEI getIngredientListOverlay() returned null");
                return null;
            }
            LOG.debug("[JeiOverlayHider] Obtained JEI ingredient overlay instance: {}", (Object)overlay.getClass().getName());
            return overlay;
        }
        catch (Throwable t) {
            LOG.error("[JeiOverlayHider] Failed to obtain JEI ingredient overlay via reflection", t);
            return null;
        }
    }

    private static VisibilityMethods findVisibilityMethods(@NotNull Object overlay) {
        Class<?> clazz = overlay.getClass();
        Method bestSetter = null;
        Method bestGetter = null;
        try {
            Method[] methods = clazz.getMethods();
            ArrayList<Method> setterCandidates = new ArrayList<Method>();
            ArrayList<Method> getterCandidates = new ArrayList<Method>();
            for (Method m : methods) {
                String name = m.getName();
                Class<?>[] params = m.getParameterTypes();
                if (name.startsWith("set") && params.length == 1 && (params[0] == Boolean.TYPE || params[0] == Boolean.class)) {
                    setterCandidates.add(m);
                }
                if (params.length != 0 || m.getReturnType() != Boolean.TYPE && m.getReturnType() != Boolean.class || !name.startsWith("is") && !name.startsWith("get")) continue;
                getterCandidates.add(m);
            }
            bestSetter = JeiOverlayHider.pickBestVisibilitySetter(setterCandidates);
            bestGetter = JeiOverlayHider.pickMatchingGetter(bestSetter, getterCandidates);
            if (bestSetter != null) {
                bestSetter.setAccessible(true);
            }
            if (bestGetter != null) {
                bestGetter.setAccessible(true);
            }
            if (bestSetter != null) {
                LOG.debug("[JeiOverlayHider] Using visibility setter '{}' and getter '{}' on JEI overlay class {}", new Object[]{bestSetter.getName(), bestGetter != null ? bestGetter.getName() : "<none>", clazz.getName()});
            } else {
                LOG.debug("[JeiOverlayHider] No suitable visibility setter discovered on JEI overlay class {}", (Object)clazz.getName());
            }
        }
        catch (Throwable t) {
            LOG.error("[JeiOverlayHider] Error while discovering visibility methods on overlay class {}", (Object)clazz.getName(), (Object)t);
            bestSetter = null;
            bestGetter = null;
        }
        return new VisibilityMethods(bestGetter, bestSetter);
    }

    private static Method pickBestVisibilitySetter(List<Method> candidates) {
        Method best = null;
        int bestScore = -1;
        for (Method m : candidates) {
            String n = m.getName().toLowerCase(Locale.ROOT);
            int score = 0;
            if (n.contains("visible")) {
                score += 5;
            }
            if (n.contains("display")) {
                score += 4;
            }
            if (n.contains("show")) {
                score += 4;
            }
            if (n.contains("enable")) {
                score += 3;
            }
            if (n.contains("list")) {
                ++score;
            }
            if (n.equals("setvisible")) {
                score += 2;
            }
            if (score <= bestScore) continue;
            bestScore = score;
            best = m;
        }
        return best;
    }

    private static Method pickMatchingGetter(Method setter, List<Method> getterCandidates) {
        if (setter == null) {
            return null;
        }
        String setterName = setter.getName();
        String suffix = setterName.startsWith("set") ? setterName.substring(3) : setterName;
        Method best = null;
        int bestScore = -1;
        for (Method m : getterCandidates) {
            String lower;
            String n = m.getName();
            int score = 0;
            if (n.equalsIgnoreCase("is" + suffix) || n.equalsIgnoreCase("get" + suffix)) {
                score += 5;
            }
            if ((lower = n.toLowerCase(Locale.ROOT)).contains("visible")) {
                score += 4;
            }
            if (lower.contains("display")) {
                score += 3;
            }
            if (lower.contains("show")) {
                score += 3;
            }
            if (lower.contains("enable")) {
                score += 2;
            }
            if (score <= bestScore) continue;
            bestScore = score;
            best = m;
        }
        return best;
    }

    private static final class VisibilityMethods {
        final Method getter;
        final Method setter;

        VisibilityMethods(Method getter, Method setter) {
            this.getter = getter;
            this.setter = setter;
        }
    }
}

