/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.integration.jei;

import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.z2six.featheredfriend.Constants;
import net.z2six.featheredfriend.client.gui.EnderPearlInventoryScreen;
import net.z2six.featheredfriend.client.gui.ScrollSealingScreen;
import net.z2six.featheredfriend.client.gui.ScrollViewScreen;
import net.z2six.featheredfriend.client.gui.SealStampScreen;
import net.z2six.featheredfriend.registry.FFItems;
import org.slf4j.Logger;

@JeiPlugin
public class FeatheredFriendJeiPlugin
implements IModPlugin {
    private static final Logger LOG = Constants.LOG;

    public ResourceLocation getPluginUid() {
        try {
            return ResourceLocation.parse((String)"featheredfriend:jei_plugin");
        }
        catch (Throwable t) {
            LOG.error("FeatheredFriendJeiPlugin: Failed to create plugin UID, falling back to 'featheredfriend:jei_plugin_fallback'", t);
            return ResourceLocation.parse((String)"featheredfriend:jei_plugin_fallback");
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        LOG.debug("FeatheredFriendJeiPlugin: Registering JEI ingredient info for sealed scroll");
        try {
            ItemStack sealedScroll = new ItemStack((ItemLike)FFItems.SCROLL_SEALED.get());
            registration.addIngredientInfo((Object)sealedScroll, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.featheredfriend.scroll_sealed.info")});
        }
        catch (Throwable t) {
            LOG.error("FeatheredFriendJeiPlugin: Failed to register JEI info for sealed scroll", t);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        try {
            LOG.debug("FeatheredFriendJeiPlugin: Registering GUI handler for ScrollSealingScreen");
            registration.addGuiContainerHandler(ScrollSealingScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<ScrollSealingScreen>(this){

                public List<Rect2i> getGuiExtraAreas(ScrollSealingScreen screen) {
                    try {
                        int x = 0;
                        int y = 0;
                        int width = screen.width;
                        int height = screen.height;
                        Rect2i fullScreen = new Rect2i(x, y, width, height);
                        LOG.debug("FeatheredFriendJeiPlugin: getGuiExtraAreas for ScrollSealingScreen -> {}x{} at {},{}", new Object[]{width, height, x, y});
                        return Collections.singletonList(fullScreen);
                    }
                    catch (Throwable t) {
                        LOG.error("FeatheredFriendJeiPlugin: getGuiExtraAreas failed for ScrollSealingScreen", t);
                        return Collections.emptyList();
                    }
                }
            });
        }
        catch (Throwable t) {
            LOG.error("FeatheredFriendJeiPlugin: registerGuiHandlers failed for ScrollSealingScreen", t);
        }
        try {
            LOG.debug("FeatheredFriendJeiPlugin: Registering GUI handler for SealStampScreen");
            registration.addGuiContainerHandler(SealStampScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<SealStampScreen>(this){

                public List<Rect2i> getGuiExtraAreas(SealStampScreen screen) {
                    try {
                        int x = 0;
                        int y = 0;
                        int width = screen.width;
                        int height = screen.height;
                        Rect2i fullScreen = new Rect2i(x, y, width, height);
                        LOG.debug("FeatheredFriendJeiPlugin: getGuiExtraAreas for SealStampScreen -> {}x{} at {},{}", new Object[]{width, height, x, y});
                        return Collections.singletonList(fullScreen);
                    }
                    catch (Throwable t) {
                        LOG.error("FeatheredFriendJeiPlugin: getGuiExtraAreas failed for SealStampScreen", t);
                        return Collections.emptyList();
                    }
                }
            });
        }
        catch (Throwable t) {
            LOG.error("FeatheredFriendJeiPlugin: registerGuiHandlers failed for SealStampScreen", t);
        }
        try {
            LOG.debug("FeatheredFriendJeiPlugin: Registering GUI handler for EnderPearlInventoryScreen");
            registration.addGuiContainerHandler(EnderPearlInventoryScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<EnderPearlInventoryScreen>(this){

                public List<Rect2i> getGuiExtraAreas(EnderPearlInventoryScreen screen) {
                    try {
                        int x = 0;
                        int y = 0;
                        int width = screen.width;
                        int height = screen.height;
                        Rect2i fullScreen = new Rect2i(x, y, width, height);
                        LOG.debug("FeatheredFriendJeiPlugin: getGuiExtraAreas for EnderPearlInventoryScreen -> {}x{} at {},{}", new Object[]{width, height, x, y});
                        return Collections.singletonList(fullScreen);
                    }
                    catch (Throwable t) {
                        LOG.error("FeatheredFriendJeiPlugin: getGuiExtraAreas failed for EnderPearlInventoryScreen", t);
                        return Collections.emptyList();
                    }
                }
            });
        }
        catch (Throwable t) {
            LOG.error("FeatheredFriendJeiPlugin: registerGuiHandlers failed for EnderPearlInventoryScreen", t);
        }
        try {
            LOG.debug("FeatheredFriendJeiPlugin: Registering GUI handler for ScrollViewScreen");
            registration.addGuiContainerHandler(ScrollViewScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<ScrollViewScreen>(this){

                public List<Rect2i> getGuiExtraAreas(ScrollViewScreen screen) {
                    try {
                        int x = 0;
                        int y = 0;
                        int width = screen.width;
                        int height = screen.height;
                        Rect2i fullScreen = new Rect2i(x, y, width, height);
                        LOG.debug("FeatheredFriendJeiPlugin: getGuiExtraAreas for ScrollViewScreen -> {}x{} at {},{}", new Object[]{width, height, x, y});
                        return Collections.singletonList(fullScreen);
                    }
                    catch (Throwable t) {
                        LOG.error("FeatheredFriendJeiPlugin: getGuiExtraAreas failed for ScrollViewScreen", t);
                        return Collections.emptyList();
                    }
                }
            });
        }
        catch (Throwable t) {
            LOG.error("FeatheredFriendJeiPlugin: registerGuiHandlers failed for ScrollViewScreen", t);
        }
    }
}

