/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.events;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.z2six.featheredfriend.data.FFKnownPlayersData;
import net.z2six.featheredfriend.network.FFNetwork;
import org.slf4j.Logger;

public final class FFPlayerEvents {
    private static final Logger LOG = LogUtils.getLogger();
    private static volatile boolean REGISTERED = false;

    private FFPlayerEvents() {
    }

    public static void register() {
        if (REGISTERED) {
            LOG.debug("[FFPlayerEvents] register(): already registered, skipping");
            return;
        }
        try {
            NeoForge.EVENT_BUS.addListener(FFPlayerEvents::onPlayerLoggedIn);
            REGISTERED = true;
            LOG.info("[FFPlayerEvents] Registered PlayerLoggedInEvent listener on NeoForge.EVENT_BUS");
        }
        catch (Throwable t) {
            LOG.error("[FFPlayerEvents] register() failed safely", t);
        }
    }

    private static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        try {
            MinecraftServer server = serverPlayer.server;
            if (server == null) {
                LOG.error("[FFPlayerEvents] PlayerLoggedInEvent: server is null for {}", (Object)FFPlayerEvents.safeName(serverPlayer));
                return;
            }
            FFKnownPlayersData data = FFKnownPlayersData.get(server);
            data.addOrUpdate(serverPlayer);
            List<FFKnownPlayersData.KnownPlayer> players = data.getSortedPlayers();
            for (ServerPlayer online : server.getPlayerList().getPlayers()) {
                try {
                    FFNetwork.sendKnownPlayersTo(online, players);
                }
                catch (Throwable sendErr) {
                    LOG.warn("[FFPlayerEvents] Failed sending known players list to {}: {}", (Object)FFPlayerEvents.safeName(online), (Object)sendErr.toString());
                }
            }
            LOG.info("[FFPlayerEvents] Login '{}' -> known players now {} (broadcasted to {} online)", new Object[]{FFPlayerEvents.safeName(serverPlayer), players.size(), server.getPlayerList().getPlayers().size()});
        }
        catch (Throwable t) {
            LOG.error("[FFPlayerEvents] Failed to process PlayerLoggedInEvent", t);
        }
    }

    private static String safeName(ServerPlayer p) {
        try {
            return p.getGameProfile().getName();
        }
        catch (Throwable ignored) {
            try {
                return p.getName().getString();
            }
            catch (Throwable ignored2) {
                return "<unknown>";
            }
        }
    }
}

