/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.entity.raven.pathing;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public final class RavenAStarPathing {
    private static final Logger LOG = LogUtils.getLogger();
    public static boolean DEBUG_LOGS = false;
    public static boolean FORCE_LOG_EVERY_CALL = false;
    public static long ENTER_LOG_MIN_INTERVAL_MS = 350L;
    public static boolean LOG_CALLER_HINT = false;
    public static boolean USE_FEET_BASED_Y_ANCHOR = true;
    public static final int DEFAULT_GRID_STEP = 1;
    public static final int DEFAULT_CLEARANCE_XZ = 2;
    public static final int DEFAULT_CLEARANCE_HEIGHT = 2;
    public static final int DEFAULT_MAX_EXPANDED = 6500;
    public static final int DEFAULT_MAX_OPEN = 16000;
    public static final int DEFAULT_MAX_RAW_WAYPOINTS = 768;
    private static final int[] NX = new int[]{1, -1, 0, 0, 0, 0};
    private static final int[] NY = new int[]{0, 0, 1, -1, 0, 0};
    private static final int[] NZ = new int[]{0, 0, 0, 0, 1, -1};
    private static final AtomicLong CALL_SEQ = new AtomicLong(0L);
    private static volatile long lastEnterLogMs = 0L;

    private RavenAStarPathing() {
    }

    public static List<Vec3> findPath(Level level, Vec3 startWorld, Vec3 goalWorld, CellBounds bounds, Config cfg) {
        long callId = CALL_SEQ.incrementAndGet();
        if (level == null || startWorld == null || goalWorld == null || bounds == null) {
            if (DEBUG_LOGS) {
                LOG.warn("[RavenAStarPathing] findPath#{} NULL ARG(S): level={} start={} goal={} bounds={}", new Object[]{callId, level, startWorld, goalWorld, bounds});
            }
            return Collections.emptyList();
        }
        if (cfg == null) {
            cfg = new Config();
        }
        int gridStep = cfg.normalizedGridStep();
        int clearanceXZ = cfg.normalizedClearanceXZ();
        int clearanceH = cfg.normalizedClearanceHeight();
        RavenAStarPathing.maybeLogEnter(callId, level, startWorld, goalWorld, bounds, cfg, gridStep, clearanceXZ, clearanceH);
        try {
            final class OpenEntry {
                final long key;
                final double g;
                final double f;

                OpenEntry(long key, double g, double f) {
                    this.key = key;
                    this.g = g;
                    this.f = f;
                }
            }
            long t0 = System.nanoTime();
            NodeCoord start = NodeCoord.fromWorld(startWorld, gridStep, clearanceXZ, clearanceH);
            NodeCoord goal = NodeCoord.fromWorld(goalWorld, gridStep, clearanceXZ, clearanceH);
            if (!bounds.contains(start.cx, start.cy, start.cz)) {
                if (DEBUG_LOGS) {
                    LOG.info("[RavenAStarPathing] findPath#{} NO PATH: start outside bounds. start={} bounds={} gridStep={} clearance={}x{}", new Object[]{callId, start, bounds, gridStep, clearanceXZ, clearanceH});
                }
                return Collections.emptyList();
            }
            if (!bounds.contains(goal.cx, goal.cy, goal.cz)) {
                if (DEBUG_LOGS) {
                    LOG.info("[RavenAStarPathing] findPath#{} NO PATH: goal outside bounds. goal={} bounds={} gridStep={} clearance={}x{}", new Object[]{callId, goal, bounds, gridStep, clearanceXZ, clearanceH});
                }
                return Collections.emptyList();
            }
            Long2ByteOpenHashMap passableCache = new Long2ByteOpenHashMap();
            passableCache.defaultReturnValue((byte)-1);
            Long2DoubleOpenHashMap nodePenaltyCache = new Long2DoubleOpenHashMap();
            nodePenaltyCache.defaultReturnValue(Double.NaN);
            if (!RavenAStarPathing.isNodePassable(level, start.cx, start.cy, start.cz, cfg, passableCache)) {
                if (DEBUG_LOGS) {
                    BlockPos anchor = RavenAStarPathing.nodeAnchorBlock(start.cx, start.cy, start.cz, gridStep);
                    String why = RavenAStarPathing.describeFirstBlockingBlock(level, anchor, cfg, clearanceXZ, clearanceH);
                    LOG.info("[RavenAStarPathing] findPath#{} NO PATH: start blocked. start={} anchorBlock={} gridStep={} clearance={}x{} allowLeaves={} allowReplaceables={} firstBlocker={}", new Object[]{callId, start, anchor, gridStep, clearanceXZ, clearanceH, cfg.allowLeaves, cfg.allowReplaceables, why});
                }
                return Collections.emptyList();
            }
            if (!RavenAStarPathing.isNodePassable(level, goal.cx, goal.cy, goal.cz, cfg, passableCache)) {
                if (DEBUG_LOGS) {
                    BlockPos anchor = RavenAStarPathing.nodeAnchorBlock(goal.cx, goal.cy, goal.cz, gridStep);
                    String why = RavenAStarPathing.describeFirstBlockingBlock(level, anchor, cfg, clearanceXZ, clearanceH);
                    LOG.info("[RavenAStarPathing] findPath#{} NO PATH: goal blocked. goal={} anchorBlock={} gridStep={} clearance={}x{} allowLeaves={} allowReplaceables={} firstBlocker={}", new Object[]{callId, goal, anchor, gridStep, clearanceXZ, clearanceH, cfg.allowLeaves, cfg.allowReplaceables, why});
                }
                return Collections.emptyList();
            }
            Long2DoubleOpenHashMap gScore = new Long2DoubleOpenHashMap();
            gScore.defaultReturnValue(Double.POSITIVE_INFINITY);
            Long2LongOpenHashMap cameFrom = new Long2LongOpenHashMap();
            cameFrom.defaultReturnValue(0L);
            LongOpenHashSet closed = new LongOpenHashSet(4096);
            long startKey = RavenAStarPathing.pack(start.cx, start.cy, start.cz);
            long goalKey = RavenAStarPathing.pack(goal.cx, goal.cy, goal.cz);
            gScore.put(startKey, 0.0);
            ObjectHeapPriorityQueue open = new ObjectHeapPriorityQueue(Comparator.comparingDouble(a -> a.f));
            double h0 = RavenAStarPathing.heuristicManhattan(start, goal);
            open.enqueue((Object)new OpenEntry(startKey, 0.0, h0));
            RandomSource tieRnd = cfg.tieBreakSeed != 0L ? RandomSource.create((long)cfg.tieBreakSeed) : null;
            int expanded = 0;
            int pushes = 1;
            int stalePops = 0;
            while (!open.isEmpty()) {
                int md;
                if (expanded >= cfg.maxExpanded) {
                    if (!DEBUG_LOGS) break;
                    LOG.info("[RavenAStarPathing] findPath#{} NO PATH: maxExpanded reached ({}). expanded={} pushes={} stalePops={} start={} goal={} bounds={} gridStep={} clearance={}x{}", new Object[]{callId, cfg.maxExpanded, expanded, pushes, stalePops, start, goal, bounds, gridStep, clearanceXZ, clearanceH});
                    break;
                }
                if (open.size() > cfg.maxOpen) {
                    if (!DEBUG_LOGS) break;
                    LOG.info("[RavenAStarPathing] findPath#{} NO PATH: maxOpen reached ({}). expanded={} pushes={} stalePops={} start={} goal={} bounds={} gridStep={} clearance={}x{}", new Object[]{callId, cfg.maxOpen, expanded, pushes, stalePops, start, goal, bounds, gridStep, clearanceXZ, clearanceH});
                    break;
                }
                OpenEntry entry = (OpenEntry)open.dequeue();
                double bestKnownG = gScore.get(entry.key);
                if (Double.isInfinite(bestKnownG) || Math.abs(bestKnownG - entry.g) > 1.0E-9) {
                    ++stalePops;
                    continue;
                }
                if (closed.contains(entry.key)) continue;
                if (entry.key == goalKey) {
                    List<Vec3> out;
                    List<Vec3> raw = RavenAStarPathing.reconstructPath(cameFrom, entry.key, startKey, cfg.maxRawWaypoints, cfg);
                    List<Vec3> list = out = cfg.smoothPath ? RavenAStarPathing.smooth(level, raw, cfg, passableCache) : raw;
                    if (DEBUG_LOGS) {
                        double ms = (double)(System.nanoTime() - t0) / 1000000.0;
                        LOG.info("[RavenAStarPathing] findPath#{} PATH OK: expanded={} pushes={} stalePops={} rawPts={} outPts={} timeMs={} start={} goal={} bounds={} gridStep={} clearance={}x{}", new Object[]{callId, expanded, pushes, stalePops, raw.size(), out.size(), String.format("%.3f", ms), start, goal, bounds, gridStep, clearanceXZ, clearanceH});
                    }
                    return out;
                }
                closed.add(entry.key);
                ++expanded;
                NodeCoord cur = RavenAStarPathing.unpack(entry.key);
                if (cfg.maxCellRadiusFromStart > 0 && (md = Math.abs(cur.cx - start.cx) + Math.abs(cur.cy - start.cy) + Math.abs(cur.cz - start.cz)) > cfg.maxCellRadiusFromStart) continue;
                double curG = entry.g;
                for (int i = 0; i < NX.length; ++i) {
                    double prevBest;
                    double tentativeG;
                    long nKey;
                    int md2;
                    int ncx = cur.cx + NX[i];
                    int ncy = cur.cy + NY[i];
                    int ncz = cur.cz + NZ[i];
                    if (!bounds.contains(ncx, ncy, ncz) || cfg.maxCellRadiusFromStart > 0 && (md2 = Math.abs(ncx - start.cx) + Math.abs(ncy - start.cy) + Math.abs(ncz - start.cz)) > cfg.maxCellRadiusFromStart || closed.contains(nKey = RavenAStarPathing.pack(ncx, ncy, ncz)) || !RavenAStarPathing.isNodePassable(level, ncx, ncy, ncz, cfg, passableCache)) continue;
                    double stepCost = 1.0;
                    if (tieRnd != null) {
                        stepCost += (tieRnd.nextDouble() - 0.5) * 0.002;
                    }
                    if (!((tentativeG = curG + (stepCost += RavenAStarPathing.extraCostForNode(level, ncx, ncy, ncz, cfg, nodePenaltyCache))) + 1.0E-9 < (prevBest = gScore.get(nKey)))) continue;
                    cameFrom.put(nKey, entry.key);
                    gScore.put(nKey, tentativeG);
                    NodeCoord nn = new NodeCoord(ncx, ncy, ncz);
                    double h = RavenAStarPathing.heuristicManhattan(nn, goal);
                    double f = tentativeG + h;
                    open.enqueue((Object)new OpenEntry(nKey, tentativeG, f));
                    ++pushes;
                }
            }
            if (DEBUG_LOGS) {
                double ms = (double)(System.nanoTime() - t0) / 1000000.0;
                LOG.info("[RavenAStarPathing] findPath#{} PATH FAIL: expanded={} pushes={} stalePops={} timeMs={} start={} goal={} bounds={} gridStep={} clearance={}x{}", new Object[]{callId, expanded, pushes, stalePops, String.format("%.3f", ms), start, goal, bounds, gridStep, clearanceXZ, clearanceH});
            }
            return Collections.emptyList();
        }
        catch (Throwable t) {
            if (DEBUG_LOGS) {
                LOG.error("[RavenAStarPathing] findPath#{} FAILED (gridStep={} clearance={}x{} cellSize={} allowLeaves={} allowReplaceables={})", new Object[]{callId, gridStep, clearanceXZ, clearanceH, cfg.cellSize, cfg.allowLeaves, cfg.allowReplaceables, t});
            }
            return Collections.emptyList();
        }
    }

    public static CellBounds boundsFrom(BlockPos center, int radiusBlocks, int minY, int maxY, int gridStep) {
        if (center == null) {
            if (DEBUG_LOGS) {
                LOG.warn("[RavenAStarPathing] boundsFrom called with null center");
            }
            return new CellBounds(0, 0, 0, 0, 0, 0);
        }
        int gs = Math.max(1, gridStep);
        int minBx = center.getX() - radiusBlocks;
        int maxBx = center.getX() + radiusBlocks;
        int minBz = center.getZ() - radiusBlocks;
        int maxBz = center.getZ() + radiusBlocks;
        int minCx = RavenAStarPathing.floorDiv(minBx, gs);
        int maxCx = RavenAStarPathing.floorDiv(maxBx, gs);
        int minCz = RavenAStarPathing.floorDiv(minBz, gs);
        int maxCz = RavenAStarPathing.floorDiv(maxBz, gs);
        int minCy = RavenAStarPathing.floorDiv(minY, gs);
        int maxCy = RavenAStarPathing.floorDiv(maxY, gs);
        return new CellBounds(minCx, minCy, minCz, maxCx, maxCy, maxCz);
    }

    public static CellBounds boundsFrom(BlockPos center, int radiusBlocks, int minY, int maxY) {
        return RavenAStarPathing.boundsFrom(center, radiusBlocks, minY, maxY, 1);
    }

    private static double extraCostForNode(Level level, int cx, int cy, int cz, Config cfg, Long2DoubleOpenHashMap nodePenaltyCache) {
        try {
            double penalty;
            if (level == null) {
                return 0.0;
            }
            long key = RavenAStarPathing.pack(cx, cy, cz);
            double cached = nodePenaltyCache.get(key);
            if (!Double.isNaN(cached)) {
                return cached;
            }
            int gridStep = cfg.normalizedGridStep();
            int clearanceXZ = cfg.normalizedClearanceXZ();
            int clearanceH = cfg.normalizedClearanceHeight();
            BlockPos anchor = RavenAStarPathing.nodeAnchorBlock(cx, cy, cz, gridStep);
            int MAX_SCAN_RADIUS = 2;
            int bestDistSq = Integer.MAX_VALUE;
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dy = -2; dy <= 2; ++dy) {
                    for (int dz = -2; dz <= 2; ++dz) {
                        int dSq;
                        BlockPos bp = anchor.offset(dx, dy, dz);
                        if (dy < 0 || dy >= clearanceH || level.isEmptyBlock(bp) && level.getFluidState(bp).isEmpty() || (dSq = dx * dx + dy * dy + dz * dz) >= bestDistSq) continue;
                        bestDistSq = dSq;
                    }
                }
            }
            if (bestDistSq == Integer.MAX_VALUE) {
                nodePenaltyCache.put(key, 0.0);
                return 0.0;
            }
            double bestDist = Math.sqrt(bestDistSq);
            double SAFE_RADIUS = 2.5;
            if (bestDist >= 2.5) {
                penalty = 0.0;
            } else {
                double t = (2.5 - bestDist) / 2.5;
                penalty = 0.25 + 0.55 * t;
            }
            if (penalty < 0.0) {
                penalty = 0.0;
            }
            if (penalty > 0.8) {
                penalty = 0.8;
            }
            nodePenaltyCache.put(key, penalty);
            return penalty;
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    private static boolean isSolidForSafety(Level level, BlockPos pos, Config cfg) {
        try {
            if (level.isEmptyBlock(pos)) {
                return false;
            }
            BlockState st = level.getBlockState(pos);
            if (st == null) {
                return true;
            }
            if (cfg.allowLeaves && st.is(BlockTags.LEAVES)) {
                return false;
            }
            if (cfg.allowReplaceables && st.canBeReplaced()) {
                return false;
            }
            return !st.getCollisionShape((BlockGetter)level, pos).isEmpty();
        }
        catch (Throwable t) {
            return true;
        }
    }

    private static void maybeLogEnter(long callId, Level level, Vec3 startWorld, Vec3 goalWorld, CellBounds bounds, Config cfg, int gridStep, int clearanceXZ, int clearanceH) {
        if (!DEBUG_LOGS) {
            return;
        }
        try {
            long last;
            if (FORCE_LOG_EVERY_CALL) {
                LOG.info("[RavenAStarPathing] findPath#{} ENTER: dim={} start={} goal={} bounds={} gridStep={} clearance={}x{} allowLeaves={} allowReplaceables={} smooth={} maxExpanded={} maxOpen={} yAnchorFeet={} caller={}", new Object[]{callId, RavenAStarPathing.safeDim(level), RavenAStarPathing.fmtVec(startWorld), RavenAStarPathing.fmtVec(goalWorld), bounds, gridStep, clearanceXZ, clearanceH, cfg.allowLeaves, cfg.allowReplaceables, cfg.smoothPath, cfg.maxExpanded, cfg.maxOpen, USE_FEET_BASED_Y_ANCHOR, LOG_CALLER_HINT ? RavenAStarPathing.safeCallerHint() : "<off>"});
                return;
            }
            long nowMs = System.currentTimeMillis();
            if (nowMs - (last = lastEnterLogMs) >= Math.max(0L, ENTER_LOG_MIN_INTERVAL_MS)) {
                lastEnterLogMs = nowMs;
                LOG.info("[RavenAStarPathing] findPath#{} ENTER(throttled): dim={} start={} goal={} bounds={} gridStep={} clearance={}x{} yAnchorFeet={} caller={}", new Object[]{callId, RavenAStarPathing.safeDim(level), RavenAStarPathing.fmtVec(startWorld), RavenAStarPathing.fmtVec(goalWorld), bounds, gridStep, clearanceXZ, clearanceH, USE_FEET_BASED_Y_ANCHOR, LOG_CALLER_HINT ? RavenAStarPathing.safeCallerHint() : "<off>"});
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String safeDim(Level level) {
        try {
            if (level != null && level.dimension() != null) {
                return String.valueOf(level.dimension().location());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "<unknown-dim>";
    }

    private static String fmtVec(Vec3 v) {
        if (v == null) {
            return "<null>";
        }
        try {
            return String.format("(%.2f, %.2f, %.2f)", v.x, v.y, v.z);
        }
        catch (Throwable t) {
            return String.valueOf(v);
        }
    }

    private static String safeCallerHint() {
        try {
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            for (int i = 4; i < st.length; ++i) {
                String cn;
                StackTraceElement e = st[i];
                if (e == null || (cn = e.getClassName()) == null || cn.equals(RavenAStarPathing.class.getName()) || cn.startsWith("java.") || cn.startsWith("jdk.") || cn.startsWith("sun.")) continue;
                return e.getClassName() + "#" + e.getMethodName() + ":" + e.getLineNumber();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "<unknown-caller>";
    }

    private static String describeFirstBlockingBlock(Level level, BlockPos anchor, Config cfg, int clearanceXZ, int clearanceH) {
        if (level == null || anchor == null) {
            return "<null>";
        }
        try {
            for (int ox = 0; ox < clearanceXZ; ++ox) {
                for (int oy = 0; oy < clearanceH; ++oy) {
                    for (int oz = 0; oz < clearanceXZ; ++oz) {
                        BlockState st;
                        boolean empty;
                        BlockPos p = anchor.offset(ox, oy, oz);
                        try {
                            empty = level.isEmptyBlock(p);
                        }
                        catch (Throwable t) {
                            return "pos=" + String.valueOf(p) + " empty=<err:" + t.getClass().getSimpleName() + ">";
                        }
                        if (empty) continue;
                        try {
                            st = level.getBlockState(p);
                        }
                        catch (Throwable t) {
                            return "pos=" + String.valueOf(p) + " empty=false state=<err:" + t.getClass().getSimpleName() + ">";
                        }
                        if (st == null) {
                            return "pos=" + String.valueOf(p) + " empty=false state=<null>";
                        }
                        if (cfg.allowLeaves && st.is(BlockTags.LEAVES) || cfg.allowReplaceables && st.canBeReplaced()) continue;
                        return "pos=" + String.valueOf(p) + " state=" + String.valueOf(st) + " isLeaves=" + st.is(BlockTags.LEAVES) + " canBeReplaced=" + st.canBeReplaced();
                    }
                }
            }
            return "<none-found-but-nonpassable?>";
        }
        catch (Throwable t) {
            return "<err:" + t.getClass().getSimpleName() + ":" + t.getMessage() + ">";
        }
    }

    private static long popBestCandidate(LongPriorityQueue open, LongOpenHashSet inOpen, Long2DoubleOpenHashMap gScore, NodeCoord goal, Config cfg, RandomSource tieRnd) {
        long k;
        int i;
        int K = 12;
        if (open.isEmpty()) {
            return Long.MIN_VALUE;
        }
        long bestKey = Long.MIN_VALUE;
        double bestF = Double.POSITIVE_INFINITY;
        LongArrayList pulled = new LongArrayList(12);
        for (i = 0; i < 12 && !open.isEmpty(); ++i) {
            k = open.dequeueLong();
            if (!inOpen.contains(k)) continue;
            double g = gScore.get(k);
            if (Double.isInfinite(g)) {
                inOpen.remove(k);
                continue;
            }
            NodeCoord c = RavenAStarPathing.unpack(k);
            double h = RavenAStarPathing.heuristicManhattan(c, goal);
            double f = g + h;
            if (cfg.tieBreakSeed != 0L && tieRnd != null) {
                f += tieRnd.nextDouble() * 1.0E-6;
            }
            pulled.add(k);
            if (!(f < bestF)) continue;
            bestF = f;
            bestKey = k;
        }
        if (bestKey == Long.MIN_VALUE) {
            for (i = 0; i < pulled.size(); ++i) {
                open.enqueue(pulled.getLong(i));
            }
            return Long.MIN_VALUE;
        }
        for (i = 0; i < pulled.size(); ++i) {
            k = pulled.getLong(i);
            if (k == bestKey) continue;
            open.enqueue(k);
        }
        inOpen.remove(bestKey);
        return bestKey;
    }

    private static double heuristicManhattan(NodeCoord a, NodeCoord b) {
        return Math.abs(a.cx - b.cx) + Math.abs(a.cy - b.cy) + Math.abs(a.cz - b.cz);
    }

    private static List<Vec3> reconstructPath(Long2LongOpenHashMap cameFrom, long currentKey, long startKey, int maxPts, Config cfg) {
        try {
            LongArrayList keys = new LongArrayList();
            long cur = currentKey;
            keys.add(cur);
            int guard = 0;
            while (cur != startKey) {
                long prev = cameFrom.get(cur);
                if (prev == 0L) {
                    if (!DEBUG_LOGS) break;
                    LOG.warn("[RavenAStarPathing] reconstructPath broke chain early (missing cameFrom). cur={} startKey={}", (Object)cur, (Object)startKey);
                    break;
                }
                cur = prev;
                keys.add(cur);
                if (++guard <= maxPts) continue;
                if (!DEBUG_LOGS) break;
                LOG.warn("[RavenAStarPathing] reconstructPath exceeded maxPts={}, aborting chain build (startKey={})", (Object)maxPts, (Object)startKey);
                break;
            }
            long[] arr = keys.elements();
            int i = 0;
            for (int j = keys.size() - 1; i < j; ++i, --j) {
                long tmp = arr[i];
                arr[i] = arr[j];
                arr[j] = tmp;
            }
            int gs = Math.max(1, cfg.gridStep);
            int clearanceXZ = Math.max(1, cfg.cellSize);
            int clearanceH = Math.max(1, cfg.clearanceHeight);
            ArrayList<Vec3> out = new ArrayList<Vec3>(keys.size());
            for (int i2 = 0; i2 < keys.size(); ++i2) {
                NodeCoord c = RavenAStarPathing.unpack(keys.getLong(i2));
                out.add(RavenAStarPathing.nodeCenterWorld(c.cx, c.cy, c.cz, gs, clearanceXZ, clearanceH));
            }
            return out;
        }
        catch (Throwable t) {
            if (DEBUG_LOGS) {
                LOG.error("[RavenAStarPathing] reconstructPath failed", t);
            }
            return Collections.emptyList();
        }
    }

    private static List<Vec3> smooth(Level level, List<Vec3> raw, Config cfg, Long2ByteOpenHashMap passableCache) {
        if (raw == null || raw.size() <= 2) {
            return raw == null ? Collections.emptyList() : raw;
        }
        int gs = Math.max(1, cfg.gridStep);
        try {
            ArrayList<Vec3> out = new ArrayList<Vec3>();
            int i = 0;
            out.add(raw.get(0));
            while (i < raw.size() - 1) {
                int best = i + 1;
                for (int j = raw.size() - 1; j > i + 1; --j) {
                    if (!RavenAStarPathing.hasAxisAlignedNodeLineOfSight(level, raw.get(i), raw.get(j), cfg, passableCache, gs)) continue;
                    best = j;
                    break;
                }
                out.add(raw.get(best));
                i = best;
            }
            return out;
        }
        catch (Throwable t) {
            if (DEBUG_LOGS) {
                LOG.error("[RavenAStarPathing] smooth failed", t);
            }
            return raw;
        }
    }

    private static boolean hasAxisAlignedNodeLineOfSight(Level level, Vec3 a, Vec3 b, Config cfg, Long2ByteOpenHashMap passableCache, int gridStep) {
        try {
            int clearanceXZ = Math.max(1, cfg.cellSize);
            int clearanceH = Math.max(1, cfg.clearanceHeight);
            NodeCoord na = NodeCoord.fromWorld(a, gridStep, clearanceXZ, clearanceH);
            NodeCoord nb = NodeCoord.fromWorld(b, gridStep, clearanceXZ, clearanceH);
            int dx = nb.cx - na.cx;
            int dy = nb.cy - na.cy;
            int dz = nb.cz - na.cz;
            int axesChanged = (dx != 0 ? 1 : 0) + (dy != 0 ? 1 : 0) + (dz != 0 ? 1 : 0);
            if (axesChanged == 0) {
                return true;
            }
            if (axesChanged > 1) {
                return false;
            }
            int stepX = Integer.compare(dx, 0);
            int stepY = Integer.compare(dy, 0);
            int stepZ = Integer.compare(dz, 0);
            int steps = Math.abs(dx) + Math.abs(dy) + Math.abs(dz);
            int cx = na.cx;
            int cy = na.cy;
            int cz = na.cz;
            for (int s = 0; s <= steps; ++s) {
                if (!RavenAStarPathing.isNodePassable(level, cx, cy, cz, cfg, passableCache)) {
                    return false;
                }
                cx += stepX;
                cy += stepY;
                cz += stepZ;
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isNodePassable(Level level, int cx, int cy, int cz, Config cfg, Long2ByteOpenHashMap cache) {
        boolean ok;
        long key = RavenAStarPathing.pack(cx, cy, cz);
        byte cached = cache.get(key);
        if (cached != -1) {
            return cached == 1;
        }
        try {
            ok = RavenAStarPathing.computeNodePassable(level, cx, cy, cz, cfg);
        }
        catch (Throwable t) {
            ok = false;
        }
        cache.put(key, ok ? (byte)1 : 0);
        return ok;
    }

    private static double computeProximityPenalty(Level level, int cx, int cy, int cz, Config cfg) {
        if (level == null) {
            return 0.0;
        }
        if (!cfg.useProximityPenalty) {
            return 0.0;
        }
        try {
            double maxPen;
            int rXZ = cfg.normalizedProximityRadiusXZ();
            int rY = cfg.normalizedProximityRadiusY();
            if (rXZ <= 0 && rY <= 0) {
                return 0.0;
            }
            int gs = Math.max(1, cfg.gridStep);
            int clearanceXZ = Math.max(1, cfg.cellSize);
            int clearanceH = Math.max(1, cfg.clearanceHeight);
            int baseX = cx * gs;
            int baseY = cy * gs;
            int baseZ = cz * gs;
            int centerX = baseX + clearanceXZ / 2;
            int centerY = baseY + clearanceH / 2;
            int centerZ = baseZ + clearanceXZ / 2;
            int solidSamples = 0;
            int totalSamples = 0;
            for (int dx = -rXZ; dx <= rXZ; ++dx) {
                for (int dz = -rXZ; dz <= rXZ; ++dz) {
                    for (int dy = -rY; dy <= rY; ++dy) {
                        BlockState st;
                        boolean empty;
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        BlockPos p = new BlockPos(centerX + dx, centerY + dy, centerZ + dz);
                        ++totalSamples;
                        try {
                            empty = level.isEmptyBlock(p);
                        }
                        catch (Throwable t) {
                            ++solidSamples;
                            continue;
                        }
                        if (empty) continue;
                        try {
                            st = level.getBlockState(p);
                        }
                        catch (Throwable t) {
                            ++solidSamples;
                            continue;
                        }
                        if (st == null) {
                            ++solidSamples;
                            continue;
                        }
                        if (st.getCollisionShape((BlockGetter)level, p).isEmpty()) continue;
                        ++solidSamples;
                    }
                }
            }
            if (totalSamples <= 0 || solidSamples <= 0) {
                return 0.0;
            }
            double density = (double)solidSamples / (double)totalSamples;
            double weight = cfg.normalizedProximityWeight();
            double rawPenalty = density * weight * (double)totalSamples;
            if (rawPenalty > (maxPen = cfg.normalizedProximityMaxPenalty())) {
                rawPenalty = maxPen;
            }
            return rawPenalty;
        }
        catch (Throwable t) {
            if (DEBUG_LOGS) {
                LOG.warn("[RavenAStarPathing] computeProximityPenalty failed safely: {}", (Object)t.toString());
            }
            return 0.0;
        }
    }

    private static boolean computeNodePassable(Level level, int cx, int cy, int cz, Config cfg) {
        int gs = Math.max(1, cfg.gridStep);
        int clearanceXZ = Math.max(1, cfg.cellSize);
        int clearanceH = Math.max(1, cfg.clearanceHeight);
        int baseX = cx * gs;
        int baseY = cy * gs;
        int baseZ = cz * gs;
        for (int ox = 0; ox < clearanceXZ; ++ox) {
            for (int oy = 0; oy < clearanceH; ++oy) {
                for (int oz = 0; oz < clearanceXZ; ++oz) {
                    BlockState st;
                    boolean empty;
                    BlockPos p = new BlockPos(baseX + ox, baseY + oy, baseZ + oz);
                    try {
                        empty = level.isEmptyBlock(p);
                    }
                    catch (Throwable t) {
                        if (DEBUG_LOGS) {
                            LOG.warn("[RavenAStarPathing] computeNodePassable: isEmptyBlock failed at {} ({})", (Object)p, (Object)t.toString());
                        }
                        return false;
                    }
                    if (empty) continue;
                    try {
                        st = level.getBlockState(p);
                    }
                    catch (Throwable t) {
                        if (DEBUG_LOGS) {
                            LOG.warn("[RavenAStarPathing] computeNodePassable: getBlockState failed at {} ({})", (Object)p, (Object)t.toString());
                        }
                        return false;
                    }
                    if (st == null) {
                        return false;
                    }
                    if (cfg.allowLeaves && st.is(BlockTags.LEAVES) || cfg.allowReplaceables && st.canBeReplaced()) continue;
                    return false;
                }
            }
        }
        if (cfg.useSafetyBuffer) {
            int r = cfg.normalizedSafetyBufferXZ();
            int yUp = cfg.normalizedSafetyBufferYUp();
            int yDown = cfg.normalizedSafetyBufferYDown();
            if (r > 0 || yUp > 0 || yDown > 0) {
                int centerX = baseX + clearanceXZ / 2;
                int centerY = baseY + clearanceH / 2;
                int centerZ = baseZ + clearanceXZ / 2;
                for (int dx = -r; dx <= r; ++dx) {
                    for (int dz = -r; dz <= r; ++dz) {
                        for (int dy = -yDown; dy <= yUp; ++dy) {
                            BlockState st;
                            boolean empty;
                            BlockPos p = new BlockPos(centerX + dx, centerY + dy, centerZ + dz);
                            try {
                                empty = level.isEmptyBlock(p);
                            }
                            catch (Throwable t) {
                                if (DEBUG_LOGS) {
                                    LOG.warn("[RavenAStarPathing] safetyBuffer: isEmptyBlock failed at {} ({})", (Object)p, (Object)t.toString());
                                }
                                return false;
                            }
                            if (empty) continue;
                            try {
                                st = level.getBlockState(p);
                            }
                            catch (Throwable t) {
                                if (DEBUG_LOGS) {
                                    LOG.warn("[RavenAStarPathing] safetyBuffer: getBlockState failed at {} ({})", (Object)p, (Object)t.toString());
                                }
                                return false;
                            }
                            if (st == null) {
                                return false;
                            }
                            boolean allowed = false;
                            if (cfg.safetyBufferRespectsAllowFlags) {
                                if (cfg.allowLeaves && st.is(BlockTags.LEAVES)) {
                                    allowed = true;
                                } else if (cfg.allowReplaceables && st.canBeReplaced()) {
                                    allowed = true;
                                }
                            }
                            if (allowed) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    private static Vec3 nodeCenterWorld(int cx, int cy, int cz, int gridStep, int clearanceXZ, int clearanceH) {
        int gs = Math.max(1, gridStep);
        int cl = Math.max(1, clearanceXZ);
        int ch = Math.max(1, clearanceH);
        double bx = cx * gs;
        double by = cy * gs;
        double bz = cz * gs;
        double x = bx + (double)cl / 2.0;
        double y = by + (double)ch / 2.0;
        double z = bz + (double)cl / 2.0;
        return new Vec3(x, y, z);
    }

    private static BlockPos nodeAnchorBlock(int cx, int cy, int cz, int gridStep) {
        int gs = Math.max(1, gridStep);
        return new BlockPos(cx * gs, cy * gs, cz * gs);
    }

    private static boolean isCellPassable(ServerLevel level, BlockPos feetPos, int clearanceX, int clearanceZ, boolean allowLeaves, boolean allowReplaceables, boolean yAnchorFeet) {
        Logger LOGGER = LogUtils.getLogger();
        for (int dx = 0; dx < clearanceX; ++dx) {
            for (int dz = 0; dz < clearanceZ; ++dz) {
                BlockPos below;
                BlockState belowSt;
                BlockPos p = feetPos.offset(dx, 0, dz);
                BlockState st = level.getBlockState(p);
                if (!allowLeaves && st.is(BlockTags.LEAVES)) {
                    return false;
                }
                if (!allowReplaceables && st.canBeReplaced()) {
                    return false;
                }
                if (!st.getCollisionShape((BlockGetter)level, p).isEmpty()) {
                    return false;
                }
                if (!yAnchorFeet || !(belowSt = level.getBlockState(below = p.below())).getCollisionShape((BlockGetter)level, below).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    private static int floorDiv(int a, int b) {
        int r = a / b;
        int m = a % b;
        if (m != 0 && (a ^ b) < 0) {
            --r;
        }
        return r;
    }

    private static long pack(int cx, int cy, int cz) {
        int BIAS_XZ = 0x100000;
        int BIAS_Y = 0x200000;
        int px = cx + 0x100000;
        int py = cy + 0x200000;
        int pz = cz + 0x100000;
        return (long)(px &= 0x1FFFFF) << 43 | (long)(py &= 0x3FFFFF) << 21 | (long)(pz &= 0x1FFFFF);
    }

    private static NodeCoord unpack(long key) {
        int BIAS_XZ = 0x100000;
        int BIAS_Y = 0x200000;
        int px = (int)(key >>> 43 & 0x1FFFFFL);
        int py = (int)(key >>> 21 & 0x3FFFFFL);
        int pz = (int)(key & 0x1FFFFFL);
        int cx = px - 0x100000;
        int cy = py - 0x200000;
        int cz = pz - 0x100000;
        return new NodeCoord(cx, cy, cz);
    }

    public static final class Config {
        public boolean useProximityPenalty = true;
        public int proximityRadiusXZ = 1;
        public int proximityRadiusY = 1;
        public double proximityWeight = 0.08;
        public double proximityMaxPenalty = 0.9;
        public int cellSize = 2;
        public int gridStep = 1;
        public int clearanceHeight = 2;
        public boolean allowLeaves = false;
        public boolean allowReplaceables = false;
        public int maxExpanded = 6500;
        public int maxOpen = 16000;
        public int maxRawWaypoints = 768;
        public long tieBreakSeed = 0L;
        public boolean smoothPath = true;
        public int maxCellRadiusFromStart = 0;
        public boolean debug = false;
        public boolean useSafetyBuffer = false;
        public int safetyBufferXZ = 1;
        public int safetyBufferYUp = 1;
        public int safetyBufferYDown = 0;
        public boolean safetyBufferRespectsAllowFlags = true;

        private int normalizedGridStep() {
            return Math.max(1, this.gridStep);
        }

        private int normalizedClearanceXZ() {
            return Math.max(1, this.cellSize);
        }

        private int normalizedClearanceHeight() {
            return Math.max(1, this.clearanceHeight);
        }

        private int normalizedSafetyBufferXZ() {
            return Math.max(0, this.safetyBufferXZ);
        }

        private int normalizedSafetyBufferYUp() {
            return Math.max(0, this.safetyBufferYUp);
        }

        private int normalizedSafetyBufferYDown() {
            return Math.max(0, this.safetyBufferYDown);
        }

        private int normalizedProximityRadiusXZ() {
            return Math.max(0, this.proximityRadiusXZ);
        }

        private int normalizedProximityRadiusY() {
            return Math.max(0, this.proximityRadiusY);
        }

        private double normalizedProximityWeight() {
            return Math.max(0.0, this.proximityWeight);
        }

        private double normalizedProximityMaxPenalty() {
            return Math.max(0.0, this.proximityMaxPenalty);
        }
    }

    public static final class CellBounds {
        public final int minCx;
        public final int minCy;
        public final int minCz;
        public final int maxCx;
        public final int maxCy;
        public final int maxCz;

        public CellBounds(int minCx, int minCy, int minCz, int maxCx, int maxCy, int maxCz) {
            this.minCx = minCx;
            this.minCy = minCy;
            this.minCz = minCz;
            this.maxCx = maxCx;
            this.maxCy = maxCy;
            this.maxCz = maxCz;
        }

        public boolean contains(int cx, int cy, int cz) {
            return cx >= this.minCx && cx <= this.maxCx && cy >= this.minCy && cy <= this.maxCy && cz >= this.minCz && cz <= this.maxCz;
        }

        public String toString() {
            return "CellBounds{min=(" + this.minCx + "," + this.minCy + "," + this.minCz + "), max=(" + this.maxCx + "," + this.maxCy + "," + this.maxCz + ")}";
        }
    }

    private static final class NodeCoord {
        final int cx;
        final int cy;
        final int cz;

        private NodeCoord(int cx, int cy, int cz) {
            this.cx = cx;
            this.cy = cy;
            this.cz = cz;
        }

        static NodeCoord fromWorld(Vec3 pos, int gridStep, int clearanceXZ, int clearanceH) {
            int anchorY;
            int gs = Math.max(1, gridStep);
            int cl = Math.max(1, clearanceXZ);
            int ch = Math.max(1, clearanceH);
            int halfSpanXZ = Math.max(0, (cl - 1) / 2);
            int halfSpanY = Math.max(0, (ch - 1) / 2);
            int fx = Mth.floor((double)(pos.x + 1.0E-4));
            int fz = Mth.floor((double)(pos.z + 1.0E-4));
            int anchorX = fx - halfSpanXZ;
            int anchorZ = fz - halfSpanXZ;
            if (USE_FEET_BASED_Y_ANCHOR) {
                int fy = Mth.floor((double)(pos.y + 1.0E-4));
                anchorY = fy - halfSpanY;
            } else {
                anchorY = Mth.floor((double)(pos.y - (double)ch / 2.0));
            }
            int cx = RavenAStarPathing.floorDiv(anchorX, gs);
            int cy = RavenAStarPathing.floorDiv(anchorY, gs);
            int cz = RavenAStarPathing.floorDiv(anchorZ, gs);
            return new NodeCoord(cx, cy, cz);
        }

        public String toString() {
            return "NodeCoord{cx=" + this.cx + ", cy=" + this.cy + ", cz=" + this.cz + "}";
        }
    }
}

