/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.entity.raven.modules;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.z2six.featheredfriend.entity.raven.RavenAIState;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import net.z2six.featheredfriend.entity.raven.modules.RavenSoundEngine;
import net.z2six.featheredfriend.registry.FFNeoForgeParticles;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class Teleportation {
    private static final Logger LOG = LogUtils.getLogger();
    private final RavenEntity raven;
    public static final EntityDataAccessor<Integer> DATA_TELEPORT_FADE_ALPHA = SynchedEntityData.defineId(RavenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_TELEPORT_FX_TICKS = SynchedEntityData.defineId(RavenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Long> DATA_TELEPORT_FX_SEED = SynchedEntityData.defineId(RavenEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    public TeleportSeqPhase teleportSeqPhase = TeleportSeqPhase.NONE;
    private int teleportSeqTicks = 0;
    @Nullable
    private Vec3 teleportSeqTarget = null;
    @Nullable
    private String teleportSeqReason = null;
    private static final int TELEPORT_FADE_TICKS_OUT = 6;
    private static final int TELEPORT_FADE_TICKS_IN = 6;
    private static final int TELEPORT_INVISIBLE_HOLD_BEFORE_TICKS = 6;
    private static final int TELEPORT_INVISIBLE_HOLD_AFTER_TICKS = 8;
    private static final int TELEPORT_CHECK_INTERVAL_TICKS = 20;
    private static final double TELEPORT_MIN_MOVED_DIST = 1.0;
    private static final int TELEPORT_COOLDOWN_TICKS = 120;
    private static final int TELEPORT_MAX_SEARCH_RADIUS = 6;
    private static final int TELEPORT_MAX_CANDIDATES = 48;
    @Nullable
    private Vec3 teleportSampleLastPos = null;
    private int teleportSampleTicker = 0;
    private int teleportCooldownTicks = 0;
    private int teleportStuckSamples = 0;
    private static final int TELEPORT_FX_DURATION_TICKS = 10;
    private static final int TELEPORT_FX_BURST_MIN = 1;
    private static final int TELEPORT_FX_BURST_MAX = 1;
    private static final int TELEPORT_FX_BURST_SPACING_MIN_TICKS = 1;
    private static final int TELEPORT_FX_BURST_SPACING_MAX_TICKS = 3;
    private static final int TELEPORT_FX_PARTICLES_PER_BURST_MIN = 3;
    private static final int TELEPORT_FX_PARTICLES_PER_BURST_MAX = 3;
    private static final double TELEPORT_FX_SPREAD_XZ = 0.55;
    private static final double TELEPORT_FX_SPREAD_Y = 0.85;
    private static final double TELEPORT_FX_SPEED = 0.02;
    private int teleportFxBurstsRemaining = 0;
    private int teleportFxNextBurstInTicks = 0;
    private long teleportFxServerSeed = 0L;
    @Nullable
    private Vec3 teleportFxOriginA = null;
    @Nullable
    private Vec3 teleportFxOriginB = null;

    public Teleportation(RavenEntity raven) {
        this.raven = raven;
    }

    public static void initEntityData() {
    }

    public int getTeleportFxTicks(RavenEntity ravenEntity) {
        try {
            return (Integer)ravenEntity.getEntityData().get(DATA_TELEPORT_FX_TICKS);
        }
        catch (Throwable t) {
            if (ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Teleportation] getTeleportFxTicks failed safely: {}", (Object)t.toString());
            }
            return 0;
        }
    }

    public long getTeleportFxSeed(RavenEntity ravenEntity) {
        try {
            return (Long)ravenEntity.getEntityData().get(DATA_TELEPORT_FX_SEED);
        }
        catch (Throwable t) {
            if (ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Teleportation] getTeleportFxSeed failed safely: {}", (Object)t.toString());
            }
            return 0L;
        }
    }

    public int getTeleportFadeAlphaPublic(RavenEntity ravenEntity) {
        try {
            return (Integer)ravenEntity.getEntityData().get(DATA_TELEPORT_FADE_ALPHA);
        }
        catch (Throwable t) {
            if (ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Teleportation] getTeleportFadeAlphaPublic failed safely: {}", (Object)t.toString());
            }
            return 255;
        }
    }

    public void setTeleportFadeAlpha(int alpha, RavenEntity ravenEntity) {
        block2: {
            try {
                ravenEntity.getEntityData().set(DATA_TELEPORT_FADE_ALPHA, (Object)Mth.clamp((int)alpha, (int)0, (int)255));
            }
            catch (Throwable t) {
                if (ravenEntity.tickCount % 80 != 0) break block2;
                LOG.warn("[Teleportation] setTeleportFadeAlpha failed safely: {}", (Object)t.toString());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void tickTeleportSequenceServer(RavenEntity ravenEntity) {
        try {
            if (ravenEntity == null) {
                return;
            }
            if (ravenEntity.level() == null) {
                return;
            }
            if (ravenEntity.level().isClientSide) {
                return;
            }
            var3_2 = ravenEntity.level();
            if (!(var3_2 instanceof ServerLevel)) {
                return;
            }
            serverLevel = (ServerLevel)var3_2;
            if (this.teleportSeqPhase == TeleportSeqPhase.NONE) {
                return;
            }
            ravenEntity.setDeltaMovement(Vec3.ZERO);
            ravenEntity.hurtMarked = true;
            ++this.teleportSeqTicks;
            switch (this.teleportSeqPhase.ordinal()) {
                case 1: {
                    t = this.teleportSeqTicks;
                    total = Math.max(1, 6);
                    k = Mth.clamp((float)((float)t / (float)total), (float)0.0f, (float)1.0f);
                    alpha = (int)Mth.lerp((float)k, (float)255.0f, (float)0.0f);
                    this.setTeleportFadeAlpha(alpha, ravenEntity);
                    if (t >= total) {
                        this.teleportSeqPhase = TeleportSeqPhase.TELEPORTING;
                        this.teleportSeqTicks = 0;
                        this.setTeleportFadeAlpha(0, ravenEntity);
                    }
                    break;
                }
                case 2: {
                    this.setTeleportFadeAlpha(0, ravenEntity);
                    target = this.teleportSeqTarget;
                    if (target == null) {
                        if (ravenEntity.tickCount % 20 == 0) {
                            Teleportation.LOG.warn("[Teleportation] TeleportSequence TELEPORTING but target=null. Aborting.");
                        }
                        this.teleportSeqPhase = TeleportSeqPhase.NONE;
                        this.setTeleportFadeAlpha(255, ravenEntity);
                        this.endTeleportPhase("teleport target null", ravenEntity);
                        return;
                    }
                    holdBefore = Math.max(0, 6);
                    holdAfter = Math.max(0, 8);
                    teleportTickIndex = holdBefore + 1;
                    endOfAfterHoldTick = holdBefore + 1 + holdAfter;
                    v0 = shouldTeleportNow = this.teleportSeqTicks == teleportTickIndex;
                    if (!shouldTeleportNow) ** GOTO lbl68
                    teleported = false;
                    before = ravenEntity.position();
                    try {
                        teleported = ravenEntity.teleportTo(serverLevel, target.x, target.y, target.z, Set.of(), ravenEntity.getYRot(), ravenEntity.getXRot());
                    }
                    catch (Throwable t) {
                        if (ravenEntity.tickCount % 20 == 0) {
                            Teleportation.LOG.warn("[Teleportation] TeleportSequence teleportTo failed safely: {}", (Object)t.toString());
                        }
                        teleported = false;
                    }
                    if (!teleported) {
                        ravenEntity.setPos(target.x, target.y, target.z);
                    }
                    ravenEntity.setDeltaMovement(Vec3.ZERO);
                    ravenEntity.hurtMarked = true;
                    try {
                        fxSeed = this.getTeleportFxSeed(ravenEntity) ^ -3360793634556481523L ^ (long)ravenEntity.tickCount;
                        this.startTeleportFxServer(fxSeed, null, ravenEntity.position(), ravenEntity);
                    }
                    catch (Throwable t) {
                        if (ravenEntity.tickCount % 20 != 0) ** GOTO lbl66
                        Teleportation.LOG.warn("[Teleportation] TeleportSequence destination FX failed safely: {}", (Object)t.toString());
                    }
lbl66:
                    // 3 sources

                    if (ravenEntity.tickCount % 20 == 0) {
                        Teleportation.LOG.info("[Teleportation] TeleportSequence TELEPORTED reason={} teleported={} from={} newPos={} (holdBefore={} holdAfter={})", new Object[]{this.teleportSeqReason, teleported, before, ravenEntity.position(), holdBefore, holdAfter});
                    }
lbl68:
                    // 4 sources

                    if (this.teleportSeqTicks >= endOfAfterHoldTick) {
                        this.teleportSeqPhase = TeleportSeqPhase.FADING_IN;
                        this.teleportSeqTicks = 0;
                        this.setTeleportFadeAlpha(0, ravenEntity);
                    }
                    break;
                }
                case 3: {
                    t = this.teleportSeqTicks;
                    total = Math.max(1, 6);
                    k = Mth.clamp((float)((float)t / (float)total), (float)0.0f, (float)1.0f);
                    alpha = (int)Mth.lerp((float)k, (float)0.0f, (float)255.0f);
                    this.setTeleportFadeAlpha(alpha, ravenEntity);
                    if (t >= total) {
                        this.setTeleportFadeAlpha(255, ravenEntity);
                        old = this.teleportSeqPhase;
                        oldTarget = this.teleportSeqTarget;
                        oldReason = this.teleportSeqReason;
                        this.teleportSeqPhase = TeleportSeqPhase.NONE;
                        this.teleportSeqTicks = 0;
                        this.teleportSeqTarget = null;
                        this.teleportSeqReason = null;
                        this.endTeleportPhase("sequence done", ravenEntity);
                        Teleportation.setPrivateInt((Object)ravenEntity, "stuckTicks", 0);
                        Teleportation.setPrivateDouble((Object)ravenEntity, "lastDistToTarget", NaN);
                        Teleportation.setPrivateInt((Object)ravenEntity, "avoidanceCooldownTicks", 0);
                        Teleportation.invokeVoid1String((Object)ravenEntity, "reissueMovementIntentAfterTeleport", oldReason == null ? "teleport sequence" : oldReason, "[Teleportation] reissueMovementIntentAfterTeleport missing/failed");
                        if (ravenEntity.tickCount % 20 == 0) {
                            Teleportation.LOG.info("[Teleportation] TeleportSequence END phase={} reason={} target={}", new Object[]{old, oldReason, oldTarget});
                        }
                    }
                    break;
                }
            }
        }
        catch (Throwable t) {
            Teleportation.LOG.error("[Teleportation] tickTeleportSequenceServer failed", t);
            this.teleportSeqPhase = TeleportSeqPhase.NONE;
            this.teleportSeqTarget = null;
            this.teleportSeqReason = null;
            this.teleportSeqTicks = 0;
            this.setTeleportFadeAlpha(255, ravenEntity);
            this.endTeleportPhase("failsafe tickTeleportSequenceServer", ravenEntity);
        }
    }

    public void startTeleportSequence(@Nullable Vec3 target, long fxSeed, String reason, RavenEntity ravenEntity) {
        try {
            if (ravenEntity == null) {
                return;
            }
            if (ravenEntity.level() == null) {
                return;
            }
            if (ravenEntity.level().isClientSide) {
                return;
            }
            if (target == null) {
                return;
            }
            if (this.teleportSeqPhase != TeleportSeqPhase.NONE) {
                if (ravenEntity.tickCount % 20 == 0) {
                    LOG.debug("[Teleportation] startTeleportSequence ignored (already active). phase={} reason={}", (Object)this.teleportSeqPhase, (Object)reason);
                }
                return;
            }
            this.teleportSeqTarget = target;
            this.teleportSeqReason = reason;
            this.teleportSeqTicks = 0;
            this.teleportSeqPhase = TeleportSeqPhase.FADING_OUT;
            this.beginTeleportPhase(reason, ravenEntity);
            this.setTeleportFadeAlpha(255, ravenEntity);
            this.startTeleportFxServer(fxSeed, ravenEntity.position(), null, ravenEntity);
            if (ravenEntity.tickCount % 20 == 0) {
                LOG.info("[Teleportation] TeleportSequence START reason={} pos={} target={} fadeOutTicks={} fadeInTicks={}", new Object[]{reason, ravenEntity.position(), target, 6, 6});
            }
        }
        catch (Throwable t) {
            LOG.error("[Teleportation] startTeleportSequence failed (reason={})", (Object)reason, (Object)t);
            this.teleportSeqPhase = TeleportSeqPhase.NONE;
            this.teleportSeqTarget = null;
            this.teleportSeqReason = null;
            this.teleportSeqTicks = 0;
            this.setTeleportFadeAlpha(255, ravenEntity);
            this.endTeleportPhase("failsafe startTeleportSequence", ravenEntity);
        }
    }

    public void beginTeleportPhase(String reason, RavenEntity ravenEntity) {
        block4: {
            try {
                if (ravenEntity == null) {
                    return;
                }
                ravenEntity.setDeltaMovement(Vec3.ZERO);
                ravenEntity.hurtMarked = true;
                ravenEntity.setInvulnerable(true);
                ravenEntity.setNoGravity(true);
                Teleportation.setPrivateBoolean((Object)ravenEntity, "noPhysics", true);
                if (ravenEntity.tickCount % 20 == 0) {
                    LOG.debug("[Teleportation] beginTeleportPhase: id={} reason={} pos={} invuln={} fadeAlpha={}", new Object[]{ravenEntity.getId(), reason, ravenEntity.position(), ravenEntity.isInvulnerable(), this.getTeleportFadeAlphaPublic(ravenEntity)});
                }
            }
            catch (Throwable t) {
                if (ravenEntity == null || ravenEntity.tickCount % 80 != 0) break block4;
                LOG.warn("[Teleportation] beginTeleportPhase failed safely: {}", (Object)t.toString());
            }
        }
    }

    public void endTeleportPhase(String reason, RavenEntity ravenEntity) {
        block4: {
            try {
                if (ravenEntity == null) {
                    return;
                }
                Teleportation.setPrivateBoolean((Object)ravenEntity, "noPhysics", false);
                ravenEntity.setInvulnerable(false);
                ravenEntity.setInvisible(false);
                ravenEntity.hurtMarked = true;
                if (ravenEntity.tickCount % 20 == 0) {
                    LOG.debug("[Teleportation] endTeleportPhase: id={} reason={} pos={} invuln={} fadeAlpha={}", new Object[]{ravenEntity.getId(), reason, ravenEntity.position(), ravenEntity.isInvulnerable(), this.getTeleportFadeAlphaPublic(ravenEntity)});
                }
            }
            catch (Throwable t) {
                if (ravenEntity == null || ravenEntity.tickCount % 80 != 0) break block4;
                LOG.warn("[Teleportation] endTeleportPhase failed safely: {}", (Object)t.toString());
            }
        }
    }

    private void startTeleportFxServer(long seed, @Nullable Vec3 startPos, @Nullable Vec3 endPos, RavenEntity ravenEntity) {
        try {
            int bursts;
            int max;
            int min;
            if (ravenEntity == null) {
                return;
            }
            ravenEntity.getEntityData().set(DATA_TELEPORT_FX_SEED, (Object)seed);
            ravenEntity.getEntityData().set(DATA_TELEPORT_FX_TICKS, (Object)0);
            this.teleportFxServerSeed = seed;
            if (startPos != null) {
                this.teleportFxOriginA = startPos.add(0.0, 0.6, 0.0);
            }
            if (endPos != null) {
                this.teleportFxOriginB = endPos.add(0.0, 0.6, 0.0);
            }
            if ((min = Math.min(1, 1)) == (max = Math.max(1, 1))) {
                bursts = min;
            } else {
                RandomSource rnd = RandomSource.create((long)(seed ^ 0xC0FFEE1234ABCDEFL));
                bursts = min + rnd.nextInt(Math.max(1, max - min + 1));
            }
            bursts = Mth.clamp((int)bursts, (int)1, (int)12);
            if (this.teleportFxBurstsRemaining > 0) {
                this.teleportFxBurstsRemaining = Mth.clamp((int)(this.teleportFxBurstsRemaining + bursts), (int)1, (int)12);
                this.teleportFxNextBurstInTicks = Math.min(this.teleportFxNextBurstInTicks, 1);
            } else {
                this.teleportFxBurstsRemaining = bursts;
                this.teleportFxNextBurstInTicks = 0;
            }
            if (ravenEntity.tickCount % 20 == 0) {
                LOG.info("[Teleportation] TeleportFX scheduled: id={} bursts={} seed={} originA={} originB={}", new Object[]{ravenEntity.getId(), this.teleportFxBurstsRemaining, seed, this.teleportFxOriginA, this.teleportFxOriginB});
            }
        }
        catch (Throwable t) {
            if (ravenEntity != null && ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Teleportation] startTeleportFxServer failed safely: {}", (Object)t.toString());
            }
            this.teleportFxBurstsRemaining = 0;
            this.teleportFxNextBurstInTicks = 0;
            this.teleportFxOriginA = null;
            this.teleportFxOriginB = null;
        }
    }

    public void tickTeleportFxServer(RavenEntity ravenEntity) {
        try {
            if (ravenEntity == null) {
                return;
            }
            if (ravenEntity.level() == null) {
                return;
            }
            if (ravenEntity.level().isClientSide) {
                return;
            }
            Level level = ravenEntity.level();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.teleportFxBurstsRemaining <= 0) {
                return;
            }
            if (this.teleportFxNextBurstInTicks > 0) {
                --this.teleportFxNextBurstInTicks;
                return;
            }
            if (this.teleportFxOriginA != null) {
                this.spawnEnderpopBurst(serverLevel, this.teleportFxOriginA.x, this.teleportFxOriginA.y, this.teleportFxOriginA.z, this.teleportFxServerSeed ^ 0xA1A1A1A1A1A1A1A1L, "teleportFx A", ravenEntity);
            }
            if (this.teleportFxOriginB != null) {
                this.spawnEnderpopBurst(serverLevel, this.teleportFxOriginB.x, this.teleportFxOriginB.y, this.teleportFxOriginB.z, this.teleportFxServerSeed ^ 0xB2B2B2B2B2B2B2B2L, "teleportFx B", ravenEntity);
            }
            --this.teleportFxBurstsRemaining;
            if (this.teleportFxBurstsRemaining > 0) {
                int max;
                RandomSource rnd = RandomSource.create((long)(this.teleportFxServerSeed ^ 0x55AA55AA55AA55AAL ^ (long)this.teleportFxBurstsRemaining));
                int min = Math.min(1, 3);
                int gap = min == (max = Math.max(1, 3)) ? min : min + rnd.nextInt(Math.max(1, max - min + 1));
                this.teleportFxNextBurstInTicks = Mth.clamp((int)gap, (int)0, (int)20);
            } else {
                this.teleportFxNextBurstInTicks = 0;
                this.teleportFxOriginA = null;
                this.teleportFxOriginB = null;
            }
        }
        catch (Throwable t) {
            if (ravenEntity != null && ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Teleportation] tickTeleportFxServer failed safely: {}", (Object)t.toString());
            }
            this.teleportFxBurstsRemaining = 0;
            this.teleportFxNextBurstInTicks = 0;
            this.teleportFxOriginA = null;
            this.teleportFxOriginB = null;
        }
    }

    public void spawnEnderpopBurst(ServerLevel level, double x, double y, double z, long seed, String why, RavenEntity ravenEntity) {
        block8: {
            try {
                int count;
                block7: {
                    int perMax;
                    if (level == null || ravenEntity == null) {
                        return;
                    }
                    RandomSource rnd = RandomSource.create((long)(seed ^ (long)ravenEntity.getId() * -7046029254386353131L ^ (long)ravenEntity.tickCount));
                    int perMin = Math.min(3, 3);
                    count = perMin == (perMax = Math.max(3, 3)) ? perMin : perMin + rnd.nextInt(Math.max(1, perMax - perMin + 1));
                    count = Mth.clamp((int)count, (int)1, (int)64);
                    level.sendParticles((ParticleOptions)((SimpleParticleType)FFNeoForgeParticles.ENDERPOP.get()), x, y, z, count, 0.55, 0.85, 0.55, 0.02);
                    try {
                        BlockPos soundPos = BlockPos.containing((double)x, (double)y, (double)z);
                        Vec3 soundVec = new Vec3(x, y, z);
                        RavenSoundEngine.playAt((Level)level, SoundEvents.ENDERMAN_TELEPORT, SoundSource.NEUTRAL, soundVec, 0.25f, 1.0f);
                        if (ravenEntity.tickCount % 40 == 0) {
                            LOG.debug("[Teleportation] spawnEnderpopBurst sound: id={} pos={} soundPos={}", new Object[]{ravenEntity.getId(), soundVec, soundPos});
                        }
                    }
                    catch (Throwable soundErr) {
                        if (ravenEntity.tickCount % 80 != 0) break block7;
                        LOG.warn("[Teleportation] spawnEnderpopBurst: sound playback failed safely: {}", (Object)soundErr.toString());
                    }
                }
                if (ravenEntity.tickCount % 20 == 0) {
                    LOG.debug("[Teleportation] EnderpopBurst: id={} why={} count={} spread=({}, {}, {}) speed={} pos=({}, {}, {}) seed={}", new Object[]{ravenEntity.getId(), why, count, String.format("%.2f", 0.55), String.format("%.2f", 0.85), String.format("%.2f", 0.55), String.format("%.3f", 0.02), String.format("%.2f", x), String.format("%.2f", y), String.format("%.2f", z), seed});
                }
            }
            catch (Throwable t) {
                if (ravenEntity == null || ravenEntity.tickCount % 80 != 0) break block8;
                LOG.warn("[Teleportation] spawnEnderpopBurst failed safely: {}", (Object)t.toString());
            }
        }
    }

    @Nullable
    public BlockPos findNearbyEmptyTeleportBlock(RavenEntity ravenEntity) {
        try {
            if (ravenEntity == null || ravenEntity.level() == null) {
                return null;
            }
            BlockPos base = ravenEntity.blockPosition();
            RandomSource rnd = ravenEntity.getRandom();
            for (int i = 0; i < 48; ++i) {
                Vec3 center;
                int rx = rnd.nextInt(13) - 6;
                int rz = rnd.nextInt(13) - 6;
                int ry = rnd.nextInt(5) - 2;
                BlockPos p = base.offset(rx, ry, rz);
                if (!ravenEntity.level().isEmptyBlock(p) || !ravenEntity.level().isEmptyBlock(p.above()) || !ravenEntity.level().getFluidState(p).isEmpty() || Teleportation.invokeIsOutOfHomeBounds(ravenEntity, center = new Vec3((double)p.getX() + 0.5, (double)p.getY(), (double)p.getZ() + 0.5))) continue;
                BlockState below = ravenEntity.level().getBlockState(p.below());
                if (below == null || below.is(BlockTags.LEAVES)) {
                    // empty if block
                }
                return p;
            }
            return null;
        }
        catch (Throwable t) {
            if (ravenEntity != null && ravenEntity.tickCount % 60 == 0) {
                LOG.warn("[Teleportation] findNearbyEmptyTeleportBlock failed safely: {}", (Object)t.toString());
            }
            return null;
        }
    }

    @Nullable
    public BlockPos findNearbyEmptyTeleportBlock3x3x3(int radiusBlocks, int maxCandidates, RavenEntity ravenEntity) {
        try {
            if (ravenEntity == null || ravenEntity.level() == null) {
                return null;
            }
            int r = Math.max(1, radiusBlocks);
            int candidates = Math.max(1, maxCandidates);
            BlockPos base = ravenEntity.blockPosition();
            RandomSource rnd = ravenEntity.getRandom();
            int yBand = 4;
            for (int i = 0; i < candidates; ++i) {
                boolean ok;
                int rx = rnd.nextInt(r * 2 + 1) - r;
                int rz = rnd.nextInt(r * 2 + 1) - r;
                int ry = rnd.nextInt(yBand * 2 + 1) - yBand;
                BlockPos p = base.offset(rx, ry, rz);
                if (!ravenEntity.level().isEmptyBlock(p) || !ravenEntity.level().isEmptyBlock(p.above()) || !ravenEntity.level().getFluidState(p).isEmpty() || !(ok = this.isEmptyTeleportPocket3x3x3At(p, ravenEntity))) continue;
                return p;
            }
            return null;
        }
        catch (Throwable t) {
            if (ravenEntity != null && ravenEntity.tickCount % 60 == 0) {
                LOG.warn("[Teleportation] findNearbyEmptyTeleportBlock3x3x3 failed safely: {}", (Object)t.toString());
            }
            return null;
        }
    }

    @Nullable
    public BlockPos findEmptyTeleportBlock3x3x3Near(BlockPos center, int radiusBlocks, int maxCandidates, long seed, RavenEntity ravenEntity) {
        try {
            if (ravenEntity == null || ravenEntity.level() == null) {
                return null;
            }
            if (center == null) {
                return null;
            }
            int r = Math.max(1, radiusBlocks);
            int candidates = Math.max(1, maxCandidates);
            RandomSource rnd = RandomSource.create((long)(seed ^ 0xA11CE5ED1234L));
            int yBand = 4;
            for (int i = 0; i < candidates; ++i) {
                Vec3 pv;
                int rx = rnd.nextInt(r * 2 + 1) - r;
                int rz = rnd.nextInt(r * 2 + 1) - r;
                int ry = rnd.nextInt(yBand * 2 + 1) - yBand;
                BlockPos p = center.offset(rx, ry, rz);
                if (!ravenEntity.level().isEmptyBlock(p) || !ravenEntity.level().isEmptyBlock(p.above()) || !ravenEntity.level().getFluidState(p).isEmpty() || Teleportation.invokeIsOutOfHomeBounds(ravenEntity, pv = new Vec3((double)p.getX() + 0.5, (double)p.getY(), (double)p.getZ() + 0.5)) || !this.isEmptyTeleportPocket3x3x3At(p, ravenEntity)) continue;
                return p;
            }
            if (ravenEntity.tickCount % 60 == 0) {
                LOG.debug("[Teleportation] findEmptyTeleportBlock3x3x3Near: no pocket found center={} r={} candidates={} seed={}", new Object[]{center, r, candidates, seed});
            }
            return null;
        }
        catch (Throwable t) {
            if (ravenEntity != null && ravenEntity.tickCount % 60 == 0) {
                LOG.warn("[Teleportation] findEmptyTeleportBlock3x3x3Near failed safely: {}", (Object)t.toString());
            }
            return null;
        }
    }

    private boolean isEmptyTeleportPocket3x3x3At(BlockPos anchor, RavenEntity ravenEntity) {
        try {
            if (anchor == null || ravenEntity == null || ravenEntity.level() == null) {
                return false;
            }
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    for (int dy = 0; dy <= 2; ++dy) {
                        BlockPos p = anchor.offset(dx, dy, dz);
                        if (!ravenEntity.level().isEmptyBlock(p)) {
                            return false;
                        }
                        if (ravenEntity.level().getFluidState(p).isEmpty()) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Throwable t) {
            if (ravenEntity != null && ravenEntity.tickCount % 120 == 0) {
                LOG.warn("[Teleportation] isEmptyTeleportPocket3x3x3At failed safely: {}", (Object)t.toString());
            }
            return false;
        }
    }

    @Nullable
    private BlockPos pickUpcomingPathWaypointTeleportTarget(RavenEntity ravenEntity, boolean excludeFinalWaypoint, int radiusBlocks, int maxCandidates, long salt) {
        try {
            int end;
            if (ravenEntity == null) {
                return null;
            }
            Object wpObj = Teleportation.getPrivateObject((Object)ravenEntity, "pathWaypoints");
            if (!(wpObj instanceof List)) {
                return null;
            }
            List rawList = (List)wpObj;
            if (rawList.isEmpty()) {
                return null;
            }
            int total = rawList.size();
            int currentIdx = Teleportation.getPrivateInt((Object)ravenEntity, "pathWaypointIndex", 0);
            if (currentIdx < 0 || currentIdx >= total) {
                currentIdx = 0;
            }
            int start = currentIdx + 1;
            int n = end = excludeFinalWaypoint ? total - 2 : total - 1;
            if (end < start || end < 0) {
                return null;
            }
            start = Math.max(0, Math.min(start, total - 1));
            if ((end = Math.max(0, Math.min(end, total - 1))) < start) {
                return null;
            }
            RandomSource rnd = ravenEntity.getRandom();
            int span = end - start + 1;
            int attempts = Math.min(6, span);
            for (int n2 = 0; n2 < attempts; ++n2) {
                long seed;
                int offset = span <= 1 ? 0 : rnd.nextInt(span);
                int idx = start + offset;
                Object v = rawList.get(idx);
                if (!(v instanceof Vec3)) continue;
                Vec3 wp = (Vec3)v;
                BlockPos center = BlockPos.containing((double)Math.floor(wp.x), (double)Math.floor(wp.y), (double)Math.floor(wp.z));
                BlockPos pocket = this.findEmptyTeleportBlock3x3x3Near(center, radiusBlocks, maxCandidates, seed = salt ^ ravenEntity.getUUID().getLeastSignificantBits() ^ (long)ravenEntity.tickCount ^ center.asLong() ^ (long)idx, ravenEntity);
                if (pocket == null) continue;
                if (ravenEntity.tickCount % 40 == 0) {
                    LOG.debug("[Teleportation] pickUpcomingPathWaypointTeleportTarget: picked waypointIdx={} center={} pocket={} excludeFinal={} total={}", new Object[]{idx, center, pocket, excludeFinalWaypoint, total});
                }
                return pocket;
            }
            if (ravenEntity.tickCount % 80 == 0) {
                LOG.debug("[Teleportation] pickUpcomingPathWaypointTeleportTarget: no pocket around waypoints range=[{}..{}] total={}", new Object[]{start, end, total});
            }
            return null;
        }
        catch (Throwable t) {
            if (ravenEntity != null && ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Teleportation] pickUpcomingPathWaypointTeleportTarget failed safely: {}", (Object)t.toString());
            }
            return null;
        }
    }

    public void tickTeleportRecoverySampler(RavenEntity ravenEntity) {
        try {
            boolean movedEnough;
            boolean eligible;
            if (ravenEntity == null) {
                return;
            }
            if (ravenEntity.level() == null) {
                return;
            }
            if (ravenEntity.level().isClientSide) {
                return;
            }
            if (this.teleportCooldownTicks > 0) {
                --this.teleportCooldownTicks;
            }
            RavenAIState st = ravenEntity.getAIState();
            boolean excludedByPhase = this.teleportSeqPhase != TeleportSeqPhase.NONE || st == RavenAIState.IDLE_GROUND;
            try {
                eligible = Teleportation.invokeBoolean0((Object)ravenEntity, "isTeleportRecoveryEligible", true);
            }
            catch (Throwable t) {
                eligible = true;
            }
            if (excludedByPhase || !eligible) {
                this.teleportSampleLastPos = ravenEntity.position();
                this.teleportSampleTicker = 0;
                this.teleportStuckSamples = 0;
                if (excludedByPhase && ravenEntity.tickCount % 80 == 0) {
                    Object landingPhase = Teleportation.getPrivateObject((Object)ravenEntity, "landingPhase");
                    int idleLockTicks = Teleportation.getPrivateInt((Object)ravenEntity, "idleLockTicks", -1);
                    LOG.debug("[Teleportation] TeleportRecovery: sampling skipped. phase={} ai={} landingPhase={} idleLockTicks={} pos={}", new Object[]{this.teleportSeqPhase, st, landingPhase, idleLockTicks, ravenEntity.position()});
                }
                return;
            }
            ++this.teleportSampleTicker;
            if (this.teleportSampleTicker < 20) {
                return;
            }
            this.teleportSampleTicker = 0;
            Vec3 now = ravenEntity.position();
            if (this.teleportSampleLastPos == null) {
                this.teleportSampleLastPos = now;
                this.teleportStuckSamples = 0;
                return;
            }
            double moved = now.distanceTo(this.teleportSampleLastPos);
            this.teleportSampleLastPos = now;
            if (this.teleportCooldownTicks > 0) {
                this.teleportStuckSamples = 0;
                return;
            }
            boolean bl = movedEnough = moved >= 1.0;
            if (movedEnough) {
                if (this.teleportStuckSamples > 0 && ravenEntity.tickCount % 40 == 0) {
                    LOG.debug("[Teleportation] TeleportRecovery: progress resumed; reset stuckSamples. moved={} >= {} ai={} pos={} vel={}", new Object[]{String.format("%.3f", moved), 1.0, st, now, ravenEntity.getDeltaMovement()});
                }
                this.teleportStuckSamples = 0;
                return;
            }
            ++this.teleportStuckSamples;
            if (ravenEntity.tickCount % 20 == 0) {
                LOG.info("[Teleportation] TeleportRecovery: stuck sample {}/3 (moved={} < {}) ai={} pos={} vel={}", new Object[]{this.teleportStuckSamples, String.format("%.3f", moved), 1.0, st, now, ravenEntity.getDeltaMovement()});
            }
            if (this.teleportStuckSamples < 3) {
                return;
            }
            this.teleportStuckSamples = 0;
            boolean ok = this.attemptTeleportRecovery("stuck 3x (3s) moved<1", ravenEntity);
            this.teleportCooldownTicks = ok ? 120 : Math.min(120, 40);
        }
        catch (Throwable t) {
            LOG.error("[Teleportation] tickTeleportRecoverySampler failed", t);
            this.teleportSampleLastPos = ravenEntity != null ? ravenEntity.position() : null;
            this.teleportSampleTicker = 0;
            this.teleportStuckSamples = 0;
        }
    }

    public boolean attemptTeleportRecovery(String reason, RavenEntity ravenEntity) {
        try {
            if (ravenEntity == null) {
                return false;
            }
            if (ravenEntity.level() == null) {
                return false;
            }
            if (ravenEntity.level().isClientSide) {
                return false;
            }
            if (!(ravenEntity.level() instanceof ServerLevel)) {
                return false;
            }
            boolean eligible = Teleportation.invokeBoolean0((Object)ravenEntity, "isTeleportRecoveryEligible", true);
            if (!eligible) {
                if (ravenEntity.tickCount % 40 == 0) {
                    LOG.debug("[Teleportation] TeleportRecovery skipped (not eligible). reason={} state={} pos={}", new Object[]{reason, ravenEntity.getAIState(), ravenEntity.position()});
                }
                return false;
            }
            if (this.teleportSeqPhase != TeleportSeqPhase.NONE) {
                if (ravenEntity.tickCount % 20 == 0) {
                    LOG.debug("[Teleportation] TeleportRecovery ignored (sequence active). phase={} reason={}", (Object)this.teleportSeqPhase, (Object)reason);
                }
                return true;
            }
            boolean usedWaypoint = false;
            long WAYPOINT_SALT = 43350355429L;
            BlockPos targetPos = this.pickUpcomingPathWaypointTeleportTarget(ravenEntity, true, 4, 80, 43350355429L);
            if (targetPos != null) {
                usedWaypoint = true;
            } else {
                targetPos = this.findNearbyEmptyTeleportBlock(ravenEntity);
            }
            if (targetPos == null) {
                if (ravenEntity.tickCount % 20 == 0) {
                    LOG.warn("[Teleportation] TeleportRecovery: no teleport target found near pos={} reason={} (usedWaypoint={})", new Object[]{ravenEntity.position(), reason, usedWaypoint});
                }
                return false;
            }
            Vec3 end = new Vec3((double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5);
            long fxSeed = ravenEntity.getUUID().getLeastSignificantBits() ^ (long)ravenEntity.tickCount ^ targetPos.asLong();
            this.startTeleportSequence(end, fxSeed, reason, ravenEntity);
            if (ravenEntity.tickCount % 20 == 0) {
                LOG.info("[Teleportation] TeleportRecovery armed sequence reason={} targetBlock={} endPos={} usedWaypoint={}", new Object[]{reason, targetPos, end, usedWaypoint});
            }
            return true;
        }
        catch (Throwable t) {
            LOG.error("[Teleportation] attemptTeleportRecovery failed (reason={})", (Object)reason, (Object)t);
            this.teleportSeqPhase = TeleportSeqPhase.NONE;
            this.teleportSeqTarget = null;
            this.teleportSeqReason = null;
            this.teleportSeqTicks = 0;
            this.setTeleportFadeAlpha(255, ravenEntity);
            this.endTeleportPhase("failsafe attemptTeleportRecovery", ravenEntity);
            return false;
        }
    }

    public void requestPanicTeleportAwayFromPlayer(@Nullable Player player, double distToPlayer, RavenEntity ravenEntity) {
        try {
            long seed;
            double rz;
            double sin;
            int dt;
            if (ravenEntity == null) {
                return;
            }
            if (ravenEntity.level() == null) {
                return;
            }
            if (ravenEntity.level().isClientSide) {
                return;
            }
            if (!ravenEntity.isAlive()) {
                return;
            }
            boolean followOverride = Teleportation.invokeBoolean0((Object)ravenEntity, "isFollowOverrideActive", false);
            boolean lureActive = Teleportation.invokeBoolean0((Object)ravenEntity, "isLureFollowActive", false);
            if (followOverride && ravenEntity.getAIState() == RavenAIState.FOLLOW_OWNER || lureActive) {
                if (ravenEntity.tickCount % 40 == 0) {
                    LOG.debug("[Teleportation] requestPanicTeleportAwayFromPlayer suppressed (follow/lure active). player={} dist={} pos={} ai={} followOverride={} lureActive={}", new Object[]{player == null ? "null" : player.getName().getString(), String.format("%.2f", distToPlayer), ravenEntity.position(), ravenEntity.getAIState(), followOverride, lureActive});
                }
                return;
            }
            if (player == null || !player.isAlive() || player.isSpectator()) {
                if (ravenEntity.tickCount % 40 == 0) {
                    LOG.debug("[Teleportation] requestPanicTeleportAwayFromPlayer: invalid player (skip)");
                }
                return;
            }
            if (this.teleportSeqPhase != TeleportSeqPhase.NONE) {
                if (ravenEntity.tickCount % 40 == 0) {
                    LOG.debug("[Teleportation] requestPanicTeleportAwayFromPlayer: teleportSeqPhase={} (skip)", (Object)this.teleportSeqPhase);
                }
                return;
            }
            int PANIC_MIN_INTERVAL_TICKS = 30;
            int lastPanic = Teleportation.getPrivateInt((Object)ravenEntity, "lastPanicTeleportTick", Integer.MIN_VALUE);
            int n = dt = lastPanic == Integer.MIN_VALUE ? Integer.MAX_VALUE : ravenEntity.tickCount - lastPanic;
            if (dt >= 0 && dt < 30) {
                if (ravenEntity.tickCount % 40 == 0) {
                    LOG.debug("[Teleportation] PanicTeleport suppressed by interval: dt={} < {} dist={} player={} pos={}", new Object[]{dt, 30, String.format("%.2f", distToPlayer), player.getName().getString(), ravenEntity.position()});
                }
                return;
            }
            Vec3 ravenPos = ravenEntity.position();
            Vec3 playerPos = player.position();
            Vec3 look = player.getLookAngle();
            double lx = look.x;
            double lz = look.z;
            double lLen = Math.sqrt(lx * lx + lz * lz);
            if (lLen < 1.0E-4) {
                RandomSource rnd = ravenEntity.getRandom();
                double ang = rnd.nextDouble() * (Math.PI * 2);
                lx = Math.cos(ang);
                lz = Math.sin(ang);
                lLen = 1.0;
            }
            double bx = -lx / lLen;
            double bz = -lz / lLen;
            RandomSource rnd = ravenEntity.getRandom();
            double yawOffset = rnd.nextDouble() * Math.PI - 1.5707963267948966;
            double cos = Math.cos(yawOffset);
            double rx = bx * cos - bz * (sin = Math.sin(yawOffset));
            double rLen = Math.sqrt(rx * rx + (rz = bx * sin + bz * cos) * rz);
            if (rLen < 1.0E-4) {
                rx = bx;
                rz = bz;
                rLen = 1.0;
            }
            double TELEPORT_DIST = 30.0;
            double tx = playerPos.x + (rx /= rLen) * 30.0;
            double tz = playerPos.z + (rz /= rLen) * 30.0;
            int tyInt = Teleportation.invokeClampYToHomeBounds(ravenEntity, Mth.floor((double)ravenPos.y));
            double ty = (double)tyInt + 0.75;
            Vec3 raw = new Vec3(tx, ty, tz);
            Vec3 clamped = Teleportation.invokeClampTargetToHomeBounds(ravenEntity, raw);
            BlockPos center = BlockPos.containing((double)clamped.x, (double)clamped.y, (double)clamped.z);
            BlockPos targetBlock = this.findEmptyTeleportBlock3x3x3Near(center, 10, 260, seed = ravenEntity.getUUID().getLeastSignificantBits() ^ (long)ravenEntity.tickCount ^ player.getUUID().getMostSignificantBits() ^ center.asLong() ^ 0x5AC1F1EDBEEFL, ravenEntity);
            if (targetBlock == null) {
                targetBlock = this.findNearbyEmptyTeleportBlock3x3x3(10, 90, ravenEntity);
            }
            if (targetBlock == null) {
                targetBlock = this.findNearbyEmptyTeleportBlock(ravenEntity);
            }
            if (targetBlock == null) {
                if (ravenEntity.tickCount % 20 == 0) {
                    LOG.warn("[Teleportation] PanicTeleport: no valid teleport target found. player={} dist={} ravenPos={} raw={} clamped={}", new Object[]{player.getName().getString(), String.format("%.2f", distToPlayer), ravenPos, raw, clamped});
                }
                Teleportation.setPrivateInt((Object)ravenEntity, "lastPanicTeleportTick", ravenEntity.tickCount);
                return;
            }
            Vec3 end = new Vec3((double)targetBlock.getX() + 0.5, (double)targetBlock.getY(), (double)targetBlock.getZ() + 0.5);
            if (Teleportation.invokeIsOutOfHomeBounds(ravenEntity, end)) {
                if (ravenEntity.tickCount % 20 == 0) {
                    LOG.warn("[Teleportation] PanicTeleport: selected end out of home bounds. end={} basePos={}", (Object)end, (Object)ravenEntity.position());
                }
                Teleportation.setPrivateInt((Object)ravenEntity, "lastPanicTeleportTick", ravenEntity.tickCount);
                return;
            }
            Teleportation.setPostTeleportIntentIfPossible(ravenEntity, "ROAM_FLIGHT");
            Teleportation.invokeVoid0((Object)ravenEntity, "clearFlyTarget", "[Teleportation] clearFlyTarget missing/failed");
            Teleportation.invokeVoid1String((Object)ravenEntity, "clearPlannedPath", "panic teleport", "[Teleportation] clearPlannedPath missing/failed");
            Teleportation.setPrivateInt((Object)ravenEntity, "playerAvoidanceOverrideTicks", 0);
            Teleportation.setPrivateInt((Object)ravenEntity, "playerAvoidanceRearmCooldownTicks", 20);
            long fxSeed = ravenEntity.getUUID().getLeastSignificantBits() ^ (long)ravenEntity.tickCount ^ targetBlock.asLong() ^ player.getUUID().getMostSignificantBits() ^ 0xD15C0FFEE0DDF00DL;
            String why = "panic teleport behind: player=" + player.getName().getString() + " dist=" + String.format("%.2f", distToPlayer) + " yawOffsetDeg=" + String.format("%.1f", yawOffset * 57.29577951308232);
            Teleportation.setPrivateInt((Object)ravenEntity, "lastPanicTeleportTick", ravenEntity.tickCount);
            this.startTeleportSequence(end, fxSeed, why, ravenEntity);
            if (ravenEntity.tickCount % 20 == 0) {
                LOG.info("[Teleportation] PanicTeleport STARTED: reason={} ravenPos={} playerPos={} behindDir=({}, {}) dist={} raw={} clamped={} targetBlock={} end={} fxSeed={}", new Object[]{why, ravenPos, playerPos, String.format("%.3f", rx), String.format("%.3f", rz), String.format("%.1f", 30.0), raw, clamped, targetBlock, end, fxSeed});
            }
        }
        catch (Throwable t) {
            LOG.error("[Teleportation] requestPanicTeleportAwayFromPlayer failed safely", t);
            try {
                if (ravenEntity != null) {
                    Teleportation.setPrivateInt((Object)ravenEntity, "lastPanicTeleportTick", ravenEntity.tickCount);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean requestDamageBlinkTeleport(@Nullable DamageSource source, float amount, String reasonTag, RavenEntity ravenEntity) {
        try {
            int dt;
            if (ravenEntity == null) {
                return false;
            }
            if (ravenEntity.level() == null) {
                return false;
            }
            if (ravenEntity.level().isClientSide) {
                return false;
            }
            if (!ravenEntity.isAlive()) {
                return false;
            }
            Teleportation.setPostTeleportIntentIfPossible(ravenEntity, "ROAM_FLIGHT");
            if (this.teleportSeqPhase != TeleportSeqPhase.NONE) {
                if (ravenEntity.tickCount % 20 == 0) {
                    LOG.debug("[Teleportation] requestDamageBlinkTeleport: sequence already active; intent=ROAM_FLIGHT reasonTag={} phase={} pos={}", new Object[]{reasonTag, this.teleportSeqPhase, ravenEntity.position()});
                }
                return true;
            }
            int lastTick = Teleportation.getPrivateInt((Object)ravenEntity, "lastDamageBlinkTick", Integer.MIN_VALUE);
            int minInterval = Teleportation.getPrivateStaticInt(RavenEntity.class, "DAMAGE_BLINK_MIN_INTERVAL_TICKS", 0);
            if (lastTick != Integer.MIN_VALUE && minInterval > 0 && (dt = ravenEntity.tickCount - lastTick) < minInterval) {
                if (ravenEntity.tickCount % 20 == 0) {
                    LOG.debug("[Teleportation] requestDamageBlinkTeleport: suppressed by interval dt={} < {} reasonTag={} pos={}", new Object[]{dt, minInterval, reasonTag, ravenEntity.position()});
                }
                return false;
            }
            Teleportation.setPrivateInt((Object)ravenEntity, "lastDamageBlinkTick", ravenEntity.tickCount);
            BlockPos targetBlock = this.findNearbyEmptyTeleportBlock3x3x3(10, 80, ravenEntity);
            if (targetBlock == null) {
                targetBlock = this.findNearbyEmptyTeleportBlock(ravenEntity);
            }
            if (targetBlock == null) {
                if (ravenEntity.tickCount % 20 == 0) {
                    LOG.warn("[Teleportation] requestDamageBlinkTeleport: no valid teleport target found. reasonTag={} src={} amt={} pos={}", new Object[]{reasonTag, source == null ? "null" : source.toString(), Float.valueOf(amount), ravenEntity.position()});
                }
                return false;
            }
            Vec3 end = new Vec3((double)targetBlock.getX() + 0.5, (double)targetBlock.getY(), (double)targetBlock.getZ() + 0.5);
            long DAMAGE_BLINK_SALT = 56059911917L;
            long fxSeed = ravenEntity.getUUID().getLeastSignificantBits() ^ (long)ravenEntity.tickCount ^ targetBlock.asLong() ^ 0xD0D6E5EEDL ^ (long)Float.floatToIntBits(amount);
            this.startTeleportSequence(end, fxSeed, "damage blink: " + reasonTag, ravenEntity);
            if (ravenEntity.tickCount % 20 == 0) {
                LOG.info("[Teleportation] requestDamageBlinkTeleport: STARTED reasonTag={} src={} amt={} fromPos={} toBlock={} end={} fxSeed={}", new Object[]{reasonTag, source == null ? "null" : source.toString(), Float.valueOf(amount), ravenEntity.position(), targetBlock, end, fxSeed});
            }
            return true;
        }
        catch (Throwable t) {
            LOG.error("[Teleportation] requestDamageBlinkTeleport failed reasonTag={}", (Object)reasonTag, (Object)t);
            return false;
        }
    }

    public void tickRandomFlightTeleportBlink(RavenEntity ravenEntity) {
        try {
            boolean newSession;
            boolean inFlight;
            RavenAIState st;
            if (ravenEntity == null) {
                return;
            }
            if (ravenEntity.level() == null) {
                return;
            }
            if (ravenEntity.level().isClientSide) {
                return;
            }
            if (!ravenEntity.isAlive()) {
                return;
            }
            if (this.teleportSeqPhase != TeleportSeqPhase.NONE) {
                return;
            }
            try {
                Object v = Teleportation.invokeObject0((Object)ravenEntity, "getAIStateForDebug");
                st = v instanceof RavenAIState ? (RavenAIState)((Object)v) : ravenEntity.getAIState();
            }
            catch (Throwable ignored) {
                st = ravenEntity.getAIState();
            }
            boolean bl = inFlight = st == RavenAIState.ROAM_FLY || st == RavenAIState.FOLLOW_OWNER || st == RavenAIState.AVOID_PLAYER;
            if (!inFlight) {
                Teleportation.setPrivateObject((Object)ravenEntity, "flightTeleportLastAI", null);
                Teleportation.setPrivateInt((Object)ravenEntity, "flightTeleportBudget", 0);
                Teleportation.setPrivateInt((Object)ravenEntity, "flightTeleportUsed", 0);
                Teleportation.setPrivateInt((Object)ravenEntity, "flightTeleportCheckCooldownTicks", 0);
                Teleportation.setPrivateInt((Object)ravenEntity, "flightTeleportHardCooldownTicks", 0);
                return;
            }
            Object lastAI = Teleportation.getPrivateObject((Object)ravenEntity, "flightTeleportLastAI");
            int budget = Teleportation.getPrivateInt((Object)ravenEntity, "flightTeleportBudget", 0);
            int used = Teleportation.getPrivateInt((Object)ravenEntity, "flightTeleportUsed", 0);
            int checkCd = Teleportation.getPrivateInt((Object)ravenEntity, "flightTeleportCheckCooldownTicks", 0);
            int hardCd = Teleportation.getPrivateInt((Object)ravenEntity, "flightTeleportHardCooldownTicks", 0);
            boolean bl2 = newSession = lastAI == null || lastAI != st;
            if (newSession) {
                Teleportation.setPrivateObject((Object)ravenEntity, "flightTeleportLastAI", (Object)st);
                int roll = ravenEntity.getRandom().nextInt(100);
                budget = roll < 55 ? 0 : (roll < 90 ? 1 : 2);
                used = 0;
                checkCd = 40 + ravenEntity.getRandom().nextInt(60);
                hardCd = 0;
                Teleportation.setPrivateInt((Object)ravenEntity, "flightTeleportBudget", budget);
                Teleportation.setPrivateInt((Object)ravenEntity, "flightTeleportUsed", used);
                Teleportation.setPrivateInt((Object)ravenEntity, "flightTeleportCheckCooldownTicks", checkCd);
                Teleportation.setPrivateInt((Object)ravenEntity, "flightTeleportHardCooldownTicks", hardCd);
                if (ravenEntity.tickCount % 20 == 0) {
                    LOG.debug("[Teleportation] FlightBlink session started ai={} budget={} pos={}", new Object[]{st, budget, ravenEntity.position()});
                }
            }
            if (budget <= 0) {
                return;
            }
            if (used >= budget) {
                return;
            }
            if (hardCd > 0) {
                Teleportation.setPrivateInt((Object)ravenEntity, "flightTeleportHardCooldownTicks", --hardCd);
            }
            if (checkCd > 0) {
                Teleportation.setPrivateInt((Object)ravenEntity, "flightTeleportCheckCooldownTicks", --checkCd);
                return;
            }
            checkCd = 20 + ravenEntity.getRandom().nextInt(25);
            Teleportation.setPrivateInt((Object)ravenEntity, "flightTeleportCheckCooldownTicks", checkCd);
            Vec3 vel = ravenEntity.getDeltaMovement();
            if (vel.lengthSqr() < 0.004) {
                return;
            }
            double p = 0.26;
            if (ravenEntity.getRandom().nextDouble() > p) {
                return;
            }
            if (hardCd > 0) {
                return;
            }
            boolean usedWaypoint = false;
            long BLINK_WAYPOINT_SALT = 2971557613L;
            BlockPos targetBlock = this.pickUpcomingPathWaypointTeleportTarget(ravenEntity, true, 6, 80, 2971557613L);
            if (targetBlock != null) {
                usedWaypoint = true;
            } else {
                targetBlock = this.findNearbyEmptyTeleportBlock3x3x3(10, 60, ravenEntity);
            }
            if (targetBlock == null) {
                if (ravenEntity.tickCount % 40 == 0) {
                    LOG.debug("[Teleportation] FlightBlink: no valid teleport space found near pos={} ai={} used={}/{} usedWaypoint={}", new Object[]{ravenEntity.position(), st, used, budget, usedWaypoint});
                }
                return;
            }
            Vec3 end = new Vec3((double)targetBlock.getX() + 0.5, (double)targetBlock.getY(), (double)targetBlock.getZ() + 0.5);
            if (Teleportation.invokeIsOutOfHomeBounds(ravenEntity, end)) {
                if (ravenEntity.tickCount % 40 == 0) {
                    LOG.debug("[Teleportation] FlightBlink: candidate out of home bounds end={} basePos={} usedWaypoint={}", new Object[]{end, ravenEntity.position(), usedWaypoint});
                }
                return;
            }
            long BLINK_SALT = 2971557613L;
            long fxSeed = ravenEntity.getUUID().getLeastSignificantBits() ^ (long)ravenEntity.tickCount ^ targetBlock.asLong() ^ 0xB11E5EEDL;
            this.startTeleportSequence(end, fxSeed, "random flight blink", ravenEntity);
            Teleportation.setPrivateInt((Object)ravenEntity, "flightTeleportUsed", ++used);
            hardCd = 60 + ravenEntity.getRandom().nextInt(80);
            Teleportation.setPrivateInt((Object)ravenEntity, "flightTeleportHardCooldownTicks", hardCd);
            if (ravenEntity.tickCount % 20 == 0) {
                LOG.info("[Teleportation] FlightBlink TRIGGERED used={}/{} ai={} fromPos={} toBlock={} end={} vel={} usedWaypoint={}", new Object[]{used, budget, st, ravenEntity.position(), targetBlock, end, vel, usedWaypoint});
            }
        }
        catch (Throwable t) {
            LOG.error("[Teleportation] tickRandomFlightTeleportBlink failed", t);
        }
    }

    public int getClientLerpStepsPublic(RavenEntity ravenEntity) {
        try {
            if (ravenEntity == null) {
                return 0;
            }
            if (ravenEntity.level() == null) {
                return 0;
            }
            if (!ravenEntity.level().isClientSide) {
                return 0;
            }
            Object v = Teleportation.getAnyFieldValue((Object)ravenEntity, "lerpSteps", "lerpStepsRemaining", "lerpSteps_");
            if (v instanceof Integer) {
                return (Integer)v;
            }
            return 0;
        }
        catch (Throwable t) {
            if (ravenEntity != null && ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Teleportation] getClientLerpStepsPublic failed safely: {}", (Object)t.toString());
            }
            return 0;
        }
    }

    public double getClientLerpTargetDistSqrPublic(RavenEntity ravenEntity) {
        try {
            if (ravenEntity == null) {
                return 0.0;
            }
            if (ravenEntity.level() == null) {
                return 0.0;
            }
            if (!ravenEntity.level().isClientSide) {
                return 0.0;
            }
            Double lerpX = (Double)Teleportation.getAnyFieldValue((Object)ravenEntity, "lerpX", "xLerp", "targetX");
            Double lerpY = (Double)Teleportation.getAnyFieldValue((Object)ravenEntity, "lerpY", "yLerp", "targetY");
            Double lerpZ = (Double)Teleportation.getAnyFieldValue((Object)ravenEntity, "lerpZ", "zLerp", "targetZ");
            if (lerpX == null || lerpY == null || lerpZ == null) {
                return 0.0;
            }
            double dx = lerpX - ravenEntity.getX();
            double dy = lerpY - ravenEntity.getY();
            double dz = lerpZ - ravenEntity.getZ();
            return dx * dx + dy * dy + dz * dz;
        }
        catch (Throwable t) {
            if (ravenEntity != null && ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Teleportation] getClientLerpTargetDistSqrPublic failed safely: {}", (Object)t.toString());
            }
            return 0.0;
        }
    }

    private static void setPrivateInt(Object obj, String fieldName, int value) {
        try {
            if (obj == null || fieldName == null) {
                return;
            }
            Field f = Teleportation.findField(obj.getClass(), fieldName);
            if (f == null) {
                return;
            }
            f.setAccessible(true);
            f.setInt(obj, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int getPrivateInt(Object obj, String fieldName, int fallback) {
        try {
            if (obj == null || fieldName == null) {
                return fallback;
            }
            Field f = Teleportation.findField(obj.getClass(), fieldName);
            if (f == null) {
                return fallback;
            }
            f.setAccessible(true);
            return f.getInt(obj);
        }
        catch (Throwable ignored) {
            return fallback;
        }
    }

    private static void setPrivateDouble(Object obj, String fieldName, double value) {
        try {
            if (obj == null || fieldName == null) {
                return;
            }
            Field f = Teleportation.findField(obj.getClass(), fieldName);
            if (f == null) {
                return;
            }
            f.setAccessible(true);
            f.setDouble(obj, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void setPrivateBoolean(Object obj, String fieldName, boolean value) {
        try {
            if (obj == null || fieldName == null) {
                return;
            }
            Field f = Teleportation.findField(obj.getClass(), fieldName);
            if (f == null) {
                return;
            }
            f.setAccessible(true);
            f.setBoolean(obj, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void setPrivateObject(Object obj, String fieldName, @Nullable Object value) {
        try {
            if (obj == null || fieldName == null) {
                return;
            }
            Field f = Teleportation.findField(obj.getClass(), fieldName);
            if (f == null) {
                return;
            }
            f.setAccessible(true);
            f.set(obj, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Nullable
    private static Object getPrivateObject(Object obj, String fieldName) {
        try {
            if (obj == null || fieldName == null) {
                return null;
            }
            Field f = Teleportation.findField(obj.getClass(), fieldName);
            if (f == null) {
                return null;
            }
            f.setAccessible(true);
            return f.get(obj);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static int getPrivateStaticInt(Class<?> clazz, String fieldName, int fallback) {
        try {
            if (clazz == null || fieldName == null) {
                return fallback;
            }
            Field f = Teleportation.findField(clazz, fieldName);
            if (f == null) {
                return fallback;
            }
            f.setAccessible(true);
            return f.getInt(null);
        }
        catch (Throwable ignored) {
            return fallback;
        }
    }

    @Nullable
    private static Field findField(Class<?> clazz, String name) {
        try {
            for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                try {
                    return c.getDeclaredField(name);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
            return null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static void invokeVoid0(Object obj, String methodName, String logOnFail) {
        try {
            if (obj == null) {
                return;
            }
            Method m = Teleportation.findMethod(obj.getClass(), methodName, new Class[0]);
            if (m == null) {
                return;
            }
            m.setAccessible(true);
            m.invoke(obj, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void invokeVoid1String(Object obj, String methodName, String arg, String logOnFail) {
        try {
            if (obj == null) {
                return;
            }
            Method m = Teleportation.findMethod(obj.getClass(), methodName, String.class);
            if (m == null) {
                return;
            }
            m.setAccessible(true);
            m.invoke(obj, arg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Nullable
    private static Object invokeObject0(Object obj, String methodName) {
        try {
            if (obj == null) {
                return null;
            }
            Method m = Teleportation.findMethod(obj.getClass(), methodName, new Class[0]);
            if (m == null) {
                return null;
            }
            m.setAccessible(true);
            return m.invoke(obj, new Object[0]);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static boolean invokeBoolean0(Object obj, String methodName, boolean fallback) {
        try {
            if (obj == null) {
                return fallback;
            }
            Method m = Teleportation.findMethod(obj.getClass(), methodName, new Class[0]);
            if (m == null) {
                return fallback;
            }
            m.setAccessible(true);
            Object res = m.invoke(obj, new Object[0]);
            if (res instanceof Boolean) {
                return (Boolean)res;
            }
            return fallback;
        }
        catch (Throwable ignored) {
            return fallback;
        }
    }

    @Nullable
    private static Method findMethod(Class<?> clazz, String name, Class<?> ... params) {
        try {
            for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                try {
                    return c.getDeclaredMethod(name, params);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            return null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static boolean invokeIsOutOfHomeBounds(RavenEntity ravenEntity, Vec3 pos) {
        try {
            Method m;
            if (ravenEntity == null || pos == null) {
                return false;
            }
            Method pub = Teleportation.findMethod(((Object)((Object)ravenEntity)).getClass(), "isOutOfHomeBoundsPublic", Vec3.class);
            if (pub != null) {
                pub.setAccessible(true);
                Object res = pub.invoke((Object)ravenEntity, pos);
                if (res instanceof Boolean) {
                    return (Boolean)res;
                }
            }
            if ((m = Teleportation.findMethod(((Object)((Object)ravenEntity)).getClass(), "isOutOfHomeBounds", Vec3.class)) != null) {
                m.setAccessible(true);
                Object res = m.invoke((Object)ravenEntity, pos);
                if (res instanceof Boolean) {
                    return (Boolean)res;
                }
            }
            return false;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static int invokeClampYToHomeBounds(RavenEntity ravenEntity, int y) {
        try {
            Method m;
            if (ravenEntity == null) {
                return y;
            }
            Method pub = Teleportation.findMethod(((Object)((Object)ravenEntity)).getClass(), "clampYToHomeBoundsPublic", Integer.TYPE);
            if (pub != null) {
                pub.setAccessible(true);
                Object res = pub.invoke((Object)ravenEntity, y);
                if (res instanceof Integer) {
                    return (Integer)res;
                }
            }
            if ((m = Teleportation.findMethod(((Object)((Object)ravenEntity)).getClass(), "clampYToHomeBounds", Integer.TYPE)) != null) {
                m.setAccessible(true);
                Object res = m.invoke((Object)ravenEntity, y);
                if (res instanceof Integer) {
                    return (Integer)res;
                }
            }
            return y;
        }
        catch (Throwable ignored) {
            return y;
        }
    }

    private static Vec3 invokeClampTargetToHomeBounds(RavenEntity ravenEntity, Vec3 v) {
        try {
            Method m;
            if (ravenEntity == null || v == null) {
                return v;
            }
            Method pub = Teleportation.findMethod(((Object)((Object)ravenEntity)).getClass(), "clampTargetToHomeBoundsPublic", Vec3.class);
            if (pub != null) {
                pub.setAccessible(true);
                Object res = pub.invoke((Object)ravenEntity, v);
                if (res instanceof Vec3) {
                    return (Vec3)res;
                }
            }
            if ((m = Teleportation.findMethod(((Object)((Object)ravenEntity)).getClass(), "clampTargetToHomeBounds", Vec3.class)) != null) {
                m.setAccessible(true);
                Object res = m.invoke((Object)ravenEntity, v);
                if (res instanceof Vec3) {
                    return (Vec3)res;
                }
            }
            return v;
        }
        catch (Throwable ignored) {
            return v;
        }
    }

    @Nullable
    private static Object getAnyFieldValue(Object obj, String ... possibleNames) {
        try {
            if (obj == null || possibleNames == null) {
                return null;
            }
            for (String n : possibleNames) {
                Field f;
                if (n == null || (f = Teleportation.findField(obj.getClass(), n)) == null) continue;
                f.setAccessible(true);
                return f.get(obj);
            }
            return null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static void setPostTeleportIntentIfPossible(RavenEntity ravenEntity, String enumConstantName) {
        try {
            if (ravenEntity == null || enumConstantName == null) {
                return;
            }
            Class<?>[] inner = ((Object)((Object)ravenEntity)).getClass().getDeclaredClasses();
            Class<?> intentEnum = null;
            for (Class<?> c : inner) {
                if (c == null || !c.isEnum() || !"PostTeleportIntent".equals(c.getSimpleName())) continue;
                intentEnum = c;
                break;
            }
            if (intentEnum == null) {
                return;
            }
            Object desired = null;
            T[] constants = intentEnum.getEnumConstants();
            if (constants != null) {
                for (Object k : constants) {
                    if (k == null || !enumConstantName.equals(String.valueOf(k))) continue;
                    desired = k;
                    break;
                }
            }
            if (desired == null) {
                return;
            }
            Field f = Teleportation.findField(((Object)((Object)ravenEntity)).getClass(), "postTeleportIntent");
            if (f == null) {
                return;
            }
            f.setAccessible(true);
            f.set((Object)ravenEntity, desired);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static enum TeleportSeqPhase {
        NONE,
        FADING_OUT,
        TELEPORTING,
        FADING_IN;

    }
}

