/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.entity.raven.modules;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.z2six.featheredfriend.command.FeatheredFriendCommands;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import net.z2six.featheredfriend.world.TamedRavenPlayerData;
import org.slf4j.Logger;

public final class TamedRavenDeathHandler {
    private static final Logger LOG = LogUtils.getLogger();
    private static final double LAST_SEEN_PLAYER_RADIUS = 64.0;

    private TamedRavenDeathHandler() {
    }

    public static void onRavenDeath(RavenEntity raven, DamageSource source) {
        try {
            if (raven == null) {
                return;
            }
            Level level = raven.level();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            List players = serverLevel.players();
            if (players.isEmpty()) {
                return;
            }
            ServerPlayer closestPlayer = null;
            double closestDistSq = Double.MAX_VALUE;
            double maxDistSq = 4096.0;
            Vec3 ravenPos = raven.position();
            for (ServerPlayer p : players) {
                double d2;
                if (p == null || p.isSpectator() || !((d2 = p.position().distanceToSqr(ravenPos)) < closestDistSq) || !(d2 <= maxDistSq)) continue;
                closestDistSq = d2;
                closestPlayer = p;
            }
            String killerName = null;
            boolean killedByPlayer = false;
            if (source != null) {
                Entity killerEntity = source.getEntity();
                if (killerEntity instanceof ServerPlayer) {
                    ServerPlayer killerPlayer = (ServerPlayer)killerEntity;
                    killedByPlayer = true;
                    killerName = killerPlayer.getGameProfile().getName();
                } else if (killerEntity != null) {
                    killerName = killerEntity.getName().getString();
                }
            }
            String ravenNameFromEntity = null;
            try {
                if (raven.hasCustomName()) {
                    ravenNameFromEntity = raven.getName().getString();
                }
            }
            catch (Throwable killerPlayer) {
                // empty catch block
            }
            String entityNameTrim = ravenNameFromEntity == null ? "" : ravenNameFromEntity.trim();
            for (ServerPlayer candidate : players) {
                boolean cleared;
                String storedNameTrim;
                TamedRavenPlayerData.TamedRavenInfo info;
                if (candidate == null || !(info = TamedRavenPlayerData.getTamedRavenInfo(candidate)).hasTamedRaven()) continue;
                String storedName = info.ravenName();
                String string = storedNameTrim = storedName == null ? "" : storedName.trim();
                if (!storedNameTrim.isEmpty() && !entityNameTrim.isEmpty()) {
                    boolean directMatch = storedNameTrim.equals(entityNameTrim);
                    boolean suffixMatch = entityNameTrim.endsWith(storedNameTrim);
                    if (!directMatch && !suffixMatch) {
                        if (raven.tickCount % 80 != 0) continue;
                        LOG.debug("[TamedRavenDeathHandler] Skipping candidate owner={} storedName='{}' entityName='{}' (no match)", new Object[]{candidate.getGameProfile().getName(), storedNameTrim, entityNameTrim});
                        continue;
                    }
                } else {
                    if (raven.tickCount % 80 != 0) continue;
                    LOG.debug("[TamedRavenDeathHandler] Skipping candidate owner={} due to empty names. stored='{}' entity='{}'", new Object[]{candidate.getGameProfile().getName(), storedNameTrim, entityNameTrim});
                    continue;
                }
                if (raven.tickCount % 40 == 0) {
                    LOG.info("[TamedRavenDeathHandler] Matched owner={} for raven id={} storedName='{}' entityName='{}'", new Object[]{candidate.getGameProfile().getName(), raven.getId(), storedNameTrim, entityNameTrim});
                }
                String displayName = !entityNameTrim.isEmpty() ? entityNameTrim : (!storedNameTrim.isEmpty() ? storedNameTrim : "your raven");
                String baseMessage = killedByPlayer && killerName != null && !killerName.isBlank() ? "[FeatheredFriend] Your raven, " + displayName + ", has perished by the hands of " + killerName + "." : "[FeatheredFriend] Your raven, " + displayName + ", has perished of natural causes.";
                try {
                    candidate.sendSystemMessage((Component)Component.literal((String)baseMessage));
                }
                catch (Throwable tSend) {
                    LOG.warn("[TamedRavenDeathHandler] Failed to send base death message to owner={}: {}", (Object)candidate.getGameProfile().getName(), (Object)tSend.toString());
                }
                if (closestPlayer != null && !closestPlayer.getUUID().equals(candidate.getUUID())) {
                    String lastSeenMsg = "[FeatheredFriend] It was last seen nearby " + closestPlayer.getGameProfile().getName() + ".";
                    try {
                        candidate.sendSystemMessage((Component)Component.literal((String)lastSeenMsg));
                    }
                    catch (Throwable tSend2) {
                        LOG.warn("[TamedRavenDeathHandler] Failed to send last-seen message to owner={}: {}", (Object)candidate.getGameProfile().getName(), (Object)tSend2.toString());
                    }
                }
                if (cleared = FeatheredFriendCommands.clearPlayerTamedRavenData(candidate)) {
                    LOG.info("[TamedRavenDeathHandler] Cleared TamedRaven data for owner={} due to raven death. ravenName={}", (Object)candidate.getGameProfile().getName(), (Object)displayName);
                } else {
                    LOG.info("[TamedRavenDeathHandler] Owner={} had no TamedRaven data to clear on raven death. ravenName={}", (Object)candidate.getGameProfile().getName(), (Object)displayName);
                }
                return;
            }
            if (raven.tickCount % 80 == 0) {
                LOG.debug("[TamedRavenDeathHandler] No matching TamedRaven owner found for raven id={} entityName='{}'", (Object)raven.getId(), (Object)entityNameTrim);
            }
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenDeathHandler] onRavenDeath failed safely", t);
        }
    }
}

