/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.entity.raven.modules;

import com.mojang.logging.LogUtils;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import net.z2six.featheredfriend.entity.raven.modules.FeatherParticles;
import net.z2six.featheredfriend.entity.raven.modules.Teleportation;
import net.z2six.featheredfriend.network.FFNetwork;
import net.z2six.featheredfriend.registry.FFNeoForgeParticles;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class TamedRaven {
    private static final Logger LOG = LogUtils.getLogger();
    private static final int MAX_NAME_CHARS = 26;
    private static final int DESPAWN_FADE_TICKS = 10;
    private final RavenEntity raven;
    private boolean tamingCompleted = false;
    private boolean namingGuiRequested = false;
    @Nullable
    private UUID pendingOwnerUuid = null;
    private boolean despawnWithFxActive = false;
    private int despawnWithFxTicks = 0;

    public TamedRaven(RavenEntity raven) {
        this.raven = raven;
    }

    public void onTamingFullyPaid(Player player) {
        try {
            if (player == null) {
                return;
            }
            if (this.raven == null) {
                return;
            }
            if (this.raven.level() == null) {
                return;
            }
            boolean isClientSide = this.raven.level().isClientSide;
            if (!(player instanceof ServerPlayer)) {
                if (isClientSide && this.raven.tickCount % 40 == 0) {
                    LOG.debug("[TamedRaven] onTamingFullyPaid: non-ServerPlayer on client; ignoring. player={}", (Object)player.getName().getString());
                }
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.tamingCompleted || this.namingGuiRequested) {
                if (this.raven.tickCount % 40 == 0) {
                    LOG.debug("[TamedRaven] onTamingFullyPaid: already handled (tamingCompleted={} namingGuiRequested={}) id={} pos={}", new Object[]{this.tamingCompleted, this.namingGuiRequested, this.raven.getId(), this.raven.position()});
                }
                return;
            }
            if (isClientSide) {
                if (this.raven.tickCount % 40 == 0) {
                    LOG.debug("[TamedRaven] onTamingFullyPaid: CLIENT side call ignored. player={} id={} pos={}", new Object[]{serverPlayer.getGameProfile().getName(), this.raven.getId(), this.raven.position()});
                }
                return;
            }
            this.namingGuiRequested = true;
            this.pendingOwnerUuid = serverPlayer.getUUID();
            LOG.info("[TamedRaven] onTamingFullyPaid: triggering naming GUI for player={} ravenId={} pos={}", new Object[]{serverPlayer.getGameProfile().getName(), this.raven.getId(), this.raven.position()});
            FFNetwork.sendOpenRavenNamingScreen(serverPlayer, this.raven.getId());
        }
        catch (Throwable t) {
            LOG.error("[TamedRaven] onTamingFullyPaid failed safely", t);
        }
    }

    public void onNameChosenFromClient(ServerPlayer player, String rawName) {
        try {
            if (player == null) {
                return;
            }
            if (this.raven == null) {
                return;
            }
            if (this.raven.level() == null) {
                return;
            }
            Level level = this.raven.level();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.pendingOwnerUuid == null || !this.pendingOwnerUuid.equals(player.getUUID())) {
                if (this.raven.tickCount % 40 == 0) {
                    LOG.warn("[TamedRaven] onNameChosenFromClient: owner mismatch or no pending owner. expected={} got={}", (Object)this.pendingOwnerUuid, (Object)player.getUUID());
                }
                return;
            }
            String name = this.sanitizeName(rawName, (Player)player);
            this.tamingCompleted = true;
            this.namingGuiRequested = false;
            LOG.info("[TamedRaven] onNameChosenFromClient: name='{}' player={} ravenId={} pos={}", new Object[]{name, player.getGameProfile().getName(), this.raven.getId(), this.raven.position()});
            this.storeTamedRavenForPlayer(player, name);
            this.beginDespawnWithFx(serverLevel, player, name);
        }
        catch (Throwable t) {
            LOG.error("[TamedRaven] onNameChosenFromClient failed safely", t);
        }
    }

    public void tickServer() {
        try {
            int total;
            block11: {
                if (!this.despawnWithFxActive) {
                    return;
                }
                if (this.raven == null) {
                    return;
                }
                if (this.raven.level() == null) {
                    return;
                }
                if (!(this.raven.level() instanceof ServerLevel)) {
                    return;
                }
                if (!this.raven.isAlive()) {
                    this.despawnWithFxActive = false;
                    return;
                }
                ++this.despawnWithFxTicks;
                total = Math.max(1, 10);
                float k = Mth.clamp((float)((float)this.despawnWithFxTicks / (float)total), (float)0.0f, (float)1.0f);
                int alpha = (int)Mth.lerp((float)k, (float)255.0f, (float)0.0f);
                try {
                    Teleportation tp = this.raven.getTeleportation();
                    if (tp != null) {
                        tp.setTeleportFadeAlpha(alpha, this.raven);
                    }
                }
                catch (Throwable t) {
                    if (this.raven.tickCount % 80 != 0) break block11;
                    LOG.warn("[TamedRaven] tickServer: setTeleportFadeAlpha failed safely: {}", (Object)t.toString());
                }
            }
            if (this.despawnWithFxTicks >= total) {
                Vec3 pos = this.raven.position();
                LOG.info("[TamedRaven] tickServer: despawn complete after fade; removing raven id={} pos={}", (Object)this.raven.getId(), (Object)pos);
                this.raven.discard();
                this.despawnWithFxActive = false;
            }
        }
        catch (Throwable t) {
            LOG.error("[TamedRaven] tickServer failed safely", t);
            this.despawnWithFxActive = false;
        }
    }

    private String sanitizeName(@Nullable String raw, Player owner) {
        try {
            String s;
            String string = s = raw == null ? "" : raw.trim();
            if (s.isEmpty()) {
                s = this.buildDefaultName(owner);
            }
            if (s.length() > 26) {
                s = s.substring(0, 26);
            }
            return s;
        }
        catch (Throwable t) {
            LOG.warn("[TamedRaven] sanitizeName failed; falling back to default. err={}", (Object)t.toString());
            return this.buildDefaultName(owner);
        }
    }

    private String buildDefaultName(Player owner) {
        try {
            Object candidate;
            String base = owner.getName().getString();
            if (base == null || base.isEmpty()) {
                base = "Raven";
            }
            if (((String)(candidate = base + "'s Raven")).length() > 26) {
                candidate = ((String)candidate).substring(0, 26);
            }
            return candidate;
        }
        catch (Throwable t) {
            LOG.warn("[TamedRaven] buildDefaultName failed; using 'Raven' as fallback: {}", (Object)t.toString());
            return "Raven";
        }
    }

    private void storeTamedRavenForPlayer(ServerPlayer player, String ravenName) {
        try {
            CompoundTag root = player.getPersistentData();
            if (root == null) {
                LOG.warn("[TamedRaven] storeTamedRavenForPlayer: player persistent data is null");
                return;
            }
            CompoundTag ffTag = root.getCompound("featheredfriend");
            CompoundTag ravenTag = new CompoundTag();
            ravenTag.putUUID("OwnerUUID", player.getUUID());
            ravenTag.putString("RavenName", ravenName != null ? ravenName : "Raven");
            ravenTag.putBoolean("HasTamedRaven", true);
            try {
                if (player.level() != null) {
                    ravenTag.putString("OwnerDimension", player.level().dimension().location().toString());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ffTag.put("TamedRaven", (Tag)ravenTag);
            root.put("featheredfriend", (Tag)ffTag);
            LOG.info("[TamedRaven] Stored tamed raven for player={} name='{}'", (Object)player.getGameProfile().getName(), (Object)ravenName);
        }
        catch (Throwable t) {
            LOG.error("[TamedRaven] storeTamedRavenForPlayer failed safely", t);
        }
    }

    public void beginDespawnWithFx(ServerLevel serverLevel, ServerPlayer owner, String name) {
        try {
            Vec3 pos;
            block8: {
                if (serverLevel == null) {
                    return;
                }
                if (this.raven == null) {
                    return;
                }
                pos = this.raven.position();
                double x = pos.x();
                double y = pos.y() + 0.6;
                double z = pos.z();
                long seed = this.raven.getUUID().getLeastSignificantBits() ^ (long)this.raven.tickCount ^ owner.getUUID().getMostSignificantBits() ^ (long)name.hashCode();
                Teleportation tp = this.raven.getTeleportation();
                if (tp != null) {
                    tp.spawnEnderpopBurst(serverLevel, x, y, z, seed, "tamed_raven_store", this.raven);
                    tp.setTeleportFadeAlpha(255, this.raven);
                }
                try {
                    int count = FeatherParticles.getFeathersPerBurst();
                    serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)FFNeoForgeParticles.FEATHER.get()), x, y, z, count, 0.4, 0.25, 0.4, 0.0);
                    if (this.raven.tickCount % 40 == 0) {
                        LOG.info("[TamedRaven] beginDespawnWithFx: spawned FEATHER particles at {} count={}", (Object)pos, (Object)count);
                    }
                }
                catch (Throwable tFeathers) {
                    if (this.raven.tickCount % 80 != 0) break block8;
                    LOG.warn("[TamedRaven] beginDespawnWithFx: FEATHER particle spawn failed safely: {}", (Object)tFeathers.toString());
                }
            }
            this.despawnWithFxActive = true;
            this.despawnWithFxTicks = 0;
            LOG.info("[TamedRaven] beginDespawnWithFx: owner={} name='{}' id={} pos={}", new Object[]{owner.getGameProfile().getName(), name, this.raven.getId(), pos});
        }
        catch (Throwable t) {
            LOG.error("[TamedRaven] beginDespawnWithFx failed safely", t);
            this.despawnWithFxActive = false;
        }
    }
}

