/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.entity.raven.modules;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public final class RavenSoundEngine {
    private static final Logger LOG = LogUtils.getLogger();

    private RavenSoundEngine() {
    }

    public static void playAt(Level level, SoundEvent sound, SoundSource src, Vec3 pos) {
        RavenSoundEngine.playAt(level, sound, src, pos, 1.0f, 1.0f);
    }

    public static void playAt(Level level, SoundEvent sound, SoundSource src, Vec3 pos, float volume, float pitch) {
        try {
            if (level == null) {
                LOG.warn("[RavenSoundEngine] playAt(SoundEvent): level is null for sound={}", (Object)RavenSoundEngine.safeSoundId(sound));
                return;
            }
            if (pos == null) {
                LOG.warn("[RavenSoundEngine] playAt(SoundEvent): pos is null for sound={}", (Object)RavenSoundEngine.safeSoundId(sound));
                return;
            }
            if (sound == null) {
                LOG.warn("[RavenSoundEngine] playAt(SoundEvent): sound is null");
                return;
            }
            float vol = RavenSoundEngine.sanitizeVolume(volume);
            float pit = RavenSoundEngine.sanitizePitch(pitch);
            RavenSoundEngine.doPlay(level, sound, src, pos, vol, pit);
            LOG.debug("[RavenSoundEngine] playAt(SoundEvent) sound={} src={} vol={} pitch={} pos={}", new Object[]{RavenSoundEngine.safeSoundId(sound), src, Float.valueOf(vol), Float.valueOf(pit), pos});
        }
        catch (Throwable t) {
            LOG.warn("[RavenSoundEngine] playAt(SoundEvent) failed safely for sound={}: {}", (Object)RavenSoundEngine.safeSoundId(sound), (Object)t.toString());
        }
    }

    public static void playAt(Level level, SoundEvent sound, SoundSource src, double x, double y, double z, float volume, float pitch) {
        RavenSoundEngine.playAt(level, sound, src, new Vec3(x, y, z), volume, pitch);
    }

    public static void playAt(Level level, String soundId, SoundSource src, Vec3 pos) {
        RavenSoundEngine.playAt(level, soundId, src, pos, 1.0f, 1.0f);
    }

    public static void playAt(Level level, String soundId, SoundSource src, Vec3 pos, float volume, float pitch) {
        try {
            if (level == null) {
                LOG.warn("[RavenSoundEngine] playAt(String): level is null for soundId='{}'", (Object)soundId);
                return;
            }
            if (pos == null) {
                LOG.warn("[RavenSoundEngine] playAt(String): pos is null for soundId='{}'", (Object)soundId);
                return;
            }
            if (soundId == null || soundId.isEmpty()) {
                LOG.warn("[RavenSoundEngine] playAt(String): soundId is null/empty");
                return;
            }
            ResourceLocation rl = ResourceLocation.tryParse((String)soundId);
            if (rl == null) {
                LOG.warn("[RavenSoundEngine] playAt(String): invalid ResourceLocation '{}'", (Object)soundId);
                return;
            }
            SoundEvent sound = SoundEvent.createVariableRangeEvent((ResourceLocation)rl);
            if (sound == null) {
                LOG.warn("[RavenSoundEngine] playAt(String): SoundEvent.createVariableRangeEvent returned null for id='{}'", (Object)soundId);
                return;
            }
            float vol = RavenSoundEngine.sanitizeVolume(volume);
            float pit = RavenSoundEngine.sanitizePitch(pitch);
            RavenSoundEngine.doPlay(level, sound, src, pos, vol, pit);
            LOG.debug("[RavenSoundEngine] playAt(String) soundId={} src={} vol={} pitch={} pos={}", new Object[]{soundId, src, Float.valueOf(vol), Float.valueOf(pit), pos});
        }
        catch (Throwable t) {
            LOG.warn("[RavenSoundEngine] playAt(String) failed safely for soundId='{}': {}", (Object)soundId, (Object)t.toString());
        }
    }

    public static void playAt(Level level, String soundId, SoundSource src, double x, double y, double z, float volume, float pitch) {
        RavenSoundEngine.playAt(level, soundId, src, new Vec3(x, y, z), volume, pitch);
    }

    public static void playAtWithRandomPitch(Level level, SoundEvent sound, SoundSource src, Vec3 pos, float volume, float pitchMin, float pitchMax, RandomSource rnd) {
        try {
            float pitch;
            if (sound == null) {
                LOG.warn("[RavenSoundEngine] playAtWithRandomPitch(SoundEvent): sound is null");
                return;
            }
            float vol = RavenSoundEngine.sanitizeVolume(volume);
            float lo = pitchMin;
            float hi = pitchMax;
            if (lo > hi) {
                float tmp = lo;
                lo = hi;
                hi = tmp;
            }
            lo = RavenSoundEngine.sanitizePitch(lo);
            hi = RavenSoundEngine.sanitizePitch(hi);
            try {
                float t = rnd != null ? rnd.nextFloat() : 0.5f;
                pitch = lo + (hi - lo) * t;
            }
            catch (Throwable ignored) {
                pitch = (lo + hi) * 0.5f;
            }
            RavenSoundEngine.playAt(level, sound, src, pos, vol, pitch);
        }
        catch (Throwable t) {
            LOG.warn("[RavenSoundEngine] playAtWithRandomPitch(SoundEvent) failed safely for sound={}: {}", (Object)RavenSoundEngine.safeSoundId(sound), (Object)t.toString());
        }
    }

    public static void playAtWithRandomPitch(Level level, String soundId, SoundSource src, Vec3 pos, float volume, float pitchMin, float pitchMax, RandomSource rnd) {
        try {
            float pitch;
            if (soundId == null || soundId.isEmpty()) {
                LOG.warn("[RavenSoundEngine] playAtWithRandomPitch(String): soundId is null/empty");
                return;
            }
            float vol = RavenSoundEngine.sanitizeVolume(volume);
            float lo = pitchMin;
            float hi = pitchMax;
            if (lo > hi) {
                float tmp = lo;
                lo = hi;
                hi = tmp;
            }
            lo = RavenSoundEngine.sanitizePitch(lo);
            hi = RavenSoundEngine.sanitizePitch(hi);
            try {
                float t = rnd != null ? rnd.nextFloat() : 0.5f;
                pitch = lo + (hi - lo) * t;
            }
            catch (Throwable ignored) {
                pitch = (lo + hi) * 0.5f;
            }
            RavenSoundEngine.playAt(level, soundId, src, pos, vol, pitch);
        }
        catch (Throwable t) {
            LOG.warn("[RavenSoundEngine] playAtWithRandomPitch(String) failed safely for soundId='{}': {}", (Object)soundId, (Object)t.toString());
        }
    }

    private static void doPlay(Level level, SoundEvent sound, SoundSource src, Vec3 pos, float volume, float pitch) {
        try {
            if (level == null || sound == null || pos == null) {
                return;
            }
            if (!level.isClientSide) {
                if (level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    sl.playSound(null, BlockPos.containing((Position)pos), sound, src, volume, pitch);
                }
            } else {
                level.playLocalSound(pos.x, pos.y, pos.z, sound, src, volume, pitch, false);
            }
        }
        catch (Throwable t) {
            LOG.warn("[RavenSoundEngine] doPlay failed safely for sound={}: {}", (Object)RavenSoundEngine.safeSoundId(sound), (Object)t.toString());
        }
    }

    private static float sanitizeVolume(float v) {
        if (Float.isNaN(v) || Float.isInfinite(v)) {
            return 1.0f;
        }
        return Mth.clamp((float)v, (float)0.0f, (float)4.0f);
    }

    private static float sanitizePitch(float p) {
        if (Float.isNaN(p) || Float.isInfinite(p)) {
            return 1.0f;
        }
        return Mth.clamp((float)p, (float)0.25f, (float)2.0f);
    }

    private static String safeSoundId(SoundEvent evt) {
        try {
            return String.valueOf(evt);
        }
        catch (Throwable t) {
            return "SoundEvent<?>";
        }
    }
}

