/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.entity.raven.modules;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.z2six.featheredfriend.entity.raven.RavenAIState;
import net.z2six.featheredfriend.entity.raven.RavenAnimMode;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import net.z2six.featheredfriend.entity.raven.modules.Teleportation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class PlayerAvoidance {
    private static final Logger LOG = LogUtils.getLogger();
    private final RavenEntity raven;
    public static final double AVOID_PLAYER_RADIUS = 25.0;
    private static final double AVOID_PLAYER_RADIUS_SQR = 625.0;
    private static final double PANIC_TELEPORT_RADIUS = 5.0;
    private static final double PANIC_TELEPORT_RADIUS_SQR = 25.0;
    private static final int RECHECK_COOLDOWN_TICKS = 1;

    public PlayerAvoidance(RavenEntity raven) {
        this.raven = raven;
    }

    public void tick() {
        try {
            PlayerAvoidance.tryTriggerPlayerAvoidance(this.raven);
        }
        catch (Throwable t) {
            try {
                if (this.raven != null && this.raven.tickCount % 40 == 0) {
                    LOG.warn("[PlayerAvoidance] tick() failed safely: {}", (Object)t.toString());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void tryTriggerPlayerAvoidance(RavenEntity raven) {
        try {
            Vec3 playerPos;
            if (raven == null) {
                return;
            }
            if (raven.level() == null) {
                return;
            }
            if (raven.level().isClientSide) {
                return;
            }
            if (!raven.isAlive()) {
                return;
            }
            Player nearest = PlayerAvoidance.findNearestPlayerWithin(raven, 25.0);
            if (nearest == null) {
                return;
            }
            Vec3 ravenPos = raven.position();
            double d2 = ravenPos.distanceToSqr(playerPos = nearest.position());
            if (d2 > 625.0) {
                return;
            }
            double dist = Math.sqrt(Math.max(0.0, d2));
            boolean holdingNugget = PlayerAvoidance.isHoldingGoldenNugget(nearest);
            if (holdingNugget) {
                boolean armed;
                block24: {
                    armed = false;
                    try {
                        raven.requestLureFollowPlayer(nearest, dist);
                        armed = raven.isLureFollowActive();
                    }
                    catch (Throwable t) {
                        armed = false;
                        if (raven.tickCount % 40 != 0) break block24;
                        LOG.warn("[PlayerAvoidance] LURE follow request failed safely: {}", (Object)t.toString());
                    }
                }
                if (raven.tickCount % 20 == 0) {
                    LOG.info("[PlayerAvoidance] LURE follow requested: player={} dist={} ravenPos={} playerPos={} mainHand={} offHand={} armedNow={}", new Object[]{PlayerAvoidance.safeName(nearest), String.format("%.2f", dist), ravenPos, playerPos, PlayerAvoidance.safeItem(nearest.getMainHandItem()), PlayerAvoidance.safeItem(nearest.getOffhandItem()), armed});
                }
                if (armed) {
                    return;
                }
            }
            if (d2 <= 25.0) {
                block25: {
                    try {
                        Teleportation tp = null;
                        try {
                            tp = raven.getTeleportation();
                        }
                        catch (Throwable ignored) {
                            tp = null;
                        }
                        if (tp != null) {
                            tp.requestPanicTeleportAwayFromPlayer(nearest, dist, raven);
                            if (raven.tickCount % 20 == 0) {
                                LOG.info("[PlayerAvoidance] PANIC teleport requested: player={} dist={} ravenPos={}", new Object[]{PlayerAvoidance.safeName(nearest), String.format("%.2f", dist), ravenPos});
                            }
                        } else if (raven.tickCount % 40 == 0) {
                            LOG.warn("[PlayerAvoidance] PANIC teleport skipped: teleportation module null. player={} dist={} ravenPos={}", new Object[]{PlayerAvoidance.safeName(nearest), String.format("%.2f", dist), ravenPos});
                        }
                    }
                    catch (Throwable t) {
                        if (raven.tickCount % 40 != 0) break block25;
                        LOG.warn("[PlayerAvoidance] PANIC teleport failed safely: {}", (Object)t.toString());
                    }
                }
                return;
            }
            PlayerAvoidance module = raven.getPlayerAvoidanceModule();
            if (module != null) {
                module.requestPlayerAvoidanceFleeTarget(nearest, dist, raven);
            }
            if (raven.tickCount % 20 == 0) {
                LOG.info("[PlayerAvoidance] avoidance requested: player={} dist={} ravenPos={}", new Object[]{PlayerAvoidance.safeName(nearest), String.format("%.2f", dist), ravenPos});
            }
        }
        catch (Throwable t) {
            LOG.error("[PlayerAvoidance] tryTriggerPlayerAvoidance failed", t);
        }
    }

    public static boolean shouldBlockLanding(RavenEntity raven) {
        block16: {
            try {
                Player nearest;
                block15: {
                    block14: {
                        if (raven == null) {
                            return false;
                        }
                        if (raven.level() == null) {
                            return false;
                        }
                        if (raven.level().isClientSide) {
                            return false;
                        }
                        if (!raven.isAlive()) {
                            return false;
                        }
                        try {
                            if (raven.isPlayerAvoidanceOverrideActive()) {
                                if (raven.tickCount % 40 == 0) {
                                    LOG.debug("[PlayerAvoidance] shouldBlockLanding: true (override active). pos={} aiState={}", (Object)raven.position(), (Object)raven.getAIState());
                                }
                                return true;
                            }
                        }
                        catch (Throwable t) {
                            if (raven.tickCount % 80 != 0) break block14;
                            LOG.warn("[PlayerAvoidance] shouldBlockLanding: override check failed safely: {}", (Object)t.toString());
                        }
                    }
                    nearest = null;
                    try {
                        double inflatedRadius = 27.500000000000004;
                        nearest = PlayerAvoidance.findNearestPlayerWithin(raven, inflatedRadius);
                    }
                    catch (Throwable t) {
                        if (raven.tickCount % 80 != 0) break block15;
                        LOG.warn("[PlayerAvoidance] shouldBlockLanding: player search failed safely: {}", (Object)t.toString());
                    }
                }
                if (nearest != null) {
                    if (raven.tickCount % 40 == 0) {
                        double dist = nearest.distanceTo((Entity)raven);
                        LOG.info("[PlayerAvoidance] shouldBlockLanding: true (nearest player={} dist={}). pos={} aiState={}", new Object[]{nearest.getName().getString(), String.format("%.3f", dist), raven.position(), raven.getAIState()});
                    }
                    return true;
                }
            }
            catch (Throwable t) {
                if (raven == null || raven.tickCount % 80 != 0) break block16;
                LOG.warn("[PlayerAvoidance] shouldBlockLanding: failed safely with exception: {}", (Object)t.toString());
            }
        }
        return false;
    }

    private static boolean isHoldingGoldenNugget(Player p) {
        try {
            if (p == null) {
                return false;
            }
            ItemStack a = p.getMainHandItem();
            if (a != null && !a.isEmpty() && a.is(Items.GOLD_NUGGET)) {
                return true;
            }
            ItemStack b = p.getOffhandItem();
            return b != null && !b.isEmpty() && b.is(Items.GOLD_NUGGET);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static String safeItem(ItemStack st) {
        try {
            if (st == null) {
                return "null";
            }
            if (st.isEmpty()) {
                return "empty";
            }
            return String.valueOf(st.getItem());
        }
        catch (Throwable t) {
            return "unknown";
        }
    }

    @Nullable
    private static Player findNearestPlayerWithin(RavenEntity raven, double radius) {
        try {
            Vec3 pos = raven.position();
            double r = Math.max(0.1, radius);
            AABB box = new AABB(pos.x - r, pos.y - r, pos.z - r, pos.x + r, pos.y + r, pos.z + r);
            List players = raven.level().getEntitiesOfClass(Player.class, box, p -> {
                try {
                    return p != null && p.isAlive() && !p.isSpectator();
                }
                catch (Throwable ignored) {
                    return false;
                }
            });
            Player best = null;
            double bestD2 = Double.MAX_VALUE;
            for (Player p2 : players) {
                double d2;
                if (p2 == null || !((d2 = p2.position().distanceToSqr(pos)) <= r * r) || !(d2 < bestD2)) continue;
                bestD2 = d2;
                best = p2;
            }
            return best;
        }
        catch (Throwable t) {
            if (raven.tickCount % 80 == 0) {
                LOG.warn("[PlayerAvoidance] findNearestPlayerWithin failed safely: {}", (Object)t.toString());
            }
            return null;
        }
    }

    private static String safeName(Player p) {
        try {
            if (p == null) {
                return "null";
            }
            return p.getGameProfile() != null ? p.getGameProfile().getName() : p.getName().getString();
        }
        catch (Throwable t) {
            return "unknown";
        }
    }

    @Nullable
    public Vec3 computePlayerAvoidanceFleeTarget(Player player, RavenEntity ravenEntity) {
        try {
            if (player == null) {
                return null;
            }
            Vec3 ravenPos = ravenEntity.position();
            Vec3 playerPos = player.position();
            double dx = ravenPos.x - playerPos.x;
            double dz = ravenPos.z - playerPos.z;
            double len = Math.sqrt(dx * dx + dz * dz);
            if (len < 1.0E-4) {
                RandomSource rnd = ravenEntity.getRandom();
                double ang = rnd.nextDouble() * (Math.PI * 2);
                dx = Math.cos(ang);
                dz = Math.sin(ang);
                len = 1.0;
            }
            double nx = dx / len;
            double nz = dz / len;
            double FLEE_DIST = 24.0;
            double tx = ravenPos.x + nx * 24.0;
            double tz = ravenPos.z + nz * 24.0;
            boolean playerAbove = playerPos.y > ravenPos.y + 1.25;
            double baseY = ravenPos.y;
            double desiredDrop = playerAbove ? 3.0 : 0.75;
            double tyRaw = baseY - desiredDrop;
            int tyInt = ravenEntity.clampYToHomeBoundsPublic(Mth.floor((double)tyRaw));
            double ty = (double)tyInt + 0.75;
            BlockPos base = BlockPos.containing((double)tx, (double)ty, (double)tz);
            BlockPos chosen = null;
            if (ravenEntity.level().isEmptyBlock(base) && ravenEntity.level().getFluidState(base).isEmpty()) {
                chosen = base;
            }
            if (chosen == null) {
                int R = 4;
                int y = base.getY();
                block2: for (int r = 1; r <= 4 && chosen == null; ++r) {
                    BlockPos p2;
                    BlockPos p1;
                    for (int ox = -r; ox <= r && chosen == null; ++ox) {
                        int ozA = -r;
                        int ozB = r;
                        p1 = new BlockPos(base.getX() + ox, y, base.getZ() + ozA);
                        if (ravenEntity.level().isEmptyBlock(p1) && ravenEntity.level().getFluidState(p1).isEmpty()) {
                            chosen = p1;
                            break;
                        }
                        if (ozB == ozA) continue;
                        p2 = new BlockPos(base.getX() + ox, y, base.getZ() + ozB);
                        if (!ravenEntity.level().isEmptyBlock(p2) || !ravenEntity.level().getFluidState(p2).isEmpty()) continue;
                        chosen = p2;
                        break;
                    }
                    for (int oz = -r + 1; oz <= r - 1 && chosen == null; ++oz) {
                        int oxA = -r;
                        int oxB = r;
                        p1 = new BlockPos(base.getX() + oxA, y, base.getZ() + oz);
                        if (ravenEntity.level().isEmptyBlock(p1) && ravenEntity.level().getFluidState(p1).isEmpty()) {
                            chosen = p1;
                            continue block2;
                        }
                        if (oxB == oxA) continue;
                        p2 = new BlockPos(base.getX() + oxB, y, base.getZ() + oz);
                        if (!ravenEntity.level().isEmptyBlock(p2) || !ravenEntity.level().getFluidState(p2).isEmpty()) continue;
                        chosen = p2;
                        continue block2;
                    }
                }
            }
            if (chosen == null) {
                BlockPos up = base.above(1);
                if (ravenEntity.level().isEmptyBlock(up) && ravenEntity.level().getFluidState(up).isEmpty()) {
                    chosen = up;
                }
            }
            if (chosen == null) {
                BlockPos down = base.below(1);
                if (ravenEntity.level().isEmptyBlock(down) && ravenEntity.level().getFluidState(down).isEmpty()) {
                    chosen = down;
                }
            }
            if (chosen == null) {
                chosen = base;
                if (ravenEntity.tickCount % 40 == 0) {
                    RavenEntity.getSharedLogger().debug("[RavenEntity] computePlayerAvoidanceFleeTarget: no empty spot found near base={} (using base as fallback) ravenPos={} playerPos={} playerAbove={}", new Object[]{base, ravenPos, playerPos, playerAbove});
                }
            }
            Vec3 out = new Vec3((double)chosen.getX() + 0.5, ty, (double)chosen.getZ() + 0.5);
            if (ravenEntity.tickCount % 40 == 0) {
                RavenEntity.getSharedLogger().debug("[RavenEntity] computePlayerAvoidanceFleeTarget: ravenPos={} playerPos={} playerAbove={} out={} baseY={} tyRaw={} tyStable={}", new Object[]{ravenPos, playerPos, playerAbove, out, String.format("%.2f", baseY), String.format("%.2f", tyRaw), String.format("%.2f", ty)});
            }
            return out;
        }
        catch (Throwable t) {
            if (ravenEntity != null && ravenEntity.tickCount % 40 == 0) {
                RavenEntity.getSharedLogger().warn("[RavenEntity] computePlayerAvoidanceFleeTarget failed safely: {}", (Object)t.toString());
            }
            return null;
        }
    }

    public void requestPlayerAvoidanceFleeTarget(Player player, double distance, RavenEntity ravenEntity) {
        block29: {
            try {
                String name;
                Vec3 fleeTarget;
                Vec3 ravenPos;
                block28: {
                    block27: {
                        boolean hasPathIntent;
                        if (player == null) {
                            return;
                        }
                        if (ravenEntity.level() == null || ravenEntity.level().isClientSide) {
                            return;
                        }
                        if (!ravenEntity.isAlive()) {
                            return;
                        }
                        Teleportation tpNow = null;
                        try {
                            tpNow = ravenEntity.getTeleportation();
                        }
                        catch (Throwable ignored) {
                            tpNow = null;
                        }
                        if (tpNow != null && tpNow.teleportSeqPhase != Teleportation.TeleportSeqPhase.NONE) {
                            return;
                        }
                        boolean overrideActive = ravenEntity.getPlayerAvoidanceOverrideTicks() > 0;
                        Vec3 currentFly = ravenEntity.getFlyTarget();
                        int flyTtl = ravenEntity.getFlyTargetTimeoutTicks();
                        boolean hasFlyIntent = currentFly != null && flyTtl > 0;
                        List<Vec3> waypoints = ravenEntity.getPathWaypoints();
                        int pathPts = waypoints == null ? 0 : waypoints.size();
                        int pathIdx = ravenEntity.getPathWaypointIndex();
                        boolean bl = hasPathIntent = waypoints != null && !waypoints.isEmpty() && pathIdx >= 0 && pathIdx < pathPts;
                        if (overrideActive && (hasFlyIntent || hasPathIntent)) {
                            int minOverride = 80;
                            ravenEntity.setPlayerAvoidanceOverrideTicks(Math.max(ravenEntity.getPlayerAvoidanceOverrideTicks(), minOverride));
                            if (ravenEntity.tickCount % 40 == 0) {
                                String name2;
                                try {
                                    name2 = player.getGameProfile() != null ? player.getGameProfile().getName() : player.getName().getString();
                                }
                                catch (Throwable t) {
                                    name2 = "unknown";
                                }
                                RavenEntity.getSharedLogger().info("[RavenEntity] Player avoidance re-arm skipped (already have intent). player={} dist={} overrideTicks={} hasFlyIntent={} hasPathIntent={} flyTarget={} pathPts={} pathIdx={}", new Object[]{name2, String.format("%.2f", distance), ravenEntity.getPlayerAvoidanceOverrideTicks(), hasFlyIntent, hasPathIntent, currentFly, pathPts, pathIdx});
                            }
                            return;
                        }
                        if (ravenEntity.getPlayerAvoidanceRearmCooldownTicks() > 0) {
                            return;
                        }
                        ravenPos = ravenEntity.position();
                        fleeTarget = null;
                        try {
                            fleeTarget = this.computePlayerAvoidanceFleeTarget(player, ravenEntity);
                        }
                        catch (Throwable t) {
                            fleeTarget = null;
                            if (ravenEntity.tickCount % 40 != 0) break block27;
                            RavenEntity.getSharedLogger().warn("[RavenEntity] requestPlayerAvoidanceFleeTarget: computePlayerAvoidanceFleeTarget failed safely: {}", (Object)t.toString());
                        }
                    }
                    if (fleeTarget == null) {
                        if (ravenEntity.tickCount % 40 == 0) {
                            String name3;
                            try {
                                name3 = player.getGameProfile() != null ? player.getGameProfile().getName() : player.getName().getString();
                            }
                            catch (Throwable t) {
                                name3 = "unknown";
                            }
                            RavenEntity.getSharedLogger().warn("[RavenEntity] requestPlayerAvoidanceFleeTarget: no A*-based flee target (computePlayerAvoidanceFleeTarget returned null). Skipping avoidance. player={} dist={} pos={}", new Object[]{name3, String.format("%.2f", distance), ravenPos});
                        }
                        return;
                    }
                    try {
                        ravenEntity.forceRoamFlightFromThreat(fleeTarget, player);
                    }
                    catch (Throwable t) {
                        if (ravenEntity.tickCount % 40 != 0) break block28;
                        RavenEntity.getSharedLogger().error("[RavenEntity] requestPlayerAvoidanceFleeTarget: forceRoamFlightFromThreat failed safely: {}", (Object)t.toString());
                    }
                }
                int minOverride = 80;
                ravenEntity.setPlayerAvoidanceOverrideTicks(Math.max(ravenEntity.getPlayerAvoidanceOverrideTicks(), minOverride));
                ravenEntity.setAvoidanceCooldownTicks(0);
                ravenEntity.setStuckTicks(0);
                ravenEntity.setNoGravity(true);
                if (ravenEntity.getAnimMode() != RavenAnimMode.IN_AIR) {
                    ravenEntity.setAnimMode(RavenAnimMode.IN_AIR);
                }
                Vec3 vel = ravenEntity.getDeltaMovement();
                double vy = vel.y;
                if (vy < 0.25) {
                    vy = 0.25;
                }
                ravenEntity.setDeltaMovement(vel.x, vy, vel.z);
                if (ravenEntity.getAIState() != RavenAIState.ROAM_FLY) {
                    ravenEntity.setAIState(RavenAIState.ROAM_FLY);
                }
                ravenEntity.setRoamTicksRemaining(0);
                if (ravenEntity.getIdleLockTicks() <= 0) {
                    ravenEntity.setIdleLockTicks(12);
                }
                if (ravenEntity.tickCount % 20 != 0) break block29;
                try {
                    name = player.getGameProfile() != null ? player.getGameProfile().getName() : player.getName().getString();
                }
                catch (Throwable t) {
                    name = "unknown";
                }
                List<Vec3> logWaypoints = ravenEntity.getPathWaypoints();
                int logPathPts = logWaypoints == null ? 0 : logWaypoints.size();
                int logPathIdx = ravenEntity.getPathWaypointIndex();
                Vec3 pathGoalNow = ravenEntity.getPathGoal();
                Vec3 pendingGoalNow = ravenEntity.getPathPendingGoal();
                RavenEntity.getSharedLogger().info("[RavenEntity] Player avoidance flee: player={} dist={} fromPos={} fleeTarget={} overrideTicks={} pathPts={} pathIdx={} pathGoal={} pendingGoal={}", new Object[]{name, String.format("%.2f", distance), ravenPos, fleeTarget, ravenEntity.getPlayerAvoidanceOverrideTicks(), logPathPts, logPathIdx, pathGoalNow, pendingGoalNow});
            }
            catch (Throwable t) {
                RavenEntity.getSharedLogger().error("[RavenEntity] requestPlayerAvoidanceFleeTarget failed", t);
            }
        }
    }
}

