/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.entity.raven.modules;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.z2six.featheredfriend.entity.raven.RavenAIState;
import net.z2six.featheredfriend.entity.raven.RavenAnimMode;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import net.z2six.featheredfriend.entity.raven.modules.RavenSoundEngine;
import net.z2six.featheredfriend.entity.raven.modules.TamedRaven;
import net.z2six.featheredfriend.entity.raven.modules.Teleportation;
import net.z2six.featheredfriend.entity.raven.pathing.RavenAStarPathing;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LureFollowTame {
    private static final Logger LOG = LogUtils.getLogger();
    private final RavenEntity raven;
    private static final String TAMING_AGREE_SOUND_ID = "featheredfriend:raven.caw_agree";
    private static final String ARRIVAL_SOUND_ID = "featheredfriend:raven.caw_whistle";
    private static final int LURE_AGREE_SEQUENCE_COOLDOWN_TICKS = 600;
    private static final int LURE_AGREE_CAW_INTERVAL_MIN_TICKS = 10;
    private static final int LURE_AGREE_CAW_INTERVAL_MAX_TICKS = 16;
    private boolean lureAgreeSequenceActive = false;
    private int lureAgreeCawsRemaining = 0;
    private int lureAgreeCawCooldownTicks = 0;
    private int lureAgreeSequenceGlobalCooldownTicks = 0;
    private boolean wasAtLureGoalLastTick = false;
    private boolean wasAtFollowGoalLastTick = false;
    public static final String NBT_TAME_NUGGETS_REQUIRED = "GoldenNuggetsRequiredToTame";
    private int goldenNuggetsRequiredToTame = 0;
    private int tamingNuggetsPaidTotal = 0;
    private boolean handFeedSequenceActive = false;
    private int handFeedCawsRemaining = 0;
    private int handFeedCawCooldownTicks = 0;
    private static final int HAND_FEED_CAW_INTERVAL_MIN_TICKS = 6;
    private static final int HAND_FEED_CAW_INTERVAL_MAX_TICKS = 10;
    private boolean followOverrideActive = false;
    @Nullable
    private BlockPos followPocketAnchor = null;
    private int followPocketRecalcCooldownTicks = 0;
    @Nullable
    private UUID lureFollowPlayerUuid = null;
    private int lureFollowTicks = 0;
    private static final int LURE_FOLLOW_GRACE_TICKS = 10;
    private static final int LURE_FOLLOW_REFRESH_TICKS = 60;
    @Nullable
    private Vec3 followCachedGoal = null;
    @Nullable
    private Vec3 followCachedOwnerPos = null;
    @Nullable
    private Vec3 followCachedOwnerLook = null;
    private int followGoalTtlTicks = 0;
    private int followRepathCooldownTicks = 0;
    private static final double FOLLOW_MIN_DIST = 3.0;
    private static final double FOLLOW_MAX_DIST = 8.0;
    private static final int FOLLOW_COOLDOWN_MIN_TICKS = 100;
    private static final int FOLLOW_COOLDOWN_MAX_TICKS = 200;
    public static final EntityDataAccessor<Integer> DATA_FOLLOW_COOLDOWN_TICKS = RavenEntity.DATA_FOLLOW_COOLDOWN_TICKS;
    private int consecutiveLurePathFails = 0;
    private int lastLurePathFailTick = 0;
    public static final String NBT_FOLLOW_CD = "RavenFollowCooldown";

    public LureFollowTame(RavenEntity raven) {
        this.raven = raven;
    }

    private boolean playerHasTamedRaven(Player player) {
        try {
            if (!(player instanceof ServerPlayer)) {
                return false;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CompoundTag root = serverPlayer.getPersistentData();
            if (root == null) {
                return false;
            }
            CompoundTag ffTag = root.getCompound("featheredfriend");
            if (!ffTag.contains("TamedRaven", 10)) {
                return false;
            }
            CompoundTag ravenTag = ffTag.getCompound("TamedRaven");
            boolean has = ravenTag.getBoolean("HasTamedRaven");
            if (has && this.raven.tickCount % 200 == 0) {
                LOG.debug("[RavenEntity] playerHasTamedRaven: player={} hasBoundRaven=true", (Object)serverPlayer.getName().getString());
            }
            return has;
        }
        catch (Throwable t) {
            if (this.raven != null && this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] playerHasTamedRaven failed safely: {}", (Object)t.toString());
            }
            return false;
        }
    }

    public InteractionResult handleTamingInteract(Player player, InteractionHand hand) {
        try {
            if (this.raven == null || player == null) {
                return InteractionResult.PASS;
            }
            boolean clientSide = this.raven.level() != null && this.raven.level().isClientSide;
            ItemStack stack = player.getItemInHand(hand);
            String itemKey = stack == null || stack.isEmpty() ? "EMPTY" : BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
            int itemCount = stack == null ? -1 : stack.getCount();
            LOG.info("[RavenEntity] handleTamingInteract ENTER: side={} player={} hand={} item={} {}", new Object[]{clientSide ? "CLIENT" : "SERVER", player.getName().getString(), hand, itemCount, itemKey});
            if (!clientSide && this.playerHasTamedRaven(player)) {
                if (this.raven.tickCount % 80 == 0) {
                    LOG.info("[RavenEntity] handleTamingInteract: player={} already has a tamed raven; taming disabled.", (Object)player.getName().getString());
                }
                return InteractionResult.PASS;
            }
            if (clientSide) {
                LOG.info("[RavenEntity] handleTamingInteract: CLIENT side, returning sidedSuccess(true)");
                return InteractionResult.sidedSuccess((boolean)true);
            }
            boolean handled = this.tryFeedLureTamingNugget(player, hand);
            if (handled) {
                ItemStack after = player.getItemInHand(hand);
                int afterCount = after == null ? -1 : after.getCount();
                String afterKey = after == null || after.isEmpty() ? "EMPTY" : BuiltInRegistries.ITEM.getKey((Object)after.getItem()).toString();
                LOG.info("[RavenEntity] handleTamingInteract: SERVER tryFeedLureTamingNugget handled=true (player={} before={} {} after={} {})", new Object[]{player.getName().getString(), itemCount, itemKey, afterCount, afterKey});
                return InteractionResult.CONSUME;
            }
            LOG.info("[RavenEntity] handleTamingInteract: SERVER not handled (PASS).");
            return InteractionResult.PASS;
        }
        catch (Throwable t) {
            LOG.warn("[RavenEntity] handleTamingInteract failed safely: {}", (Object)t.toString());
            return InteractionResult.PASS;
        }
    }

    public boolean tryFeedLureTamingNugget(Player player, InteractionHand hand) {
        try {
            int remaining;
            block37: {
                if (player == null) {
                    return false;
                }
                if (this.raven == null) {
                    return false;
                }
                if (this.raven.level() == null) {
                    return false;
                }
                if (this.raven.level().isClientSide) {
                    return false;
                }
                if (!this.raven.isAlive()) {
                    return false;
                }
                if (this.playerHasTamedRaven(player)) {
                    if (this.raven.tickCount % 80 == 0) {
                        LOG.info("[RavenEntity] tryFeedLureTamingNugget: player={} already has a tamed raven; rejecting feed.", (Object)player.getName().getString());
                    }
                    return false;
                }
                ItemStack stack = player.getItemInHand(hand);
                if (stack == null || stack.isEmpty()) {
                    return false;
                }
                if (!stack.is(Items.GOLD_NUGGET)) {
                    return false;
                }
                boolean creative = false;
                try {
                    creative = player.getAbilities().instabuild;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                int countBefore = stack.getCount();
                if (!this.isLureFollowActive()) {
                    if (this.raven.tickCount % 80 == 0) {
                        LOG.info("[RavenEntity] tryFeedLureTamingNugget: lure not active, reject feed. pos={}", (Object)this.raven.position());
                    }
                    return false;
                }
                if (this.lureFollowPlayerUuid == null || !this.lureFollowPlayerUuid.equals(player.getUUID())) {
                    if (this.raven.tickCount % 80 == 0) {
                        LOG.info("[RavenEntity] tryFeedLureTamingNugget: player {} is not current lure player, rejecting feed.", (Object)player.getName().getString());
                    }
                    return false;
                }
                this.initGoldenNuggetsRequiredToTameIfNeeded("tryFeedLureTamingNugget");
                if (this.goldenNuggetsRequiredToTame <= 0) {
                    if (this.raven.tickCount % 80 == 0) {
                        LOG.warn("[RavenEntity] tryFeedLureTamingNugget: goldenNuggetsRequiredToTame <= 0, nothing to pay. pos={}", (Object)this.raven.position());
                    }
                    return true;
                }
                if (this.tamingNuggetsPaidTotal >= this.goldenNuggetsRequiredToTame) {
                    if (this.raven.tickCount % 80 == 0) {
                        LOG.info("[RavenEntity] tryFeedLureTamingNugget: already fully paid (paid={} / required={})", (Object)this.tamingNuggetsPaidTotal, (Object)this.goldenNuggetsRequiredToTame);
                    }
                    return true;
                }
                if (!creative) {
                    try {
                        stack.shrink(1);
                    }
                    catch (Throwable t) {
                        LOG.warn("[RavenEntity] tryFeedLureTamingNugget: failed to shrink stack: {}", (Object)t.toString());
                    }
                    try {
                        player.setItemInHand(hand, stack);
                    }
                    catch (Throwable t) {
                        LOG.warn("[RavenEntity] tryFeedLureTamingNugget: setItemInHand failed: {}", (Object)t.toString());
                    }
                }
                int countAfter = stack.getCount();
                LOG.info("[RavenEntity] tryFeedLureTamingNugget: stack count {} -> {} (creative={}, player={})", new Object[]{countBefore, countAfter, creative, player.getName().getString()});
                this.tamingNuggetsPaidTotal = Math.max(0, this.tamingNuggetsPaidTotal + 1);
                if (this.tamingNuggetsPaidTotal > this.goldenNuggetsRequiredToTame) {
                    this.tamingNuggetsPaidTotal = this.goldenNuggetsRequiredToTame;
                }
                remaining = Math.max(0, this.goldenNuggetsRequiredToTame - this.tamingNuggetsPaidTotal);
                if (this.raven.tickCount % 40 == 0) {
                    LOG.info("[RavenEntity] tryFeedLureTamingNugget: player={} paid=1 -> totalPaid={} / required={} remaining={}", new Object[]{player.getName().getString(), this.tamingNuggetsPaidTotal, this.goldenNuggetsRequiredToTame, remaining});
                }
                if (remaining == 0) {
                    try {
                        TamedRaven tamed = this.raven.getTamedRavenModule();
                        if (tamed != null) {
                            if (this.raven.tickCount % 40 == 0) {
                                LOG.info("[RavenEntity] tryFeedLureTamingNugget: tame cost fully paid; triggering TamedRaven.onTamingFullyPaid. pos={}", (Object)this.raven.position());
                            }
                            tamed.onTamingFullyPaid(player);
                        } else if (this.raven.tickCount % 80 == 0) {
                            LOG.warn("[RavenEntity] tryFeedLureTamingNugget: TamedRaven module is null on fully-paid event. pos={}", (Object)this.raven.position());
                        }
                    }
                    catch (Throwable t) {
                        if (this.raven.tickCount % 80 != 0) break block37;
                        LOG.warn("[RavenEntity] tryFeedLureTamingNugget: onTamingFullyPaid failed safely: {}", (Object)t.toString());
                    }
                }
            }
            this.startHandFeedAgreeSequence(remaining, "nugget feed");
            if (remaining == 0 && this.raven.tickCount % 40 == 0) {
                LOG.info("[RavenEntity] tryFeedLureTamingNugget: tame cost fully paid; remaining=0. pos={}", (Object)this.raven.position());
            }
            return true;
        }
        catch (Throwable t) {
            if (this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] tryFeedLureTamingNugget failed safely: {}", (Object)t.toString());
            }
            return false;
        }
    }

    private void startHandFeedAgreeSequence(int remainingCaws, String context) {
        try {
            this.handFeedSequenceActive = false;
            this.handFeedCawsRemaining = 0;
            this.handFeedCawCooldownTicks = 0;
            if (this.raven.level() == null || this.raven.level().isClientSide) {
                LOG.info("[RavenEntity] startHandFeedAgreeSequence: abort (no level or client-side). context={} remaining={}", (Object)context, (Object)remainingCaws);
                return;
            }
            if (!this.raven.isAlive()) {
                LOG.info("[RavenEntity] startHandFeedAgreeSequence: abort (raven not alive). context={} remaining={}", (Object)context, (Object)remainingCaws);
                return;
            }
            if (remainingCaws <= 0) {
                LOG.info("[RavenEntity] startHandFeedAgreeSequence: remaining<=0, cancelling. context={} remaining={} pos={}", new Object[]{context, remainingCaws, this.raven.position()});
                return;
            }
            this.handFeedSequenceActive = true;
            this.handFeedCawsRemaining = remainingCaws;
            this.handFeedCawCooldownTicks = 0;
            LOG.info("[RavenEntity] startHandFeedAgreeSequence: START hand-feed sequence caws={} context={} pos={}", new Object[]{remainingCaws, context, this.raven.position()});
        }
        catch (Throwable t) {
            LOG.warn("[RavenEntity] startHandFeedAgreeSequence failed safely: {}", (Object)t.toString());
            this.handFeedSequenceActive = false;
            this.handFeedCawsRemaining = 0;
            this.handFeedCawCooldownTicks = 0;
        }
    }

    private void fallbackBallisticLure(@Nullable Vec3 desiredGoal, Player target) {
        block6: {
            try {
                if (target == null || !target.isAlive() || target.isSpectator()) {
                    return;
                }
                Vec3 goal = desiredGoal;
                if (goal == null) {
                    goal = this.computeFollowFrontPosition(target);
                }
                if (goal == null) {
                    return;
                }
                this.invokeClearPlannedPath("lure follow: A* failed, ballistic fallback");
                this.invokeSetFlyTarget(goal, 120);
                if (this.raven.tickCount % 40 == 0) {
                    LOG.info("[RavenEntity] LURE FALLBACK: using direct fly target={} pos={} lureFails={}", new Object[]{goal, this.raven.position(), this.consecutiveLurePathFails});
                }
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block6;
                LOG.warn("[RavenEntity] fallbackBallisticLure failed safely: {}", (Object)t.toString());
            }
        }
    }

    private double computeSafeHoverYUnderCeiling(double x, double preferredY, double z, Player player) {
        try {
            int colY;
            if (player == null) {
                return preferredY;
            }
            if (this.raven.level() == null) {
                return preferredY;
            }
            int baseX = Mth.floor((double)x);
            int baseZ = Mth.floor((double)z);
            int playerFeetY = Mth.floor((double)player.getY());
            int MAX_DOWN = 2;
            int preferredBlockY = Mth.floor((double)preferredY);
            double chosenCenterY = preferredY;
            boolean found = false;
            for (int down = 0; down <= 2 && (colY = preferredBlockY - down) >= playerFeetY; ++down) {
                boolean ok;
                BlockPos p0 = new BlockPos(baseX, colY, baseZ);
                BlockPos p1 = p0.above();
                try {
                    boolean empty0 = this.raven.level().isEmptyBlock(p0) && this.raven.level().getFluidState(p0).isEmpty();
                    boolean empty1 = this.raven.level().isEmptyBlock(p1) && this.raven.level().getFluidState(p1).isEmpty();
                    ok = empty0 && empty1;
                }
                catch (Throwable t) {
                    ok = false;
                }
                if (!ok) continue;
                chosenCenterY = (double)colY + 0.5;
                found = true;
                break;
            }
            if (!found) {
                chosenCenterY = preferredY;
            }
            return chosenCenterY;
        }
        catch (Throwable t) {
            if (this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] computeSafeHoverYUnderCeiling failed safely: {}", (Object)t.toString());
            }
            return preferredY;
        }
    }

    public int getFollowCooldownTicks() {
        try {
            return (Integer)this.raven.getEntityData().get(DATA_FOLLOW_COOLDOWN_TICKS);
        }
        catch (Throwable t) {
            if (this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] getFollowCooldownTicks failed safely: {}", (Object)t.toString());
            }
            return 0;
        }
    }

    public void setFollowCooldownTicks(int ticks) {
        block5: {
            try {
                int clamped = Math.max(0, ticks);
                int prev = 0;
                try {
                    prev = (Integer)this.raven.getEntityData().get(DATA_FOLLOW_COOLDOWN_TICKS);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.raven.getEntityData().set(DATA_FOLLOW_COOLDOWN_TICKS, (Object)clamped);
                if (prev != clamped && !this.raven.level().isClientSide) {
                    LOG.info("[RavenEntity] FollowCooldown set: {} -> {} pos={} ai={}", new Object[]{prev, clamped, this.raven.position(), this.raven.getAIState()});
                }
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block5;
                LOG.warn("[RavenEntity] setFollowCooldownTicks failed safely: {}", (Object)t.toString());
            }
        }
    }

    public int getGoldenNuggetsRequiredToTame() {
        return this.goldenNuggetsRequiredToTame;
    }

    public void setGoldenNuggetsRequiredToTame(int value) {
        this.goldenNuggetsRequiredToTame = value;
    }

    public void initGoldenNuggetsRequiredToTameIfNeeded(String context) {
        block5: {
            try {
                if (this.goldenNuggetsRequiredToTame <= 0) {
                    int rolled;
                    RandomSource rnd = this.raven.getRandom();
                    this.goldenNuggetsRequiredToTame = rolled = 3 + rnd.nextInt(4);
                    if (!this.raven.level().isClientSide && this.raven.tickCount % 200 == 0) {
                        LOG.debug("[RavenEntity] initGoldenNuggetsRequiredToTameIfNeeded: context={} rolled={} pos={}", new Object[]{context, rolled, this.raven.position()});
                    }
                }
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 200 == 0) {
                    LOG.warn("[RavenEntity] initGoldenNuggetsRequiredToTameIfNeeded failed safely: {}", (Object)t.toString());
                }
                if (this.goldenNuggetsRequiredToTame > 0) break block5;
                this.goldenNuggetsRequiredToTame = 4;
            }
        }
    }

    private void maybeStartLureAgreeSequence() {
        try {
            int remaining;
            if (this.raven.level() == null || this.raven.level().isClientSide) {
                return;
            }
            if (!this.raven.isAlive()) {
                return;
            }
            if (this.lureAgreeSequenceActive) {
                return;
            }
            if (this.lureAgreeSequenceGlobalCooldownTicks > 0) {
                if (this.raven.tickCount % 40 == 0) {
                    LOG.debug("[RavenEntity] maybeStartLureAgreeSequence: blocked by global cooldown={}t pos={}", (Object)this.lureAgreeSequenceGlobalCooldownTicks, (Object)this.raven.position());
                }
                return;
            }
            if (this.goldenNuggetsRequiredToTame <= 0) {
                this.initGoldenNuggetsRequiredToTameIfNeeded("lure agree sequence start");
            }
            int total = Math.max(0, this.goldenNuggetsRequiredToTame);
            int paid = Math.max(0, this.tamingNuggetsPaidTotal);
            if (paid > total) {
                paid = total;
            }
            if ((remaining = Math.max(0, total - paid)) <= 0) {
                if (this.raven.tickCount % 40 == 0) {
                    LOG.info("[RavenEntity] maybeStartLureAgreeSequence: no remaining tame cost (total={} paid={}), skipping sequence.", (Object)total, (Object)paid);
                }
                return;
            }
            this.lureAgreeSequenceActive = true;
            this.lureAgreeCawsRemaining = remaining;
            this.lureAgreeCawCooldownTicks = 0;
            if (this.raven.tickCount % 40 == 0) {
                LOG.debug("[RavenEntity] maybeStartLureAgreeSequence: starting agree-caw sequence count={} total={} paid={} pos={}", new Object[]{remaining, total, paid, this.raven.position()});
            }
        }
        catch (Throwable t) {
            if (this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] maybeStartLureAgreeSequence failed safely: {}", (Object)t.toString());
            }
            this.stopLureAgreeSequence("exception starting");
        }
    }

    private void tickLureAgreeSequenceProgress() {
        block15: {
            try {
                float pitch;
                if (!this.lureAgreeSequenceActive) {
                    return;
                }
                if (this.raven == null) {
                    this.stopLureAgreeSequence("raven null");
                    return;
                }
                if (this.raven.level() == null || this.raven.level().isClientSide) {
                    return;
                }
                if (!this.raven.isAlive()) {
                    this.stopLureAgreeSequence("raven not alive");
                    return;
                }
                if (this.lureAgreeCawCooldownTicks > 0) {
                    --this.lureAgreeCawCooldownTicks;
                    return;
                }
                float volume = 0.9f;
                float pitchMin = 0.95f;
                float lo = pitchMin;
                float pitchMax = 1.05f;
                float hi = pitchMax;
                if (lo > hi) {
                    float tmp = lo;
                    lo = hi;
                    hi = tmp;
                }
                try {
                    RandomSource rnd = this.raven.getRandom();
                    float t = rnd == null ? 0.5f : rnd.nextFloat();
                    pitch = lo + (hi - lo) * t;
                }
                catch (Throwable ignored) {
                    pitch = (lo + hi) * 0.5f;
                }
                RavenSoundEngine.playAt(this.raven.level(), TAMING_AGREE_SOUND_ID, SoundSource.NEUTRAL, this.raven.position(), volume, pitch);
                --this.lureAgreeCawsRemaining;
                if (this.lureAgreeCawsRemaining <= 0) {
                    this.stopLureAgreeSequence("sequence complete");
                    break block15;
                }
                int delay = 10;
                try {
                    RandomSource rnd = this.raven.getRandom();
                    if (rnd != null) {
                        int span = Math.max(0, 6);
                        delay = span == 0 ? 10 : 10 + rnd.nextInt(span + 1);
                    }
                }
                catch (Throwable ignored) {
                    delay = 10;
                }
                this.lureAgreeCawCooldownTicks = Math.max(0, delay);
            }
            catch (Throwable t) {
                if (this.raven != null && this.raven.tickCount % 80 == 0) {
                    LOG.warn("[RavenEntity] tickLureAgreeSequenceProgress failed safely: {}", (Object)t.toString());
                }
                this.stopLureAgreeSequence("exception");
            }
        }
    }

    private void stopLureAgreeSequence(String reason) {
        try {
            if (this.lureAgreeSequenceActive && this.raven.tickCount % 40 == 0) {
                LOG.debug("[RavenEntity] stopLureAgreeSequence: reason={} remaining={} pos={}", new Object[]{reason, this.lureAgreeCawsRemaining, this.raven.position()});
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean completed = "sequence complete".equals(reason);
        this.lureAgreeSequenceActive = false;
        this.lureAgreeCawsRemaining = 0;
        this.lureAgreeCawCooldownTicks = 0;
        if (completed) {
            this.lureAgreeSequenceGlobalCooldownTicks = 600;
        }
    }

    public void tickHandFeedAgreeSequence() {
        try {
            if (!this.handFeedSequenceActive) {
                return;
            }
            if (this.raven == null) {
                LOG.warn("[RavenEntity] tickHandFeedAgreeSequence: raven null, cancelling.");
                this.handFeedSequenceActive = false;
                this.handFeedCawsRemaining = 0;
                this.handFeedCawCooldownTicks = 0;
                return;
            }
            if (this.raven.level() == null || this.raven.level().isClientSide) {
                LOG.info("[RavenEntity] tickHandFeedAgreeSequence: wrong side or no level, cancelling. side={}", (Object)(this.raven.level() == null ? "null" : (this.raven.level().isClientSide ? "CLIENT" : "SERVER")));
                this.handFeedSequenceActive = false;
                this.handFeedCawsRemaining = 0;
                this.handFeedCawCooldownTicks = 0;
                return;
            }
            if (!this.raven.isAlive()) {
                LOG.info("[RavenEntity] tickHandFeedAgreeSequence: raven not alive, cancelling.");
                this.handFeedSequenceActive = false;
                this.handFeedCawsRemaining = 0;
                this.handFeedCawCooldownTicks = 0;
                return;
            }
            if (this.handFeedCawCooldownTicks > 0) {
                --this.handFeedCawCooldownTicks;
                return;
            }
            int before = this.handFeedCawsRemaining;
            try {
                float pitch;
                float volume = 0.9f;
                float pitchMin = 0.97f;
                float pitchMax = 1.03f;
                float lo = pitchMin;
                float hi = pitchMax;
                if (lo > hi) {
                    float tmp = lo;
                    lo = hi;
                    hi = tmp;
                }
                try {
                    RandomSource rnd = this.raven.getRandom();
                    float t = rnd == null ? 0.5f : rnd.nextFloat();
                    pitch = lo + (hi - lo) * t;
                }
                catch (Throwable ignored) {
                    pitch = (lo + hi) * 0.5f;
                }
                RavenSoundEngine.playAt(this.raven.level(), TAMING_AGREE_SOUND_ID, SoundSource.NEUTRAL, this.raven.position(), volume, pitch);
            }
            catch (Throwable t) {
                LOG.warn("[RavenEntity] tickHandFeedAgreeSequence: play failed: {}", (Object)t.toString());
            }
            --this.handFeedCawsRemaining;
            LOG.info("[RavenEntity] tickHandFeedAgreeSequence: played hand-feed caw (before={} after={} pos={})", new Object[]{before, this.handFeedCawsRemaining, this.raven.position()});
            if (this.handFeedCawsRemaining <= 0) {
                this.handFeedSequenceActive = false;
                this.handFeedCawsRemaining = 0;
                this.handFeedCawCooldownTicks = 0;
                LOG.info("[RavenEntity] tickHandFeedAgreeSequence: sequence COMPLETE at pos={}", (Object)this.raven.position());
                return;
            }
            int delay = 6;
            try {
                RandomSource rnd = this.raven.getRandom();
                if (rnd != null) {
                    int span = Math.max(0, 4);
                    delay = span == 0 ? 6 : 6 + rnd.nextInt(span + 1);
                }
            }
            catch (Throwable ignored) {
                delay = 6;
            }
            this.handFeedCawCooldownTicks = Math.max(0, delay);
        }
        catch (Throwable t) {
            LOG.warn("[RavenEntity] tickHandFeedAgreeSequence failed safely: {}", (Object)t.toString());
            this.handFeedSequenceActive = false;
            this.handFeedCawsRemaining = 0;
            this.handFeedCawCooldownTicks = 0;
        }
    }

    public boolean isFollowOverrideActive() {
        return this.followOverrideActive;
    }

    @Nullable
    public Player getOwnerPlayerServerSafe() {
        try {
            Level level = this.raven.level();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.raven.isTame()) {
                return null;
            }
            if (this.raven.getOwnerUUID() == null) {
                return null;
            }
            return serverLevel.getPlayerByUUID(this.raven.getOwnerUUID());
        }
        catch (Throwable t) {
            LOG.error("[RavenEntity] getOwnerPlayerServerSafe failed", t);
            return null;
        }
    }

    public boolean isLureFollowActive() {
        try {
            if (this.raven.level().isClientSide) {
                return false;
            }
            if (!this.raven.isAlive()) {
                if (this.lureFollowPlayerUuid != null || this.lureFollowTicks > 0 || this.followOverrideActive) {
                    this.clearLureFollowState("isLureFollowActive: raven not alive");
                }
                return false;
            }
            if (this.lureFollowPlayerUuid == null) {
                if (this.lureFollowTicks != 0 || this.followOverrideActive || this.followPocketAnchor != null) {
                    this.clearLureFollowState("isLureFollowActive: missing UUID");
                } else {
                    this.lureFollowTicks = 0;
                }
                return false;
            }
            if (this.lureFollowTicks > 0) {
                --this.lureFollowTicks;
            }
            if (this.lureFollowTicks <= 0) {
                this.clearLureFollowState("isLureFollowActive: timer expired");
                return false;
            }
            Player p = this.raven.level().getPlayerByUUID(this.lureFollowPlayerUuid);
            if (p == null || !p.isAlive() || p.isSpectator()) {
                this.clearLureFollowState("isLureFollowActive: lure player invalid");
                return false;
            }
            if (!this.isLureItemInHand(p)) {
                this.clearLureFollowState("isLureFollowActive: lure player no longer holding lure item");
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            if (this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] isLureFollowActive failed safely: {}", (Object)t.toString());
            }
            this.clearLureFollowState("isLureFollowActive: exception");
            return false;
        }
    }

    @Nullable
    public Player getLureFollowPlayerServerSafe() {
        try {
            Level level = this.raven.level();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.isLureFollowActive()) {
                return null;
            }
            Player p = serverLevel.getPlayerByUUID(this.lureFollowPlayerUuid);
            if (p == null) {
                return null;
            }
            if (!p.isAlive() || p.isSpectator()) {
                return null;
            }
            return p;
        }
        catch (Throwable t) {
            if (this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] getLureFollowPlayerServerSafe failed safely: {}", (Object)t.toString());
            }
            return null;
        }
    }

    public void requestLureFollowPlayer(@Nullable Player player, double distToPlayer) {
        try {
            boolean pathOk;
            if (this.raven.level().isClientSide) {
                return;
            }
            if (!this.raven.isAlive()) {
                return;
            }
            if (player == null || !player.isAlive() || player.isSpectator()) {
                if (this.lureFollowPlayerUuid != null || this.lureFollowTicks > 0 || this.followOverrideActive) {
                    this.clearLureFollowState("requestLureFollowPlayer: player invalid");
                }
                return;
            }
            if (this.playerHasTamedRaven(player)) {
                if (this.raven.tickCount % 80 == 0) {
                    LOG.debug("[RavenEntity] requestLureFollowPlayer: player={} already has a tamed raven; ignoring lure.", (Object)player.getName().getString());
                }
                return;
            }
            if (!this.isLureItemInHand(player)) {
                if (this.lureFollowPlayerUuid != null || this.lureFollowTicks > 0 || this.followOverrideActive) {
                    this.clearLureFollowState("requestLureFollowPlayer: player no longer holding lure item");
                }
                return;
            }
            UUID incomingId = player.getUUID();
            if (this.lureFollowPlayerUuid != null && !incomingId.equals(this.lureFollowPlayerUuid) && this.isLureFollowActive()) {
                if (this.raven.tickCount % 40 == 0) {
                    LOG.debug("[RavenEntity] requestLureFollowPlayer: already lured by {} \u2013 ignoring new lure from {}", (Object)this.lureFollowPlayerUuid, (Object)player.getName().getString());
                }
                return;
            }
            this.lureFollowPlayerUuid = incomingId;
            int refresh = 60;
            if (this.lureFollowTicks < refresh) {
                this.lureFollowTicks = refresh;
            }
            if (this.raven.getAIState() != RavenAIState.FOLLOW_OWNER) {
                this.raven.setAIState(RavenAIState.FOLLOW_OWNER);
            }
            this.followOverrideActive = true;
            try {
                this.setPrivateInt("playerAvoidanceOverrideTicks", 0);
                this.setPrivateInt("playerAvoidanceRearmCooldownTicks", 0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.invokeResetLandingState("lure follow arm");
            this.setPrivateInt("idleCommitTicks", 0);
            this.setPrivateInt("idleLockTicks", 0);
            this.setPrivateInt("idleLeafLossTicks", 0);
            this.setPrivateInt("roamTicksRemaining", 0);
            this.raven.setNoGravity(true);
            if (this.raven.getAnimMode() != RavenAnimMode.IN_AIR) {
                this.raven.setAnimMode(RavenAnimMode.IN_AIR);
            }
            BlockPos pocket = null;
            try {
                pocket = this.findFollowPocketNearPlayer(player);
            }
            catch (Throwable ignored) {
                pocket = null;
            }
            if (pocket == null) {
                int py = Mth.floor((double)player.getY());
                int y = this.invokeClampYToHomeBounds(py + 3);
                pocket = new BlockPos(Mth.floor((double)player.getX()), y, Mth.floor((double)player.getZ()));
            }
            this.followPocketAnchor = pocket;
            this.followPocketRecalcCooldownTicks = 10;
            Vec3 desiredFront = this.computeFollowFrontPosition(player);
            RavenAStarPathing.Config cfg = new RavenAStarPathing.Config();
            cfg.allowLeaves = false;
            cfg.allowReplaceables = false;
            cfg.clearanceHeight = 2;
            cfg.cellSize = 1;
            Vec3 safeGoal = this.invokeComputeSafePathingGoal(desiredFront, cfg);
            long seed = player.getUUID().getLeastSignificantBits() ^ this.raven.getUUID().getMostSignificantBits() ^ (long)this.raven.tickCount ^ 0xF011000DL;
            try {
                pathOk = this.invokeEnsurePathToWithFlags(safeGoal, true, 160, seed, "lure follow (front-of-player): player=" + player.getName().getString() + " dist=" + String.format("%.2f", distToPlayer));
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 40 == 0) {
                    LOG.warn("[RavenEntity] requestLureFollowPlayer ensurePathTo failed safely: {}", (Object)t.toString());
                }
                pathOk = false;
            }
            if (pathOk) {
                this.setPrivateObject("pathPendingGoal", safeGoal);
                this.invokeClearFlyTarget();
            } else {
                this.invokeClearPlannedPath("lure follow: path failed");
                this.invokeClearFlyTarget();
            }
            if (this.raven.tickCount % 20 == 0) {
                LOG.info("[RavenEntity] LURE FOLLOW armed: player={} dist={} pocket={} desiredFront={} safeGoal={} pathOk={} lureTicks={} aiState={} pos={}", new Object[]{player.getName().getString(), String.format("%.2f", distToPlayer), pocket, desiredFront, safeGoal, pathOk, this.lureFollowTicks, this.raven.getAIState(), this.raven.position()});
            }
        }
        catch (Throwable t) {
            LOG.error("[RavenEntity] requestLureFollowPlayer failed safely", t);
            try {
                if (this.lureFollowTicks > 10) {
                    this.lureFollowTicks = 10;
                }
                this.followOverrideActive = false;
                this.followPocketAnchor = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void tickFollowOwner() {
        try {
            List<Vec3> wpNow;
            int wpIndex;
            List<Vec3> waypoints;
            int flyTtl;
            Vec3 currentFlyTarget;
            boolean needNewGoal;
            this.raven.setNoGravity(true);
            if (this.raven.getAnimMode() != RavenAnimMode.IN_AIR) {
                this.raven.setAnimMode(RavenAnimMode.IN_AIR);
            }
            try {
                if (!this.raven.level().isClientSide && this.lureAgreeSequenceGlobalCooldownTicks > 0) {
                    --this.lureAgreeSequenceGlobalCooldownTicks;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.tickLureAgreeSequenceProgress();
            this.tickHandFeedAgreeSequence();
            this.invokeResetLandingState("follow");
            this.setPrivateInt("idleLockTicks", 0);
            this.setPrivateInt("idleLeafLossTicks", 0);
            try {
                if (!this.raven.level().isClientSide) {
                    if (this.lureFollowTicks > 0) {
                        --this.lureFollowTicks;
                    }
                    if (this.lureFollowTicks <= 0 && this.lureFollowPlayerUuid != null) {
                        this.clearLureFollowState("follow: lure timer expired");
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Player target = null;
            boolean usingLure = false;
            try {
                target = this.getOwnerPlayerServerSafe();
            }
            catch (Throwable ignored) {
                target = null;
            }
            if (target == null) {
                try {
                    Player lure = this.getLureFollowPlayerServerSafe();
                    if (lure != null) {
                        target = lure;
                        usingLure = true;
                    }
                }
                catch (Throwable ignored) {
                    target = null;
                }
            }
            if (target == null) {
                if (this.isLureFollowActive()) {
                    this.clearLureFollowState("follow: target missing");
                }
                this.wasAtLureGoalLastTick = false;
                this.wasAtFollowGoalLastTick = false;
                this.raven.setAIState(RavenAIState.IDLE_GROUND);
                this.setPrivateInt("idleTicksRemaining", 0);
                this.invokeClearPlannedPath("follow lost target");
                this.invokeClearFlyTarget();
                this.setPrivateInt("roamTicksRemaining", 0);
                return;
            }
            if (!usingLure && this.followOverrideActive) {
                if (this.raven.tickCount % 40 == 0) {
                    LOG.debug("[RavenEntity] tickFollowOwner: clearing followOverrideActive (not using lure). pos={} ai={}", (Object)this.raven.position(), (Object)this.raven.getAIState());
                }
                this.followOverrideActive = false;
            }
            if (usingLure) {
                try {
                    if (this.lureFollowTicks < 10 && this.lureFollowPlayerUuid != null) {
                        this.lureFollowTicks = 10;
                    }
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
            if (this.invokeIsOutOfHomeBounds(target.position())) {
                this.triggerFollowCooldownAndReturn();
                return;
            }
            if (this.followGoalTtlTicks > 0) {
                --this.followGoalTtlTicks;
            }
            if (this.followRepathCooldownTicks > 0) {
                --this.followRepathCooldownTicks;
            }
            boolean atGoal = false;
            Vec3 computedFront = null;
            try {
                computedFront = this.computeFollowFrontPosition(target);
                atGoal = this.isCloseEnoughToFollowPlayer(target);
            }
            catch (Throwable ignored) {
                atGoal = false;
            }
            boolean firstArrivalAny = atGoal && !this.wasAtFollowGoalLastTick;
            this.wasAtFollowGoalLastTick = atGoal;
            boolean shouldStartAgreeSequence = false;
            if (usingLure && atGoal && !this.wasAtLureGoalLastTick && this.lureAgreeSequenceGlobalCooldownTicks <= 0) {
                shouldStartAgreeSequence = true;
            }
            boolean bl = this.wasAtLureGoalLastTick = usingLure && atGoal;
            if (atGoal) {
                if (firstArrivalAny) {
                    this.onRavenArrivedAtFollowTarget(target, usingLure, computedFront);
                }
                if (shouldStartAgreeSequence) {
                    this.maybeStartLureAgreeSequence();
                }
                this.invokeClearPlannedPath("follow: arrived");
                this.invokeClearFlyTarget();
                this.raven.setDeltaMovement(this.raven.getDeltaMovement().scale(0.6));
                this.followCachedGoal = null;
                this.followCachedOwnerPos = null;
                this.followCachedOwnerLook = null;
                this.followGoalTtlTicks = 0;
                this.consecutiveLurePathFails = 0;
                this.lastLurePathFailTick = 0;
                int flyTtl2 = this.getPrivateInt("flyTargetTimeoutTicks", 0);
                if (flyTtl2 > 0) {
                    this.setPrivateInt("flyTargetTimeoutTicks", flyTtl2 - 1);
                }
                this.invokeMaybeAvoidOrRetargetDuringFlight(this.raven.getRandom());
                if (this.raven.tickCount % 40 == 0) {
                    LOG.debug("[RavenEntity] tickFollowOwner: ARRIVED target={} usingLure={} pos={} frontGoal={}", new Object[]{target.getName().getString(), usingLure, this.raven.position(), computedFront});
                }
                return;
            }
            Vec3 ownerPosNow = target.position();
            Vec3 ownerLookNow = target.getLookAngle();
            boolean bl2 = needNewGoal = this.followCachedGoal == null || this.followGoalTtlTicks <= 0;
            if (!needNewGoal) {
                boolean stuckOrColliding;
                double moved2 = this.followCachedOwnerPos == null ? Double.MAX_VALUE : ownerPosNow.distanceToSqr(this.followCachedOwnerPos);
                boolean turned = false;
                if (this.followCachedOwnerLook != null) {
                    double ax = this.followCachedOwnerLook.x;
                    double az = this.followCachedOwnerLook.z;
                    double bx = ownerLookNow.x;
                    double bz = ownerLookNow.z;
                    double al = Math.sqrt(ax * ax + az * az);
                    double bl3 = Math.sqrt(bx * bx + bz * bz);
                    if (al > 1.0E-4 && bl3 > 1.0E-4) {
                        double dot = (ax /= al) * (bx /= bl3) + (az /= al) * (bz /= bl3);
                        turned = dot < 0.92;
                    }
                }
                currentFlyTarget = this.getFlyTargetField();
                flyTtl = this.getPrivateInt("flyTargetTimeoutTicks", 0);
                waypoints = this.getPathWaypoints();
                wpIndex = this.getPrivateInt("pathWaypointIndex", 0);
                int stuckTicks = this.getPrivateInt("stuckTicks", 0);
                int stuckThreshold = this.getStuckTicksThreshold();
                boolean hasFlyIntent = currentFlyTarget != null && flyTtl > 0;
                boolean hasPathIntent = waypoints != null && !waypoints.isEmpty() && wpIndex < waypoints.size();
                boolean hasAnyIntent = hasFlyIntent || hasPathIntent;
                boolean bl4 = stuckOrColliding = this.raven.horizontalCollision || this.raven.verticalCollision || stuckTicks >= stuckThreshold;
                if (moved2 >= 0.5625) {
                    needNewGoal = true;
                }
                if (turned) {
                    needNewGoal = true;
                }
                if (!hasAnyIntent || stuckOrColliding) {
                    needNewGoal = true;
                }
            }
            if (needNewGoal && this.followRepathCooldownTicks > 0) {
                needNewGoal = false;
            }
            Vec3 desiredGoal = this.followCachedGoal;
            Vec3 effectivePathGoal = null;
            boolean pathOk = false;
            if (needNewGoal) {
                block76: {
                    String reason;
                    Vec3 rawFront = this.computeFollowFrontPosition(target);
                    Vec3 lockedSafe = this.computeSafeFollowGoalXZLockedY(rawFront);
                    this.followCachedGoal = lockedSafe = this.invokeClampTargetToHomeBounds(lockedSafe);
                    desiredGoal = lockedSafe;
                    this.followCachedOwnerPos = ownerPosNow;
                    this.followCachedOwnerLook = ownerLookNow;
                    this.followGoalTtlTicks = 12;
                    this.followRepathCooldownTicks = 10;
                    this.invokeClearPlannedPath("follow: new goal");
                    this.invokeClearFlyTarget();
                    long seed = target.getUUID().getLeastSignificantBits() ^ this.raven.getUUID().getMostSignificantBits() ^ (long)this.raven.tickCount ^ 0xF0110BEEFL;
                    String string = reason = usingLure ? "follow lure player (aggressive)" : "follow owner (aggressive)";
                    if (usingLure) {
                        RavenAStarPathing.Config cfg = new RavenAStarPathing.Config();
                        cfg.allowLeaves = false;
                        cfg.allowReplaceables = false;
                        cfg.clearanceHeight = 2;
                        cfg.cellSize = 1;
                        effectivePathGoal = this.invokeComputeSafePathingGoal(desiredGoal, cfg);
                    } else {
                        effectivePathGoal = desiredGoal;
                    }
                    try {
                        pathOk = usingLure ? this.invokeEnsurePathToWithFlags(effectivePathGoal, false, 100, seed, reason) : this.invokeEnsurePathTo(effectivePathGoal, 100, seed, reason);
                    }
                    catch (Throwable t) {
                        pathOk = false;
                        if (this.raven.tickCount % 40 != 0) break block76;
                        LOG.warn("[RavenEntity] tickFollowOwner ensurePathTo failed safely: {}", (Object)t.toString());
                    }
                }
                if (pathOk) {
                    this.setPrivateObject("pathPendingGoal", effectivePathGoal);
                    this.invokeClearFlyTarget();
                    if (usingLure) {
                        this.consecutiveLurePathFails = 0;
                        this.lastLurePathFailTick = 0;
                    }
                } else {
                    this.invokeClearPlannedPath("follow: path failed");
                    this.invokeClearFlyTarget();
                    if (usingLure) {
                        if (this.raven.tickCount != this.lastLurePathFailTick) {
                            this.lastLurePathFailTick = this.raven.tickCount;
                            ++this.consecutiveLurePathFails;
                        }
                        if (this.consecutiveLurePathFails >= 3) {
                            this.fallbackBallisticLure(desiredGoal, target);
                        }
                    }
                }
            } else {
                boolean hasPathIntent;
                currentFlyTarget = this.getFlyTargetField();
                flyTtl = this.getPrivateInt("flyTargetTimeoutTicks", 0);
                waypoints = this.getPathWaypoints();
                wpIndex = this.getPrivateInt("pathWaypointIndex", 0);
                boolean hasFlyIntent = currentFlyTarget != null && flyTtl > 0;
                boolean bl5 = hasPathIntent = waypoints != null && !waypoints.isEmpty() && wpIndex < waypoints.size();
                if (!hasFlyIntent && !hasPathIntent && desiredGoal != null) {
                    long seed2 = target.getUUID().getLeastSignificantBits() ^ this.raven.getUUID().getMostSignificantBits() ^ (long)this.raven.tickCount ^ 0xF0110C0DEL;
                    String reason2 = usingLure ? "follow lure player (reassert path)" : "follow owner (reassert path)";
                    Vec3 reassertGoal = desiredGoal;
                    if (usingLure) {
                        RavenAStarPathing.Config cfg2 = new RavenAStarPathing.Config();
                        cfg2.allowLeaves = false;
                        cfg2.allowReplaceables = false;
                        cfg2.clearanceHeight = 2;
                        cfg2.cellSize = 1;
                        reassertGoal = this.invokeComputeSafePathingGoal(desiredGoal, cfg2);
                    }
                    boolean ok2 = false;
                    try {
                        ok2 = usingLure ? this.invokeEnsurePathToWithFlags(reassertGoal, false, 100, seed2, reason2) : this.invokeEnsurePathTo(reassertGoal, 100, seed2, reason2);
                    }
                    catch (Throwable t) {
                        if (this.raven.tickCount % 40 == 0) {
                            LOG.warn("[RavenEntity] tickFollowOwner reassert ensurePathTo failed safely: {}", (Object)t.toString());
                        }
                        ok2 = false;
                    }
                    if (ok2) {
                        this.setPrivateObject("pathPendingGoal", reassertGoal);
                        this.invokeClearFlyTarget();
                        if (usingLure) {
                            this.consecutiveLurePathFails = 0;
                            this.lastLurePathFailTick = 0;
                        }
                    } else {
                        this.invokeClearPlannedPath("follow: reassert path failed");
                        this.invokeClearFlyTarget();
                        if (usingLure) {
                            if (this.raven.tickCount != this.lastLurePathFailTick) {
                                this.lastLurePathFailTick = this.raven.tickCount;
                                ++this.consecutiveLurePathFails;
                            }
                            if (this.consecutiveLurePathFails >= 3) {
                                this.fallbackBallisticLure(desiredGoal, target);
                            }
                        }
                    }
                }
            }
            if (this.invokeIsOutOfHomeBounds(this.raven.position())) {
                this.triggerFollowCooldownAndReturn();
                return;
            }
            int flyTimeout = this.getPrivateInt("flyTargetTimeoutTicks", 0);
            if (flyTimeout > 0) {
                this.setPrivateInt("flyTargetTimeoutTicks", flyTimeout - 1);
            }
            if (!usingLure) {
                this.invokeMaybeAvoidOrRetargetDuringFlight(this.raven.getRandom());
            } else {
                boolean collidingOrStuck;
                Vec3 currentFly = this.getFlyTargetField();
                List<Vec3> currentPath = this.getPathWaypoints();
                boolean hasPathIntent = currentPath != null && !currentPath.isEmpty();
                boolean hasFlyIntent = currentFly != null && this.getPrivateInt("flyTargetTimeoutTicks", 0) > 0;
                int stuckTicks = this.getPrivateInt("stuckTicks", 0);
                int stuckThreshold = this.getStuckTicksThreshold();
                boolean bl6 = collidingOrStuck = this.raven.horizontalCollision || this.raven.verticalCollision || stuckTicks >= stuckThreshold;
                if (!hasPathIntent && !hasFlyIntent) {
                    this.invokeMaybeAvoidOrRetargetDuringFlight(this.raven.getRandom());
                } else if (collidingOrStuck) {
                    this.invokeMaybeAvoidOrRetargetDuringFlight(this.raven.getRandom());
                }
            }
            Vec3 flyTargetNow = this.getFlyTargetField();
            if (flyTargetNow != null) {
                double speed = this.getFlySpeedBase();
                this.invokeFlyTowardTarget(speed);
            }
            if ((wpNow = this.getPathWaypoints()) != null && !wpNow.isEmpty()) {
                this.invokeAdvanceWaypointIfNeeded(100, usingLure ? "follow lure player" : "follow owner");
            }
            if (this.raven.tickCount % 40 == 0) {
                Vec3 logFlyTarget = this.getFlyTargetField();
                List<Vec3> logWaypoints = this.getPathWaypoints();
                int logIdx = this.getPrivateInt("pathWaypointIndex", 0);
                int logPts = logWaypoints == null ? 0 : logWaypoints.size();
                LOG.debug("[RavenEntity] tickFollowOwner: target={} usingLure={} goal={} ttl={} repathCd={} flyTarget={} pathPts={} pathIdx={} pos={} vel={} lureFails={}", new Object[]{target.getName().getString(), usingLure, desiredGoal, this.followGoalTtlTicks, this.followRepathCooldownTicks, logFlyTarget, logPts, logIdx, this.raven.position(), this.raven.getDeltaMovement(), this.consecutiveLurePathFails});
            }
        }
        catch (Throwable t) {
            LOG.error("[RavenEntity] tickFollowOwner failed safely", t);
        }
    }

    public void triggerFollowCooldownAndReturn() {
        block5: {
            try {
                RandomSource rnd = this.raven.getRandom();
                int cd = 100 + rnd.nextInt(Math.max(1, 101));
                this.setFollowCooldownTicks(cd);
                this.raven.setAIState(RavenAIState.ROAM_FLY);
                this.invokeClearPlannedPath("follow cooldown return");
                Vec3 ret = this.invokeHomeCenterReturnTarget();
                long seed = this.raven.getUUID().getMostSignificantBits() ^ (long)this.raven.tickCount ^ 0xA11CE5EDL;
                boolean ok = this.invokeEnsurePathTo(ret, 200, seed, "follow cooldown return");
                if (!ok) {
                    this.invokeSetFlyTarget(ret, 200);
                }
                this.setPrivateInt("roamTicksRemaining", 0);
                this.invokeResetLandingState("follow cooldown");
                this.setPrivateInt("idleLockTicks", 0);
                this.setPrivateInt("idleLeafLossTicks", 0);
                this.raven.beginRoamFlightWindow("follow cooldown -> roam");
                this.invokeClearPlannedPath("override roam window with return");
                boolean ok2 = this.invokeEnsurePathTo(ret, 200, seed ^ 0x55AA55AAL, "follow cooldown return (post-roam window)");
                if (!ok2) {
                    this.invokeSetFlyTarget(ret, 200);
                }
                this.stopLureAgreeSequence("follow cooldown");
                this.wasAtLureGoalLastTick = false;
                if (this.raven.tickCount % 40 == 0) {
                    LOG.debug("[RavenEntity] Follow bounds violated -> cooldown {} ticks and return to home", (Object)cd);
                }
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block5;
                LOG.warn("[RavenEntity] triggerFollowCooldownAndReturn failed safely: {}", (Object)t.toString());
            }
        }
    }

    public void clearLureFollowState(String reason) {
        try {
            if (this.raven.tickCount % 40 == 0) {
                LOG.debug("[RavenEntity] clearLureFollowState: reason={} hadUuid={} ticksLeft={} overrideActive={} pocket={} pos={}", new Object[]{reason, this.lureFollowPlayerUuid != null, this.lureFollowTicks, this.followOverrideActive, this.followPocketAnchor, this.raven.position()});
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.lureFollowPlayerUuid = null;
        this.lureFollowTicks = 0;
        this.followOverrideActive = false;
        this.followPocketAnchor = null;
        this.followPocketRecalcCooldownTicks = 0;
        this.stopLureAgreeSequence("clearLureFollowState");
        this.wasAtLureGoalLastTick = false;
        this.handFeedSequenceActive = false;
        this.handFeedCawsRemaining = 0;
        this.handFeedCawCooldownTicks = 0;
    }

    private boolean isLureItemInHand(Player player) {
        try {
            if (player == null) {
                return false;
            }
            ItemStack main = player.getMainHandItem();
            ItemStack off = player.getOffhandItem();
            return this.isLureItem(main) || this.isLureItem(off);
        }
        catch (Throwable t) {
            if (this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] isLureItemInHand failed safely: {}", (Object)t.toString());
            }
            return false;
        }
    }

    private boolean isLureItem(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        return stack.is(Items.GOLD_NUGGET);
    }

    @Nullable
    public BlockPos findFollowPocketNearPlayer(Player player) {
        try {
            BlockPos pocket;
            if (player == null || !player.isAlive() || player.isSpectator()) {
                return null;
            }
            Vec3 look = player.getLookAngle();
            double lx = look.x;
            double lz = look.z;
            double lenXZ = Math.sqrt(lx * lx + lz * lz);
            if (lenXZ < 1.0E-4) {
                lx = 0.0;
                lz = 1.0;
                lenXZ = 1.0;
            }
            double FRONT_DISTANCE = 2.0;
            double baseX = player.getX() + (lx /= lenXZ) * 2.0;
            double baseZ = player.getZ() + (lz /= lenXZ) * 2.0;
            double baseYRaw = player.getY() + (double)player.getEyeHeight() - 1.0;
            int baseYInt = this.invokeClampYToHomeBounds(Mth.floor((double)baseYRaw));
            double baseY = (double)baseYInt + 0.5;
            Vec3 centerVec = new Vec3(baseX, baseY, baseZ);
            centerVec = this.invokeClampTargetToHomeBounds(centerVec);
            BlockPos center = BlockPos.containing((Position)centerVec);
            long seed = this.raven.getUUID().getLeastSignificantBits() ^ player.getUUID().getMostSignificantBits() ^ (long)this.raven.tickCount ^ 0xF0110FACE5L;
            Teleportation tp = this.raven.getTeleportation();
            BlockPos blockPos = pocket = tp == null ? null : tp.findEmptyTeleportBlock3x3x3Near(center, 4, 80, seed, this.raven);
            if (pocket == null) {
                if (this.raven.tickCount % 40 == 0) {
                    LOG.debug("[RavenEntity] findFollowPocketNearPlayer: no 3x3x3 pocket near front center={} player={} pos={}", new Object[]{center, player.getName().getString(), this.raven.position()});
                }
            } else if (this.raven.tickCount % 40 == 0) {
                LOG.debug("[RavenEntity] findFollowPocketNearPlayer: pocket={} for player={} frontCenter={} pos={}", new Object[]{pocket, player.getName().getString(), center, this.raven.position()});
            }
            return pocket;
        }
        catch (Throwable t) {
            if (this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] findFollowPocketNearPlayer failed safely: {}", (Object)t.toString());
            }
            return null;
        }
    }

    @Nullable
    public BlockPos findFollowPocketNearPlayerInternal(BlockPos playerCenter, int playerY, int[] yOffsets, int maxR) {
        try {
            if (playerCenter == null) {
                return null;
            }
            for (int r = 0; r <= maxR; ++r) {
                for (int yo : yOffsets) {
                    int z;
                    BlockPos cand;
                    int x;
                    int yRaw = playerY + yo;
                    int y = this.invokeClampYToHomeBounds(yRaw);
                    if (yo >= 0 && y < playerY) {
                        y = playerY;
                    }
                    int x0 = playerCenter.getX() - r;
                    int x1 = playerCenter.getX() + r;
                    int z0 = playerCenter.getZ() - r;
                    int z1 = playerCenter.getZ() + r;
                    for (x = x0; x <= x1; ++x) {
                        cand = new BlockPos(x, y, z0);
                        if (!this.isFollowPocketCandidateOk(cand)) continue;
                        return cand;
                    }
                    if (z1 != z0) {
                        for (x = x0; x <= x1; ++x) {
                            cand = new BlockPos(x, y, z1);
                            if (!this.isFollowPocketCandidateOk(cand)) continue;
                            return cand;
                        }
                    }
                    for (z = z0 + 1; z <= z1 - 1; ++z) {
                        cand = new BlockPos(x0, y, z);
                        if (!this.isFollowPocketCandidateOk(cand)) continue;
                        return cand;
                    }
                    if (x1 == x0) continue;
                    for (z = z0 + 1; z <= z1 - 1; ++z) {
                        cand = new BlockPos(x1, y, z);
                        if (!this.isFollowPocketCandidateOk(cand)) continue;
                        return cand;
                    }
                }
            }
            return null;
        }
        catch (Throwable t) {
            if (this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] findFollowPocketNearPlayerInternal failed safely: {}", (Object)t.toString());
            }
            return null;
        }
    }

    private boolean isFollowPocketCandidateOk(BlockPos anchor) {
        try {
            if (anchor == null) {
                return false;
            }
            Vec3 center = new Vec3((double)anchor.getX() + 0.5, (double)anchor.getY(), (double)anchor.getZ() + 0.5);
            if (this.invokeIsOutOfHomeBounds(center)) {
                return false;
            }
            return this.isEmptyTeleportPocket3x3x3At(anchor);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean isEmptyTeleportPocket3x3x3At(BlockPos anchor) {
        try {
            if (anchor == null) {
                return false;
            }
            int x0 = anchor.getX() - 1;
            int y0 = anchor.getY();
            int z0 = anchor.getZ() - 1;
            for (int dx = 0; dx < 3; ++dx) {
                for (int dz = 0; dz < 3; ++dz) {
                    for (int dy = 0; dy < 3; ++dy) {
                        BlockPos p = new BlockPos(x0 + dx, y0 + dy, z0 + dz);
                        if (!this.raven.level().isEmptyBlock(p)) {
                            return false;
                        }
                        if (this.raven.level().getFluidState(p).isEmpty()) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Throwable t) {
            if (this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] isEmptyTeleportPocket3x3x3At failed safely: {}", (Object)t.toString());
            }
            return false;
        }
    }

    public Vec3 computeSafeFollowGoalXZLockedY(Vec3 rawGoal) {
        try {
            if (rawGoal == null) {
                return null;
            }
            int y = Mth.floor((double)(rawGoal.y + 1.0E-4));
            double baseX = Math.floor(rawGoal.x) + 0.5;
            double baseZ = Math.floor(rawGoal.z) + 0.5;
            BlockPos base = BlockPos.containing((double)baseX, (double)y, (double)baseZ);
            if (this.raven.level().isEmptyBlock(base) && this.raven.level().getFluidState(base).isEmpty() && this.raven.level().isEmptyBlock(base.above())) {
                return new Vec3(baseX, rawGoal.y, baseZ);
            }
            int R = 3;
            BlockPos chosen = null;
            block2: for (int r = 1; r <= 3 && chosen == null; ++r) {
                BlockPos p2;
                BlockPos p1;
                for (int dx = -r; dx <= r && chosen == null; ++dx) {
                    int dzA = -r;
                    int dzB = r;
                    p1 = base.offset(dx, 0, dzA);
                    if (this.raven.level().isEmptyBlock(p1) && this.raven.level().getFluidState(p1).isEmpty() && this.raven.level().isEmptyBlock(p1.above())) {
                        chosen = p1;
                        break;
                    }
                    if (dzB == dzA) continue;
                    p2 = base.offset(dx, 0, dzB);
                    if (!this.raven.level().isEmptyBlock(p2) || !this.raven.level().getFluidState(p2).isEmpty() || !this.raven.level().isEmptyBlock(p2.above())) continue;
                    chosen = p2;
                    break;
                }
                for (int dz = -r + 1; dz <= r - 1 && chosen == null; ++dz) {
                    int dxA = -r;
                    int dxB = r;
                    p1 = base.offset(dxA, 0, dz);
                    if (this.raven.level().isEmptyBlock(p1) && this.raven.level().getFluidState(p1).isEmpty() && this.raven.level().isEmptyBlock(p1.above())) {
                        chosen = p1;
                        continue block2;
                    }
                    if (dxB == dxA) continue;
                    p2 = base.offset(dxB, 0, dz);
                    if (!this.raven.level().isEmptyBlock(p2) || !this.raven.level().getFluidState(p2).isEmpty() || !this.raven.level().isEmptyBlock(p2.above())) continue;
                    chosen = p2;
                    continue block2;
                }
            }
            if (chosen != null) {
                Vec3 out = new Vec3((double)chosen.getX() + 0.5, rawGoal.y, (double)chosen.getZ() + 0.5);
                out = this.invokeClampTargetToHomeBounds(out);
                return out;
            }
            return this.invokeClampTargetToHomeBounds(new Vec3(baseX, rawGoal.y, baseZ));
        }
        catch (Throwable t) {
            return rawGoal;
        }
    }

    private void onRavenArrivedAtFollowTarget(Player target, boolean usingLure, @Nullable Vec3 frontGoal) {
        block13: {
            try {
                float pitchMax;
                float pitchMin;
                float volume;
                String soundId;
                if (this.raven == null) {
                    return;
                }
                if (this.raven.level() == null || this.raven.level().isClientSide) {
                    return;
                }
                if (target == null) {
                    return;
                }
                LOG.info("[RavenEntity] onRavenArrivedAtFollowTarget: target={} usingLure={} pos={} frontGoal={}", new Object[]{target.getName().getString(), usingLure, this.raven.position(), frontGoal});
                if (usingLure) {
                    soundId = TAMING_AGREE_SOUND_ID;
                    volume = 1.0f;
                    pitchMin = 0.98f;
                    pitchMax = 1.02f;
                } else {
                    soundId = ARRIVAL_SOUND_ID;
                    volume = 0.8f;
                    pitchMin = 0.95f;
                    pitchMax = 1.05f;
                }
                try {
                    float pitch;
                    float lo = pitchMin;
                    float hi = pitchMax;
                    if (lo > hi) {
                        float tmp = lo;
                        lo = hi;
                        hi = tmp;
                    }
                    try {
                        RandomSource rnd = this.raven.getRandom();
                        float t = rnd == null ? 0.5f : rnd.nextFloat();
                        pitch = lo + (hi - lo) * t;
                    }
                    catch (Throwable ignored) {
                        pitch = (lo + hi) * 0.5f;
                    }
                    RavenSoundEngine.playAt(this.raven.level(), soundId, SoundSource.NEUTRAL, this.raven.position(), volume, pitch);
                    LOG.info("[RavenEntity] onRavenArrivedAtFollowTarget: played arrival sound={} usingLure={} pos={}", new Object[]{soundId, usingLure, this.raven.position()});
                }
                catch (Throwable t) {
                    if (this.raven.tickCount % 80 == 0) {
                        LOG.warn("[RavenEntity] onRavenArrivedAtFollowTarget: sound playback failed safely: {}", (Object)t.toString());
                    }
                }
            }
            catch (Throwable t) {
                if (this.raven == null || this.raven.tickCount % 80 != 0) break block13;
                LOG.warn("[RavenEntity] onRavenArrivedAtFollowTarget failed safely: {}", (Object)t.toString());
            }
        }
    }

    public Vec3 computeFollowFrontPosition(Player player) {
        try {
            double eyeY;
            Vec3 playerPos = player.position();
            Vec3 look = player.getLookAngle();
            double lx = look.x;
            double lz = look.z;
            double len = Math.sqrt(lx * lx + lz * lz);
            if (len < 1.0E-4) {
                double dz;
                double dx = this.raven.getX() - playerPos.x;
                double len2 = Math.sqrt(dx * dx + (dz = this.raven.getZ() - playerPos.z) * dz);
                if (len2 < 1.0E-4) {
                    lx = 1.0;
                    lz = 0.0;
                    len = 1.0;
                } else {
                    lx = dx / len2;
                    lz = dz / len2;
                    len = 1.0;
                }
            } else {
                lx /= len;
                lz /= len;
            }
            double FOLLOW_FRONT_DISTANCE = 1.15;
            double tx = playerPos.x + lx * 1.15;
            double tz = playerPos.z + lz * 1.15;
            double preferredY = eyeY = player.getEyeY();
            double safeY = this.computeSafeHoverYUnderCeiling(tx, preferredY, tz, player);
            int tyInt = this.invokeClampYToHomeBounds(Mth.floor((double)safeY));
            double ty = (double)tyInt + 0.05;
            Vec3 raw = new Vec3(tx, ty, tz);
            Vec3 clamped = this.invokeClampTargetToHomeBounds(raw);
            if (this.raven.tickCount % 40 == 0) {
                LOG.debug("[RavenEntity] computeFollowFrontPosition: playerPos={} eyeY={} preferredY={} safeY={} out={} raw={} dist={}", new Object[]{playerPos, String.format("%.2f", eyeY), String.format("%.2f", preferredY), String.format("%.2f", safeY), clamped, raw, String.format("%.2f", 1.15)});
            }
            return clamped;
        }
        catch (Throwable t) {
            if (this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] computeFollowFrontPosition failed safely: {}", (Object)t.toString());
            }
            return this.raven.position().add(0.0, 1.5, 0.0);
        }
    }

    public boolean isCloseEnoughToFollowPlayer(Player player) {
        try {
            if (player == null) {
                return false;
            }
            Vec3 goal = this.computeFollowFrontPosition(player);
            if (goal == null) {
                return false;
            }
            Vec3 pos = this.raven.position();
            double dx = pos.x - goal.x;
            double dz = pos.z - goal.z;
            double dXZ2 = dx * dx + dz * dz;
            double dy = Math.abs(pos.y - goal.y);
            boolean closeXZ = dXZ2 <= 1.1025;
            boolean closeY = dy <= 1.25;
            return closeXZ && closeY;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private void setPrivateInt(String fieldName, int value) {
        block2: {
            try {
                Field f = RavenEntity.class.getDeclaredField(fieldName);
                f.setAccessible(true);
                f.setInt((Object)this.raven, value);
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block2;
                LOG.warn("[RavenEntity] LureFollowTame.setPrivateInt({}) failed: {}", (Object)fieldName, (Object)t.toString());
            }
        }
    }

    private int getPrivateInt(String fieldName, int fallback) {
        try {
            Field f = RavenEntity.class.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.getInt((Object)this.raven);
        }
        catch (Throwable t) {
            if (this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] LureFollowTame.getPrivateInt({}) failed: {}", (Object)fieldName, (Object)t.toString());
            }
            return fallback;
        }
    }

    private int getPrivateStaticInt(String fieldName, int fallback) {
        try {
            Field f = RavenEntity.class.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.getInt(null);
        }
        catch (Throwable t) {
            if (this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] LureFollowTame.getPrivateStaticInt({}) failed: {}", (Object)fieldName, (Object)t.toString());
            }
            return fallback;
        }
    }

    private double getPrivateStaticDouble(String fieldName, double fallback) {
        try {
            Field f = RavenEntity.class.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.getDouble(null);
        }
        catch (Throwable t) {
            if (this.raven.tickCount % 80 == 0) {
                LOG.warn("[RavenEntity] LureFollowTame.getPrivateStaticDouble({}) failed: {}", (Object)fieldName, (Object)t.toString());
            }
            return fallback;
        }
    }

    private void setPrivateObject(String fieldName, Object value) {
        block2: {
            try {
                Field f = RavenEntity.class.getDeclaredField(fieldName);
                f.setAccessible(true);
                f.set((Object)this.raven, value);
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block2;
                LOG.warn("[RavenEntity] LureFollowTame.setPrivateObject({}) failed: {}", (Object)fieldName, (Object)t.toString());
            }
        }
    }

    private List<Vec3> getPathWaypoints() {
        block3: {
            try {
                Field f = RavenEntity.class.getDeclaredField("pathWaypoints");
                f.setAccessible(true);
                Object v = f.get((Object)this.raven);
                if (v instanceof List) {
                    return (List)v;
                }
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block3;
                LOG.warn("[RavenEntity] LureFollowTame.getPathWaypoints failed: {}", (Object)t.toString());
            }
        }
        return null;
    }

    private Vec3 getFlyTargetField() {
        block3: {
            try {
                Field f = RavenEntity.class.getDeclaredField("flyTarget");
                f.setAccessible(true);
                Object v = f.get((Object)this.raven);
                if (v instanceof Vec3) {
                    return (Vec3)v;
                }
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block3;
                LOG.warn("[RavenEntity] LureFollowTame.getFlyTargetField failed: {}", (Object)t.toString());
            }
        }
        return null;
    }

    private int getStuckTicksThreshold() {
        return this.getPrivateStaticInt("STUCK_TICKS_THRESHOLD", 40);
    }

    private double getFlySpeedBase() {
        return this.getPrivateStaticDouble("FLY_SPEED_BASE", 0.25);
    }

    private void invokeResetLandingState(String reason) {
        block2: {
            try {
                Method m = RavenEntity.class.getDeclaredMethod("resetLandingState", String.class);
                m.setAccessible(true);
                m.invoke((Object)this.raven, reason);
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block2;
                LOG.warn("[RavenEntity] LureFollowTame.invokeResetLandingState failed: {}", (Object)t.toString());
            }
        }
    }

    private void invokeClearPlannedPath(String reason) {
        block2: {
            try {
                Method m = RavenEntity.class.getDeclaredMethod("clearPlannedPath", String.class);
                m.setAccessible(true);
                m.invoke((Object)this.raven, reason);
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block2;
                LOG.warn("[RavenEntity] LureFollowTame.invokeClearPlannedPath failed: {}", (Object)t.toString());
            }
        }
    }

    private void invokeClearFlyTarget() {
        block2: {
            try {
                Method m = RavenEntity.class.getDeclaredMethod("clearFlyTarget", new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)this.raven, new Object[0]);
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block2;
                LOG.warn("[RavenEntity] LureFollowTame.invokeClearFlyTarget failed: {}", (Object)t.toString());
            }
        }
    }

    private int invokeClampYToHomeBounds(int y) {
        block3: {
            try {
                Method m = RavenEntity.class.getDeclaredMethod("clampYToHomeBounds", Integer.TYPE);
                m.setAccessible(true);
                Object res = m.invoke((Object)this.raven, y);
                if (res instanceof Integer) {
                    return (Integer)res;
                }
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block3;
                LOG.warn("[RavenEntity] LureFollowTame.invokeClampYToHomeBounds failed: {}", (Object)t.toString());
            }
        }
        return y;
    }

    private Vec3 invokeClampTargetToHomeBounds(Vec3 in) {
        block3: {
            try {
                Method m = RavenEntity.class.getDeclaredMethod("clampTargetToHomeBounds", Vec3.class);
                m.setAccessible(true);
                Object res = m.invoke((Object)this.raven, in);
                if (res instanceof Vec3) {
                    return (Vec3)res;
                }
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block3;
                LOG.warn("[RavenEntity] LureFollowTame.invokeClampTargetToHomeBounds failed: {}", (Object)t.toString());
            }
        }
        return in;
    }

    private Vec3 invokeComputeSafePathingGoal(Vec3 rawGoal, RavenAStarPathing.Config cfg) {
        block3: {
            try {
                Method m = RavenEntity.class.getDeclaredMethod("computeSafePathingGoal", Vec3.class, RavenAStarPathing.Config.class);
                m.setAccessible(true);
                Object res = m.invoke((Object)this.raven, rawGoal, cfg);
                if (res instanceof Vec3) {
                    return (Vec3)res;
                }
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block3;
                LOG.warn("[RavenEntity] LureFollowTame.invokeComputeSafePathingGoal failed: {}", (Object)t.toString());
            }
        }
        return rawGoal;
    }

    private boolean invokeEnsurePathToWithFlags(Vec3 goal, boolean allowLeaves, int ttlTicks, long seed, String reason) {
        block3: {
            try {
                Method m = RavenEntity.class.getDeclaredMethod("ensurePathTo", Vec3.class, Boolean.TYPE, Integer.TYPE, Long.TYPE, String.class);
                m.setAccessible(true);
                Object res = m.invoke((Object)this.raven, goal, allowLeaves, ttlTicks, seed, reason);
                if (res instanceof Boolean) {
                    return (Boolean)res;
                }
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block3;
                LOG.warn("[RavenEntity] LureFollowTame.invokeEnsurePathToWithFlags failed: {}", (Object)t.toString());
            }
        }
        return false;
    }

    private boolean invokeEnsurePathTo(Vec3 goal, int ttlTicks, long seed, String reason) {
        block3: {
            try {
                Method m = RavenEntity.class.getDeclaredMethod("ensurePathTo", Vec3.class, Integer.TYPE, Long.TYPE, String.class);
                m.setAccessible(true);
                Object res = m.invoke((Object)this.raven, goal, ttlTicks, seed, reason);
                if (res instanceof Boolean) {
                    return (Boolean)res;
                }
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block3;
                LOG.warn("[RavenEntity] LureFollowTame.invokeEnsurePathTo failed: {}", (Object)t.toString());
            }
        }
        return false;
    }

    private boolean invokeIsOutOfHomeBounds(Vec3 pos) {
        block3: {
            try {
                Method m = RavenEntity.class.getDeclaredMethod("isOutOfHomeBounds", Vec3.class);
                m.setAccessible(true);
                Object res = m.invoke((Object)this.raven, pos);
                if (res instanceof Boolean) {
                    return (Boolean)res;
                }
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block3;
                LOG.warn("[RavenEntity] LureFollowTame.invokeIsOutOfHomeBounds failed: {}", (Object)t.toString());
            }
        }
        return false;
    }

    private Vec3 invokeHomeCenterReturnTarget() {
        block3: {
            try {
                Method m = RavenEntity.class.getDeclaredMethod("homeCenterReturnTarget", new Class[0]);
                m.setAccessible(true);
                Object res = m.invoke((Object)this.raven, new Object[0]);
                if (res instanceof Vec3) {
                    return (Vec3)res;
                }
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block3;
                LOG.warn("[RavenEntity] LureFollowTame.invokeHomeCenterReturnTarget failed: {}", (Object)t.toString());
            }
        }
        return this.raven.position();
    }

    private void invokeSetFlyTarget(Vec3 target, int ttlTicks) {
        block2: {
            try {
                Method m = RavenEntity.class.getDeclaredMethod("setFlyTarget", Vec3.class, Integer.TYPE);
                m.setAccessible(true);
                m.invoke((Object)this.raven, target, ttlTicks);
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block2;
                LOG.warn("[RavenEntity] LureFollowTame.invokeSetFlyTarget failed: {}", (Object)t.toString());
            }
        }
    }

    private void invokeMaybeAvoidOrRetargetDuringFlight(RandomSource rnd) {
        block2: {
            try {
                Method m = RavenEntity.class.getDeclaredMethod("maybeAvoidOrRetargetDuringFlight", RandomSource.class);
                m.setAccessible(true);
                m.invoke((Object)this.raven, rnd);
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block2;
                LOG.warn("[RavenEntity] LureFollowTame.invokeMaybeAvoidOrRetargetDuringFlight failed: {}", (Object)t.toString());
            }
        }
    }

    private void invokeFlyTowardTarget(double speed) {
        block2: {
            try {
                Method m = RavenEntity.class.getDeclaredMethod("flyTowardTarget", Double.TYPE);
                m.setAccessible(true);
                m.invoke((Object)this.raven, speed);
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block2;
                LOG.warn("[RavenEntity] LureFollowTame.invokeFlyTowardTarget failed: {}", (Object)t.toString());
            }
        }
    }

    private void invokeAdvanceWaypointIfNeeded(int ttlTicks, String debugTag) {
        block2: {
            try {
                Method m = RavenEntity.class.getDeclaredMethod("advanceWaypointIfNeeded", Integer.TYPE, String.class);
                m.setAccessible(true);
                m.invoke((Object)this.raven, ttlTicks, debugTag);
            }
            catch (Throwable t) {
                if (this.raven.tickCount % 80 != 0) break block2;
                LOG.warn("[RavenEntity] LureFollowTame.invokeAdvanceWaypointIfNeeded failed: {}", (Object)t.toString());
            }
        }
    }
}

