/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.entity.raven.modules;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.z2six.featheredfriend.entity.raven.RavenAIState;
import net.z2six.featheredfriend.entity.raven.RavenAnimMode;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import net.z2six.featheredfriend.entity.raven.modules.PlayerAvoidance;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class Landing {
    private static final Logger LOG = LogUtils.getLogger();
    private final RavenEntity raven;
    private static final int PERCH_FOOTPRINT_SIZE = 2;
    private static final int PERCH_STEP_DOWN_MAX = 1;
    private static final double PERCH_CENTER_EPS = 0.55;
    @Nullable
    public BlockPos landingLeafPos = null;
    @Nullable
    public BlockPos idlePerchCorner = null;
    private static final int LAND_SEARCH_RADIUS = 18;
    private static final int LAND_SEARCH_ATTEMPTS = 60;
    private static final int LAND_SCAN_DOWN = 32;
    public static final int LAND_REQUIRED_AIR_ABOVE = 10;
    public static final int CANOPY_NEIGHBOR_LEAVES_REQUIRED = 5;
    public static final int LANDING_MAX_TOTAL_TICKS = 160;
    private static final double OVERHEAD_Y_OFFSET_FROM_LEAF = 2.25;
    private static final double DESCEND_SPEED_Y = -0.06;
    private static final double DESCEND_SPEED_Y_MIN = -0.12;
    private static final double DESCEND_SPEED_Y_MAX_UP = 0.04;
    private static final double DESCEND_CENTER_SPEED = 0.1;
    private static final double DESCEND_CENTER_MAX = 0.12;
    private static final double OVERHEAD_HORIZONTAL_EPS = 0.55;
    private static final double OVERHEAD_VERTICAL_EPS = 0.75;
    private static final double DROP_START_ABOVE_LEAF_TOP_Y = 1.15;
    private static final double DROP_CENTER_EPS = 0.32;
    private static final double DROP_NUDGE_Y = -0.18;

    public Landing(RavenEntity raven) {
        this.raven = raven;
    }

    @Nullable
    private static Field findField(Class<?> clazz, String fieldName) {
        try {
            for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                try {
                    return c.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
            return null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Nullable
    private static Object getFieldValueSafe(Object target, String fieldName) {
        try {
            if (target == null || fieldName == null) {
                return null;
            }
            Field f = Landing.findField(target.getClass(), fieldName);
            if (f == null) {
                return null;
            }
            f.setAccessible(true);
            return f.get(target);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static boolean setFieldValueSafe(Object target, String fieldName, @Nullable Object value) {
        try {
            if (target == null || fieldName == null) {
                return false;
            }
            Field f = Landing.findField(target.getClass(), fieldName);
            if (f == null) {
                return false;
            }
            f.setAccessible(true);
            f.set(target, value);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static int getIntFieldSafe(Object target, String fieldName, int fallback) {
        try {
            Object v = Landing.getFieldValueSafe(target, fieldName);
            if (v instanceof Integer) {
                Integer i = (Integer)v;
                return i;
            }
            return fallback;
        }
        catch (Throwable t) {
            return fallback;
        }
    }

    private static void setIntFieldSafe(Object target, String fieldName, int value) {
        try {
            if (target == null || fieldName == null) {
                return;
            }
            Field f = Landing.findField(target.getClass(), fieldName);
            if (f == null) {
                return;
            }
            f.setAccessible(true);
            f.setInt(target, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean invokeVoidMethodSafe(Object target, String methodName, Class<?>[] paramTypes, Object[] args) {
        try {
            if (target == null || methodName == null) {
                return false;
            }
            Method m = null;
            Class<?> c = target.getClass();
            while (c != null && m == null) {
                try {
                    m = c.getDeclaredMethod(methodName, paramTypes);
                }
                catch (NoSuchMethodException ignored) {
                    c = c.getSuperclass();
                }
            }
            if (m == null) {
                return false;
            }
            m.setAccessible(true);
            m.invoke(target, args);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static double horizontalDistanceTo(Vec3 a, Vec3 b) {
        if (a == null || b == null) {
            return Double.MAX_VALUE;
        }
        double dx = a.x - b.x;
        double dz = a.z - b.z;
        return Math.sqrt(dx * dx + dz * dz);
    }

    private static Phase getPhaseFromRaven(RavenEntity ravenEntity) {
        try {
            Object v = Landing.getFieldValueSafe((Object)ravenEntity, "landingPhase");
            if (v instanceof Enum) {
                Enum e = (Enum)v;
                try {
                    return Phase.valueOf(e.name());
                }
                catch (IllegalArgumentException ignored) {
                    return Phase.NONE;
                }
            }
            if (v != null) {
                try {
                    return Phase.valueOf(String.valueOf(v));
                }
                catch (IllegalArgumentException ignored) {
                    return Phase.NONE;
                }
            }
            return Phase.NONE;
        }
        catch (Throwable ignored) {
            return Phase.NONE;
        }
    }

    private static void setPhaseOnRaven(RavenEntity ravenEntity, Phase phase) {
        try {
            Enum enumVal;
            if (ravenEntity == null || phase == null) {
                return;
            }
            Field f = Landing.findField(((Object)((Object)ravenEntity)).getClass(), "landingPhase");
            if (f == null) {
                return;
            }
            f.setAccessible(true);
            Class<?> t = f.getType();
            if (!t.isEnum()) {
                return;
            }
            Class<Enum> enumClass = t.asSubclass(Enum.class);
            try {
                enumVal = Enum.valueOf(enumClass, phase.name());
            }
            catch (IllegalArgumentException ex) {
                return;
            }
            f.set((Object)ravenEntity, enumVal);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int getLandingTicksFromRaven(RavenEntity ravenEntity) {
        return Landing.getIntFieldSafe((Object)ravenEntity, "landingTicks", 0);
    }

    private static void setLandingTicksOnRaven(RavenEntity ravenEntity, int value) {
        Landing.setIntFieldSafe((Object)ravenEntity, "landingTicks", value);
    }

    @Nullable
    public BlockPos getLandingLeafPos() {
        return this.landingLeafPos;
    }

    public void setLandingLeafPos(@Nullable BlockPos pos) {
        this.landingLeafPos = pos;
    }

    @Nullable
    public BlockPos getIdlePerchCorner() {
        return this.idlePerchCorner;
    }

    public void setIdlePerchCorner(@Nullable BlockPos pos) {
        this.idlePerchCorner = pos;
    }

    public boolean isLandingActive(RavenEntity ravenEntity) {
        return Landing.getPhaseFromRaven(ravenEntity) != Phase.NONE;
    }

    @Nullable
    public BlockPos findBestPerchCornerForLanding(@Nullable BlockPos landingLeaf, BlockPos feetBlock, RavenEntity ravenEntity) {
        try {
            BlockPos best = null;
            double bestD2 = Double.MAX_VALUE;
            BlockPos[] seeds = landingLeaf != null ? new BlockPos[]{landingLeaf, feetBlock} : new BlockPos[]{feetBlock};
            for (BlockPos seed : seeds) {
                BlockPos[] corners;
                for (BlockPos c : corners = new BlockPos[]{seed, seed.west(), seed.north(), seed.west().north()}) {
                    double dz;
                    if (!this.isValidPerchCornerAtTopY(c, ravenEntity)) continue;
                    Vec3 center = this.perchCenterTop(c, ravenEntity);
                    double dx = ravenEntity.getX() - center.x;
                    double d2 = dx * dx + (dz = ravenEntity.getZ() - center.z) * dz;
                    if (!(d2 < bestD2)) continue;
                    bestD2 = d2;
                    best = c;
                }
            }
            return best;
        }
        catch (Throwable t) {
            if (ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Landing] findBestPerchCornerForLanding failed safely: {}", (Object)t.toString());
            }
            return null;
        }
    }

    public boolean isOnValidPerchNowRelaxedForLanding(String debugTag, RavenEntity ravenEntity) {
        block23: {
            try {
                if (ravenEntity.isPlayerAvoidanceOverrideActive()) {
                    if (ravenEntity.tickCount % 40 == 0) {
                        LOG.debug("[Landing] {}: skipping relaxed perch check due to player avoidance override. pos={} aiState={}", new Object[]{debugTag, ravenEntity.position(), ravenEntity.getAIState()});
                    }
                    return false;
                }
            }
            catch (Throwable t) {
                if (ravenEntity.tickCount % 80 != 0) break block23;
                LOG.warn("[Landing] {}: avoidance gate failed safely in isOnValidPerchNowRelaxedForLanding: {}", (Object)debugTag, (Object)t.toString());
            }
        }
        try {
            boolean ok;
            boolean canForceCommit;
            double relaxedEps;
            BlockPos bestCorner;
            Phase phase = Landing.getPhaseFromRaven(ravenEntity);
            int landingTicks = Landing.getLandingTicksFromRaven(ravenEntity);
            if (ravenEntity.isNoGravity()) {
                return false;
            }
            if (ravenEntity.getBoundingBox() == null) {
                return false;
            }
            boolean inDrop = phase == Phase.DROP;
            BlockPos feetBlock = BlockPos.containing((double)ravenEntity.getX(), (double)(ravenEntity.getBoundingBox().minY - 0.001), (double)ravenEntity.getZ());
            try {
                bestCorner = this.findBestPerchCornerForLanding(this.landingLeafPos, feetBlock, ravenEntity);
            }
            catch (Throwable t) {
                bestCorner = null;
            }
            if (bestCorner == null) {
                bestCorner = this.findValidPerchCornerNearXZ(feetBlock.getX(), feetBlock.getZ(), ravenEntity);
            }
            if (bestCorner == null) {
                if (ravenEntity.tickCount % 40 == 0) {
                    LOG.info("[Landing] {}: relaxedPerch=false (no corner) pos={} feetBlock={} onGround={} vColl={} phase={} landingTicks={}", new Object[]{debugTag, ravenEntity.position(), feetBlock, ravenEntity.onGround(), ravenEntity.verticalCollision, phase, landingTicks});
                }
                return false;
            }
            if (!this.isValidPerchCornerAtTopY(bestCorner, ravenEntity)) {
                if (ravenEntity.tickCount % 40 == 0) {
                    LOG.info("[Landing] {}: relaxedPerch=false (corner invalid) pos={} corner={} phase={} landingTicks={}", new Object[]{debugTag, ravenEntity.position(), bestCorner, phase, landingTicks});
                }
                return false;
            }
            Vec3 center = this.perchCenterTop(bestCorner, ravenEntity);
            Vec3 pos = ravenEntity.position();
            double dx = pos.x - center.x;
            double dz = pos.z - center.z;
            double dXZ = Math.sqrt(dx * dx + dz * dz);
            boolean withinRelaxed = dXZ <= (relaxedEps = Math.max(0.55, 0.35));
            boolean bl = canForceCommit = inDrop && (ravenEntity.onGround() || ravenEntity.verticalCollision) && landingTicks >= 20;
            if (!withinRelaxed && canForceCommit) {
                boolean movingSlowEnough;
                double maxSnapRadius = 1.8;
                Vec3 vel = ravenEntity.getDeltaMovement();
                double speedSqr = vel.lengthSqr();
                boolean bl2 = movingSlowEnough = speedSqr <= 0.08;
                if (dXZ <= 1.8 && movingSlowEnough) {
                    double snapX = center.x;
                    double snapZ = center.z;
                    double keepY = ravenEntity.getY();
                    ravenEntity.setPos(snapX, keepY, snapZ);
                    ravenEntity.hurtMarked = true;
                    this.landingLeafPos = bestCorner;
                    if (ravenEntity.tickCount % 20 == 0) {
                        LOG.info("[Landing] {}: DROP-COMMIT SNAP applied dXZ={} -> 0.0 corner={} center={} posNow={} vel={} landingTicks={}", new Object[]{debugTag, String.format("%.3f", dXZ), bestCorner, center, ravenEntity.position(), vel, landingTicks});
                    }
                    return true;
                }
                if (ravenEntity.tickCount % 20 == 0) {
                    LOG.info("[Landing] {}: DROP force-commit skipped dXZ={} maxSnap={} movingSlow={} vel={} corner={} center={} landingTicks={}", new Object[]{debugTag, String.format("%.3f", dXZ), String.format("%.3f", 1.8), movingSlowEnough, vel, bestCorner, center, landingTicks});
                }
            }
            if (!(ok = withinRelaxed) && ravenEntity.tickCount % 20 == 0) {
                LOG.info("[Landing] {}: relaxedPerch=false dXZ={} eps={} pos={} center={} corner={} onGround={} vColl={} vel={} phase={} landingTicks={}", new Object[]{debugTag, String.format("%.3f", dXZ), String.format("%.3f", relaxedEps), pos, center, bestCorner, ravenEntity.onGround(), ravenEntity.verticalCollision, ravenEntity.getDeltaMovement(), phase, landingTicks});
            } else if (ok && ravenEntity.tickCount % 20 == 0) {
                LOG.info("[Landing] {}: relaxedPerch=true dXZ={} eps={} pos={} center={} corner={} (will enter idle + snap)", new Object[]{debugTag, String.format("%.3f", dXZ), String.format("%.3f", relaxedEps), pos, center, bestCorner});
            }
            return ok;
        }
        catch (Throwable t) {
            if (ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Landing] isOnValidPerchNowRelaxedForLanding failed safely: {}", (Object)t.toString());
            }
            return false;
        }
    }

    private boolean isPerchFootprintStillSupported(BlockPos cornerTop, RavenEntity ravenEntity) {
        try {
            if (cornerTop == null) {
                return false;
            }
            int cx = cornerTop.getX();
            int cz = cornerTop.getZ();
            int topY = cornerTop.getY();
            boolean anyAtTop = false;
            for (int ox = 0; ox < 2; ++ox) {
                for (int oz = 0; oz < 2; ++oz) {
                    int x = cx + ox;
                    int z = cz + oz;
                    boolean atTop = this.isLeavesAt(x, topY, z, ravenEntity);
                    boolean atStep = this.isLeavesAt(x, topY - 1, z, ravenEntity);
                    if (!atTop && !atStep) {
                        return false;
                    }
                    if (!atTop) continue;
                    anyAtTop = true;
                }
            }
            return anyAtTop;
        }
        catch (Throwable t) {
            if (ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Landing] isPerchFootprintStillSupported failed safely: {}", (Object)t.toString());
            }
            return false;
        }
    }

    public PerchValidity validatePerchCornerAtTopY(BlockPos cornerTop, RavenEntity ravenEntity) {
        try {
            int oz;
            int ox;
            if (cornerTop == null) {
                return PerchValidity.fail("cornerTop=null", "");
            }
            int cx = cornerTop.getX();
            int cz = cornerTop.getZ();
            int topY = cornerTop.getY();
            boolean anyAtTop = false;
            for (ox = 0; ox < 2; ++ox) {
                for (oz = 0; oz < 2; ++oz) {
                    int x = cx + ox;
                    int z = cz + oz;
                    boolean atTop = this.isLeavesAt(x, topY, z, ravenEntity);
                    boolean atStep = this.isLeavesAt(x, topY - 1, z, ravenEntity);
                    if (!atTop && !atStep) {
                        return PerchValidity.fail("footprint_missing_leaves", "cell=(" + x + "," + topY + "," + z + ") top=" + atTop + " step=" + atStep);
                    }
                    if (!atTop) continue;
                    anyAtTop = true;
                }
            }
            if (!anyAtTop) {
                return PerchValidity.fail("footprint_no_top_layer", "topY=" + topY + " (all 4 cells only at topY-1)");
            }
            for (ox = 0; ox < 2; ++ox) {
                for (oz = 0; oz < 2; ++oz) {
                    BlockPos start = new BlockPos(cx + ox, topY + 1, cz + oz);
                    if (this.hasAirColumn(start, 10, ravenEntity)) continue;
                    int blockedAtY = Integer.MIN_VALUE;
                    BlockPos blockedPos = null;
                    for (int i = 0; i < 10; ++i) {
                        BlockPos p = start.above(i);
                        if (ravenEntity.level().isEmptyBlock(p)) continue;
                        blockedAtY = p.getY();
                        blockedPos = p;
                        break;
                    }
                    Object extra = "";
                    if (blockedPos != null) {
                        BlockState st = ravenEntity.level().getBlockState(blockedPos);
                        extra = " blockedPos=" + String.valueOf(blockedPos) + " block=" + (st == null ? "null" : st.getBlock().toString());
                    }
                    return PerchValidity.fail("air_column_blocked", "col=(" + (cx + ox) + "," + (cz + oz) + ") startY=" + (topY + 1) + " need=10 firstBlockedY=" + String.valueOf(blockedAtY == Integer.MIN_VALUE ? "?" : Integer.valueOf(blockedAtY)) + (String)extra);
                }
            }
            int neighbors = 0;
            for (int ox2 = -1; ox2 <= 2; ++ox2) {
                for (int oz2 = -1; oz2 <= 2; ++oz2) {
                    BlockState st;
                    if (ox2 >= 0 && ox2 <= 1 && oz2 >= 0 && oz2 <= 1 || (st = ravenEntity.level().getBlockState(new BlockPos(cx + ox2, topY, cz + oz2))) == null || !st.is(BlockTags.LEAVES)) continue;
                    ++neighbors;
                }
            }
            int requiredNeighbors = Math.max(2, 3);
            if (neighbors < requiredNeighbors) {
                return PerchValidity.fail("canopy_neighbors_low", "neighbors=" + neighbors + " required=" + requiredNeighbors + " topY=" + topY + " corner=(" + cx + "," + cz + ")");
            }
            return PerchValidity.ok();
        }
        catch (Throwable t) {
            return PerchValidity.fail("exception", t.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void tickLandingStateMachine(RandomSource rnd, RavenEntity ravenEntity) {
        block70: {
            block69: {
                try {
                    if (PlayerAvoidance.shouldBlockLanding(ravenEntity)) {
                        phaseNow = Landing.getPhaseFromRaven(ravenEntity);
                        landingTicksNow = Landing.getLandingTicksFromRaven(ravenEntity);
                        if ((phaseNow != Phase.NONE || this.landingLeafPos != null || landingTicksNow != 0) && ravenEntity.tickCount % 20 == 0) {
                            Landing.LOG.info("[Landing] skipping landing due to player avoidance; clearing landing state. phase={} pos={} leafPos={} idlePerchCorner={} landingTicks={}", new Object[]{phaseNow, ravenEntity.position(), this.landingLeafPos, this.idlePerchCorner, landingTicksNow});
                        }
                        this.resetLandingState("player avoidance (global block)", ravenEntity);
                        return;
                    }
                }
                catch (Throwable t) {
                    if (ravenEntity.tickCount % 40 != 0) break block69;
                    Landing.LOG.warn("[Landing] tickLandingStateMachine avoidance gate failed safely: {}", (Object)t.toString());
                }
            }
            phase = Landing.getPhaseFromRaven(ravenEntity);
            landingTicks = Landing.getLandingTicksFromRaven(ravenEntity);
            try {
                if (ravenEntity.tickCount % 40 == 0) {
                    Landing.LOG.info("[Landing] HEARTBEAT: phase={} ai={} pos={} vel={} leafPos={} idlePerchCorner={} landingTicks={}", new Object[]{phase, ravenEntity.getAIState(), ravenEntity.position(), ravenEntity.getDeltaMovement(), this.landingLeafPos, this.idlePerchCorner, landingTicks});
                }
            }
            catch (Throwable var5_8) {
                // empty catch block
            }
            try {
                allowPerchShortcutNow = false;
                if (phase == Phase.DROP) {
                    allowPerchShortcutNow = true;
                } else {
                    try {
                        allowPerchShortcutNow = ravenEntity.isNoGravity() == false;
                    }
                    catch (Throwable t) {
                        allowPerchShortcutNow = false;
                    }
                }
                if (allowPerchShortcutNow && this.isOnValidPerchNow(ravenEntity)) {
                    if (ravenEntity.tickCount % 20 == 0) {
                        Landing.LOG.debug("[Landing] Landing shortcut -> IDLE allowed (phase={} noGravity={} pos={} vel={} leafPos={})", new Object[]{phase, ravenEntity.isNoGravity(), ravenEntity.position(), ravenEntity.getDeltaMovement(), this.landingLeafPos});
                    }
                    this.enterIdleFromLanding("Landing: perched (phase=" + String.valueOf((Object)phase) + ")", ravenEntity);
                    return;
                }
            }
            catch (Throwable t) {
                if (ravenEntity.tickCount % 40 != 0) break block70;
                Landing.LOG.warn("[Landing] tickLandingStateMachine perch-shortcut gate failed safely: {}", (Object)t.toString());
            }
        }
        switch (phase.ordinal()) {
            case 0: {
                this.resetLandingState("tickLandingStateMachine called with NONE", ravenEntity);
                Landing.invokeVoidMethodSafe((Object)ravenEntity, "clearPlannedPath", new Class[]{String.class}, new Object[]{"landing NONE"});
                break;
            }
            case 1: {
                ravenEntity.setNoGravity(true);
                if (ravenEntity.getAnimMode() != RavenAnimMode.IN_AIR) {
                    ravenEntity.setAnimMode(RavenAnimMode.IN_AIR);
                }
                if (this.landingLeafPos == null) {
                    this.resetLandingState("FLY_TO_OVERHEAD missing leaf", ravenEntity);
                    Landing.invokeVoidMethodSafe((Object)ravenEntity, "clearPlannedPath", new Class[]{String.class}, new Object[]{"FLY_TO_OVERHEAD missing leaf"});
                    return;
                }
                overhead = this.overheadTargetForLeaf(this.landingLeafPos, ravenEntity);
                try {
                    ravenEntity.landingTickFlyTargetTimeout("Landing FLY_TO_OVERHEAD");
                }
                catch (Throwable t) {
                    if (ravenEntity.tickCount % 80 != 0) ** GOTO lbl64
                    Landing.LOG.warn("[Landing] landingTickFlyTargetTimeout failed safely: {}", (Object)t.toString());
                }
lbl64:
                // 3 sources

                hasFlyIntent = false;
                hasPathIntent = false;
                try {
                    ft = Landing.getFieldValueSafe((Object)ravenEntity, "flyTarget");
                    ftt = Landing.getFieldValueSafe((Object)ravenEntity, "flyTargetTimeoutTicks");
                    if (ft instanceof Vec3 && ftt instanceof Integer) {
                        hasFlyIntent = ft != null && (Integer)ftt > 0;
                    } else if (ft instanceof Vec3) {
                        hasFlyIntent = true;
                    }
                }
                catch (Throwable ignored) {
                    hasFlyIntent = false;
                }
                try {
                    wp = Landing.getFieldValueSafe((Object)ravenEntity, "pathWaypoints");
                    wpi = Landing.getFieldValueSafe((Object)ravenEntity, "pathWaypointIndex");
                    if (wp instanceof List) {
                        list = (List)wp;
                        idx = wpi instanceof Integer != false ? (Integer)wpi : 0;
                        hasPathIntent = list.isEmpty() == false && idx < list.size();
                    }
                }
                catch (Throwable ignored) {
                    hasPathIntent = false;
                }
                pos = ravenEntity.position();
                horizNow = Landing.horizontalDistanceTo(pos, overhead);
                vertNow = Math.abs(pos.y - overhead.y);
                if (horizNow <= 0.55 && vertNow <= 0.75) {
                    Landing.setPhaseOnRaven(ravenEntity, Phase.DESCEND_SLOW);
                    Landing.invokeVoidMethodSafe((Object)ravenEntity, "clearFlyTarget", new Class[0], new Object[0]);
                    Landing.invokeVoidMethodSafe((Object)ravenEntity, "clearPlannedPath", new Class[]{String.class}, new Object[]{"overhead reached -> descent"});
                    if (ravenEntity.tickCount % 20 == 0) {
                        Landing.LOG.info("[Landing] Overhead reached -> DESCEND_SLOW (leaf={} pos={} horiz={} vert={})", new Object[]{this.landingLeafPos, pos, String.format("%.3f", new Object[]{horizNow}), String.format("%.3f", new Object[]{vertNow})});
                    }
                    return;
                }
                if (hasFlyIntent || hasPathIntent) ** GOTO lbl118
                seed = ravenEntity.getUUID().getLeastSignificantBits() ^ (long)ravenEntity.tickCount ^ this.landingLeafPos.asLong();
                ok = false;
                try {
                    ok = ravenEntity.landingEnsurePathTo(overhead, 120, seed, "FLY_TO_OVERHEAD");
                }
                catch (Throwable t) {
                    ok = false;
                    if (ravenEntity.tickCount % 40 != 0) ** GOTO lbl109
                    Landing.LOG.warn("[Landing] ensurePathTo failed safely (will fallback to setFlyTarget): {}", (Object)t.toString());
                }
lbl109:
                // 3 sources

                if (ok) ** GOTO lbl116
                try {
                    ravenEntity.landingSetFlyTarget(overhead, 120);
                }
                catch (Throwable t) {
                    if (ravenEntity.tickCount % 40 != 0) ** GOTO lbl116
                    Landing.LOG.warn("[Landing] setFlyTarget fallback failed safely: {}", (Object)t.toString());
                }
lbl116:
                // 4 sources

                if (ravenEntity.tickCount % 20 == 0) {
                    Landing.LOG.info("[Landing] FLY_TO_OVERHEAD acquire intent: pathOk={} overhead={} pos={} vel={}", new Object[]{ok, overhead, pos, ravenEntity.getDeltaMovement()});
                }
lbl118:
                // 4 sources

                try {
                    ravenEntity.landingMaybeAvoidOrRetargetDuringFlightApproachOnly(rnd);
                }
                catch (Throwable t) {
                    if (ravenEntity.tickCount % 80 != 0) ** GOTO lbl124
                    Landing.LOG.warn("[Landing] maybeAvoidOrRetargetDuringFlightApproachOnly failed safely: {}", (Object)t.toString());
                }
lbl124:
                // 3 sources

                try {
                    ravenEntity.landingFlyTowardTarget(0.25);
                }
                catch (Throwable t) {
                    if (ravenEntity.tickCount % 80 != 0) ** GOTO lbl130
                    Landing.LOG.warn("[Landing] flyTowardTarget failed safely: {}", (Object)t.toString());
                }
lbl130:
                // 3 sources

                try {
                    ravenEntity.landingAdvanceWaypointIfNeeded(120, "FLY_TO_OVERHEAD");
                }
                catch (Throwable t) {
                    if (ravenEntity.tickCount % 80 != 0) ** GOTO lbl136
                    Landing.LOG.warn("[Landing] advanceWaypointIfNeeded failed safely: {}", (Object)t.toString());
                }
lbl136:
                // 3 sources

                if (ravenEntity.tickCount % 40 != 0) break;
                Landing.LOG.info("[Landing] FLY_TO_OVERHEAD tick: pos={} vel={} overhead={} horiz={} vert={} hasFlyIntent={} hasPathIntent={} leaf={} landingTicks={}", new Object[]{ravenEntity.position(), ravenEntity.getDeltaMovement(), overhead, String.format("%.3f", new Object[]{horizNow}), String.format("%.3f", new Object[]{vertNow}), hasFlyIntent, hasPathIntent, this.landingLeafPos, landingTicks});
                break;
            }
            case 2: {
                if (this.landingLeafPos == null) {
                    this.resetLandingState("DESCEND_SLOW missing leaf", ravenEntity);
                    Landing.invokeVoidMethodSafe((Object)ravenEntity, "clearPlannedPath", new Class[]{String.class}, new Object[]{"DESCEND_SLOW missing leaf"});
                    return;
                }
                ravenEntity.setNoGravity(true);
                if (ravenEntity.getAnimMode() != RavenAnimMode.IN_AIR) {
                    ravenEntity.setAnimMode(RavenAnimMode.IN_AIR);
                }
                pos = ravenEntity.position();
                leafCenter = this.leafCenterTop(this.landingLeafPos, ravenEntity);
                toCenter = new Vec3(leafCenter.x - pos.x, 0.0, leafCenter.z - pos.z);
                d2 = toCenter.length();
                horizVel = Vec3.ZERO;
                if (d2 > 1.0E-4) {
                    dir = toCenter.scale(1.0 / d2);
                    sp = Mth.clamp((double)0.1, (double)0.0, (double)0.12);
                    horizVel = new Vec3(dir.x * sp, 0.0, dir.z * sp);
                }
                if ((vy = ravenEntity.getDeltaMovement().y) > 0.04) {
                    vy = 0.04;
                }
                if (vy > -0.06) {
                    vy = -0.06;
                }
                if (vy < -0.12) {
                    vy = -0.12;
                }
                ravenEntity.setDeltaMovement(horizVel.x, vy, horizVel.z);
                if (horizVel.lengthSqr() > 1.0E-4) {
                    yaw = (float)(Mth.atan2((double)horizVel.z, (double)horizVel.x) * 57.29577951308232) - 90.0f;
                    ravenEntity.setYRot(yaw);
                    ravenEntity.setYHeadRot(yaw);
                    ravenEntity.yBodyRot = yaw;
                }
                centerDist = Landing.horizontalDistanceTo(pos, leafCenter);
                leafTopY = (double)this.landingLeafPos.getY() + 1.0;
                aboveTop = pos.y - leafTopY;
                if (centerDist <= 0.32 && aboveTop <= 1.4) {
                    Landing.setPhaseOnRaven(ravenEntity, Phase.DROP);
                    if (ravenEntity.tickCount % 120 != 0) break;
                    Landing.LOG.debug("[Landing] DESCEND_SLOW -> DROP (leaf={}, pos={}, centerDist={}, aboveTop={})", new Object[]{this.landingLeafPos, pos, centerDist, aboveTop});
                    break;
                }
                if (ravenEntity.tickCount % 80 != 0) break;
                Landing.LOG.debug("[Landing] DESCEND_SLOW tick pos={} vel={} leaf={} centerDist={} aboveTop={}", new Object[]{pos, ravenEntity.getDeltaMovement(), this.landingLeafPos, String.format("%.3f", new Object[]{centerDist}), String.format("%.3f", new Object[]{aboveTop})});
                break;
            }
            case 3: {
                if (this.landingLeafPos == null) {
                    this.resetLandingState("DROP missing leaf", ravenEntity);
                    Landing.invokeVoidMethodSafe((Object)ravenEntity, "clearPlannedPath", new Class[]{String.class}, new Object[]{"DROP missing leaf"});
                    return;
                }
                ravenEntity.setNoGravity(false);
                if (ravenEntity.getAnimMode() != RavenAnimMode.NO_AIR) {
                    ravenEntity.setAnimMode(RavenAnimMode.NO_AIR);
                }
                vel = ravenEntity.getDeltaMovement();
                vy = vel.y;
                IDLE_SETTLE_MAX_UP = 0.04;
                IDLE_SETTLE_MIN_FALL = -0.28;
                if (vy > 0.04) {
                    vy = 0.04;
                }
                if (vy > -0.18) {
                    vy = -0.18;
                }
                if (vy < -0.28) {
                    vy = -0.28;
                }
                ravenEntity.setDeltaMovement(0.0, vy, 0.0);
                try {
                    v0 = groundedStable = ravenEntity.onGround() != false || ravenEntity.verticalCollision != false;
                    if (!groundedStable) ** GOTO lbl229
                    feetBlock = BlockPos.containing((double)ravenEntity.getX(), (double)(ravenEntity.getBoundingBox().minY - 0.001), (double)ravenEntity.getZ());
                    try {
                        bestCorner = this.findBestPerchCornerForLanding(this.landingLeafPos, feetBlock, ravenEntity);
                    }
                    catch (Throwable t) {
                        bestCorner = null;
                        if (ravenEntity.tickCount % 40 != 0) ** GOTO lbl211
                        Landing.LOG.warn("[Landing] DROP: findBestPerchCornerForLanding failed safely: {}", (Object)t.toString());
                    }
lbl211:
                    // 3 sources

                    if (bestCorner != null && this.isValidPerchCornerAtTopY(bestCorner, ravenEntity)) {
                        center = this.perchCenterTop(bestCorner, ravenEntity);
                        pos = ravenEntity.position();
                        dx = pos.x - center.x;
                        dz = pos.z - center.z;
                        dXZ = Math.sqrt(dx * dx + dz * dz);
                        DROP_SNAP_EPS = 1.6;
                        if (ravenEntity.tickCount % 20 == 0) {
                            Landing.LOG.info("[Landing] DROP: groundedStable={} bestCorner={} center={} pos={} dXZ={} eps={} landingLeafPos={} onGround={} vColl={} vel={}", new Object[]{groundedStable, bestCorner, center, pos, String.format("%.3f", new Object[]{dXZ}), String.format("%.2f", new Object[]{1.6}), this.landingLeafPos, ravenEntity.onGround(), ravenEntity.verticalCollision, ravenEntity.getDeltaMovement()});
                        }
                        if (dXZ <= 1.6) {
                            this.idlePerchCorner = bestCorner;
                            this.landingLeafPos = bestCorner;
                            this.enterIdleFromLanding("DROP: grounded stable + bestCorner within snap eps (dXZ=" + String.format("%.3f", new Object[]{dXZ}) + ")", ravenEntity);
                            return;
                        }
                    }
                }
                catch (Throwable t) {
                    if (ravenEntity.tickCount % 40 != 0) ** GOTO lbl229
                    Landing.LOG.warn("[Landing] DROP: snap-accept logic failed safely: {}", (Object)t.toString());
                }
lbl229:
                // 4 sources

                if (this.isOnValidPerchNowRelaxedForLanding("DROP", ravenEntity)) {
                    this.enterIdleFromLanding("DROP: on valid 2x2 perch (relaxed threshold, will snap)", ravenEntity);
                    return;
                }
                pos = ravenEntity.position();
                leafTopY = (double)this.landingLeafPos.getY() + 1.0;
                if (pos.y < leafTopY - 1.25) {
                    if (ravenEntity.tickCount % 80 == 0) {
                        Landing.LOG.debug("[Landing] DROP missed leaf (posY={}, leafTopY={}) -> resetting landing and reattempting", (Object)pos.y, (Object)leafTopY);
                    }
                    this.resetLandingState("drop missed", ravenEntity);
                    Landing.invokeVoidMethodSafe((Object)ravenEntity, "clearPlannedPath", new Class[]{String.class}, new Object[]{"drop missed"});
                    break;
                }
                if (ravenEntity.tickCount % 40 != 0) break;
                Landing.LOG.debug("[Landing] DROP tick pos={} vel={} leafTopY={} landingTicks={}", new Object[]{pos, ravenEntity.getDeltaMovement(), leafTopY, landingTicks});
            }
        }
    }

    public void resetLandingState(String reason, RavenEntity ravenEntity) {
        block3: {
            try {
                Phase phase = Landing.getPhaseFromRaven(ravenEntity);
                int ticks = Landing.getLandingTicksFromRaven(ravenEntity);
                if ((phase != Phase.NONE || this.landingLeafPos != null || ticks != 0) && ravenEntity.tickCount % 120 == 0) {
                    LOG.debug("[Landing] resetLandingState(reason={}) phase={} leaf={} ticks={}", new Object[]{reason, phase, this.landingLeafPos, ticks});
                }
                Landing.setPhaseOnRaven(ravenEntity, Phase.NONE);
                Landing.setLandingTicksOnRaven(ravenEntity, 0);
                this.landingLeafPos = null;
            }
            catch (Throwable t) {
                if (ravenEntity.tickCount % 80 != 0) break block3;
                LOG.warn("[Landing] resetLandingState failed safely: {}", (Object)t.toString());
            }
        }
    }

    public void enterIdleFromLanding(String reason, RavenEntity ravenEntity) {
        try {
            boolean canSnapNow;
            BlockPos committedCorner;
            Landing.invokeVoidMethodSafe((Object)ravenEntity, "clearPlannedPath", new Class[]{String.class}, new Object[]{"enter idle: " + reason});
            Landing.invokeVoidMethodSafe((Object)ravenEntity, "clearFlyTarget", new Class[0], new Object[0]);
            Landing.setFieldValueSafe((Object)ravenEntity, "flyTargetTimeoutTicks", 0);
            Landing.setFieldValueSafe((Object)ravenEntity, "avoidanceCooldownTicks", 0);
            Landing.setFieldValueSafe((Object)ravenEntity, "stuckTicks", 0);
            Landing.setFieldValueSafe((Object)ravenEntity, "lastDistToTarget", Double.NaN);
            boolean hadAnyIntent = false;
            try {
                List list;
                Object pg = Landing.getFieldValueSafe((Object)ravenEntity, "pathGoal");
                Object ppg = Landing.getFieldValueSafe((Object)ravenEntity, "pathPendingGoal");
                Object wp = Landing.getFieldValueSafe((Object)ravenEntity, "pathWaypoints");
                if (pg != null || ppg != null) {
                    hadAnyIntent = true;
                }
                if (wp instanceof List && !(list = (List)wp).isEmpty()) {
                    hadAnyIntent = true;
                }
            }
            catch (Throwable pg) {
                // empty catch block
            }
            Landing.setFieldValueSafe((Object)ravenEntity, "pathGoal", null);
            Landing.setFieldValueSafe((Object)ravenEntity, "pathPendingGoal", null);
            Landing.setFieldValueSafe((Object)ravenEntity, "pathWaypoints", null);
            Landing.setFieldValueSafe((Object)ravenEntity, "pathWaypointIndex", 0);
            Landing.setFieldValueSafe((Object)ravenEntity, "pathRetryCooldownTicks", 0);
            if (hadAnyIntent && ravenEntity.tickCount % 20 == 0) {
                LOG.info("[Landing] enterIdleFromLanding: cleared leftover path/goal intent. reason={} pos={}", (Object)reason, (Object)ravenEntity.position());
            }
            if ((committedCorner = this.landingLeafPos) == null) {
                BlockPos feetBlock = BlockPos.containing((double)ravenEntity.getX(), (double)(ravenEntity.getBoundingBox().minY - 0.001), (double)ravenEntity.getZ());
                committedCorner = this.findValidPerchCornerNearXZ(feetBlock.getX(), feetBlock.getZ(), ravenEntity);
            }
            this.resetLandingState("enter idle: " + reason, ravenEntity);
            this.idlePerchCorner = committedCorner;
            ravenEntity.setAIState(RavenAIState.IDLE_GROUND);
            Landing.setFieldValueSafe((Object)ravenEntity, "idleCommitTicks", 60);
            Landing.setFieldValueSafe((Object)ravenEntity, "idleLockTicks", 50);
            Landing.setFieldValueSafe((Object)ravenEntity, "idleLeafLossTicks", 0);
            try {
                int idleTicksRemaining;
                Object itr = Landing.getFieldValueSafe((Object)ravenEntity, "idleTicksRemaining");
                int n = idleTicksRemaining = itr instanceof Integer ? (Integer)itr : 0;
                if (idleTicksRemaining <= 0) {
                    RandomSource rnd = ravenEntity.getRandom();
                    int IDLE_MIN_TICKS = 300;
                    int IDLE_MAX_TICKS = 600;
                    int newTicks = IDLE_MIN_TICKS + rnd.nextInt(Math.max(1, IDLE_MAX_TICKS - IDLE_MIN_TICKS + 1));
                    Landing.setFieldValueSafe((Object)ravenEntity, "idleTicksRemaining", newTicks);
                    Landing.setFieldValueSafe((Object)ravenEntity, "idleTargetYaw", Float.valueOf(ravenEntity.getYRot()));
                    Landing.setFieldValueSafe((Object)ravenEntity, "idleNextTurnTicks", 10 + rnd.nextInt(50));
                }
            }
            catch (Throwable itr) {
                // empty catch block
            }
            Landing.setFieldValueSafe((Object)ravenEntity, "roamTicksRemaining", 0);
            ravenEntity.setNoGravity(false);
            ravenEntity.setAnimMode(RavenAnimMode.NO_AIR);
            double IDLE_SETTLE_NUDGE_DOWN = -0.1;
            double IDLE_SETTLE_MIN_FALL = -0.28;
            double IDLE_SETTLE_MAX_UP = 0.04;
            Vec3 vel = ravenEntity.getDeltaMovement();
            double vy = vel.y;
            if (vy > 0.04) {
                vy = 0.04;
            }
            if (vy > -0.1) {
                vy = -0.1;
            }
            if (vy < -0.28) {
                vy = -0.28;
            }
            ravenEntity.setDeltaMovement(0.0, vy, 0.0);
            try {
                boolean notFlying = !ravenEntity.isNoGravity();
                boolean lowVertical = Math.abs(ravenEntity.getDeltaMovement().y) <= 0.1;
                boolean touchingSomething = ravenEntity.onGround() || ravenEntity.verticalCollision;
                canSnapNow = notFlying && (lowVertical || touchingSomething);
            }
            catch (Throwable t) {
                canSnapNow = false;
            }
            if (canSnapNow && this.idlePerchCorner != null && this.isValidPerchCornerAtTopY(this.idlePerchCorner, ravenEntity)) {
                Vec3 centerTop = this.perchCenterTop(this.idlePerchCorner, ravenEntity);
                double snapX = centerTop.x;
                double snapZ = centerTop.z;
                double keepY = ravenEntity.getY();
                ravenEntity.setPos(snapX, keepY, snapZ);
                ravenEntity.hurtMarked = true;
                if (ravenEntity.tickCount % 40 == 0) {
                    LOG.debug("[Landing] enterIdleFromLanding: snapped to perch center. reason={} idlePerchCorner={} newPos={} vel={}", new Object[]{reason, this.idlePerchCorner, ravenEntity.position(), ravenEntity.getDeltaMovement()});
                }
            } else if (ravenEntity.tickCount % 80 == 0) {
                LOG.debug("[Landing] enterIdleFromLanding: snap skipped (canSnapNow={}). reason={} idlePerchCorner={} pos={} vel={} noGravity={} onGround={} vColl={}", new Object[]{canSnapNow, reason, this.idlePerchCorner, ravenEntity.position(), ravenEntity.getDeltaMovement(), ravenEntity.isNoGravity(), ravenEntity.onGround(), ravenEntity.verticalCollision});
            }
            if (ravenEntity.tickCount % 20 == 0) {
                Object commitTicks = Landing.getFieldValueSafe((Object)ravenEntity, "idleCommitTicks");
                LOG.info("[Landing] ENTER IDLE: reason={} pos={} idlePerchCorner={} idleTicksRemaining={} commitTicks={}", new Object[]{reason, ravenEntity.position(), this.idlePerchCorner, Landing.getFieldValueSafe((Object)ravenEntity, "idleTicksRemaining"), commitTicks});
            }
        }
        catch (Throwable t) {
            LOG.error("[Landing] enterIdleFromLanding failed (reason={})", (Object)reason, (Object)t);
        }
    }

    public boolean isStillValidLandingLeaf(BlockPos leaf, RavenEntity ravenEntity) {
        try {
            if (leaf == null) {
                return false;
            }
            return this.isValidPerchCornerAtTopY(leaf, ravenEntity);
        }
        catch (Throwable t) {
            if (ravenEntity.tickCount % 200 == 0) {
                LOG.warn("[Landing] isStillValidLandingLeaf failed: {}", (Object)t.toString());
            }
            return false;
        }
    }

    public Vec3 overheadTargetForLeaf(BlockPos leaf, RavenEntity ravenEntity) {
        Vec3 centerTop = this.perchCenterTop(leaf, ravenEntity);
        return new Vec3(centerTop.x, (double)leaf.getY() + 2.25, centerTop.z);
    }

    private Vec3 leafCenterTop(BlockPos leaf, RavenEntity ravenEntity) {
        return this.perchCenterTop(leaf, ravenEntity);
    }

    @Nullable
    public BlockPos pickLandingLeafBlock(RandomSource rnd, RavenEntity ravenEntity) {
        block13: {
            try {
                if (PlayerAvoidance.shouldBlockLanding(ravenEntity)) {
                    if (ravenEntity.tickCount % 40 == 0) {
                        LOG.debug("[Landing] pickLandingLeafBlock: aborted because player avoidance is blocking landing. pos={} aiState={}", (Object)ravenEntity.position(), (Object)ravenEntity.getAIState());
                    }
                    return null;
                }
            }
            catch (Throwable t) {
                if (ravenEntity.tickCount % 80 != 0) break block13;
                LOG.warn("[Landing] pickLandingLeafBlock: avoidance gate failed safely: {}", (Object)t.toString());
            }
        }
        try {
            int baseY;
            BlockPos homePos = null;
            try {
                Object hp = Landing.getFieldValueSafe((Object)ravenEntity, "homePos");
                if (hp instanceof BlockPos) {
                    homePos = (BlockPos)hp;
                }
            }
            catch (Throwable hp) {
                // empty catch block
            }
            if (homePos == null) {
                homePos = ravenEntity.blockPosition();
            }
            double hx = (double)homePos.getX() + 0.5;
            double hz = (double)homePos.getZ() + 0.5;
            double angle = rnd.nextDouble() * (Math.PI * 2);
            int HOME_RADIUS_BLOCKS = 50;
            try {
                Object hr = Landing.getFieldValueSafe((Object)ravenEntity, "HOME_RADIUS_BLOCKS");
                if (hr instanceof Integer) {
                    HOME_RADIUS_BLOCKS = (Integer)hr;
                }
            }
            catch (Throwable hr) {
                // empty catch block
            }
            double radius = 4.0 + rnd.nextDouble() * ((double)HOME_RADIUS_BLOCKS - 4.0);
            int cx = Mth.floor((double)(hx + Math.cos(angle) * radius));
            int cz = Mth.floor((double)(hz + Math.sin(angle) * radius));
            int clampedY = baseY = homePos.getY();
            BlockPos center = new BlockPos(cx, clampedY, cz);
            return this.pickLandingLeafBlockNear(center, rnd, ravenEntity);
        }
        catch (Throwable t) {
            LOG.error("[Landing] pickLandingLeafBlock failed", t);
            return null;
        }
    }

    @Nullable
    private BlockPos pickLandingLeafBlockNear(BlockPos center, RandomSource rnd, RavenEntity ravenEntity) {
        try {
            for (int i = 0; i < 60; ++i) {
                int topY;
                int dx = rnd.nextInt(37) - 18;
                int dz = rnd.nextInt(37) - 18;
                int x = center.getX() + dx;
                int z = center.getZ() + dz;
                try {
                    topY = ravenEntity.level().getHeight(Heightmap.Types.WORLD_SURFACE, x, z);
                }
                catch (Throwable t) {
                    continue;
                }
                int scanMinY = Math.max(ravenEntity.level().getMinBuildHeight(), topY - 32);
                for (int y = topY; y >= scanMinY; --y) {
                    BlockPos perchCorner;
                    BlockPos probe = new BlockPos(x, y, z);
                    BlockState state = ravenEntity.level().getBlockState(probe);
                    if (state == null || !state.is(BlockTags.LEAVES) || (perchCorner = this.findValidPerchCornerNearXZ(probe.getX(), probe.getZ(), ravenEntity)) == null) continue;
                    Vec3 perchCenter = this.perchCenterTop(perchCorner, ravenEntity);
                    boolean out = false;
                    try {
                        Method m = null;
                        Class<?> c = ((Object)((Object)ravenEntity)).getClass();
                        while (c != null && m == null) {
                            try {
                                m = c.getDeclaredMethod("isOutOfHomeBounds", Vec3.class);
                            }
                            catch (NoSuchMethodException ignored) {
                                c = c.getSuperclass();
                            }
                        }
                        if (m != null) {
                            m.setAccessible(true);
                            Object res = m.invoke((Object)ravenEntity, perchCenter);
                            if (res instanceof Boolean) {
                                out = (Boolean)res;
                            }
                        }
                    }
                    catch (Throwable ignored) {
                        out = false;
                    }
                    if (out || !this.isValidPerchCornerAtTopY(perchCorner, ravenEntity)) continue;
                    return perchCorner;
                }
            }
            return null;
        }
        catch (Throwable t) {
            LOG.error("[Landing] pickLandingLeafBlockNear failed", t);
            return null;
        }
    }

    private boolean isThickCanopyLeaf(BlockPos leaf, RavenEntity ravenEntity) {
        try {
            int leavesNeighbors = 0;
            for (int ox = -1; ox <= 1; ++ox) {
                for (int oz = -1; oz <= 1; ++oz) {
                    if (ox == 0 && oz == 0) continue;
                    BlockPos p = leaf.offset(ox, 0, oz);
                    BlockState st = ravenEntity.level().getBlockState(p);
                    if (st == null || !st.is(BlockTags.LEAVES)) continue;
                    ++leavesNeighbors;
                }
            }
            BlockState below = ravenEntity.level().getBlockState(leaf.below());
            boolean hasSupport = below != null && below.is(BlockTags.LEAVES);
            return leavesNeighbors >= 5 && hasSupport;
        }
        catch (Throwable t) {
            if (ravenEntity.tickCount % 200 == 0) {
                LOG.warn("[Landing] isThickCanopyLeaf failed: {}", (Object)t.toString());
            }
            return false;
        }
    }

    private boolean hasAirColumn(BlockPos start, int count, RavenEntity ravenEntity) {
        try {
            BlockPos p = start;
            for (int i = 0; i < count; ++i) {
                if (!ravenEntity.level().isEmptyBlock(p)) {
                    return false;
                }
                p = p.above();
            }
            return true;
        }
        catch (Throwable t) {
            if (ravenEntity.tickCount % 200 == 0) {
                LOG.warn("[Landing] hasAirColumn failed: {}", (Object)t.toString());
            }
            return false;
        }
    }

    @Nullable
    public BlockPos findValidPerchCornerNearXZ(int x, int z, RavenEntity ravenEntity) {
        try {
            int[][] corners;
            for (int[] c : corners = new int[][]{{x, z}, {x - 1, z}, {x, z - 1}, {x - 1, z - 1}}) {
                BlockPos cornerTop;
                int cx = c[0];
                int cz = c[1];
                Integer topY = this.computePerchTopY(cx, cz, ravenEntity);
                if (topY == null || !this.isValidPerchCornerAtTopY(cornerTop = new BlockPos(cx, topY.intValue(), cz), ravenEntity)) continue;
                return cornerTop;
            }
            return null;
        }
        catch (Throwable t) {
            if (ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Landing] findValidPerchCornerNearXZ failed safely: {}", (Object)t.toString());
            }
            return null;
        }
    }

    @Nullable
    private Integer computePerchTopY(int cx, int cz, RavenEntity ravenEntity) {
        try {
            int hintY;
            try {
                hintY = ravenEntity.level().getHeight(Heightmap.Types.WORLD_SURFACE, cx, cz);
            }
            catch (Throwable t) {
                hintY = ravenEntity.blockPosition().getY();
            }
            int maxY = Integer.MIN_VALUE;
            int scanTop = Mth.clamp((int)(hintY + 2), (int)ravenEntity.level().getMinBuildHeight(), (int)(ravenEntity.level().getMaxBuildHeight() - 1));
            int scanBottom = Mth.clamp((int)(hintY - 8), (int)ravenEntity.level().getMinBuildHeight(), (int)(ravenEntity.level().getMaxBuildHeight() - 1));
            for (int y = scanTop; y >= scanBottom; --y) {
                if (!this.isLeavesAt(cx, y, cz, ravenEntity) && !this.isLeavesAt(cx + 1, y, cz, ravenEntity) && !this.isLeavesAt(cx, y, cz + 1, ravenEntity) && !this.isLeavesAt(cx + 1, y, cz + 1, ravenEntity)) continue;
                maxY = y;
                break;
            }
            if (maxY == Integer.MIN_VALUE) {
                return null;
            }
            return maxY;
        }
        catch (Throwable t) {
            if (ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Landing] computePerchTopY failed safely: {}", (Object)t.toString());
            }
            return null;
        }
    }

    private boolean isLeavesAt(int x, int y, int z, RavenEntity ravenEntity) {
        try {
            BlockState st = ravenEntity.level().getBlockState(new BlockPos(x, y, z));
            return st != null && st.is(BlockTags.LEAVES);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isValidPerchCornerAtTopY(BlockPos cornerTop, RavenEntity ravenEntity) {
        try {
            return this.validatePerchCornerAtTopY((BlockPos)cornerTop, (RavenEntity)ravenEntity).ok;
        }
        catch (Throwable t) {
            if (ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Landing] isValidPerchCornerAtTopY wrapper failed safely: {}", (Object)t.toString());
            }
            return false;
        }
    }

    public Vec3 perchCenterTop(BlockPos cornerTop, RavenEntity ravenEntity) {
        try {
            if (cornerTop == null) {
                return ravenEntity.position();
            }
            double x = (double)cornerTop.getX() + 1.0;
            double z = (double)cornerTop.getZ() + 1.0;
            double y = (double)cornerTop.getY() + 1.0;
            return new Vec3(x, y, z);
        }
        catch (Throwable t) {
            return ravenEntity.position();
        }
    }

    public boolean isOnValidPerchNow(RavenEntity ravenEntity) {
        block8: {
            try {
                if (ravenEntity.isPlayerAvoidanceOverrideActive()) {
                    if (ravenEntity.tickCount % 40 == 0) {
                        LOG.debug("[Landing] isOnValidPerchNow: skipping because player avoidance override is active. pos={} aiState={}", (Object)ravenEntity.position(), (Object)ravenEntity.getAIState());
                    }
                    return false;
                }
            }
            catch (Throwable t) {
                if (ravenEntity.tickCount % 80 != 0) break block8;
                LOG.warn("[Landing] isOnValidPerchNow: avoidance gate failed safely: {}", (Object)t.toString());
            }
        }
        try {
            BlockPos feetBlock = BlockPos.containing((double)ravenEntity.getX(), (double)(ravenEntity.getBoundingBox().minY - 0.001), (double)ravenEntity.getZ());
            BlockPos corner = this.findValidPerchCornerNearXZ(feetBlock.getX(), feetBlock.getZ(), ravenEntity);
            if (corner == null) {
                return false;
            }
            Vec3 center = this.perchCenterTop(corner, ravenEntity);
            Vec3 pos = ravenEntity.position();
            double dx = pos.x - center.x;
            double dz = pos.z - center.z;
            double dXZ = Math.sqrt(dx * dx + dz * dz);
            return dXZ <= 0.55;
        }
        catch (Throwable t) {
            if (ravenEntity.tickCount % 80 == 0) {
                LOG.warn("[Landing] isOnValidPerchNow failed safely: {}", (Object)t.toString());
            }
            return false;
        }
    }

    private static enum Phase {
        NONE,
        FLY_TO_OVERHEAD,
        DESCEND_SLOW,
        DROP;

    }

    private static final class PerchValidity {
        final boolean ok;
        final String reason;
        final String details;

        private PerchValidity(boolean ok, String reason, String details) {
            this.ok = ok;
            this.reason = reason;
            this.details = details;
        }

        static PerchValidity ok() {
            return new PerchValidity(true, "OK", "");
        }

        static PerchValidity fail(String reason, String details) {
            return new PerchValidity(false, reason == null ? "FAIL" : reason, details == null ? "" : details);
        }
    }
}

