/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.entity.raven.modules;

import com.mojang.logging.LogUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class FeatherParticles {
    private static final Logger LOG = LogUtils.getLogger();
    public static int FEATHERS_PER_BURST = 12;
    public static double SPAWN_RADIUS = 0.45;
    public static double SPAWN_RADIUS_JITTER = 0.3;
    public static double BASE_OUTWARD_SPEED = 0.06;
    public static double OUTWARD_SPEED_RANDOM_FACTOR = 0.04;
    public static double INITIAL_UPWARD_BONUS = 0.06;
    public static int FEATHER_LIFETIME_MIN_TICKS = 18;
    public static int FEATHER_LIFETIME_MAX_TICKS = 28;
    public static float FEATHER_BASE_SCALE = 0.11f;
    public static float FEATHER_SCALE_VARIATION = 0.04f;
    public static float FEATHER_MAX_SWING_DEG = 45.0f;
    public static float FEATHER_SWING_SPEED_DEG_PER_TICK = 13.0f;
    public static double FEATHER_GRAVITY_PER_TICK = 0.008;
    public static double HORIZONTAL_DRAG = 0.94;
    public static double VERTICAL_DRAG = 0.92;
    public static float FEATHER_ALPHA_START = 1.0f;
    public static float FEATHER_ALPHA_END = 0.0f;

    private FeatherParticles() {
    }

    public static int getFeathersPerBurst() {
        return Math.max(1, FEATHERS_PER_BURST);
    }

    public static ParticleProvider<SimpleParticleType> createProvider(SpriteSet spriteSet) {
        return (type, level, centerX, centerY, centerZ, unusedVx, unusedVy, unusedVz) -> {
            if (!(level instanceof ClientLevel)) {
                return null;
            }
            ClientLevel clientLevel = level;
            RandomSource rnd = clientLevel.random;
            double theta = rnd.nextDouble() * (Math.PI * 2);
            double phi = rnd.nextDouble() * Math.PI;
            double baseRadius = SPAWN_RADIUS;
            double radiusJitterFactor = 1.0 + (rnd.nextDouble() * 2.0 - 1.0) * SPAWN_RADIUS_JITTER;
            double radius = baseRadius * radiusJitterFactor;
            double dirX = Math.sin(phi) * Math.cos(theta);
            double dirY = Math.cos(phi);
            double dirZ = Math.sin(phi) * Math.sin(theta);
            double len = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
            if (len < 1.0E-6) {
                dirX = 0.0;
                dirY = 1.0;
                dirZ = 0.0;
                len = 1.0;
            }
            double fx = centerX + (dirX /= len) * radius;
            double fy = centerY + (dirY /= len) * radius;
            double fz = centerZ + (dirZ /= len) * radius;
            double speed = BASE_OUTWARD_SPEED + (rnd.nextDouble() * 2.0 - 1.0) * OUTWARD_SPEED_RANDOM_FACTOR;
            if (speed < 0.0) {
                speed = 0.0;
            }
            double vx = dirX * speed;
            double vy = dirY * speed + INITIAL_UPWARD_BONUS;
            double vz = dirZ * speed;
            return FeatherParticle.create(clientLevel, fx, fy, fz, vx, vy, vz, spriteSet);
        };
    }

    public static final class FeatherParticle
    extends TextureSheetParticle {
        private final float maxSwingRad;
        private final float swingSpeedRadPerTick;
        private final float swingPhaseOffsetRad;

        private FeatherParticle(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, SpriteSet sprites, RandomSource rnd) {
            super(level, x, y, z, vx, vy, vz);
            this.pickSprite(sprites);
            this.xd = vx;
            this.yd = vy;
            this.zd = vz;
            this.quadSize = FEATHER_BASE_SCALE + (float)((rnd.nextDouble() * 2.0 - 1.0) * (double)FEATHER_SCALE_VARIATION);
            this.lifetime = Mth.nextInt((RandomSource)rnd, (int)FEATHER_LIFETIME_MIN_TICKS, (int)FEATHER_LIFETIME_MAX_TICKS);
            this.gravity = 0.0f;
            float initialRollDeg = (float)(rnd.nextDouble() * 360.0 - 180.0);
            this.oRoll = this.roll = (float)((double)initialRollDeg * (Math.PI / 180));
            this.maxSwingRad = (float)((double)FEATHER_MAX_SWING_DEG * (Math.PI / 180));
            this.swingSpeedRadPerTick = (float)((double)FEATHER_SWING_SPEED_DEG_PER_TICK * (Math.PI / 180));
            this.swingPhaseOffsetRad = (float)(rnd.nextDouble() * Math.PI * 2.0);
            this.alpha = FEATHER_ALPHA_START;
            if (level.getGameTime() % 80L == 0L) {
                LOG.info("[FeatherParticles] Created feather particle at ({}, {}, {}) alpha={} initialRollDeg={}", new Object[]{String.format("%.2f", x), String.format("%.2f", y), String.format("%.2f", z), Float.valueOf(this.alpha), Float.valueOf(initialRollDeg)});
            }
        }

        @Nullable
        public static FeatherParticle create(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, SpriteSet sprites) {
            try {
                if (level == null) {
                    return null;
                }
                RandomSource rnd = level.random;
                return new FeatherParticle(level, x, y, z, vx, vy, vz, sprites, rnd);
            }
            catch (Throwable t) {
                if (level != null && level.getGameTime() % 200L == 0L) {
                    LOG.warn("[FeatherParticles] FeatherParticle.create failed safely: {}", (Object)t.toString());
                }
                return null;
            }
        }

        public void tick() {
            try {
                this.xo = this.x;
                this.yo = this.y;
                this.zo = this.z;
                this.oRoll = this.roll;
                ++this.age;
                if (this.age >= this.lifetime) {
                    this.remove();
                    return;
                }
                float phase = (float)this.age * this.swingSpeedRadPerTick + this.swingPhaseOffsetRad;
                this.roll = this.maxSwingRad * Mth.sin((float)phase);
                this.xd *= HORIZONTAL_DRAG;
                this.zd *= HORIZONTAL_DRAG;
                this.yd -= FEATHER_GRAVITY_PER_TICK;
                this.yd *= VERTICAL_DRAG;
                this.move(this.xd, this.yd, this.zd);
                float t = (float)this.age / (float)this.lifetime;
                t = Mth.clamp((float)t, (float)0.0f, (float)1.0f);
                this.alpha = Mth.lerp((float)t, (float)FEATHER_ALPHA_START, (float)FEATHER_ALPHA_END);
            }
            catch (Throwable t) {
                if (this.level != null && this.level.getGameTime() % 200L == 0L) {
                    LOG.warn("[FeatherParticles] FeatherParticle.tick failed safely: {}", (Object)t.toString());
                }
                this.remove();
            }
        }

        public ParticleRenderType getRenderType() {
            return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        }
    }
}

