/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.entity.raven.modules;

import com.mojang.logging.LogUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import net.z2six.featheredfriend.entity.raven.modules.Teleportation;
import org.slf4j.Logger;

public final class DamageDodge {
    private static final Logger LOG = LogUtils.getLogger();
    public static final float DODGE_CHANCE = 0.75f;

    private DamageDodge() {
    }

    public static boolean handleHurt(RavenEntity raven, DamageSource source, float amount) {
        try {
            boolean dodge;
            if (raven == null) {
                return false;
            }
            if (raven.level() == null || raven.level().isClientSide) {
                return false;
            }
            if (!raven.isAlive()) {
                return false;
            }
            boolean teleportStartedOrQueued = false;
            try {
                Teleportation tp = null;
                try {
                    tp = raven.getTeleportation();
                }
                catch (Throwable ignored) {
                    tp = null;
                }
                if (tp != null) {
                    teleportStartedOrQueued = tp.requestDamageBlinkTeleport(source, amount, "hurt", raven);
                } else {
                    if (raven.tickCount % 40 == 0) {
                        LOG.warn("[DamageDodge] DamageBlink skipped: teleportation module null. pos={} src={} amt={}", new Object[]{raven.position(), source == null ? "null" : source.toString(), Float.valueOf(amount)});
                    }
                    teleportStartedOrQueued = false;
                }
            }
            catch (Throwable t) {
                if (raven.tickCount % 40 == 0) {
                    LOG.warn("[DamageDodge] DamageBlink failed safely: {}", (Object)t.toString());
                }
                teleportStartedOrQueued = false;
            }
            RandomSource rnd = raven.getRandom();
            boolean bl = dodge = rnd.nextFloat() < 0.75f;
            if (raven.tickCount % 20 == 0) {
                LOG.info("[DamageDodge] handleHurt: dodge={} chance={} amount={} src={} teleportStartedOrQueued={} pos={} ai={}", new Object[]{dodge, Float.valueOf(0.75f), Float.valueOf(amount), source == null ? "null" : source.toString(), teleportStartedOrQueued, raven.position(), raven.getAIState()});
            }
            return dodge;
        }
        catch (Throwable t) {
            try {
                if (raven != null && raven.tickCount % 80 == 0) {
                    LOG.warn("[DamageDodge] handleHurt failed safely: {}", (Object)t.toString());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
    }
}

