/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.entity.raven;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.z2six.featheredfriend.entity.raven.RavenAIState;
import net.z2six.featheredfriend.entity.raven.RavenAnimMode;
import net.z2six.featheredfriend.entity.raven.RavenControl;
import net.z2six.featheredfriend.entity.raven.RavenVariant;
import net.z2six.featheredfriend.entity.raven.modules.DamageDodge;
import net.z2six.featheredfriend.entity.raven.modules.FeatherParticles;
import net.z2six.featheredfriend.entity.raven.modules.Landing;
import net.z2six.featheredfriend.entity.raven.modules.LureFollowTame;
import net.z2six.featheredfriend.entity.raven.modules.PlayerAvoidance;
import net.z2six.featheredfriend.entity.raven.modules.RavenSoundEngine;
import net.z2six.featheredfriend.entity.raven.modules.TamedRaven;
import net.z2six.featheredfriend.entity.raven.modules.TamedRavenDeathHandler;
import net.z2six.featheredfriend.entity.raven.modules.Teleportation;
import net.z2six.featheredfriend.entity.raven.pathing.RavenAStarPathing;
import net.z2six.featheredfriend.registry.FFNeoForgeParticles;
import net.z2six.featheredfriend.world.TamedRavenScrollWatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RavenEntity
extends TamableAnimal
implements GeoEntity {
    private static final Logger LOG = LogUtils.getLogger();
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.defineId(RavenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ANIM_MODE = SynchedEntityData.defineId(RavenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_AI_STATE = SynchedEntityData.defineId(RavenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_LURE_FOLLOW_ARMED = SynchedEntityData.defineId(RavenEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_LURE_FOLLOW_ACTIVE = SynchedEntityData.defineId(RavenEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_FOLLOW_COOLDOWN_TICKS = SynchedEntityData.defineId(RavenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final String NBT_VARIANT = "RavenVariant";
    private static final String NBT_ANIM_MODE = "RavenAnimMode";
    private static final String NBT_AI_STATE = "RavenAIState";
    private static final String NBT_HOME_INIT = "RavenHomeInit";
    private static final String NBT_HOME_X = "RavenHomeX";
    private static final String NBT_HOME_Y = "RavenHomeY";
    private static final String NBT_HOME_Z = "RavenHomeZ";
    private static final int HOME_RADIUS_BLOCKS = 50;
    private static final int HOME_Y_DELTA = 15;
    private final LureFollowTame lureFollowTame = new LureFollowTame(this);
    private final Teleportation teleportation = new Teleportation(this);
    private final Landing landing = new Landing(this);
    private final PlayerAvoidance playeravoidance = new PlayerAvoidance(this);
    private final TamedRaven tamedRaven = new TamedRaven(this);
    private static final ResourceLocation SOUND_RAVEN_CAWING_NORMAL_ID;
    private static final ResourceLocation SOUND_RAVEN_CAW_AGREE_ID;
    private static final ResourceLocation SOUND_RAVEN_CAW_DMG_ID;
    private static final ResourceLocation SOUND_RAVEN_CAW_WHISTLE_ID;
    private static final ResourceLocation SOUND_RAVEN_AIR_WOOSH_ID;
    private static final ResourceLocation SOUND_RAVEN_TELEPORT_ID;
    private static SoundEvent cachedRavenCawingNormal;
    private static SoundEvent cachedRavenCawAgree;
    private static SoundEvent cachedRavenCawDmg;
    private static SoundEvent cachedRavenCawWhistle;
    private static SoundEvent cachedRavenAirWoosh;
    private static SoundEvent cachedRavenTeleport;
    private int ambientCawCooldownTicks = 0;
    private int lastPanicTeleportTick = Integer.MIN_VALUE;
    private int playerAvoidanceOverrideTicks = 0;
    private int playerAvoidanceRearmCooldownTicks = 0;
    private PostTeleportIntent postTeleportIntent = PostTeleportIntent.PERCH;
    private int lastDamageBlinkTick = -999999;
    private static final int DAMAGE_BLINK_MIN_INTERVAL_TICKS = 10;
    private static final int IDLE_MIN_TICKS = 300;
    private static final int IDLE_MAX_TICKS = 600;
    private static final int ROAM_MIN_TICKS = 80;
    private static final int ROAM_MAX_TICKS = 200;
    private static final int STUCK_TICKS_THRESHOLD = 30;
    private static final double STUCK_PROGRESS_EPS = 0.06;
    private static final int AVOIDANCE_COOLDOWN_TICKS = 8;
    private static final double FLY_SPEED_BASE = 0.25;
    private static final double FLY_SPEED_RETURN = 0.32;
    private static final double ARRIVE_DIST = 1.2;
    private static final int IDLE_LOCK_TICKS = 50;
    private static final int IDLE_LEAF_LOSS_GRACE_TICKS = 20;
    private static final double IDLE_SETTLE_NUDGE_DOWN = -0.1;
    private static final double IDLE_SETTLE_MIN_FALL = -0.28;
    private static final double IDLE_SETTLE_MAX_UP = 0.04;
    private RavenAIState flightTeleportLastAI = null;
    private int flightTeleportBudget = 0;
    private int flightTeleportUsed = 0;
    private int flightTeleportCheckCooldownTicks = 0;
    private int flightTeleportHardCooldownTicks = 0;
    private static final int DEBUG_LOG_INTERVAL_TICKS = 120;
    private static final boolean DEBUG_DRAW_PATH_GIZMOS = false;
    private static final int DEBUG_PATH_GIZMO_MAX_WAYPOINTS = 20;
    private static final int DEBUG_PATH_GIZMO_TICK_INTERVAL = 2;
    private final List<Integer> debugPathMarkerIds = new ArrayList<Integer>();
    private static final String DEBUG_PATH_GIZMO_TAG = "raven_path_gizmo";
    private static final double DEBUG_PATH_GIZMO_CLEAN_RADIUS = 96.0;
    private static final int PATH_REPLAN_MIN_INTERVAL_TICKS = 8;
    private static final double PATH_GOAL_REPLAN_DIST_SQR = 16.0;
    private static final double PATH_WAYPOINT_REACHED_DIST = 1.25;
    private static final int PATH_RETRY_INTERVAL_TICKS = 20;
    private int pathRetryTicks = 0;
    private static final double[] PATH_START_PROBE_UP_OFFSETS;
    private static final boolean PATH_START_SAMPLE_LOGS = false;
    private static final boolean PATH_RETRY_LOGS = false;
    private int pathFailCooldownTicks = 0;
    @Nullable
    private Vec3 pathGoal = null;
    @Nullable
    private Vec3 pathPendingGoal = null;
    private int pathReplanCooldownTicks = 0;
    private List<Vec3> pathWaypoints = Collections.emptyList();
    private int pathWaypointIndex = 0;
    private int pathRetryCooldownTicks = 0;
    private long lastPathPlanAttemptTick = -1L;
    private int consecutivePathPlanFails = 0;
    private int consecutiveStartSampleAdjustments = 0;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RavenControl control = new RavenControl(this);
    private static final RawAnimation ANIM_NO_AIR;
    private static final RawAnimation ANIM_IN_AIR;
    private boolean homeInitialized = false;
    private BlockPos homePos = BlockPos.ZERO;
    @Nullable
    private Vec3 flyTarget = null;
    private int flyTargetTimeoutTicks = 0;
    private int idleTicksRemaining = 0;
    private float idleTargetYaw = 0.0f;
    private int idleNextTurnTicks = 0;
    private int idleCommitTicks = 0;
    private int roamTicksRemaining = 0;
    private double lastDistToTarget = Double.NaN;
    private int stuckTicks = 0;
    private int avoidanceCooldownTicks = 0;
    private int idleLockTicks = 0;
    private int idleLeafLossTicks = 0;
    private boolean idleSettleArmed = false;
    private boolean idleSettlingActive = false;
    private LandingPhase landingPhase = LandingPhase.NONE;
    private int landingTicks = 0;

    public RavenEntity(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT, (Object)RavenVariant.NORMAL.id());
        builder.define(DATA_ANIM_MODE, (Object)RavenAnimMode.AUTO.id());
        builder.define(DATA_AI_STATE, (Object)RavenAIState.IDLE_GROUND.id());
        builder.define(DATA_FOLLOW_COOLDOWN_TICKS, (Object)0);
        builder.define(Teleportation.DATA_TELEPORT_FX_TICKS, (Object)0);
        builder.define(Teleportation.DATA_TELEPORT_FX_SEED, (Object)0L);
        builder.define(Teleportation.DATA_TELEPORT_FADE_ALPHA, (Object)255);
        builder.define(DATA_LURE_FOLLOW_ARMED, (Object)Boolean.FALSE);
        builder.define(DATA_LURE_FOLLOW_ACTIVE, (Object)Boolean.FALSE);
    }

    public RavenVariant getRavenVariant() {
        return RavenVariant.fromId((Integer)this.entityData.get(DATA_VARIANT));
    }

    public void setRavenVariant(@Nullable RavenVariant variant) {
        if (variant == null) {
            variant = RavenVariant.NORMAL;
        }
        this.entityData.set(DATA_VARIANT, (Object)variant.id());
    }

    public RavenAnimMode getAnimMode() {
        return RavenAnimMode.fromId((Integer)this.entityData.get(DATA_ANIM_MODE));
    }

    public void setAnimMode(@Nullable RavenAnimMode mode) {
        if (mode == null) {
            mode = RavenAnimMode.AUTO;
        }
        this.entityData.set(DATA_ANIM_MODE, (Object)mode.id());
    }

    public RavenAIState getAIState() {
        return RavenAIState.fromId((Integer)this.entityData.get(DATA_AI_STATE));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAIState(@Nullable RavenAIState state) {
        if (state == null) {
            state = RavenAIState.IDLE_GROUND;
        }
        try {
            prev = this.getAIState();
            followOverrideActive = false;
            scrollSummonFollowLock = false;
            try {
                followOverrideActive = this.lureFollowTame != null && this.lureFollowTame.isFollowOverrideActive() != false;
            }
            catch (Throwable t) {
                if (this.tickCount % 80 == 0) {
                    // empty if block
                }
            }
            scrollSummonFollowLock = this.isScrollSummonFollowLockActive();
            ** finally { 
lbl17:
            // 1 sources

            protectFollow = followOverrideActive != false || scrollSummonFollowLock != false;
            ownerValid = false;
            if (protectFollow) {
                if (this.lureFollowTame == null) {
                }
                ownerNow = this.lureFollowTame.getOwnerPlayerServerSafe();
                ownerValid = ownerNow != null && ownerNow.isAlive() != false && ownerNow.level() == this.level();
            }
            ** finally { 
lbl28:
            // 1 sources

            if (protectFollow && ownerValid && prev == RavenAIState.FOLLOW_OWNER && state != RavenAIState.FOLLOW_OWNER) {
                if (this.tickCount % 20 == 0) {
                    // empty if block
                }
                if (!RavenEntity.LOG.isDebugEnabled() || this.tickCount % 200 != 0) return;
                try {
                    st = Thread.currentThread().getStackTrace();
                    sb = new StringBuilder();
                    shown = 0;
                    for (i = 2; i < st.length && shown < 10; ++i) {
                        cn = st[i].getClassName();
                        if (cn.startsWith("java.") || cn.startsWith("sun.") || cn.startsWith("jdk.")) continue;
                        sb.append("\n  at ").append(st[i]);
                        ++shown;
                    }
                    return;
                }
                catch (Throwable var7_13) {
                    // empty catch block
                }
                return;
            }
            try {
                if (!this.level().isClientSide && state == RavenAIState.IDLE_GROUND && prev != RavenAIState.IDLE_GROUND) {
                    this.idleSettleArmed = true;
                    this.idleSettlingActive = true;
                    if (this.tickCount % 40 != 0) {
                        // empty if block
                    }
                }
            }
            catch (Throwable var7_14) {
                // empty catch block
            }
            if (prev == state && this.tickCount % 80 != 0) {
                // empty if block
            }
        }
        catch (Throwable var2_3) {
            // empty catch block
        }
        this.entityData.set(RavenEntity.DATA_AI_STATE, (Object)state.id());
    }

    private void debugAiHeartbeat(String where) {
        try {
            if (this.level().isClientSide) {
                return;
            }
            if (this.tickCount % 20 != 0) {
                return;
            }
            RavenAIState ravenAIState = this.getAIStateForDebug();
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    private void ensureHomeInitialized() {
        if (this.homeInitialized) {
            return;
        }
        this.homeInitialized = true;
        this.homePos = this.blockPosition();
        if (this.tickCount % 20 == 0) {
            // empty if block
        }
    }

    private int clampYToHomeBounds(int y) {
        int minY = this.homePos.getY() - 15;
        int maxY = this.homePos.getY() + 15;
        return Mth.clamp((int)y, (int)minY, (int)maxY);
    }

    private Vec3 clampTargetToHomeBounds(Vec3 target) {
        double hz;
        double dz;
        try {
            if (this.getAIState() == RavenAIState.FOLLOW_OWNER) {
                return target;
            }
        }
        catch (Throwable t) {
            if (this.tickCount % 200 == 0) {
                // empty if block
            }
        }
        double clampedY = this.clampYToHomeBounds((int)Math.round(target.y));
        double hx = (double)this.homePos.getX() + 0.5;
        double dx = target.x - hx;
        double dist = Math.sqrt(dx * dx + (dz = target.z - (hz = (double)this.homePos.getZ() + 0.5)) * dz);
        if (dist <= 50.0) {
            return new Vec3(target.x, clampedY, target.z);
        }
        double scale = 50.0 / Math.max(1.0E-4, dist);
        double nx = hx + dx * scale;
        double nz = hz + dz * scale;
        return new Vec3(nx, clampedY, nz);
    }

    private boolean isOutOfHomeBounds(Vec3 pos) {
        double hz;
        double dz;
        double hx = (double)this.homePos.getX() + 0.5;
        double dx = pos.x - hx;
        double dist = Math.sqrt(dx * dx + (dz = pos.z - (hz = (double)this.homePos.getZ() + 0.5)) * dz);
        if (dist > 50.75) {
            return true;
        }
        int y = (int)Math.floor(pos.y);
        int minY = this.homePos.getY() - 15;
        int maxY = this.homePos.getY() + 15;
        return y < minY || y > maxY;
    }

    private Vec3 homeCenterReturnTarget() {
        double hx = (double)this.homePos.getX() + 0.5;
        double hz = (double)this.homePos.getZ() + 0.5;
        double y = this.clampYToHomeBounds(this.homePos.getY());
        return new Vec3(hx, y, hz);
    }

    private void setFlyTarget(Vec3 target, int timeoutTicks) {
        Vec3 clamped;
        this.flyTarget = clamped = this.clampTargetToHomeBounds(target);
        this.flyTargetTimeoutTicks = Math.max(20, timeoutTicks);
        this.lastDistToTarget = Double.NaN;
        this.stuckTicks = 0;
    }

    private void clearFlyTarget() {
        this.flyTarget = null;
        this.flyTargetTimeoutTicks = 0;
        this.lastDistToTarget = Double.NaN;
        this.stuckTicks = 0;
    }

    private void clearPlannedPath(String reason) {
        try {
            int wpSize = 0;
            boolean hadWaypoints = false;
            try {
                if (this.pathWaypoints != null) {
                    hadWaypoints = !this.pathWaypoints.isEmpty();
                    wpSize = this.pathWaypoints.size();
                }
            }
            catch (Throwable ignored) {
                hadWaypoints = false;
                wpSize = 0;
            }
            if (!hadWaypoints && this.pathGoal == null && this.pathPendingGoal == null || this.tickCount % 120 == 0) {
                // empty if block
            }
            this.pathGoal = null;
            this.pathPendingGoal = null;
            this.pathWaypoints = Collections.emptyList();
            this.pathWaypointIndex = 0;
            this.pathReplanCooldownTicks = 0;
            this.pathRetryCooldownTicks = 0;
            this.lastPathPlanAttemptTick = -1L;
            this.consecutivePathPlanFails = 0;
            this.consecutiveStartSampleAdjustments = 0;
        }
        catch (Throwable t) {
            try {
                this.pathGoal = null;
                this.pathPendingGoal = null;
                this.pathWaypoints = Collections.emptyList();
                this.pathWaypointIndex = 0;
                this.pathReplanCooldownTicks = 0;
                this.pathRetryCooldownTicks = 0;
                this.lastPathPlanAttemptTick = -1L;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private RavenAStarPathing.CellBounds currentHomeCellBounds() {
        int minY = this.homePos.getY() - 15;
        int maxY = this.homePos.getY() + 15;
        return RavenAStarPathing.boundsFrom(this.homePos, 50, minY, maxY);
    }

    private Vec3 computeSafePathingStart(Vec3 rawStart, RavenAStarPathing.Config cfg) {
        Vec3[] baseCandidates;
        if (rawStart == null) {
            return this.position();
        }
        if (cfg == null) {
            cfg = new RavenAStarPathing.Config();
        }
        int clearanceXZ = Math.max(1, cfg.cellSize);
        int clearanceH = Math.max(1, cfg.clearanceHeight);
        double rawX = rawStart.x;
        double rawZ = rawStart.z;
        double snapX = Math.floor(rawX) + 0.5;
        double snapZ = Math.floor(rawZ) + 0.5;
        for (Vec3 base : baseCandidates = new Vec3[]{new Vec3(rawX, rawStart.y, rawZ), new Vec3(snapX, rawStart.y, snapZ), new Vec3(Mth.lerp((double)0.35, (double)rawX, (double)snapX), rawStart.y, Mth.lerp((double)0.35, (double)rawZ, (double)snapZ))}) {
            for (double up : PATH_START_PROBE_UP_OFFSETS) {
                Vec3 cand = new Vec3(base.x, base.y + up, base.z);
                if (!this.looksLocallyPassableForClearance(cand, clearanceXZ, clearanceH, cfg.allowLeaves, cfg.allowReplaceables)) continue;
                return cand;
            }
        }
        Vec3 fallback = new Vec3(snapX, rawStart.y + 0.25, snapZ);
        return fallback;
    }

    private Vec3 computeStablePathStart() {
        try {
            Vec3 pos = this.position();
            double sx = Math.floor(pos.x) + 0.5;
            double sy = Math.floor(pos.y) + 0.5;
            double sz = Math.floor(pos.z) + 0.5;
            BlockPos bp = BlockPos.containing((double)sx, (double)sy, (double)sz);
            for (int i = 0; i < 4 && !this.level().isEmptyBlock(bp); ++i) {
                sy += 1.0;
                bp = bp.above();
            }
            return new Vec3(sx, sy, sz);
        }
        catch (Throwable t) {
            if (this.tickCount % 40 == 0) {
                // empty if block
            }
            return this.position();
        }
    }

    private boolean looksLocallyPassableForClearance(Vec3 start, int clearanceXZ, int clearanceH, boolean allowLeaves, boolean allowReplaceables) {
        try {
            if (start == null) {
                return false;
            }
            int cx = Mth.floor((double)(start.x + 1.0E-4));
            int cy = Mth.floor((double)(start.y + 1.0E-4));
            int cz = Mth.floor((double)(start.z + 1.0E-4));
            for (int dy = 0; dy <= 1; ++dy) {
                int y = cy + dy;
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockState st;
                        block13: {
                            boolean empty;
                            BlockPos p = new BlockPos(cx + dx, y, cz + dz);
                            try {
                                empty = this.level().isEmptyBlock(p);
                            }
                            catch (Throwable t) {
                                if (this.tickCount % 200 == 0) {
                                    // empty if block
                                }
                                return false;
                            }
                            if (empty) continue;
                            try {
                                st = this.level().getBlockState(p);
                            }
                            finally {
                                if (st != null) break block13;
                                return false;
                            }
                        }
                        if (allowLeaves && st.is(BlockTags.LEAVES) || allowReplaceables && st.canBeReplaced()) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Throwable t) {
            if (this.tickCount % 200 == 0) {
                // empty if block
            }
            return false;
        }
    }

    private boolean ensurePathTo(@Nullable Vec3 goal, int timeoutTicks, long seed, @Nullable String reason) {
        boolean highPriority = this.isHighPriorityReason(reason);
        if (timeoutTicks > 0 && timeoutTicks <= 120) {
            highPriority = true;
        }
        return this.ensurePathTo(goal, highPriority, timeoutTicks, seed, reason);
    }

    private boolean ensurePathTo(@Nullable Vec3 goal, boolean highPriority, long seed, @Nullable String reason) {
        int defaultTimeout = 120;
        return this.ensurePathTo(goal, highPriority, 120, seed, reason);
    }

    private boolean ensurePathTo(@Nullable Vec3 goal, boolean highPriority, int timeoutTicks, long seed, @Nullable String reason) {
        if (this.level().isClientSide) {
            return false;
        }
        if (goal == null) {
            if (this.tickCount % 40 == 0) {
                // empty if block
            }
            return false;
        }
        this.pathPendingGoal = goal;
        try {
            List<Object> pts;
            double dg2;
            long dt;
            double d2;
            this.ensureHomeInitialized();
            if (!highPriority && this.pathFailCooldownTicks > 0) {
                return false;
            }
            if (!highPriority && this.pathReplanCooldownTicks > 0) {
                return false;
            }
            if (!highPriority && this.pathRetryCooldownTicks > 0) {
                return false;
            }
            if (this.pathGoal != null && (d2 = this.pathGoal.distanceToSqr(goal)) <= 16.0) {
                boolean hasFly;
                boolean hasUsablePath = !this.isPathExhausted();
                boolean bl = hasFly = this.flyTarget != null && this.flyTargetTimeoutTicks > 0;
                if (hasUsablePath || hasFly) {
                    return true;
                }
                if (this.tickCount % 40 == 0) {
                    // empty if block
                }
            }
            if (!highPriority && this.lastPathPlanAttemptTick >= 0L && (dt = (long)this.tickCount - this.lastPathPlanAttemptTick) >= 0L && dt < 8L) {
                return false;
            }
            this.lastPathPlanAttemptTick = this.tickCount;
            RavenAStarPathing.Config cfg = new RavenAStarPathing.Config();
            cfg.cellSize = 1;
            cfg.clearanceHeight = 2;
            cfg.gridStep = 1;
            cfg.allowLeaves = false;
            cfg.allowReplaceables = false;
            cfg.maxExpanded = 6500;
            cfg.maxOpen = 16000;
            cfg.smoothPath = true;
            cfg.tieBreakSeed = seed;
            cfg.useSafetyBuffer = true;
            cfg.safetyBufferXZ = 1;
            cfg.safetyBufferYUp = 1;
            cfg.safetyBufferYDown = 0;
            cfg.safetyBufferRespectsAllowFlags = false;
            RavenAStarPathing.CellBounds bounds = this.currentHomeCellBounds();
            Vec3 rawStart = this.computeStablePathStart();
            Vec3 safeStart = this.computeSafePathingStart(rawStart, cfg);
            Vec3 rawGoal = goal;
            Vec3 safeGoal = this.computeSafePathingGoal(rawGoal, cfg);
            safeGoal = this.clampTargetToHomeBounds(safeGoal);
            if (this.tickCount % 20 != 0 || (dg2 = safeGoal.distanceToSqr(rawGoal)) > 1.0E-6) {
                // empty if block
            }
            try {
                pts = RavenAStarPathing.findPath(this.level(), safeStart, safeGoal, bounds, cfg);
            }
            catch (Throwable t) {
                pts = Collections.emptyList();
            }
            if (pts == null || pts.isEmpty()) {
                ++this.consecutivePathPlanFails;
                this.pathFailCooldownTicks = Math.max(this.pathFailCooldownTicks, 12);
                this.pathReplanCooldownTicks = Math.max(this.pathReplanCooldownTicks, 6);
                this.pathRetryCooldownTicks = highPriority ? 5 : 20;
                return false;
            }
            this.consecutivePathPlanFails = 0;
            this.pathGoal = safeGoal;
            this.pathWaypoints = pts;
            this.pathWaypointIndex = 0;
            this.pathReplanCooldownTicks = highPriority ? 4 : 8;
            this.pathRetryCooldownTicks = highPriority ? 4 : 10;
            this.pathFailCooldownTicks = 0;
            if (this.tickCount % 20 == 0) {
                // empty if block
            }
            this.advanceWaypointIfNeeded(Math.max(20, timeoutTicks), "ensurePathTo(core) accept: " + String.valueOf(reason));
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean isHighPriorityReason(@Nullable String reason) {
        if (reason == null || reason.isEmpty()) {
            return false;
        }
        String r = reason.toLowerCase();
        if (r.contains("retry")) {
            return true;
        }
        if (r.contains("out-of-bounds")) {
            return true;
        }
        if (r.contains("return")) {
            return true;
        }
        if (r.contains("follow")) {
            return true;
        }
        if (r.contains("collision")) {
            return true;
        }
        if (r.contains("blocked")) {
            return true;
        }
        return r.contains("landing");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void advanceWaypointIfNeeded(int timeoutTicks, String reason) {
        try {
            if (this.pathWaypoints == null || this.pathWaypoints.isEmpty()) {
                return;
            }
            Vec3 pos = this.position();
            while (this.pathWaypointIndex < this.pathWaypoints.size()) {
                Vec3 wp = this.pathWaypoints.get(this.pathWaypointIndex);
                if (wp == null) {
                    ++this.pathWaypointIndex;
                    continue;
                }
                double d = pos.distanceTo(wp);
                if (!(d <= 1.25)) break;
                ++this.pathWaypointIndex;
            }
            if (this.pathWaypointIndex >= this.pathWaypoints.size()) {
                double dGoal;
                Vec3 goal = this.pathGoal;
                if (goal != null && (dGoal = pos.distanceTo(goal)) > 1.2) {
                    this.setFlyTarget(goal, Math.max(20, timeoutTicks));
                    this.pathWaypoints = Collections.emptyList();
                    this.pathWaypointIndex = 0;
                    if (this.tickCount % 20 != 0) return;
                    return;
                }
                this.clearFlyTarget();
                this.clearPlannedPath("path completed: " + reason);
                if (this.tickCount % 120 != 0) return;
                return;
            }
            Vec3 next = this.pathWaypoints.get(this.pathWaypointIndex);
            if (next != null) {
                this.setFlyTarget(next, timeoutTicks);
                if (this.tickCount % 60 != 0) return;
                return;
            }
            ++this.pathWaypointIndex;
            if (this.tickCount % 40 != 0) return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean commandMoveTo(BlockPos pos, double speed) {
        if (pos == null) {
            return false;
        }
        if (speed <= 0.0) {
            return false;
        }
        try {
            this.ensureHomeInitialized();
            Vec3 target = new Vec3((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            target = this.clampTargetToHomeBounds(target);
            long seed = this.getUUID().getLeastSignificantBits() ^ (long)this.tickCount;
            boolean ok = this.ensurePathTo(target, 240, seed, "commandMoveTo");
            if (!ok) {
                this.setFlyTarget(target, 240);
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void commandStopMoving() {
        this.clearPlannedPath("commandStopMoving");
        this.clearFlyTarget();
        this.setDeltaMovement(Vec3.ZERO);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        if (this.tickCount % 200 == 0) {
            // empty if block
        }
        return null;
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    protected void checkInsideBlocks() {
        try {
            if (this.isNoGravity()) {
                return;
            }
            super.checkInsideBlocks();
        }
        catch (Throwable t) {
            if (this.tickCount % 200 == 0) {
                // empty if block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData out = null;
        try {
            out = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        }
        catch (Throwable t) {
            out = spawnGroupData;
        }
        try {
            this.initGoldenNuggetsRequiredToTameIfNeeded("finalizeSpawn:" + String.valueOf(spawnType));
            if (this.tickCount % 20 != 0) return out;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        try {
            tag.putInt(NBT_VARIANT, ((Integer)this.entityData.get(DATA_VARIANT)).intValue());
            tag.putInt(NBT_ANIM_MODE, ((Integer)this.entityData.get(DATA_ANIM_MODE)).intValue());
            tag.putInt(NBT_AI_STATE, ((Integer)this.entityData.get(DATA_AI_STATE)).intValue());
            tag.putInt("RavenFollowCooldown", ((Integer)this.entityData.get(LureFollowTame.DATA_FOLLOW_COOLDOWN_TICKS)).intValue());
            tag.putBoolean(NBT_HOME_INIT, this.homeInitialized);
            tag.putInt(NBT_HOME_X, this.homePos.getX());
            tag.putInt(NBT_HOME_Y, this.homePos.getY());
            tag.putInt(NBT_HOME_Z, this.homePos.getZ());
            try {
                int v;
                if (this.getGoldenNuggetsRequiredToTame() <= 0 && this.level() != null && !this.level().isClientSide) {
                    this.initGoldenNuggetsRequiredToTameIfNeeded("save");
                }
                if ((v = this.getGoldenNuggetsRequiredToTame()) < 3) {
                    v = 3;
                }
                if (v > 6) {
                    v = 6;
                }
                tag.putInt("GoldenNuggetsRequiredToTame", v);
                if (this.tickCount % 200 != 0) return;
                return;
            }
            catch (Throwable t2) {
                if (this.tickCount % 200 != 0) return;
            }
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        try {
            int id;
            if (tag.contains(NBT_VARIANT)) {
                id = tag.getInt(NBT_VARIANT);
                RavenVariant v = RavenVariant.fromId(id);
                this.setRavenVariant(v);
            }
            if (tag.contains(NBT_ANIM_MODE)) {
                id = tag.getInt(NBT_ANIM_MODE);
                RavenAnimMode m = RavenAnimMode.fromId(id);
                this.setAnimMode(m);
            }
            if (tag.contains(NBT_AI_STATE)) {
                id = tag.getInt(NBT_AI_STATE);
                RavenAIState s = RavenAIState.fromId(id);
                this.setAIState(s);
            }
            if (tag.contains("RavenFollowCooldown")) {
                int cd = tag.getInt("RavenFollowCooldown");
                this.setFollowCooldownTicks(cd);
            }
            if (tag.contains(NBT_HOME_INIT)) {
                this.homeInitialized = tag.getBoolean(NBT_HOME_INIT);
            }
            if (tag.contains(NBT_HOME_X) && tag.contains(NBT_HOME_Y) && tag.contains(NBT_HOME_Z)) {
                this.homePos = new BlockPos(tag.getInt(NBT_HOME_X), tag.getInt(NBT_HOME_Y), tag.getInt(NBT_HOME_Z));
            }
            try {
                if (tag.contains("GoldenNuggetsRequiredToTame", 3)) {
                    int v = tag.getInt("GoldenNuggetsRequiredToTame");
                    if (v < 3) {
                        v = 3;
                    }
                    if (v > 6) {
                        v = 6;
                    }
                    this.setGoldenNuggetsRequiredToTame(v);
                    if (this.tickCount % 200 != 0) return;
                }
                this.initGoldenNuggetsRequiredToTameIfNeeded("load-missingTag");
                return;
            }
            catch (Throwable t2) {
                if (this.tickCount % 200 == 0) {
                    // empty if block
                }
                this.setGoldenNuggetsRequiredToTame(4);
            }
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide) {
            return;
        }
        try {
            block44: {
                block42: {
                    boolean canFollow;
                    block41: {
                        block43: {
                            boolean retryAllowed;
                            this.ensureHomeInitialized();
                            this.teleportation.tickTeleportSequenceServer(this);
                            if (this.teleportation.teleportSeqPhase != Teleportation.TeleportSeqPhase.NONE) {
                                this.teleportation.tickTeleportFxServer(this);
                                return;
                            }
                            try {
                                TamedRaven tamed = this.getTamedRavenModule();
                                if (tamed != null) {
                                    tamed.tickServer();
                                }
                            }
                            catch (Throwable t) {
                                if (this.tickCount % 80 == 0) {
                                    // empty if block
                                }
                            }
                            int cd = this.getFollowCooldownTicks();
                            if (cd > 0) {
                                this.setFollowCooldownTicks(cd - 1);
                            }
                            if (this.avoidanceCooldownTicks > 0) {
                                --this.avoidanceCooldownTicks;
                            }
                            if (this.pathFailCooldownTicks > 0) {
                                --this.pathFailCooldownTicks;
                            }
                            if (this.pathReplanCooldownTicks > 0) {
                                --this.pathReplanCooldownTicks;
                            }
                            if (this.pathRetryCooldownTicks > 0) {
                                --this.pathRetryCooldownTicks;
                            }
                            RavenAIState st = this.getAIStateForDebug();
                            boolean bl = retryAllowed = this.teleportation.teleportSeqPhase == Teleportation.TeleportSeqPhase.NONE && this.playerAvoidanceOverrideTicks <= 0 && st != RavenAIState.IDLE_GROUND && this.landingPhase == LandingPhase.NONE && this.idleLockTicks <= 0;
                            if (!retryAllowed) break block43;
                            Vec3 retryGoal = this.pathGoal != null ? this.pathGoal : this.pathPendingGoal;
                            boolean noUsablePath = this.isPathExhausted();
                            if (retryGoal != null && noUsablePath) {
                                if (this.pathRetryTicks > 0) {
                                    --this.pathRetryTicks;
                                    break block41;
                                } else {
                                    this.pathRetryTicks = 20;
                                    this.pathRetryCooldownTicks = 0;
                                    this.pathReplanCooldownTicks = 0;
                                    long seed = this.getUUID().getLeastSignificantBits() ^ (long)this.tickCount ^ 0xA5A5A5A5L;
                                    boolean ok = this.ensurePathTo(retryGoal, 120, seed, "retry-loop");
                                    if (!ok) {
                                        // empty if block
                                    }
                                }
                                break block41;
                            } else {
                                this.pathRetryTicks = Math.min(this.pathRetryTicks, 20);
                            }
                            break block41;
                        }
                        this.pathRetryTicks = Math.min(this.pathRetryTicks, 20);
                    }
                    if (this.playerAvoidanceOverrideTicks <= 0 && this.getAIState() != RavenAIState.FOLLOW_OWNER && this.isOutOfHomeBounds(this.position())) {
                        if (this.tickCount % 40 == 0) {
                            // empty if block
                        }
                        this.setAIState(RavenAIState.ROAM_FLY);
                        this.landing.resetLandingState("out-of-bounds", this);
                        this.idleLockTicks = 0;
                        this.idleLeafLossTicks = 0;
                        Vec3 ret = this.homeCenterReturnTarget();
                        long seed = this.getUUID().getMostSignificantBits() ^ (long)this.tickCount;
                        boolean ok = this.ensurePathTo(ret, 200, seed, "out-of-bounds return");
                        if (!ok) {
                            this.setFlyTarget(ret, 200);
                        }
                        if (this.roamTicksRemaining <= 0) {
                            this.beginRoamFlightWindow("out-of-bounds return");
                            this.clearPlannedPath("override roam path with return");
                            boolean ok2 = this.ensurePathTo(ret, 200, seed ^ 0xBADC0FFEE0DDF00DL, "out-of-bounds return (after roam window)");
                            if (!ok2) {
                                this.setFlyTarget(ret, 200);
                            }
                        }
                    }
                    Player owner = this.lureFollowTame != null ? this.lureFollowTame.getOwnerPlayerServerSafe() : null;
                    boolean scrollSummonFollowLock = this.isScrollSummonFollowLockActive();
                    boolean bl = canFollow = owner != null && this.isTame() && (scrollSummonFollowLock || this.getFollowCooldownTicks() <= 0);
                    if (this.playerAvoidanceOverrideTicks <= 0) {
                        if (canFollow) {
                            this.setAIState(RavenAIState.FOLLOW_OWNER);
                        } else {
                            RavenAIState st = this.getAIStateForDebug();
                            if (st == RavenAIState.FOLLOW_OWNER) {
                                this.setAIState(RavenAIState.IDLE_GROUND);
                                this.idleTicksRemaining = 0;
                            }
                        }
                    }
                    switch (this.getAIState()) {
                        case IDLE_GROUND: {
                            this.tickIdleGround();
                            break;
                        }
                        case ROAM_FLY: {
                            this.tickRoamFly();
                            break;
                        }
                        case FOLLOW_OWNER: {
                            if (this.lureFollowTame == null) break;
                            this.lureFollowTame.tickFollowOwner();
                            break;
                        }
                        default: {
                            this.tickIdleGround();
                        }
                    }
                    this.debugDrawPathGizmos("aiStep");
                    boolean skipStuckTeleport = false;
                    if (this.getAIState() != RavenAIState.FOLLOW_OWNER) {
                    }
                    if (this.lureFollowTame == null) {
                    }
                    try {
                        Player p = this.lureFollowTame.getOwnerPlayerServerSafe();
                        if (p == null) {
                            p = this.lureFollowTame.getLureFollowPlayerServerSafe();
                        }
                        if (p != null) {
                            if (this.lureFollowTame.isCloseEnoughToFollowPlayer(p)) {
                                skipStuckTeleport = true;
                            }
                        }
                    }
                    finally {
                        if (skipStuckTeleport) break block42;
                    }
                    this.teleportation.tickTeleportRecoverySampler(this);
                    break block44;
                }
                if (this.tickCount % 40 == 0) {
                    // empty if block
                }
            }
            this.teleportation.tickTeleportFxServer(this);
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tickIdleGround() {
        try {
            boolean hasUnexpectedIntent;
            this.debugAiHeartbeat("tickIdleGround");
            RandomSource rnd = this.getRandom();
            try {
                PlayerAvoidance.tryTriggerPlayerAvoidance(this);
                if (this.getAIState() != RavenAIState.IDLE_GROUND) {
                    if (this.tickCount % 20 != 0) return;
                    return;
                }
            }
            catch (Throwable t) {
                if (this.tickCount % 40 == 0) {
                    // empty if block
                }
            }
            this.setNoGravity(false);
            if (this.getAnimMode() != RavenAnimMode.NO_AIR) {
                this.setAnimMode(RavenAnimMode.NO_AIR);
            }
            boolean bl = hasUnexpectedIntent = this.flyTarget != null && this.flyTargetTimeoutTicks > 0 || this.pathGoal != null || this.pathPendingGoal != null || this.pathWaypoints != null && !this.pathWaypoints.isEmpty();
            if (hasUnexpectedIntent) {
                if (this.tickCount % 20 == 0) {
                    // empty if block
                }
                this.clearFlyTarget();
                this.flyTargetTimeoutTicks = 0;
                this.clearPlannedPath("idle unexpected intent");
                this.pathGoal = null;
                this.pathPendingGoal = null;
                this.pathWaypoints = null;
                this.pathWaypointIndex = 0;
                this.pathRetryCooldownTicks = 0;
            }
            if (this.idleCommitTicks > 0) {
                --this.idleCommitTicks;
            }
            boolean perchValidNow = false;
            BlockPos corner = this.landing.idlePerchCorner;
            if (corner != null) {
                perchValidNow = this.landing.isValidPerchCornerAtTopY(corner, this);
            } else {
                BlockPos feetBlock = BlockPos.containing((double)this.getX(), (double)(this.getBoundingBox().minY - 0.001), (double)this.getZ());
                BlockPos found = this.landing.findValidPerchCornerNearXZ(feetBlock.getX(), feetBlock.getZ(), this);
                if (found != null) {
                    this.landing.idlePerchCorner = found;
                    perchValidNow = this.landing.isValidPerchCornerAtTopY(found, this);
                } else {
                    perchValidNow = false;
                }
            }
            if (!perchValidNow) {
                ++this.idleLeafLossTicks;
                if (this.tickCount % 20 == 0) {
                    // empty if block
                }
                if (this.idleLeafLossTicks > 20) {
                    String leaveReason = "idle perch invalid for " + this.idleLeafLossTicks + " ticks";
                    if (this.tickCount % 20 == 0) {
                        // empty if block
                    }
                    this.setAIState(RavenAIState.ROAM_FLY);
                    this.idleLockTicks = 12;
                    this.roamTicksRemaining = 0;
                    this.landing.resetLandingState("idle left: " + leaveReason, this);
                    this.clearPlannedPath("idle left: " + leaveReason);
                    this.clearFlyTarget();
                    this.beginRoamFlightWindow("idle left: perch invalid");
                    return;
                }
            } else {
                if (this.idleLeafLossTicks <= 0 || this.tickCount % 40 == 0) {
                    // empty if block
                }
                this.idleLeafLossTicks = 0;
            }
            if (this.idleTicksRemaining > 0) {
                --this.idleTicksRemaining;
            }
            if (this.idleNextTurnTicks > 0) {
                --this.idleNextTurnTicks;
            } else {
                this.idleTargetYaw = this.getYRot() + (rnd.nextFloat() - 0.5f) * 90.0f;
                this.idleNextTurnTicks = 15 + rnd.nextInt(60);
            }
            float curYaw = this.getYRot();
            float newYaw = Mth.approachDegrees((float)curYaw, (float)this.idleTargetYaw, (float)4.0f);
            this.setYRot(newYaw);
            this.setYHeadRot(newYaw);
            this.yBodyRot = newYaw;
            if (this.idleTicksRemaining <= 0) {
                if (this.idleCommitTicks > 0) {
                    if (this.tickCount % 40 == 0) {
                        // empty if block
                    }
                } else {
                    String leaveReason = "idle timer expired";
                    if (this.tickCount % 20 == 0) {
                        // empty if block
                    }
                    this.setAIState(RavenAIState.ROAM_FLY);
                    this.idleLockTicks = 12;
                    this.roamTicksRemaining = 0;
                    this.landing.resetLandingState("idle left: " + leaveReason, this);
                    this.clearPlannedPath("idle left: " + leaveReason);
                    this.clearFlyTarget();
                    this.beginRoamFlightWindow("idle left: timer expired");
                    return;
                }
            }
            this.tickAmbientCawing();
            if (this.tickCount % 200 != 0) return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tickRoamFly() {
        try {
            block77: {
                block80: {
                    this.debugAiHeartbeat("tickRoamFly");
                    try {
                        if (this.playerAvoidanceRearmCooldownTicks > 0) {
                            --this.playerAvoidanceRearmCooldownTicks;
                        }
                    }
                    catch (Throwable var1_1) {
                        // empty catch block
                    }
                    try {
                        if (this.playerAvoidanceOverrideTicks > 0) {
                            --this.playerAvoidanceOverrideTicks;
                        }
                    }
                    catch (Throwable var1_2) {
                        // empty catch block
                    }
                    rnd = this.getRandom();
                    this.tickAmbientCawing();
                    try {
                        PlayerAvoidance.tryTriggerPlayerAvoidance(this);
                    }
                    finally {
                        if (this.playerAvoidanceOverrideTicks <= 0) break block77;
                    }
                    stillOverriding = true;
                    if (this.flyTarget == null) break block78;
                    pos = this.position();
                    d2 = pos.distanceToSqr(this.flyTarget);
                    ARRIVE_EPS = 0.6;
                    if (!(d2 <= 0.36)) break block79;
                    this.clearFlyTarget();
                    this.flyTargetTimeoutTicks = 0;
                    if (this.playerAvoidanceOverrideTicks > 0) {
                        this.playerAvoidanceOverrideTicks = 0;
                    }
                    if (this.playerAvoidanceRearmCooldownTicks < 40) {
                        this.playerAvoidanceRearmCooldownTicks = 40;
                    }
                    stillOverriding = false;
                    if (this.tickCount % 40 != 0) break block80;
                }
                ** finally { 
                {
                    block78: {
                        block79: {
                        }
                    }
                }
lbl45:
                // 1 sources

                if (stillOverriding && this.playerAvoidanceOverrideTicks > 0) {
                    try {
                        this.landing.resetLandingState("player avoidance override tick", this);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.landingPhase = LandingPhase.NONE;
                    this.landing.landingLeafPos = null;
                    this.landingTicks = 0;
                    this.setNoGravity(true);
                    if (this.getAnimMode() != RavenAnimMode.IN_AIR) {
                        this.setAnimMode(RavenAnimMode.IN_AIR);
                    }
                    this.roamTicksRemaining = 0;
                    this.idleLockTicks = 0;
                    didMove = false;
                    try {
                        if (this.flyTarget != null && this.flyTargetTimeoutTicks > 0) {
                            --this.flyTargetTimeoutTicks;
                            this.flyTowardTarget(0.25);
                            didMove = true;
                        }
                    }
                    catch (Throwable t) {
                        if (this.tickCount % 40 == 0) {
                            // empty if block
                        }
                    }
                    try {
                        if (!didMove && this.pathWaypoints != null && !this.pathWaypoints.isEmpty() && this.pathWaypointIndex < this.pathWaypoints.size()) {
                            this.advanceWaypointIfNeeded(80, "player avoidance override");
                            didMove = true;
                        }
                    }
                    catch (Throwable t) {
                        if (this.tickCount % 40 == 0) {
                            // empty if block
                        }
                    }
                    try {
                        this.teleportation.tickRandomFlightTeleportBlink(this);
                    }
                    finally {
                        if (this.tickCount % 40 != 0) return;
                    }
                    return;
                }
            }
            if (this.idleLockTicks > 0) {
                --this.idleLockTicks;
                this.setNoGravity(true);
                if (this.getAnimMode() != RavenAnimMode.IN_AIR) {
                    this.setAnimMode(RavenAnimMode.IN_AIR);
                }
                vel = this.getDeltaMovement();
                vy = vel.y;
                if (vy < 0.18) {
                    vy = 0.18;
                }
                if (vy > 0.32) {
                    vy = 0.32;
                }
                this.setDeltaMovement(vel.x, vy, vel.z);
                if (!(this.pathWaypoints != null && !this.pathWaypoints.isEmpty() || this.flyTarget != null && this.flyTargetTimeoutTicks > 0)) {
                    roamTarget = this.pickRoamFallbackTarget(rnd);
                    if (roamTarget != null) {
                        seed = this.getUUID().getLeastSignificantBits() ^ (long)this.tickCount ^ 324508639L;
                        ok = this.ensurePathTo(roamTarget, 80, seed, "takeoff lock roam");
                        if (!ok) {
                            this.setFlyTarget(roamTarget, 80);
                        }
                    } else {
                        this.clearPlannedPath("takeoff lock no roam target");
                        this.clearFlyTarget();
                    }
                }
                if (this.flyTarget != null) {
                    if (this.flyTargetTimeoutTicks > 0) {
                        --this.flyTargetTimeoutTicks;
                    }
                    this.maybeAvoidOrRetargetDuringFlight(rnd);
                    this.flyTowardTarget(0.25);
                } else if (this.pathWaypoints != null && !this.pathWaypoints.isEmpty()) {
                    this.advanceWaypointIfNeeded(80, "takeoff lock advance");
                }
                try {
                    this.teleportation.tickRandomFlightTeleportBlink(this);
                }
                finally {
                    if (this.tickCount % 120 != 0) return;
                }
                return;
            }
            if (!this.isNoGravity() && this.landing.isOnValidPerchNow(this)) {
                if (this.tickCount % 40 == 0) {
                    // empty if block
                }
                this.landing.enterIdleFromLanding("ROAM_FLY: centered on valid 2x2 perch (not flying)", this);
                return;
            }
            if (this.landingPhase != LandingPhase.NONE) {
                ++this.landingTicks;
                if (this.landingTicks > 160) {
                    if (this.tickCount % 80 == 0) {
                        // empty if block
                    }
                    this.landing.resetLandingState("landing timeout", this);
                    this.clearPlannedPath("landing timeout");
                }
            } else {
                this.landingTicks = 0;
            }
            if (this.landing.landingLeafPos != null && !this.landing.isStillValidLandingLeaf(this.landing.landingLeafPos, this)) {
                if (this.tickCount % 80 == 0) {
                    // empty if block
                }
                this.landing.resetLandingState("invalid leaf", this);
                this.clearPlannedPath("invalid landing leaf");
            }
            if (this.landingPhase == LandingPhase.NONE && this.roamTicksRemaining > 0) {
                --this.roamTicksRemaining;
                this.setNoGravity(true);
                if (this.getAnimMode() != RavenAnimMode.IN_AIR) {
                    this.setAnimMode(RavenAnimMode.IN_AIR);
                }
                if (!(this.pathWaypoints != null && !this.pathWaypoints.isEmpty() && this.pathWaypointIndex < this.pathWaypoints.size() || this.flyTarget != null && this.flyTargetTimeoutTicks > 0)) {
                    roamTarget = this.pickRoamFallbackTarget(rnd);
                    if (roamTarget != null) {
                        seed = this.getUUID().getMostSignificantBits() ^ (long)this.tickCount ^ 3405691582L;
                        ok = this.ensurePathTo(roamTarget, 80, seed, "roam window");
                        if (!ok) {
                            this.setFlyTarget(roamTarget, 80);
                        }
                    } else {
                        this.clearPlannedPath("roam window no target");
                        this.clearFlyTarget();
                        this.setDeltaMovement(Vec3.ZERO);
                    }
                }
                if (this.flyTarget != null) {
                    this.maybeAvoidOrRetargetDuringFlight(rnd);
                    if (this.flyTargetTimeoutTicks > 0) {
                        --this.flyTargetTimeoutTicks;
                    }
                    this.flyTowardTarget(0.25);
                }
                if (this.pathWaypoints != null && !this.pathWaypoints.isEmpty()) {
                    this.advanceWaypointIfNeeded(80, "roam window");
                }
                try {
                    this.teleportation.tickRandomFlightTeleportBlink(this);
                    return;
                }
                catch (Throwable t) {
                    if (this.tickCount % 40 != 0) return;
                }
                return;
            }
            if (this.landingPhase != LandingPhase.NONE) {
                this.landing.tickLandingStateMachine(rnd, this);
                return;
            }
            leaf = this.landing.pickLandingLeafBlock(rnd, this);
            if (leaf == null) {
                this.roamTicksRemaining = extra = 20 + rnd.nextInt(60);
                this.setNoGravity(true);
                if (this.getAnimMode() != RavenAnimMode.IN_AIR) {
                    this.setAnimMode(RavenAnimMode.IN_AIR);
                }
                if (!(this.pathWaypoints != null && !this.pathWaypoints.isEmpty() || this.flyTarget != null && this.flyTargetTimeoutTicks > 0)) {
                    roamTarget = this.pickRoamFallbackTarget(rnd);
                    if (roamTarget != null) {
                        seed = this.getUUID().getLeastSignificantBits() ^ (long)this.tickCount ^ 3735928559L;
                        ok = this.ensurePathTo(roamTarget, 80, seed, "landing allowed but no leaf -> roam");
                        if (!ok) {
                            this.setFlyTarget(roamTarget, 80);
                        }
                    } else {
                        this.clearPlannedPath("no leaf roam no target");
                        this.clearFlyTarget();
                        this.setDeltaMovement(Vec3.ZERO);
                    }
                }
                try {
                    this.teleportation.tickRandomFlightTeleportBlink(this);
                }
                finally {
                    if (this.tickCount % 120 != 0) return;
                }
                return;
            }
            this.landing.landingLeafPos = leaf;
            this.landingPhase = LandingPhase.FLY_TO_OVERHEAD;
            this.landingTicks = 0;
            overhead = this.landing.overheadTargetForLeaf(leaf, this);
            this.setNoGravity(true);
            if (this.getAnimMode() != RavenAnimMode.IN_AIR) {
                this.setAnimMode(RavenAnimMode.IN_AIR);
            }
            this.clearPlannedPath("starting landing -> plan overhead");
            seed = this.getUUID().getMostSignificantBits() ^ (long)this.tickCount ^ leaf.asLong();
            ok = this.ensurePathTo(overhead, 120, seed, "landing FLY_TO_OVERHEAD init");
            if (!ok) {
                this.setFlyTarget(overhead, 120);
            }
            if (this.tickCount % 120 != 0) return;
        }
        catch (Throwable var1_4) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beginRoamFlightWindow(String reason) {
        try {
            RandomSource rnd = this.getRandom();
            int span = Math.max(1, 121);
            int ticks = 80 + rnd.nextInt(span);
            this.roamTicksRemaining = Math.max(1, ticks);
            this.landing.resetLandingState("beginRoamFlightWindow: " + reason, this);
            this.setNoGravity(true);
            if (this.getAnimMode() != RavenAnimMode.IN_AIR) {
                this.setAnimMode(RavenAnimMode.IN_AIR);
            }
            this.clearPlannedPath("beginRoamFlightWindow: " + reason);
            Vec3 roamTarget = this.pickRoamFallbackTarget(rnd);
            if (roamTarget != null) {
                long seed = this.getUUID().getLeastSignificantBits() ^ (long)this.tickCount ^ (long)reason.hashCode();
                boolean ok = this.ensurePathTo(roamTarget, 80, seed, "beginRoamFlightWindow");
                if (!ok) {
                    this.setFlyTarget(roamTarget, 80);
                }
            } else {
                this.clearFlyTarget();
            }
            if (this.idleLockTicks <= 0) {
                this.idleLockTicks = 12;
            }
            if (this.tickCount % 120 != 0) return;
        }
        catch (Throwable t) {
            this.roamTicksRemaining = Math.max(1, 80);
            if (this.idleLockTicks > 0) return;
            this.idleLockTicks = 12;
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        try {
            if (player == null) {
                return InteractionResult.PASS;
            }
            ItemStack stack = player.getItemInHand(hand);
            try {
                InteractionResult scrollResult = TamedRavenScrollWatcher.handleSealedScrollInteract(this, player, hand);
                if (scrollResult.consumesAction()) {
                    return scrollResult;
                }
            }
            catch (Throwable scrollResult) {
                // empty catch block
            }
            try {
                InteractionResult lureResult;
                if (this.lureFollowTame != null && (lureResult = this.lureFollowTame.handleTamingInteract(player, hand)).consumesAction()) {
                    return lureResult;
                }
            }
            catch (Throwable lureResult) {
                // empty catch block
            }
            InteractionResult base = super.mobInteract(player, hand);
            return base;
        }
        catch (Throwable t) {
            return InteractionResult.PASS;
        }
    }

    private double horizontalDistanceTo(Vec3 a, Vec3 b) {
        double dx = a.x - b.x;
        double dz = a.z - b.z;
        return Math.sqrt(dx * dx + dz * dz);
    }

    @Nullable
    private Vec3 pickRoamFallbackTarget(RandomSource rnd) {
        try {
            double hx = (double)this.homePos.getX() + 0.5;
            double hz = (double)this.homePos.getZ() + 0.5;
            double angle = rnd.nextDouble() * (Math.PI * 2);
            double radius = 4.0 + rnd.nextDouble() * 46.0;
            double x = hx + Math.cos(angle) * radius;
            double z = hz + Math.sin(angle) * radius;
            double y = (double)this.clampYToHomeBounds(this.homePos.getY() + rnd.nextInt(9) - 4) + 0.25;
            Vec3 target = new Vec3(x, y, z);
            return this.clampTargetToHomeBounds(target);
        }
        catch (Throwable t) {
            if (this.tickCount % 200 == 0) {
                // empty if block
            }
            return null;
        }
    }

    private void maybeAvoidOrRetargetDuringFlight(RandomSource rnd) {
        long seed;
        boolean ok;
        boolean pathBlocked;
        if (this.flyTarget == null) {
            return;
        }
        if (this.tickCount < 10) {
            return;
        }
        Vec3 pos = this.position();
        Vec3 vel = this.getDeltaMovement();
        double speedSqr = vel.lengthSqr();
        if (speedSqr < 4.0E-4) {
            return;
        }
        double dist = pos.distanceTo(this.flyTarget);
        if (!Double.isNaN(this.lastDistToTarget)) {
            double progress = this.lastDistToTarget - dist;
            this.stuckTicks = progress < 0.06 ? ++this.stuckTicks : Math.max(0, this.stuckTicks - 2);
        }
        this.lastDistToTarget = dist;
        boolean collisionNow = this.horizontalCollision || this.verticalCollision;
        boolean collisionPersistent = collisionNow && this.stuckTicks >= 3;
        boolean rayBlocked = this.isDirectPathBlocked(pos, this.flyTarget);
        boolean bl = pathBlocked = rayBlocked || collisionPersistent;
        if (!collisionPersistent || this.tickCount % 20 == 0) {
            // empty if block
        }
        if (this.pathGoal != null && pathBlocked && this.pathRetryCooldownTicks <= 0 && (ok = this.ensurePathTo(this.pathGoal, 100, seed = this.getUUID().getLeastSignificantBits() ^ (long)this.tickCount ^ 0xA57C1EADL, collisionPersistent ? "collision-persistent" : "blocked"))) {
            this.advanceWaypointIfNeeded(100, "collision replan");
            this.stuckTicks = 0;
            if (this.tickCount % 20 == 0) {
                // empty if block
            }
            return;
        }
        if (pathBlocked && this.avoidanceCooldownTicks <= 0) {
            this.avoidanceCooldownTicks = 8;
            Vec3 avoidance = this.computeAvoidanceWaypoint(pos, this.flyTarget, rnd);
            if (avoidance != null) {
                this.setFlyTarget(avoidance, 80);
                this.stuckTicks = 0;
                if (this.tickCount % 20 == 0) {
                    // empty if block
                }
                return;
            }
        }
        if (this.stuckTicks >= 30) {
            this.clearFlyTarget();
            this.setDeltaMovement(Vec3.ZERO);
            if (this.tickCount % 20 == 0) {
                // empty if block
            }
        }
    }

    private void maybeAvoidOrRetargetDuringFlightApproachOnly(RandomSource rnd) {
        if (this.flyTarget == null) {
            return;
        }
        Vec3 pos = this.position();
        double dist = pos.distanceTo(this.flyTarget);
        if (!Double.isNaN(this.lastDistToTarget)) {
            double progress = this.lastDistToTarget - dist;
            this.stuckTicks = progress < 0.06 ? ++this.stuckTicks : Math.max(0, this.stuckTicks - 2);
        }
        this.lastDistToTarget = dist;
        boolean pathBlocked = this.isDirectPathBlocked(pos, this.flyTarget);
        if ((pathBlocked || this.stuckTicks >= 30) && this.avoidanceCooldownTicks <= 0) {
            long seed;
            boolean ok;
            this.avoidanceCooldownTicks = 8;
            if (this.pathGoal != null && (ok = this.ensurePathTo(this.pathGoal, 80, seed = this.getUUID().getMostSignificantBits() ^ (long)this.tickCount ^ 0xABCDEF12345L, "landing approach replan"))) {
                this.advanceWaypointIfNeeded(80, "landing approach replan");
                if (this.tickCount % 120 == 0) {
                    // empty if block
                }
                return;
            }
            Vec3 avoidance = this.computeAvoidanceWaypoint(pos, this.flyTarget, rnd);
            if (avoidance != null) {
                this.setFlyTarget(avoidance, 60);
                if (this.tickCount % 120 == 0) {
                    // empty if block
                }
                return;
            }
            if (this.tickCount % 120 == 0) {
                // empty if block
            }
        }
    }

    private boolean isDirectPathBlocked(Vec3 from, Vec3 to) {
        try {
            double targetDistSqr;
            BlockHitResult hit = this.level().clip(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hit.getType() == HitResult.Type.MISS) {
                return false;
            }
            double hitDistSqr = hit.getLocation().distanceToSqr(from);
            return hitDistSqr < (targetDistSqr = to.distanceToSqr(from)) - 0.25;
        }
        catch (Throwable t) {
            if (this.tickCount % 200 == 0) {
                // empty if block
            }
            return false;
        }
    }

    @Nullable
    private Vec3 computeAvoidanceWaypoint(Vec3 pos, Vec3 target, RandomSource rnd) {
        try {
            Vec3 to = target.subtract(pos);
            double len = to.length();
            if (len < 1.0E-4) {
                return null;
            }
            Vec3 dir = to.scale(1.0 / len);
            Vec3 side = new Vec3(-dir.z, 0.0, dir.x);
            if (side.lengthSqr() < 1.0E-4) {
                side = new Vec3(1.0, 0.0, 0.0);
            }
            side = side.normalize();
            double sideSign = rnd.nextBoolean() ? 1.0 : -1.0;
            double sideMag = 3.0 + rnd.nextDouble() * 6.0;
            double upMag = 2.5 + rnd.nextDouble() * 4.5;
            double forwardMag = 4.0 + rnd.nextDouble() * 6.0;
            Vec3 waypoint = pos.add(dir.scale(forwardMag)).add(side.scale(sideMag * sideSign)).add(0.0, upMag, 0.0);
            waypoint = this.clampTargetToHomeBounds(waypoint);
            return waypoint;
        }
        catch (Throwable t) {
            if (this.tickCount % 200 == 0) {
                // empty if block
            }
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void flyTowardTarget(double speed) {
        try {
            Vec3 newVel;
            Vec3 actualTarget = null;
            actualTarget = this.pathWaypoints != null && !this.pathWaypoints.isEmpty() && this.pathWaypointIndex >= 0 && this.pathWaypointIndex < this.pathWaypoints.size() ? this.pathWaypoints.get(this.pathWaypointIndex) : this.flyTarget;
            if (actualTarget == null) {
                return;
            }
            Vec3 pos = this.position();
            Vec3 to = actualTarget.subtract(pos);
            double dist = to.length();
            if (dist < 1.2) {
                return;
            }
            Vec3 dir = to.normalize();
            double scaledSpeed = speed;
            if (dist < 6.0) {
                scaledSpeed = speed * 0.65;
            }
            Vec3 desiredVel = dir.scale(scaledSpeed);
            boolean collH = this.horizontalCollision;
            boolean collV = this.verticalCollision;
            double vx = desiredVel.x;
            double vy = desiredVel.y;
            double vz = desiredVel.z;
            if (collH) {
                vx *= 0.35;
                vz *= 0.35;
            }
            if (collV) {
                vy *= 0.35;
            }
            if ((newVel = new Vec3(vx, vy, vz)).lengthSqr() < 5.0E-4) {
                RandomSource rnd = this.getRandom();
                newVel = new Vec3((rnd.nextDouble() - 0.5) * 0.08, 0.06, (rnd.nextDouble() - 0.5) * 0.08);
                if (this.tickCount % 40 == 0) {
                    // empty if block
                }
            }
            this.setDeltaMovement(newVel);
            float yaw = (float)(Math.atan2(newVel.z, newVel.x) * 57.29577951308232) - 90.0f;
            this.setYRot(yaw);
            this.setYHeadRot(yaw);
            this.yBodyRot = yaw;
            if (this.tickCount % 40 != 0) return;
        }
        catch (Throwable t) {
            if (this.tickCount % 40 != 0) return;
        }
    }

    private boolean isPathExhausted() {
        try {
            return this.pathWaypoints == null || this.pathWaypoints.isEmpty() || this.pathWaypointIndex < 0 || this.pathWaypointIndex >= this.pathWaypoints.size();
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
            return true;
        }
    }

    public BlockPos getHomePosPublic() {
        try {
            return this.homePos;
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
            return this.blockPosition();
        }
    }

    public int getHomeRadiusBlocksPublic() {
        try {
            return 50;
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
            return 50;
        }
    }

    @Nullable
    public Vec3 getHomeCenterVec() {
        return new Vec3((double)this.homePos.getX() + 0.5, (double)this.homePos.getY() + 0.5, (double)this.homePos.getZ() + 0.5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void forceRoamFlightFromThreat(Vec3 fleeTarget, Player threat) {
        try {
            boolean ok;
            Vec3 playerPos;
            if (fleeTarget == null) return;
            if (threat == null) {
                return;
            }
            Vec3 ravenPos = this.position();
            try {
                playerPos = threat.position();
            }
            catch (Throwable t) {
                playerPos = fleeTarget;
            }
            this.clearPlannedPath("player avoidance");
            this.clearFlyTarget();
            this.setAIState(RavenAIState.ROAM_FLY);
            this.roamTicksRemaining = 0;
            this.landing.resetLandingState("player avoidance", this);
            this.idleCommitTicks = 0;
            this.idleLockTicks = 0;
            this.setNoGravity(true);
            if (this.getAnimMode() != RavenAnimMode.IN_AIR) {
                this.setAnimMode(RavenAnimMode.IN_AIR);
            }
            long baseSeed = this.getUUID().getLeastSignificantBits() ^ (long)this.tickCount ^ threat.getUUID().getMostSignificantBits() ^ 0xF1EEBEEFL;
            boolean okPrimary = false;
            boolean okFallback = false;
            Vec3 usedGoal = fleeTarget;
            try {
                okPrimary = this.ensurePathTo(fleeTarget, 120, baseSeed, "player avoidance flee");
            }
            catch (Throwable t) {
                okPrimary = false;
                if (this.tickCount % 40 == 0) {
                    // empty if block
                }
            }
            if (!okPrimary) {
                Vec3 homeCenter = null;
                try {
                    homeCenter = this.getHomeCenterVec();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (homeCenter != null) {
                    Vec3 away = homeCenter.subtract(playerPos);
                    if (away.lengthSqr() < 1.0E-4) {
                        away = ravenPos.subtract(playerPos);
                    }
                    if (away.lengthSqr() < 1.0E-4) {
                        away = new Vec3(1.0, 0.0, 0.0);
                    }
                    away = away.normalize();
                    double dist = 16.0;
                    Vec3 fallbackGoal = homeCenter.add(away.scale(dist));
                    fallbackGoal = this.clampTargetToHomeBounds(fallbackGoal);
                    long fallbackSeed = baseSeed ^ 0xA5A5A5A5L;
                    try {
                        okFallback = this.ensurePathTo(fallbackGoal, 120, fallbackSeed, "player avoidance flee (fallback)");
                    }
                    catch (Throwable t) {
                        okFallback = false;
                        if (this.tickCount % 40 == 0) {
                            // empty if block
                        }
                    }
                    if (okFallback) {
                        usedGoal = fallbackGoal;
                        if (this.tickCount % 20 == 0) {
                            // empty if block
                        }
                    } else if (this.tickCount % 40 != 0) {
                        // empty if block
                    }
                } else if (this.tickCount % 40 == 0) {
                    // empty if block
                }
            }
            boolean bl = ok = okPrimary || okFallback;
            if (ok ? this.tickCount % 20 == 0 : this.tickCount % 40 == 0) {
                // empty if block
            }
            this.idleCommitTicks = 40;
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hurt(DamageSource source, float amount) {
        try {
            if (this.isInvulnerableTo(source)) {
                try {
                    if (this.level().isClientSide) return false;
                    this.teleportation.requestDamageBlinkTeleport(source, amount, "invulnerable-hurt", this);
                    return false;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return false;
            }
            boolean dodge = false;
            try {
                dodge = DamageDodge.handleHurt(this, source, amount);
            }
            catch (Throwable t) {
                if (this.tickCount % 80 == 0) {
                    // empty if block
                }
                dodge = false;
            }
            if (dodge) {
                if (this.tickCount % 20 != 0) return false;
                return false;
            }
            boolean result = super.hurt(source, amount);
            if (this.tickCount % 20 == 0) {
                // empty if block
            }
            if (!result || this.level().isClientSide || !this.isAlive()) return result;
            try {
                Level level = this.level();
                if (!(level instanceof ServerLevel)) return result;
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 pos = this.position();
                double fxX = pos.x();
                double fxY = pos.y() + 0.6;
                double fxZ = pos.z();
                int count = FeatherParticles.getFeathersPerBurst();
                serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)FFNeoForgeParticles.FEATHER.get()), fxX, fxY, fxZ, count, 0.4, 0.25, 0.4, 0.0);
                if (this.tickCount % 40 != 0) return result;
            }
            catch (Throwable tFx) {
                if (this.tickCount % 80 != 0) return result;
            }
            return result;
        }
        catch (Throwable t) {
            if (this.tickCount % 40 == 0) {
                // empty if block
            }
            try {
                return super.hurt(source, amount);
            }
            catch (Throwable t2) {
                if (this.tickCount % 40 != 0) return false;
                return false;
            }
        }
    }

    public void die(DamageSource source) {
        try {
            super.die(source);
        }
        catch (Throwable t) {
            if (this.tickCount % 40 == 0) {
                // empty if block
            }
        }
        try {
            if (!this.level().isClientSide) {
                TamedRavenDeathHandler.onRavenDeath(this, source);
            }
        }
        catch (Throwable t) {
            if (this.tickCount % 40 == 0) {
                // empty if block
            }
        }
    }

    private RavenAIState getAIStateForDebug() {
        try {
            if (this.playerAvoidanceOverrideTicks > 0) {
                return RavenAIState.AVOID_PLAYER;
            }
            return this.getAIState();
        }
        catch (Throwable t) {
            if (this.tickCount % 200 == 0) {
                // empty if block
            }
            return this.getAIState();
        }
    }

    private Vec3 computeSafePathingGoal(Vec3 rawGoal, RavenAStarPathing.Config cfg) {
        try {
            Vec3[] baseCandidates;
            if (rawGoal == null) {
                return null;
            }
            if (cfg == null) {
                cfg = new RavenAStarPathing.Config();
            }
            int clearanceXZ = Math.max(1, cfg.cellSize);
            int clearanceH = Math.max(1, cfg.clearanceHeight);
            boolean safetyR = true;
            boolean safetyUp = true;
            boolean safetyDown = false;
            double snapX = Math.floor(rawGoal.x) + 0.5;
            double snapZ = Math.floor(rawGoal.z) + 0.5;
            int maxR = 4;
            int[] yOffsets = new int[]{0, 1, -1, 2, -2};
            for (Vec3 base : baseCandidates = new Vec3[]{rawGoal, new Vec3(snapX, rawGoal.y, snapZ), new Vec3(Mth.lerp((double)0.35, (double)rawGoal.x, (double)snapX), rawGoal.y, Mth.lerp((double)0.35, (double)rawGoal.z, (double)snapZ))}) {
                for (int r = 0; r <= 4; ++r) {
                    for (int dx = -r; dx <= r; ++dx) {
                        int[] dzOptions;
                        int[] nArray;
                        int dzAbs = r - Math.abs(dx);
                        if (dzAbs == 0) {
                            int[] nArray2 = new int[1];
                            nArray = nArray2;
                            nArray2[0] = 0;
                        } else {
                            int[] nArray3 = new int[2];
                            nArray3[0] = dzAbs;
                            nArray = nArray3;
                            nArray3[1] = -dzAbs;
                        }
                        for (int dz : dzOptions = nArray) {
                            for (int dy : yOffsets) {
                                Vec3 cand = new Vec3(base.x + (double)dx, base.y + (double)dy, base.z + (double)dz);
                                if (!this.looksLocallyPassableForClearance(cand, clearanceXZ, clearanceH, cfg.allowLeaves, cfg.allowReplaceables) || !this.looksLocallyPassableSafetyBuffer(cand, clearanceXZ, clearanceH, 1, 1, 0, cfg.allowLeaves, cfg.allowReplaceables)) continue;
                                if (this.tickCount % 20 == 0) {
                                    boolean changed;
                                    boolean bl = changed = cand.distanceToSqr(rawGoal) > 1.0E-6;
                                    if (changed) {
                                        // empty if block
                                    }
                                }
                                return cand;
                            }
                        }
                    }
                }
            }
            if (this.tickCount % 40 == 0) {
                // empty if block
            }
            return rawGoal;
        }
        catch (Throwable t) {
            if (this.tickCount % 40 == 0) {
                // empty if block
            }
            return rawGoal;
        }
    }

    private boolean looksLocallyPassableSafetyBuffer(Vec3 center, int clearanceXZ, int clearanceH, int rXZ, int yUp, int yDown, boolean allowLeaves, boolean allowReplaceables) {
        try {
            if (center == null) {
                return false;
            }
            int ax = Mth.floor((double)(center.x + 1.0E-4));
            int ay = Mth.floor((double)(center.y + 1.0E-4));
            int az = Mth.floor((double)(center.z + 1.0E-4));
            int centerX = ax + Math.max(0, clearanceXZ / 2);
            int centerY = ay + Math.max(0, clearanceH / 2);
            int centerZ = az + Math.max(0, clearanceXZ / 2);
            int rx = Math.max(0, rXZ);
            int up = Math.max(0, yUp);
            int down = Math.max(0, yDown);
            for (int dx = -rx; dx <= rx; ++dx) {
                for (int dz = -rx; dz <= rx; ++dz) {
                    for (int dy = -down; dy <= up; ++dy) {
                        BlockPos p = new BlockPos(centerX + dx, centerY + dy, centerZ + dz);
                        if (this.level().isEmptyBlock(p)) continue;
                        BlockState st = this.level().getBlockState(p);
                        if (st == null) {
                            return false;
                        }
                        if (allowLeaves && st.is(BlockTags.LEAVES) || allowReplaceables && st.canBeReplaced()) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static int lerpRgb(int c1, int c2, float t) {
        t = Mth.clamp((float)t, (float)0.0f, (float)1.0f);
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return r << 16 | g << 8 | b;
    }

    private void debugClearOldPathMarkers(ServerLevel serverLevel) {
        try {
            if (this.debugPathMarkerIds != null && !this.debugPathMarkerIds.isEmpty()) {
                for (Integer id : this.debugPathMarkerIds) {
                    if (id == null) continue;
                    try {
                        Entity e = serverLevel.getEntity(id.intValue());
                        if (!(e instanceof ArmorStand)) continue;
                        ArmorStand stand2 = (ArmorStand)e;
                        stand2.discard();
                    }
                    catch (Throwable e) {}
                }
                this.debugPathMarkerIds.clear();
            }
            double r = 96.0;
            AABB box = this.getBoundingBox().inflate(96.0);
            List candidates = serverLevel.getEntitiesOfClass(ArmorStand.class, box, stand -> {
                if (stand.getTags().contains(DEBUG_PATH_GIZMO_TAG)) {
                    return true;
                }
                if (!stand.isInvisible()) {
                    return false;
                }
                if (!stand.isInvulnerable()) {
                    return false;
                }
                if (!stand.isNoGravity()) {
                    return false;
                }
                Component nameComp = stand.getCustomName();
                if (nameComp == null) {
                    return false;
                }
                String name = nameComp.getString();
                if (name == null || name.isEmpty()) {
                    return false;
                }
                if ("Goal".equalsIgnoreCase(name) || "End".equalsIgnoreCase(name)) {
                    return true;
                }
                boolean allDigits = true;
                for (int i = 0; i < name.length(); ++i) {
                    if (Character.isDigit(name.charAt(i))) continue;
                    allDigits = false;
                    break;
                }
                return allDigits;
            });
            for (ArmorStand stand3 : candidates) {
                try {
                    stand3.discard();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    private boolean isScrollSummonFollowLockActive() {
        try {
            Level level = this.level();
            if (!(level instanceof ServerLevel)) {
                return false;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer owner = TamedRavenScrollWatcher.getScrollSummonOwnerIfHoldingScroll(serverLevel, this);
            if (owner == null) {
                return false;
            }
            if (this.tickCount % 80 == 0) {
                try {
                    String string = owner.getGameProfile().getName();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
            return false;
        }
    }

    private void debugSpawnWaypointMarker(ServerLevel level, Vec3 pos, String label, int rgb) {
        try {
            if (level == null || pos == null) {
                return;
            }
            ArmorStand stand = (ArmorStand)EntityType.ARMOR_STAND.create((Level)level);
            if (stand == null) {
                return;
            }
            try {
                try {
                    Method mSetMarker = ArmorStand.class.getDeclaredMethod("setMarker", Boolean.TYPE);
                    mSetMarker.setAccessible(true);
                    mSetMarker.invoke((Object)stand, true);
                }
                catch (Throwable mSetMarker) {
                    // empty catch block
                }
                try {
                    Method mSetSmall = ArmorStand.class.getDeclaredMethod("setSmall", Boolean.TYPE);
                    mSetSmall.setAccessible(true);
                    mSetSmall.invoke((Object)stand, true);
                }
                catch (Throwable mSetSmall) {
                    // empty catch block
                }
                try {
                    Method mSetNoBasePlate = ArmorStand.class.getDeclaredMethod("setNoBasePlate", Boolean.TYPE);
                    mSetNoBasePlate.setAccessible(true);
                    mSetNoBasePlate.invoke((Object)stand, true);
                }
                catch (Throwable mSetNoBasePlate) {}
            }
            catch (Throwable tCfg) {
                if (this.tickCount % 200 == 0) {
                    // empty if block
                }
            }
            stand.setInvisible(true);
            stand.setNoGravity(true);
            stand.setInvulnerable(true);
            stand.setCustomNameVisible(true);
            stand.addTag(DEBUG_PATH_GIZMO_TAG);
            stand.moveTo(pos.x, pos.y + 0.2, pos.z, 0.0f, 0.0f);
            stand.setCustomName((Component)Component.literal((String)label).withStyle(style -> style.withColor(TextColor.fromRgb((int)rgb))));
            level.addFreshEntity((Entity)stand);
            if (this.debugPathMarkerIds != null) {
                this.debugPathMarkerIds.add(stand.getId());
            }
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    private void debugSpawnLineGizmos(ServerLevel level, Vec3 a, Vec3 b, int steps, int rgb) {
        try {
            if (level == null || a == null || b == null || steps <= 1) {
                return;
            }
            for (int i = 1; i < steps; ++i) {
                double t = (double)i / (double)steps;
                double x = Mth.lerp((double)t, (double)a.x, (double)b.x);
                double y = Mth.lerp((double)t, (double)a.y, (double)b.y);
                double z = Mth.lerp((double)t, (double)a.z, (double)b.z);
                Vec3 p = new Vec3(x, y, z);
                this.debugSpawnWaypointMarker(level, p, "\u00b7", rgb);
            }
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    private void debugSpawnCircleGizmos(ServerLevel level, Vec3 center, double radius, int points, int rgb) {
        try {
            if (level == null || center == null || radius <= 0.0 || points <= 0) {
                return;
            }
            for (int i = 0; i < points; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)points;
                double x = center.x + Math.cos(angle) * radius;
                double z = center.z + Math.sin(angle) * radius;
                Vec3 p = new Vec3(x, center.y, z);
                this.debugSpawnWaypointMarker(level, p, "\u25e6", rgb);
            }
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    private void debugDrawPathGizmos(String callerTag) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tickAmbientCawing() {
        try {
            boolean inIdlePerch;
            if (this.level() == null) {
                return;
            }
            if (this.level().isClientSide) {
                return;
            }
            if (!this.isAlive()) {
                return;
            }
            RavenAIState st = this.getAIStateForDebug();
            boolean inRoamFly = st == RavenAIState.ROAM_FLY;
            boolean bl = inIdlePerch = st == RavenAIState.IDLE_GROUND;
            if (!inRoamFly && !inIdlePerch) {
                if (this.ambientCawCooldownTicks <= 200) return;
                this.ambientCawCooldownTicks = 200;
                return;
            }
            if (this.ambientCawCooldownTicks > 0) {
                --this.ambientCawCooldownTicks;
                return;
            }
            RandomSource rnd = this.getRandom();
            int minDelay = 400;
            int extra = 800;
            int rolled = minDelay;
            try {
                if (rnd != null) {
                    rolled = minDelay + rnd.nextInt(extra + 1);
                }
            }
            catch (Throwable ignored) {
                rolled = 600;
            }
            this.ambientCawCooldownTicks = rolled;
            if (SOUND_RAVEN_CAWING_NORMAL_ID == null) {
                if (this.tickCount % 200 != 0) return;
                return;
            }
            String soundId = SOUND_RAVEN_CAWING_NORMAL_ID.toString();
            float volume = 0.9f;
            float pitchMin = 0.95f;
            float pitchMax = 1.05f;
            RavenSoundEngine.playAtWithRandomPitch(this.level(), soundId, SoundSource.NEUTRAL, this.position(), volume, pitchMin, pitchMax, rnd);
            if (this.tickCount % 200 != 0) return;
        }
        catch (Throwable t) {
            if (this.tickCount % 200 != 0) return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void playRavenArriveSound() {
        try {
            if (this.level() == null) {
                return;
            }
            if (!this.isAlive()) {
                return;
            }
            if (SOUND_RAVEN_CAW_WHISTLE_ID == null) {
                if (this.tickCount % 200 != 0) return;
                return;
            }
            String soundId = SOUND_RAVEN_CAW_WHISTLE_ID.toString();
            float volume = 1.0f;
            float pitchMin = 0.98f;
            float pitchMax = 1.02f;
            RavenSoundEngine.playAtWithRandomPitch(this.level(), soundId, SoundSource.NEUTRAL, this.position(), volume, pitchMin, pitchMax, this.getRandom());
            if (this.tickCount % 200 != 0) return;
        }
        catch (Throwable t) {
            if (this.tickCount % 200 != 0) return;
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::mainAnimController));
    }

    private <E extends RavenEntity> PlayState mainAnimController(AnimationState<E> state) {
        try {
            RavenAnimMode mode = this.getAnimMode();
            if (mode == RavenAnimMode.NO_AIR) {
                return state.setAndContinue(ANIM_NO_AIR);
            }
            if (mode == RavenAnimMode.IN_AIR) {
                return state.setAndContinue(ANIM_IN_AIR);
            }
            RavenAIState ai = this.getAIState();
            if (ai == RavenAIState.IDLE_GROUND) {
                return state.setAndContinue(ANIM_NO_AIR);
            }
            return state.setAndContinue(ANIM_IN_AIR);
        }
        catch (Throwable t) {
            if (this.tickCount % 200 == 0) {
                // empty if block
            }
            return PlayState.CONTINUE;
        }
    }

    public boolean simulateAStarPathTo(@NotNull Vec3 goal, int maxPlanTicks, long seed, @NotNull String reason) {
        try {
            boolean ok;
            RavenAIState prevState;
            try {
                prevState = this.getAIStateForDebug();
            }
            catch (Throwable t) {
                prevState = RavenAIState.ROAM_FLY;
            }
            LandingPhase prevLandingPhase = this.landingPhase;
            BlockPos prevLandingLeaf = this.landing != null ? this.landing.landingLeafPos : null;
            int prevIdleLock = this.idleLockTicks;
            int prevAvoidOverride = this.playerAvoidanceOverrideTicks;
            int prevPathFailCd = this.pathFailCooldownTicks;
            int prevPathReplanCd = this.pathReplanCooldownTicks;
            int prevPathRetryCd = this.pathRetryCooldownTicks;
            int prevPathRetryTicks = this.pathRetryTicks;
            Vec3 prevFlyTarget = this.flyTarget;
            int prevFlyTargetTtl = this.flyTargetTimeoutTicks;
            Vec3 prevPathGoal = this.pathGoal;
            Vec3 prevPathPending = this.pathPendingGoal;
            List<Vec3> prevWaypoints = this.pathWaypoints;
            int prevWaypointIdx = this.pathWaypointIndex;
            int prevConsecutiveFails = this.consecutivePathPlanFails;
            boolean prevNoGravity = this.isNoGravity();
            RavenAnimMode prevAnim = this.getAnimMode();
            Vec3 prevVel = this.getDeltaMovement();
            try {
                this.playerAvoidanceOverrideTicks = 0;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.idleLockTicks = 0;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.landingPhase = LandingPhase.NONE;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.landing != null) {
                    this.landing.landingLeafPos = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.pathFailCooldownTicks = 0;
                this.pathReplanCooldownTicks = 0;
                this.pathRetryCooldownTicks = 0;
                this.pathRetryTicks = 0;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.consecutivePathPlanFails = 0;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.setNoGravity(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.getAnimMode() != RavenAnimMode.IN_AIR) {
                    this.setAnimMode(RavenAnimMode.IN_AIR);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.clearFlyTarget();
                this.flyTargetTimeoutTicks = 0;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.clearPlannedPath("simulateAStarPathTo: pre-clear");
                this.pathGoal = null;
                this.pathPendingGoal = null;
                this.pathWaypoints = null;
                this.pathWaypointIndex = 0;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.setAIState(RavenAIState.ROAM_FLY);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                ok = this.ensurePathTo(goal, maxPlanTicks, seed, "simulate: " + reason);
            }
            catch (Throwable t) {
                ok = false;
                if (this.tickCount % 20 == 0) {
                    // empty if block
                }
            }
            if (ok) {
                try {
                    int pts;
                    int n = pts = this.pathWaypoints == null ? 0 : this.pathWaypoints.size();
                    if (pts <= 0) {
                        ok = false;
                        LOG.info("[RavenEntity] simulateAStarPathTo: ensurePathTo returned ok but waypoints empty -> treating as FAIL. goal={} reason={}", (Object)goal, (Object)reason);
                    }
                }
                catch (Throwable pts) {
                    // empty catch block
                }
            }
            if (LOG.isInfoEnabled()) {
                int pts = 0;
                try {
                    pts = this.pathWaypoints == null ? 0 : this.pathWaypoints.size();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                this.clearFlyTarget();
                this.flyTargetTimeoutTicks = 0;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.clearPlannedPath("simulateAStarPathTo: post-clear");
                this.pathGoal = null;
                this.pathPendingGoal = null;
                this.pathWaypoints = null;
                this.pathWaypointIndex = 0;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.setAIState(prevState);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.landingPhase = prevLandingPhase;
            try {
                if (this.landing != null) {
                    this.landing.landingLeafPos = prevLandingLeaf;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.idleLockTicks = prevIdleLock;
            this.playerAvoidanceOverrideTicks = prevAvoidOverride;
            this.pathFailCooldownTicks = prevPathFailCd;
            this.pathReplanCooldownTicks = prevPathReplanCd;
            this.pathRetryCooldownTicks = prevPathRetryCd;
            this.pathRetryTicks = prevPathRetryTicks;
            this.flyTarget = prevFlyTarget;
            this.flyTargetTimeoutTicks = prevFlyTargetTtl;
            this.pathGoal = prevPathGoal;
            this.pathPendingGoal = prevPathPending;
            this.pathWaypoints = prevWaypoints;
            this.pathWaypointIndex = prevWaypointIdx;
            this.consecutivePathPlanFails = prevConsecutiveFails;
            try {
                this.setNoGravity(prevNoGravity);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.getAnimMode() != prevAnim) {
                    this.setAnimMode(prevAnim);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.setDeltaMovement(prevVel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return ok;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public RavenVariant getVariant() {
        try {
            int raw = (Integer)this.entityData.get(DATA_VARIANT);
            return RavenVariant.fromId(raw);
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
            return RavenVariant.NORMAL;
        }
    }

    public void setVariant(RavenVariant variant) {
        try {
            if (variant == null) {
                variant = RavenVariant.NORMAL;
            }
            this.entityData.set(DATA_VARIANT, (Object)variant.id());
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    public TamedRaven getTamedRavenModule() {
        return this.tamedRaven;
    }

    public PlayerAvoidance getPlayerAvoidanceModule() {
        try {
            return this.playeravoidance;
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                RavenEntity.getSharedLogger().warn("[RavenEntity] getPlayerAvoidanceModule failed safely: {}", (Object)t.toString());
            }
            return null;
        }
    }

    public static Logger getSharedLogger() {
        try {
            return LOG;
        }
        catch (Throwable t) {
            return LogUtils.getLogger();
        }
    }

    public int clampYToHomeBoundsPublic(int y) {
        try {
            return this.clampYToHomeBounds(y);
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                RavenEntity.getSharedLogger().warn("[RavenEntity] clampYToHomeBoundsPublic failed safely: {}", (Object)t.toString());
            }
            return y;
        }
    }

    public int getPlayerAvoidanceOverrideTicks() {
        try {
            return this.playerAvoidanceOverrideTicks;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public void setPlayerAvoidanceOverrideTicks(int ticks) {
        block2: {
            try {
                this.playerAvoidanceOverrideTicks = ticks;
            }
            catch (Throwable t) {
                if (this.tickCount % 80 != 0) break block2;
                RavenEntity.getSharedLogger().warn("[RavenEntity] setPlayerAvoidanceOverrideTicks failed safely: {}", (Object)t.toString());
            }
        }
    }

    public int getPlayerAvoidanceRearmCooldownTicks() {
        try {
            return this.playerAvoidanceRearmCooldownTicks;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    @Nullable
    public Vec3 getFlyTarget() {
        try {
            return this.flyTarget;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public int getFlyTargetTimeoutTicks() {
        try {
            return this.flyTargetTimeoutTicks;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public List<Vec3> getPathWaypoints() {
        try {
            return this.pathWaypoints;
        }
        catch (Throwable t) {
            return Collections.emptyList();
        }
    }

    public int getPathWaypointIndex() {
        try {
            return this.pathWaypointIndex;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    @Nullable
    public Vec3 getPathGoal() {
        try {
            return this.pathGoal;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    public Vec3 getPathPendingGoal() {
        try {
            return this.pathPendingGoal;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void setAvoidanceCooldownTicks(int ticks) {
        block2: {
            try {
                this.avoidanceCooldownTicks = ticks;
            }
            catch (Throwable t) {
                if (this.tickCount % 80 != 0) break block2;
                RavenEntity.getSharedLogger().warn("[RavenEntity] setAvoidanceCooldownTicks failed safely: {}", (Object)t.toString());
            }
        }
    }

    public void setStuckTicks(int ticks) {
        block2: {
            try {
                this.stuckTicks = ticks;
            }
            catch (Throwable t) {
                if (this.tickCount % 80 != 0) break block2;
                RavenEntity.getSharedLogger().warn("[RavenEntity] setStuckTicks failed safely: {}", (Object)t.toString());
            }
        }
    }

    public void setRoamTicksRemaining(int ticks) {
        block2: {
            try {
                this.roamTicksRemaining = ticks;
            }
            catch (Throwable t) {
                if (this.tickCount % 80 != 0) break block2;
                RavenEntity.getSharedLogger().warn("[RavenEntity] setRoamTicksRemaining failed safely: {}", (Object)t.toString());
            }
        }
    }

    public int getIdleLockTicks() {
        try {
            return this.idleLockTicks;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public void setIdleLockTicks(int ticks) {
        block2: {
            try {
                this.idleLockTicks = ticks;
            }
            catch (Throwable t) {
                if (this.tickCount % 80 != 0) break block2;
                RavenEntity.getSharedLogger().warn("[RavenEntity] setIdleLockTicks failed safely: {}", (Object)t.toString());
            }
        }
    }

    public Landing getLanding() {
        return this.landing;
    }

    public boolean landingEnsurePathTo(@Nullable Vec3 goal, int ttlTicks, long seed, @Nullable String caller) {
        try {
            return this.ensurePathTo(goal, ttlTicks, seed, caller);
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
            return false;
        }
    }

    public void landingSetFlyTarget(@Nullable Vec3 goal, int ttlTicks) {
        try {
            this.setFlyTarget(goal, ttlTicks);
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    public void landingMaybeAvoidOrRetargetDuringFlightApproachOnly(@Nullable RandomSource rnd) {
        try {
            this.maybeAvoidOrRetargetDuringFlightApproachOnly(rnd);
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    public void landingFlyTowardTarget(double speed) {
        try {
            this.flyTowardTarget(speed);
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    public void landingAdvanceWaypointIfNeeded(int ttlTicks, @Nullable String caller) {
        try {
            this.advanceWaypointIfNeeded(ttlTicks, caller);
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    public void landingTickFlyTargetTimeout(@Nullable String why) {
        try {
            if (this.flyTarget != null) {
                if (this.flyTargetTimeoutTicks > 0) {
                    --this.flyTargetTimeoutTicks;
                }
                if (this.flyTargetTimeoutTicks <= 0) {
                    if (this.tickCount % 40 == 0) {
                        // empty if block
                    }
                    this.clearFlyTarget();
                    this.flyTargetTimeoutTicks = 0;
                }
            }
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    public boolean isPlayerAvoidanceOverrideActive() {
        try {
            return this.playerAvoidanceOverrideTicks > 0;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public Teleportation getTeleportation() {
        try {
            return this.teleportation;
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
            return null;
        }
    }

    private void resetLandingState(String reason) {
        try {
            if (this.landing != null) {
                this.landing.resetLandingState(reason, this);
            }
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    public void requestLureFollowPlayer(@Nullable Player player, double distToPlayer) {
        try {
            if (this.lureFollowTame != null) {
                this.lureFollowTame.requestLureFollowPlayer(player, distToPlayer);
            }
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    public boolean isLureFollowActive() {
        try {
            return this.lureFollowTame != null && this.lureFollowTame.isLureFollowActive();
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
            return false;
        }
    }

    private int getFollowCooldownTicks() {
        try {
            return this.lureFollowTame != null ? this.lureFollowTame.getFollowCooldownTicks() : 0;
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
            return 0;
        }
    }

    private void setFollowCooldownTicks(int ticks) {
        try {
            if (this.lureFollowTame != null) {
                this.lureFollowTame.setFollowCooldownTicks(ticks);
            }
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    public boolean isFollowOverrideActive() {
        try {
            return this.lureFollowTame != null && this.lureFollowTame.isFollowOverrideActive();
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
            return false;
        }
    }

    public int getGoldenNuggetsRequiredToTame() {
        try {
            return this.lureFollowTame != null ? this.lureFollowTame.getGoldenNuggetsRequiredToTame() : 0;
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
            return 0;
        }
    }

    public void setGoldenNuggetsRequiredToTame(int value) {
        try {
            if (this.lureFollowTame != null) {
                this.lureFollowTame.setGoldenNuggetsRequiredToTame(value);
            }
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    public void initGoldenNuggetsRequiredToTameIfNeeded(String context) {
        try {
            if (this.lureFollowTame != null) {
                this.lureFollowTame.initGoldenNuggetsRequiredToTameIfNeeded(context);
            }
        }
        catch (Throwable t) {
            if (this.tickCount % 80 == 0) {
                // empty if block
            }
        }
    }

    static {
        Teleportation.initEntityData();
        SOUND_RAVEN_CAWING_NORMAL_ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"raven.cawing_normal");
        SOUND_RAVEN_CAW_AGREE_ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"raven.caw_agree");
        SOUND_RAVEN_CAW_DMG_ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"raven.caw_dmg");
        SOUND_RAVEN_CAW_WHISTLE_ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"raven.caw_whistle");
        SOUND_RAVEN_AIR_WOOSH_ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"raven.air_woosh");
        SOUND_RAVEN_TELEPORT_ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"raven.teleport");
        cachedRavenCawingNormal = null;
        cachedRavenCawAgree = null;
        cachedRavenCawDmg = null;
        cachedRavenCawWhistle = null;
        cachedRavenAirWoosh = null;
        cachedRavenTeleport = null;
        PATH_START_PROBE_UP_OFFSETS = new double[]{0.0, 0.125, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 2.0};
        ANIM_NO_AIR = RawAnimation.begin().thenLoop("animation.raven.no_air");
        ANIM_IN_AIR = RawAnimation.begin().thenLoop("animation.raven.in_air");
    }

    private static enum PostTeleportIntent {
        PERCH,
        ROAM_FLIGHT;

    }

    private static enum LandingPhase {
        NONE,
        FLY_TO_OVERHEAD,
        DESCEND_SLOW,
        DROP;

    }
}

