/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.entity.raven;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.z2six.featheredfriend.entity.raven.RavenAnimMode;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import net.z2six.featheredfriend.entity.raven.RavenVariant;
import org.slf4j.Logger;

public final class RavenControl {
    private static final Logger LOG = LogUtils.getLogger();
    private final RavenEntity raven;

    public RavenControl(RavenEntity raven) {
        this.raven = raven;
    }

    public RavenEntity entity() {
        return this.raven;
    }

    public void setVariant(RavenVariant variant) {
        try {
            this.raven.setRavenVariant(variant);
        }
        catch (Throwable t) {
            LOG.error("[RavenControl] Failed setVariant({})", (Object)variant, (Object)t);
        }
    }

    public void setVariantNormal() {
        this.setVariant(RavenVariant.NORMAL);
    }

    public void setVariantScroll() {
        this.setVariant(RavenVariant.SCROLL);
    }

    public void setAnimMode(RavenAnimMode mode) {
        try {
            this.raven.setAnimMode(mode);
        }
        catch (Throwable t) {
            LOG.error("[RavenControl] Failed setAnimMode({})", (Object)mode, (Object)t);
        }
    }

    public void animAuto() {
        this.setAnimMode(RavenAnimMode.AUTO);
    }

    public void animNoAir() {
        this.setAnimMode(RavenAnimMode.NO_AIR);
    }

    public void animInAir() {
        this.setAnimMode(RavenAnimMode.IN_AIR);
    }

    public boolean moveTo(BlockPos pos, double speed) {
        try {
            return this.raven.commandMoveTo(pos, speed);
        }
        catch (Throwable t) {
            LOG.error("[RavenControl] Failed moveTo({}, {})", new Object[]{pos, speed, t});
            return false;
        }
    }

    public void stopMoving() {
        try {
            this.raven.commandStopMoving();
        }
        catch (Throwable t) {
            LOG.error("[RavenControl] Failed stopMoving()", t);
        }
    }
}

