/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.data;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class FFKnownPlayersData
extends SavedData {
    private static final Logger LOG = LogUtils.getLogger();
    private static final String SAVE_ID = "featheredfriend_known_players";
    private static final String NBT_PLAYERS = "Players";
    private static final String NBT_UUID = "UUID";
    private static final String NBT_NAME = "Name";
    private final Map<UUID, String> known = new ConcurrentHashMap<UUID, String>();

    public FFKnownPlayersData() {
        LOG.debug("[FFKnownPlayersData] Constructed new instance (empty)");
    }

    @NotNull
    public static FFKnownPlayersData get(@NotNull MinecraftServer server) {
        try {
            SavedData.Factory factory;
            if (server.overworld() == null) {
                LOG.warn("[FFKnownPlayersData] get(): server.overworld() is null; returning non-persisting instance");
                return new FFKnownPlayersData();
            }
            DimensionDataStorage storage = server.overworld().getDataStorage();
            FFKnownPlayersData data = (FFKnownPlayersData)storage.computeIfAbsent(factory = new SavedData.Factory(FFKnownPlayersData::new, FFKnownPlayersData::load, DataFixTypes.LEVEL), SAVE_ID);
            if (data == null) {
                LOG.error("[FFKnownPlayersData] get(): computeIfAbsent returned null; returning non-persisting instance");
                return new FFKnownPlayersData();
            }
            return data;
        }
        catch (Throwable t) {
            LOG.error("[FFKnownPlayersData] get() failed safely; returning non-persisting instance", t);
            return new FFKnownPlayersData();
        }
    }

    @NotNull
    private static FFKnownPlayersData load(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider lookup) {
        FFKnownPlayersData data = new FFKnownPlayersData();
        try {
            if (tag.contains(NBT_PLAYERS, 9)) {
                ListTag list = tag.getList(NBT_PLAYERS, 10);
                int loaded = 0;
                for (int i = 0; i < list.size(); ++i) {
                    Tag t = list.get(i);
                    if (!(t instanceof CompoundTag)) continue;
                    CompoundTag ct = (CompoundTag)t;
                    String uuidStr = ct.getString(NBT_UUID);
                    String name = ct.getString(NBT_NAME);
                    if (uuidStr == null || uuidStr.isBlank() || name == null || name.isBlank()) continue;
                    try {
                        UUID uuid = UUID.fromString(uuidStr);
                        data.known.put(uuid, name);
                        ++loaded;
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                LOG.info("[FFKnownPlayersData] Loaded {} known players from disk", (Object)loaded);
            } else {
                LOG.info("[FFKnownPlayersData] No '{}' list in saved data; starting empty", (Object)NBT_PLAYERS);
            }
        }
        catch (Throwable t) {
            LOG.error("[FFKnownPlayersData] load() failed safely; data may be incomplete", t);
        }
        return data;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider lookup) {
        try {
            ListTag list = new ListTag();
            int written = 0;
            for (Map.Entry<UUID, String> e : this.known.entrySet()) {
                UUID uuid = e.getKey();
                String name = e.getValue();
                if (uuid == null || name == null || name.isBlank()) continue;
                CompoundTag ct = new CompoundTag();
                ct.putString(NBT_UUID, uuid.toString());
                ct.putString(NBT_NAME, name);
                list.add((Object)ct);
                ++written;
            }
            tag.put(NBT_PLAYERS, (Tag)list);
            LOG.debug("[FFKnownPlayersData] save(): wrote {} players", (Object)written);
        }
        catch (Throwable t) {
            LOG.error("[FFKnownPlayersData] save() failed safely", t);
        }
        return tag;
    }

    public void addOrUpdate(@NotNull ServerPlayer player) {
        try {
            UUID uuid = player.getUUID();
            String name = player.getGameProfile().getName();
            if (uuid == null || name == null || name.isBlank()) {
                LOG.warn("[FFKnownPlayersData] addOrUpdate: invalid player identity (uuid={} name='{}')", (Object)uuid, (Object)name);
                return;
            }
            String prev = this.known.put(uuid, name);
            this.setDirty();
            if (prev == null) {
                LOG.info("[FFKnownPlayersData] Added known player: {} ({})", (Object)name, (Object)uuid);
            } else if (!prev.equals(name)) {
                LOG.info("[FFKnownPlayersData] Updated known player name: {} -> {} ({})", new Object[]{prev, name, uuid});
            } else {
                LOG.debug("[FFKnownPlayersData] addOrUpdate: unchanged for {} ({})", (Object)name, (Object)uuid);
            }
        }
        catch (Throwable t) {
            LOG.error("[FFKnownPlayersData] addOrUpdate failed safely", t);
        }
    }

    @NotNull
    public List<KnownPlayer> getSortedPlayers() {
        try {
            ArrayList<KnownPlayer> out = new ArrayList<KnownPlayer>();
            for (Map.Entry<UUID, String> e : this.known.entrySet()) {
                UUID uuid = e.getKey();
                String name = e.getValue();
                if (uuid == null || name == null || name.isBlank()) continue;
                out.add(new KnownPlayer(uuid, name));
            }
            out.sort(Comparator.comparing(KnownPlayer::name, String.CASE_INSENSITIVE_ORDER));
            return out;
        }
        catch (Throwable t) {
            LOG.error("[FFKnownPlayersData] getSortedPlayers failed safely", t);
            return List.of();
        }
    }

    @NotNull
    public List<String> getSortedNames() {
        try {
            ArrayList<String> names = new ArrayList<String>();
            for (KnownPlayer kp : this.getSortedPlayers()) {
                names.add(kp.name());
            }
            return names;
        }
        catch (Throwable t) {
            LOG.error("[FFKnownPlayersData] getSortedNames failed safely", t);
            return List.of();
        }
    }

    public record KnownPlayer(@NotNull UUID uuid, @NotNull String name) {
    }
}

