/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.config;

import com.mojang.logging.LogUtils;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.slf4j.Logger;

public final class FFClientConfig {
    private static final Logger LOG = LogUtils.getLogger();
    public static final boolean DEFAULT_AUTO_SUMMON_ON_SCROLL = true;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final ModConfigSpec.BooleanValue AUTO_SUMMON_ON_SCROLL;

    public static void register() {
        try {
            if (!FMLEnvironment.dist.isClient()) {
                LOG.debug("[FFClientConfig] register() called on non-client; skipping safely");
                return;
            }
            ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
            LOG.debug("[FFClientConfig] Registered CLIENT config");
        }
        catch (Throwable t) {
            LOG.error("[FFClientConfig] Failed to register CLIENT config", t);
        }
    }

    public static boolean isAutoSummonOnScroll() {
        try {
            return (Boolean)AUTO_SUMMON_ON_SCROLL.get();
        }
        catch (Throwable t) {
            LOG.error("[FFClientConfig] isAutoSummonOnScroll failed, returning default {}", (Object)true, (Object)t);
            return true;
        }
    }

    public static void setAutoSummonOnScroll(boolean value) {
        try {
            AUTO_SUMMON_ON_SCROLL.set((Object)value);
            LOG.info("[FFClientConfig] autoSummonOnScroll set to {}", (Object)value);
        }
        catch (Throwable t) {
            LOG.error("[FFClientConfig] setAutoSummonOnScroll failed safely: {}", (Object)t.toString());
        }
    }

    public static void save() {
        try {
            CLIENT_SPEC.save();
            LOG.debug("[FFClientConfig] Saved client config to disk");
        }
        catch (Throwable t) {
            LOG.error("[FFClientConfig] save() failed safely", t);
        }
    }

    private FFClientConfig() {
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("client");
        AUTO_SUMMON_ON_SCROLL = builder.comment(new String[]{"If true, holding a sealed scroll will automatically summon your raven (client preference).", "If false, you must whistle manually."}).define("autoSummonOnScroll", true);
        builder.pop();
        CLIENT_SPEC = builder.build();
        LOG.debug("[FFClientConfig] Built CLIENT config spec");
    }
}

