/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.config;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.z2six.featheredfriend.calendar.CalendarDefinition;
import org.slf4j.Logger;

public final class FFCalendarConfig {
    private static final Logger LOG = LogUtils.getLogger();
    public static final String[] DEFAULT_MONTH_NAMES = new String[]{"Dawnroot", "Blossomwake", "Greengale", "Suncrest", "Stormfall", "Shadowmere", "Frostveil", "Darkrest"};
    public static final String DEFAULT_YEAR_SUFFIX = "A.N.";
    public static final int DEFAULT_DAYS_PER_MONTH = 28;
    public static final int MONTHS_PER_YEAR = DEFAULT_MONTH_NAMES.length;
    public static final int TICKS_PER_DAY = 24000;
    public static final boolean DEFAULT_CHAT_DISABLED_DEFAULT = true;
    public static final ModConfigSpec SERVER_SPEC;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> MONTH_NAMES;
    public static final ModConfigSpec.ConfigValue<String> YEAR_SUFFIX;
    public static final ModConfigSpec.IntValue DAYS_PER_MONTH;
    public static final ModConfigSpec.BooleanValue CHAT_DISABLED_DEFAULT;

    public static void register() {
        try {
            ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
            LOG.debug("[FFCalendarConfig] Registered SERVER config with active ModContainer");
        }
        catch (Throwable t) {
            LOG.error("[FFCalendarConfig] Failed to register SERVER config", t);
        }
    }

    public static String getMonthName(int index) {
        try {
            if (index < 0 || index >= DEFAULT_MONTH_NAMES.length) {
                LOG.warn("[FFCalendarConfig] getMonthName: index {} out of range, using placeholder", (Object)index);
                return "Month" + index;
            }
            List names = (List)MONTH_NAMES.get();
            if (names == null || names.size() != DEFAULT_MONTH_NAMES.length) {
                LOG.warn("[FFCalendarConfig] monthNames config invalid (got size {}), falling back to defaults", names == null ? "null" : Integer.valueOf(names.size()));
                return DEFAULT_MONTH_NAMES[index];
            }
            String value = (String)names.get(index);
            if (value == null || value.isBlank()) {
                LOG.warn("[FFCalendarConfig] monthNames[{}] is blank/null, falling back to default", (Object)index);
                return DEFAULT_MONTH_NAMES[index];
            }
            return value;
        }
        catch (Throwable t) {
            LOG.error("[FFCalendarConfig] getMonthName failed for index {}, using safe fallback", (Object)index, (Object)t);
            if (index >= 0 && index < DEFAULT_MONTH_NAMES.length) {
                return DEFAULT_MONTH_NAMES[index];
            }
            return "Month" + index;
        }
    }

    public static String getYearSuffix() {
        try {
            String suffix = (String)YEAR_SUFFIX.get();
            if (suffix == null || suffix.isBlank()) {
                LOG.warn("[FFCalendarConfig] yearSuffix is blank/null, using default '{}'", (Object)DEFAULT_YEAR_SUFFIX);
                return DEFAULT_YEAR_SUFFIX;
            }
            return suffix;
        }
        catch (Throwable t) {
            LOG.error("[FFCalendarConfig] getYearSuffix failed, using default '{}'", (Object)DEFAULT_YEAR_SUFFIX, (Object)t);
            return DEFAULT_YEAR_SUFFIX;
        }
    }

    public static int getDaysPerMonth() {
        try {
            int v = (Integer)DAYS_PER_MONTH.get();
            if (v <= 0) {
                LOG.warn("[FFCalendarConfig] daysPerMonth <= 0 ({}), using default {}", (Object)v, (Object)28);
                return 28;
            }
            if (v > 365) {
                LOG.warn("[FFCalendarConfig] daysPerMonth > 365 ({}), clamping to 365", (Object)v);
                return 365;
            }
            return v;
        }
        catch (Throwable t) {
            LOG.error("[FFCalendarConfig] getDaysPerMonth failed, using default {}", (Object)28, (Object)t);
            return 28;
        }
    }

    public static boolean getChatDisabledDefault() {
        try {
            return (Boolean)CHAT_DISABLED_DEFAULT.get();
        }
        catch (Throwable t) {
            LOG.error("[FFCalendarConfig] getChatDisabledDefault failed, using default {}", (Object)true, (Object)t);
            return true;
        }
    }

    public static CalendarDefinition getCalendarDefinition() {
        try {
            ArrayList<String> monthNamesList = new ArrayList<String>(MONTHS_PER_YEAR);
            for (int i = 0; i < MONTHS_PER_YEAR; ++i) {
                monthNamesList.add(FFCalendarConfig.getMonthName(i));
            }
            String suffix = FFCalendarConfig.getYearSuffix();
            int daysPerMonth = FFCalendarConfig.getDaysPerMonth();
            String[] namesArray = monthNamesList.toArray(new String[0]);
            CalendarDefinition def = new CalendarDefinition(namesArray, suffix, daysPerMonth, 24000L);
            LOG.debug("[FFCalendarConfig] Built CalendarDefinition: months={}, daysPerMonth={}, suffix='{}', ticksPerDay={}", new Object[]{namesArray.length, daysPerMonth, suffix, 24000});
            return def;
        }
        catch (Throwable t) {
            LOG.error("[FFCalendarConfig] getCalendarDefinition failed; falling back to hard-coded defaults", t);
            return new CalendarDefinition(DEFAULT_MONTH_NAMES, DEFAULT_YEAR_SUFFIX, 28, 24000L);
        }
    }

    private FFCalendarConfig() {
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("calendar");
        MONTH_NAMES = builder.comment(new String[]{"Names of the 8 calendar months, in order.", "If the list is missing or has the wrong size,", "the mod will fall back to its built-in defaults."}).defineList("monthNames", Arrays.asList(DEFAULT_MONTH_NAMES), o -> {
            String s;
            return o instanceof String && !(s = (String)o).isBlank();
        });
        YEAR_SUFFIX = builder.comment(new String[]{"Year suffix string, e.g. \"A.N.\" for \"After Notch\".", "Used when displaying dates like: Day 17 of Dawnroot, 112 A.N."}).define("yearSuffix", (Object)DEFAULT_YEAR_SUFFIX);
        DAYS_PER_MONTH = builder.comment(new String[]{"How many in-game days each month lasts before progressing to the next month.", "This is server-authoritative and synced to clients.", "", "Examples:", "- Vanilla-ish fantasy default: 28", "- Perfect sync with Serene Seasons sub_season_duration=16: set this to 24", "", "Valid range: 1..365"}).defineInRange("daysPerMonth", 28, 1, 365);
        builder.pop();
        builder.push("settings");
        CHAT_DISABLED_DEFAULT = builder.comment(new String[]{"Default for FeatheredFriend's world-owned chat flag when the world SavedData has no value yet.", "If true, chat is disabled by default until an admin enables it in-game (or via commands if you add those).", "This does NOT forcibly override the world value every boot; it is only used as a fallback default."}).define("chatDisabledDefault", true);
        builder.pop();
        SERVER_SPEC = builder.build();
        LOG.debug("[FFCalendarConfig] Built SERVER config spec (calendar + settings)");
    }
}

