/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.z2six.featheredfriend.world.RavenCourierData;
import org.slf4j.Logger;

public final class FeatheredFriendCommands {
    private static final Logger LOG = LogUtils.getLogger();
    private static final int MAX_RAVEN_NAME_CHARS = 26;
    private static final String KEY_TAMED_RAVEN = "TamedRaven";
    private static final String KEY_HAS_TAMED_RAVEN = "HasTamedRaven";
    private static final String KEY_RAVEN_NAME = "RavenName";
    private static final String KEY_OWNER_UUID = "OwnerUUID";
    private static final String KEY_OWNER_DIMENSION = "OwnerDimension";
    private static final String ROOT_NEOFORGE_DATA = "NeoForgeData";
    private static final String ROOT_FORGE_DATA = "ForgeData";
    private static final long PLAYERDAT_NBT_BUDGET_BYTES = 0x4000000L;

    private FeatheredFriendCommands() {
    }

    public static void register() {
        try {
            NeoForge.EVENT_BUS.addListener(event -> FeatheredFriendCommands.onRegisterCommands(event));
            LOG.info("[FeatheredFriendCommands] Registered command listener on NeoForge.EVENT_BUS");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendCommands] Failed to register command listener", t);
        }
    }

    private static void onRegisterCommands(RegisterCommandsEvent event) {
        try {
            CommandDispatcher dispatcher = event.getDispatcher();
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"featheredfriend").requires(src -> src.hasPermission(2))).then(Commands.literal((String)"clear_tamed_raven").executes(FeatheredFriendCommands::executeClearTamedRavenSelf))).then(((LiteralArgumentBuilder)Commands.literal((String)"tamed_raven").then(Commands.literal((String)"list").executes(FeatheredFriendCommands::executeTamedRavenListAll))).then(Commands.literal((String)"add").then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(FeatheredFriendCommands::executeTamedRavenAddForPlayer)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"courier").then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(FeatheredFriendCommands::executeCourierListAll)).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).executes(FeatheredFriendCommands::executeCourierListPlayer)))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(FeatheredFriendCommands::executeCourierClearAll)).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).executes(FeatheredFriendCommands::executeCourierClearPlayer)))));
            LOG.info("[FeatheredFriendCommands] Commands registered: /featheredfriend clear_tamed_raven, /featheredfriend tamed_raven list, /featheredfriend tamed_raven add <player> <name>, /featheredfriend courier list [player], /featheredfriend courier clear [player]");
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendCommands] onRegisterCommands failed", t);
        }
    }

    private static int executeClearTamedRavenSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        boolean cleared;
        ServerPlayer player;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        try {
            player = source.getPlayerOrException();
        }
        catch (CommandSyntaxException ex) {
            LOG.warn("[FeatheredFriendCommands] clear_tamed_raven: source is not a player (name={})", (Object)source.getTextName());
            source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] This command must be run by a player."));
            throw ex;
        }
        MinecraftServer server = player.server;
        if (server == null) {
            LOG.warn("[FeatheredFriendCommands] clear_tamed_raven: server is null for player={}", (Object)player.getGameProfile().getName());
            source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Internal error: server is null."));
            return 0;
        }
        boolean clearedFinal = cleared = FeatheredFriendCommands.clearPlayerTamedRavenData(player);
        source.sendSuccess(() -> Component.literal((String)("[FeatheredFriend] " + (clearedFinal ? "Cleared tamed raven data for " + player.getGameProfile().getName() : "Found no tamed raven data to clear for " + player.getGameProfile().getName()))), true);
        return cleared ? 1 : 0;
    }

    public static boolean clearPlayerTamedRavenData(ServerPlayer player) {
        try {
            if (player == null) {
                return false;
            }
            CompoundTag root = player.getPersistentData();
            if (root == null) {
                LOG.info("[FeatheredFriendCommands] clearPlayerTamedRavenData: no persistent data for player={}", (Object)player.getGameProfile().getName());
                return false;
            }
            if (!root.contains("featheredfriend", 10)) {
                LOG.info("[FeatheredFriendCommands] clearPlayerTamedRavenData: no '{}' tag for player={}", (Object)"featheredfriend", (Object)player.getGameProfile().getName());
                return false;
            }
            CompoundTag modTag = root.getCompound("featheredfriend");
            if (modTag == null || !modTag.contains(KEY_TAMED_RAVEN, 10)) {
                LOG.info("[FeatheredFriendCommands] clearPlayerTamedRavenData: no {} compound for player={}", (Object)KEY_TAMED_RAVEN, (Object)player.getGameProfile().getName());
                return false;
            }
            CompoundTag tamed = modTag.getCompound(KEY_TAMED_RAVEN);
            if (tamed == null || tamed.isEmpty()) {
                LOG.info("[FeatheredFriendCommands] clearPlayerTamedRavenData: empty {} compound for player={}", (Object)KEY_TAMED_RAVEN, (Object)player.getGameProfile().getName());
                return false;
            }
            boolean had = tamed.getBoolean(KEY_HAS_TAMED_RAVEN);
            LOG.info("[FeatheredFriendCommands] clearPlayerTamedRavenData: BEFORE clear player={} uuid={} tag={}", new Object[]{player.getGameProfile().getName(), player.getUUID(), tamed});
            tamed.putBoolean(KEY_HAS_TAMED_RAVEN, false);
            tamed.remove(KEY_RAVEN_NAME);
            tamed.remove(KEY_OWNER_UUID);
            tamed.remove(KEY_OWNER_DIMENSION);
            if (tamed.isEmpty()) {
                modTag.remove(KEY_TAMED_RAVEN);
            } else {
                modTag.put(KEY_TAMED_RAVEN, (Tag)tamed);
            }
            if (modTag.isEmpty()) {
                root.remove("featheredfriend");
            } else {
                root.put("featheredfriend", (Tag)modTag);
            }
            LOG.info("[FeatheredFriendCommands] clearPlayerTamedRavenData: AFTER clear player={} uuid={} had={} nowTag={}", new Object[]{player.getGameProfile().getName(), player.getUUID(), had, tamed});
            return had;
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendCommands] clearPlayerTamedRavenData failed for player={}", (Object)(player == null ? "null" : player.getGameProfile().getName()), (Object)t);
            return false;
        }
    }

    private static int executeTamedRavenListAll(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        try {
            MinecraftServer server = source.getServer();
            if (server == null) {
                source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Internal error: server is null."));
                LOG.warn("[FeatheredFriendCommands] tamed_raven list: source.getServer() was null");
                return 0;
            }
            Path playerDataDir = FeatheredFriendCommands.getPlayerDataDir(server);
            if (playerDataDir == null) {
                source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Could not locate playerdata directory (see server log)."));
                return 0;
            }
            if (!Files.exists(playerDataDir, new LinkOption[0]) || !Files.isDirectory(playerDataDir, new LinkOption[0])) {
                source.sendFailure((Component)Component.literal((String)("[FeatheredFriend] playerdata directory not found: " + String.valueOf(playerDataDir))));
                LOG.warn("[FeatheredFriendCommands] tamed_raven list: playerdata dir missing/not directory: {}", (Object)playerDataDir);
                return 0;
            }
            HashMap<UUID, String> onlineNameByUuid = new HashMap<UUID, String>();
            try {
                for (ServerPlayer sp : server.getPlayerList().getPlayers()) {
                    if (sp == null) continue;
                    onlineNameByUuid.put(sp.getUUID(), sp.getGameProfile().getName());
                }
            }
            catch (Throwable t) {
                LOG.warn("[FeatheredFriendCommands] tamed_raven list: failed building online name map: {}", (Object)t.toString());
            }
            ArrayList<String> lines = new ArrayList<String>();
            int scanned = 0;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(playerDataDir, "*.dat");){
                for (Path p : stream) {
                    String ownerDim;
                    String ownerName;
                    String ravenName;
                    boolean has;
                    CompoundTag tamed;
                    CompoundTag modTag;
                    CompoundTag persistent;
                    ++scanned;
                    UUID playerUuid = FeatheredFriendCommands.parseUuidFromPlayerDatName(p.getFileName().toString());
                    if (playerUuid == null) {
                        LOG.debug("[FeatheredFriendCommands] tamed_raven list: skipping non-uuid dat name={}", (Object)p.getFileName());
                        continue;
                    }
                    CompoundTag playerRoot = FeatheredFriendCommands.readPlayerDatSafe(p);
                    if (playerRoot == null || playerRoot.isEmpty() || (persistent = FeatheredFriendCommands.extractPersistentDataFromPlayerFile(playerRoot)) == null || persistent.isEmpty() || (modTag = persistent.contains("featheredfriend", 10) ? persistent.getCompound("featheredfriend") : null) == null || modTag.isEmpty() || (tamed = modTag.contains(KEY_TAMED_RAVEN, 10) ? modTag.getCompound(KEY_TAMED_RAVEN) : null) == null || tamed.isEmpty() || !(has = tamed.getBoolean(KEY_HAS_TAMED_RAVEN))) continue;
                    String string = ravenName = tamed.contains(KEY_RAVEN_NAME, 8) ? tamed.getString(KEY_RAVEN_NAME) : "";
                    if (ravenName == null) {
                        ravenName = "";
                    }
                    if (ravenName.isBlank()) {
                        ravenName = "(unnamed)";
                    }
                    if ((ownerName = (String)onlineNameByUuid.get(playerUuid)) == null || ownerName.isBlank()) {
                        ownerName = FeatheredFriendCommands.safeGuessNameFromPlayerRoot(playerRoot);
                    }
                    if (ownerName == null || ownerName.isBlank()) {
                        ownerName = "(unknown)";
                    }
                    String string2 = ownerDim = tamed.contains(KEY_OWNER_DIMENSION, 8) ? tamed.getString(KEY_OWNER_DIMENSION) : "";
                    if (ownerDim == null) {
                        ownerDim = "";
                    }
                    lines.add(String.format(" - owner='%s' [%s] ravenName='%s' ownerDim='%s'", ownerName, playerUuid, ravenName, ownerDim));
                }
            }
            catch (Throwable t) {
                LOG.error("[FeatheredFriendCommands] tamed_raven list: directory scan failed for dir={}", (Object)playerDataDir, (Object)t);
                source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Error scanning playerdata directory; see log."));
                return 0;
            }
            if (lines.isEmpty()) {
                int scannedFinal = scanned;
                source.sendSuccess(() -> Component.literal((String)("[FeatheredFriend] No stored tamed ravens found (scanned " + scannedFinal + " playerdata files).")), false);
                LOG.info("[FeatheredFriendCommands] tamed_raven list: none found (scanned={} dir={})", (Object)scannedFinal, (Object)playerDataDir);
                return 0;
            }
            int scannedFinal = scanned;
            int foundFinal = lines.size();
            source.sendSuccess(() -> Component.literal((String)("[FeatheredFriend] Stored tamed ravens: " + foundFinal + " (scanned " + scannedFinal + " playerdata files)")), false);
            Iterator iterator = lines.iterator();
            while (iterator.hasNext()) {
                String line;
                String out = line = (String)iterator.next();
                source.sendSuccess(() -> Component.literal((String)out), false);
            }
            LOG.info("[FeatheredFriendCommands] tamed_raven list: found={} scanned={} dir={}", new Object[]{foundFinal, scannedFinal, playerDataDir});
            return foundFinal;
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendCommands] executeTamedRavenListAll failed", t);
            source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Error while listing stored tamed ravens; see log."));
            return 0;
        }
    }

    private static int executeTamedRavenAddForPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        MinecraftServer server = source.getServer();
        if (server == null) {
            source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Internal error: server is null."));
            LOG.warn("[FeatheredFriendCommands] tamed_raven add: source.getServer() was null");
            return 0;
        }
        Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"player");
        if (profiles == null || profiles.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] No matching player found."));
            return 0;
        }
        GameProfile profile = (GameProfile)profiles.iterator().next();
        UUID targetUuid = profile.getId();
        String targetName = profile.getName();
        if (targetUuid == null) {
            source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Target player's UUID is null (cannot proceed)."));
            LOG.warn("[FeatheredFriendCommands] tamed_raven add: profile had null UUID (name={})", (Object)targetName);
            return 0;
        }
        String rawName = "";
        try {
            rawName = StringArgumentType.getString(ctx, (String)"name");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String ravenName = FeatheredFriendCommands.sanitizeRavenName(rawName);
        LOG.info("[FeatheredFriendCommands] tamed_raven add: request targetName='{}' uuid={} ravenName='{}' (raw='{}')", new Object[]{targetName, targetUuid, ravenName, rawName});
        ServerPlayer online = server.getPlayerList().getPlayer(targetUuid);
        if (online != null) {
            boolean ok = FeatheredFriendCommands.setTamedRavenPersistentDataOnline(online, ravenName);
            if (ok) {
                source.sendSuccess(() -> Component.literal((String)("[FeatheredFriend] Set tamed raven for online player '" + online.getGameProfile().getName() + "' to '" + ravenName + "'.")), true);
                return 1;
            }
            source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Failed to set tamed raven for online player; see log."));
            return 0;
        }
        Path playerDataDir = FeatheredFriendCommands.getPlayerDataDir(server);
        if (playerDataDir == null) {
            source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Could not locate playerdata directory (see server log)."));
            return 0;
        }
        Path playerDat = playerDataDir.resolve(targetUuid.toString() + ".dat");
        if (!Files.exists(playerDat, new LinkOption[0])) {
            source.sendFailure((Component)Component.literal((String)("[FeatheredFriend] Playerdata file not found for " + String.valueOf(targetName != null ? targetName : targetUuid) + " (" + String.valueOf(playerDat) + ").")));
            LOG.warn("[FeatheredFriendCommands] tamed_raven add: offline playerdat missing: {}", (Object)playerDat);
            return 0;
        }
        boolean wrote = FeatheredFriendCommands.setTamedRavenPersistentDataOffline(playerDat, targetUuid, ravenName);
        if (wrote) {
            String display = targetName == null || targetName.isBlank() ? targetUuid.toString() : targetName;
            source.sendSuccess(() -> Component.literal((String)("[FeatheredFriend] Set tamed raven for offline player '" + display + "' to '" + ravenName + "'.")), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Failed to set tamed raven for offline player; see log."));
        return 0;
    }

    private static boolean setTamedRavenPersistentDataOnline(ServerPlayer player, String ravenName) {
        try {
            if (player == null) {
                return false;
            }
            CompoundTag root = player.getPersistentData();
            if (root == null) {
                LOG.warn("[FeatheredFriendCommands] setTamedRavenPersistentDataOnline: persistentData null for player={}", (Object)FeatheredFriendCommands.safeName(player));
                return false;
            }
            CompoundTag modTag = root.contains("featheredfriend", 10) ? root.getCompound("featheredfriend") : new CompoundTag();
            CompoundTag tamed = modTag.contains(KEY_TAMED_RAVEN, 10) ? modTag.getCompound(KEY_TAMED_RAVEN) : new CompoundTag();
            tamed.putBoolean(KEY_HAS_TAMED_RAVEN, true);
            tamed.putString(KEY_RAVEN_NAME, ravenName);
            try {
                tamed.putString(KEY_OWNER_UUID, player.getUUID().toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                String dim = player.level() != null && player.level().dimension() != null ? player.level().dimension().location().toString() : "minecraft:overworld";
                tamed.putString(KEY_OWNER_DIMENSION, dim);
            }
            catch (Throwable ignored) {
                tamed.putString(KEY_OWNER_DIMENSION, "minecraft:overworld");
            }
            modTag.put(KEY_TAMED_RAVEN, (Tag)tamed);
            root.put("featheredfriend", (Tag)modTag);
            LOG.info("[FeatheredFriendCommands] setTamedRavenPersistentDataOnline: player={} uuid={} ravenName='{}' tagNow={}", new Object[]{FeatheredFriendCommands.safeName(player), player.getUUID(), ravenName, tamed});
            return true;
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendCommands] setTamedRavenPersistentDataOnline failed for player={}", (Object)FeatheredFriendCommands.safeName(player), (Object)t);
            return false;
        }
    }

    private static boolean setTamedRavenPersistentDataOffline(Path playerDat, UUID playerUuid, String ravenName) {
        try {
            CompoundTag persistent;
            String chosenRootKey;
            if (playerDat == null || playerUuid == null) {
                return false;
            }
            CompoundTag playerRoot = FeatheredFriendCommands.readPlayerDatSafe(playerDat);
            if (playerRoot == null) {
                LOG.warn("[FeatheredFriendCommands] setTamedRavenPersistentDataOffline: readPlayerDatSafe returned null for {}", (Object)playerDat);
                return false;
            }
            if (playerRoot.contains(ROOT_NEOFORGE_DATA, 10)) {
                chosenRootKey = ROOT_NEOFORGE_DATA;
                persistent = playerRoot.getCompound(ROOT_NEOFORGE_DATA);
            } else if (playerRoot.contains(ROOT_FORGE_DATA, 10)) {
                chosenRootKey = ROOT_FORGE_DATA;
                persistent = playerRoot.getCompound(ROOT_FORGE_DATA);
            } else {
                chosenRootKey = ROOT_NEOFORGE_DATA;
                persistent = new CompoundTag();
            }
            CompoundTag modTag = persistent.contains("featheredfriend", 10) ? persistent.getCompound("featheredfriend") : new CompoundTag();
            CompoundTag tamed = modTag.contains(KEY_TAMED_RAVEN, 10) ? modTag.getCompound(KEY_TAMED_RAVEN) : new CompoundTag();
            tamed.putBoolean(KEY_HAS_TAMED_RAVEN, true);
            tamed.putString(KEY_RAVEN_NAME, ravenName);
            tamed.putString(KEY_OWNER_UUID, playerUuid.toString());
            if (!tamed.contains(KEY_OWNER_DIMENSION, 8) || tamed.getString(KEY_OWNER_DIMENSION).isBlank()) {
                tamed.putString(KEY_OWNER_DIMENSION, "minecraft:overworld");
            }
            modTag.put(KEY_TAMED_RAVEN, (Tag)tamed);
            persistent.put("featheredfriend", (Tag)modTag);
            playerRoot.put(chosenRootKey, (Tag)persistent);
            boolean wrote = FeatheredFriendCommands.writePlayerDatSafe(playerDat, playerRoot);
            if (!wrote) {
                LOG.error("[FeatheredFriendCommands] setTamedRavenPersistentDataOffline: writePlayerDatSafe failed for {}", (Object)playerDat);
                return false;
            }
            LOG.info("[FeatheredFriendCommands] setTamedRavenPersistentDataOffline: wrote {} uuid={} ravenName='{}' rootKey={} tagNow={}", new Object[]{playerDat, playerUuid, ravenName, chosenRootKey, tamed});
            return true;
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendCommands] setTamedRavenPersistentDataOffline failed for file={}", (Object)playerDat, (Object)t);
            return false;
        }
    }

    private static String sanitizeRavenName(String raw) {
        try {
            String s;
            String string = s = raw == null ? "" : raw.trim();
            if (s.isEmpty()) {
                s = "Raven";
            }
            if (s.length() > 26) {
                s = s.substring(0, 26);
            }
            return s;
        }
        catch (Throwable t) {
            LOG.warn("[FeatheredFriendCommands] sanitizeRavenName failed safely: {}", (Object)t.toString());
            return "Raven";
        }
    }

    private static Path getPlayerDataDir(MinecraftServer server) {
        try {
            if (server == null) {
                return null;
            }
            Path p = server.getWorldPath(LevelResource.PLAYER_DATA_DIR);
            if (p == null) {
                LOG.warn("[FeatheredFriendCommands] getPlayerDataDir: server.getWorldPath(LevelResource.PLAYER_DATA_DIR) returned null");
                return null;
            }
            return p;
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendCommands] getPlayerDataDir failed", t);
            return null;
        }
    }

    private static UUID parseUuidFromPlayerDatName(String filename) {
        try {
            if (filename == null) {
                return null;
            }
            String base = filename;
            if (base.endsWith(".dat")) {
                base = base.substring(0, base.length() - 4);
            }
            return UUID.fromString(base);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static CompoundTag extractPersistentDataFromPlayerFile(CompoundTag playerRoot) {
        try {
            if (playerRoot == null) {
                return null;
            }
            if (playerRoot.contains(ROOT_NEOFORGE_DATA, 10)) {
                return playerRoot.getCompound(ROOT_NEOFORGE_DATA);
            }
            if (playerRoot.contains(ROOT_FORGE_DATA, 10)) {
                return playerRoot.getCompound(ROOT_FORGE_DATA);
            }
            if (playerRoot.contains("featheredfriend", 10)) {
                return playerRoot;
            }
            return null;
        }
        catch (Throwable t) {
            LOG.warn("[FeatheredFriendCommands] extractPersistentDataFromPlayerFile failed safely: {}", (Object)t.toString());
            return null;
        }
    }

    private static String safeGuessNameFromPlayerRoot(CompoundTag playerRoot) {
        try {
            if (playerRoot == null) {
                return "";
            }
            if (playerRoot.contains("LastKnownName", 8)) {
                String s = playerRoot.getString("LastKnownName");
                return s == null ? "" : s;
            }
            if (playerRoot.contains("lastKnownName", 8)) {
                String s = playerRoot.getString("lastKnownName");
                return s == null ? "" : s;
            }
            if (playerRoot.contains("Name", 8)) {
                String s = playerRoot.getString("Name");
                return s == null ? "" : s;
            }
            return "";
        }
        catch (Throwable t) {
            LOG.debug("[FeatheredFriendCommands] safeGuessNameFromPlayerRoot failed safely: {}", (Object)t.toString());
            return "";
        }
    }

    private static String safeName(ServerPlayer p) {
        try {
            if (p == null) {
                return "null";
            }
            String n = p.getGameProfile() != null ? p.getGameProfile().getName() : null;
            return n == null || n.isBlank() ? "unknown" : n;
        }
        catch (Throwable ignored) {
            return "unknown";
        }
    }

    private static CompoundTag readPlayerDatSafe(Path path) {
        if (path == null) {
            return null;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            LOG.debug("[FeatheredFriendCommands] readPlayerDatSafe: file does not exist: {}", (Object)path);
            return null;
        }
        NbtAccounter accounter = NbtAccounter.create((long)0x4000000L);
        try {
            CompoundTag tag = NbtIo.readCompressed((Path)path, (NbtAccounter)accounter);
            return tag == null ? new CompoundTag() : tag;
        }
        catch (Throwable pathOverloadErr) {
            CompoundTag compoundTag;
            block12: {
                LOG.debug("[FeatheredFriendCommands] readPlayerDatSafe: Path overload failed for {}: {} (trying InputStream)", (Object)path, (Object)pathOverloadErr.toString());
                InputStream in = Files.newInputStream(path, new OpenOption[0]);
                try {
                    CompoundTag tag = NbtIo.readCompressed((InputStream)in, (NbtAccounter)accounter);
                    CompoundTag compoundTag2 = compoundTag = tag == null ? new CompoundTag() : tag;
                    if (in == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        LOG.warn("[FeatheredFriendCommands] readPlayerDatSafe failed for {}: {}", (Object)path, (Object)t.toString());
                        return null;
                    }
                }
                in.close();
            }
            return compoundTag;
        }
    }

    private static boolean writePlayerDatSafe(Path path, CompoundTag tag) {
        try {
            if (path == null) {
                return false;
            }
            if (tag == null) {
                tag = new CompoundTag();
            }
            Path tmp = path.resolveSibling(path.getFileName().toString() + ".tmp_ff");
            try (OutputStream out = Files.newOutputStream(tmp, new OpenOption[0]);){
                NbtIo.writeCompressed((CompoundTag)tag, (OutputStream)out);
            }
            catch (Throwable writeErr) {
                LOG.error("[FeatheredFriendCommands] writePlayerDatSafe: writeCompressed failed for tmp={} target={}: {}", new Object[]{tmp, path, writeErr.toString()});
                try {
                    Files.deleteIfExists(tmp);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return false;
            }
            try {
                Files.move(tmp, path, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (Throwable moveErr) {
                LOG.debug("[FeatheredFriendCommands] writePlayerDatSafe: atomic move failed for {} -> {}: {} (retrying non-atomic)", new Object[]{tmp, path, moveErr.toString()});
                try {
                    Files.move(tmp, path, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable moveErr2) {
                    LOG.error("[FeatheredFriendCommands] writePlayerDatSafe: move failed for {} -> {}: {}", new Object[]{tmp, path, moveErr2.toString()});
                    try {
                        Files.deleteIfExists(tmp);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return false;
                }
            }
            return true;
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendCommands] writePlayerDatSafe failed for {}: {}", (Object)path, (Object)t.toString());
            return false;
        }
    }

    private static int executeCourierListAll(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        try {
            ServerLevel level = source.getLevel();
            RavenCourierData data = RavenCourierData.get(level);
            List<RavenCourierData.DeliveryJob> jobs = data.getAllJobsFlat();
            if (jobs.isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)"[FeatheredFriend] No pending raven courier jobs found."), false);
                return 0;
            }
            source.sendSuccess(() -> Component.literal((String)("[FeatheredFriend] Pending raven courier jobs: " + jobs.size())), false);
            for (RavenCourierData.DeliveryJob job : jobs) {
                if (job == null) continue;
                String line = String.format(" - id=%d sender='%s' [%s] -> recipient='%s' [%s] inFlight=%s failed=%s failureCount=%d lastFailTime=%d lastFailReason='%s'", job.jobId, job.senderName, job.senderUuid, job.recipientName, job.recipientUuid, job.inFlight, job.failed, job.failureCount, job.lastFailureGameTime, job.lastFailureReason == null ? "" : job.lastFailureReason);
                source.sendSuccess(() -> Component.literal((String)line), false);
            }
            return jobs.size();
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendCommands] executeCourierListAll failed", t);
            source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Error while listing courier jobs; see log."));
            return 0;
        }
    }

    private static int executeCourierListPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        try {
            Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"player");
            if (profiles.isEmpty()) {
                source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] No matching player found."));
                return 0;
            }
            GameProfile profile = (GameProfile)profiles.iterator().next();
            UUID targetUuid = profile.getId();
            String targetName = profile.getName();
            if (targetUuid == null) {
                source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Target player UUID is null."));
                return 0;
            }
            ServerLevel level = source.getLevel();
            RavenCourierData data = RavenCourierData.get(level);
            List<RavenCourierData.DeliveryJob> jobs = data.getJobsForPlayer(targetUuid);
            if (jobs.isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)("[FeatheredFriend] No courier jobs found for player '" + targetName + "'.")), false);
                return 0;
            }
            source.sendSuccess(() -> Component.literal((String)("[FeatheredFriend] Courier jobs for '" + targetName + "': " + jobs.size())), false);
            for (RavenCourierData.DeliveryJob job : jobs) {
                if (job == null) continue;
                String line = String.format(" - id=%d sender='%s' [%s] -> recipient='%s' [%s] inFlight=%s failed=%s", job.jobId, job.senderName, job.senderUuid, job.recipientName, job.recipientUuid, job.inFlight, job.failed);
                source.sendSuccess(() -> Component.literal((String)line), false);
            }
            return jobs.size();
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendCommands] executeCourierListPlayer failed", t);
            source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Error while listing courier jobs for player; see log."));
            return 0;
        }
    }

    private static int executeCourierClearAll(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        try {
            ServerLevel level = source.getLevel();
            RavenCourierData data = RavenCourierData.get(level);
            int removed = data.clearAllJobs();
            source.sendSuccess(() -> Component.literal((String)("[FeatheredFriend] Cleared " + removed + " raven courier job(s) from the world.")), true);
            return removed > 0 ? 1 : 0;
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendCommands] executeCourierClearAll failed", t);
            source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Error while clearing courier jobs; see log."));
            return 0;
        }
    }

    private static int executeCourierClearPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        try {
            Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"player");
            if (profiles.isEmpty()) {
                source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] No matching player found."));
                return 0;
            }
            GameProfile profile = (GameProfile)profiles.iterator().next();
            UUID targetUuid = profile.getId();
            String targetName = profile.getName();
            if (targetUuid == null) {
                source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Target player UUID is null."));
                return 0;
            }
            ServerLevel level = source.getLevel();
            RavenCourierData data = RavenCourierData.get(level);
            int removed = data.clearJobsForPlayer(targetUuid);
            source.sendSuccess(() -> Component.literal((String)("[FeatheredFriend] Cleared " + removed + " raven courier job(s) for player '" + targetName + "'.")), true);
            return removed > 0 ? 1 : 0;
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendCommands] executeCourierClearPlayer failed", t);
            source.sendFailure((Component)Component.literal((String)"[FeatheredFriend] Error while clearing courier jobs for player; see log."));
            return 0;
        }
    }
}

