/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.screen;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.z2six.featheredfriend.network.FFNetwork;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class RavenNamingScreen
extends Screen {
    private static final Logger LOG = LogUtils.getLogger();
    private static final int MAX_NAME_CHARS = 26;
    private final int ravenEntityId;
    private EditBox nameBox;
    private Button doneButton;
    private Button cancelButton;

    public RavenNamingScreen(int ravenEntityId) {
        super((Component)Component.literal((String)"Name your raven"));
        this.ravenEntityId = ravenEntityId;
    }

    protected void init() {
        super.init();
        try {
            int centerX = this.width / 2;
            int centerY = this.height / 2;
            this.nameBox = new EditBox(this.font, centerX - 100, centerY - 20, 200, 20, (Component)Component.literal((String)"Name your raven"));
            this.nameBox.setMaxLength(26);
            this.nameBox.setFocused(true);
            this.nameBox.setValue("");
            this.addRenderableWidget((GuiEventListener)this.nameBox);
            this.doneButton = Button.builder((Component)Component.translatable((String)"gui.done"), btn -> this.onDone()).bounds(centerX - 100, centerY + 10, 95, 20).build();
            this.cancelButton = Button.builder((Component)Component.translatable((String)"gui.cancel"), btn -> this.onCancel()).bounds(centerX + 5, centerY + 10, 95, 20).build();
            this.addRenderableWidget((GuiEventListener)this.doneButton);
            this.addRenderableWidget((GuiEventListener)this.cancelButton);
        }
        catch (Throwable t) {
            LOG.error("[RavenNamingScreen] init failed", t);
        }
    }

    public void tick() {
        try {
            super.tick();
        }
        catch (Throwable t) {
            LOG.warn("[RavenNamingScreen] tick failed safely: {}", (Object)t.toString());
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        try {
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
            guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)"Name your raven:"), this.width / 2, this.height / 2 - 35, 0xFFFFFF);
            if (this.nameBox != null) {
                this.nameBox.render(guiGraphics, mouseX, mouseY, partialTick);
            }
            super.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        catch (Throwable t) {
            LOG.error("[RavenNamingScreen] render failed", t);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        try {
            if (keyCode == 257 || keyCode == 335) {
                this.onDone();
                return true;
            }
            if (keyCode == 256) {
                this.onCancel();
                return true;
            }
            if (this.nameBox != null && this.nameBox.keyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        catch (Throwable t) {
            LOG.error("[RavenNamingScreen] keyPressed failed", t);
            return false;
        }
    }

    public boolean charTyped(char codePoint, int modifiers) {
        try {
            if (this.nameBox != null && this.nameBox.charTyped(codePoint, modifiers)) {
                return true;
            }
            return super.charTyped(codePoint, modifiers);
        }
        catch (Throwable t) {
            LOG.error("[RavenNamingScreen] charTyped failed", t);
            return false;
        }
    }

    private void onDone() {
        try {
            String name;
            if (this.minecraft == null) {
                return;
            }
            String string = name = this.nameBox != null ? this.nameBox.getValue() : "";
            if (name == null) {
                name = "";
            }
            if (name.length() > 26) {
                name = name.substring(0, 26);
            }
            LOG.info("[RavenNamingScreen] onDone: sending name='{}' for ravenEntityId={}", (Object)name, (Object)this.ravenEntityId);
            FFNetwork.sendRavenNameChosenToServer(this.ravenEntityId, name);
            this.onClose();
        }
        catch (Throwable t) {
            LOG.error("[RavenNamingScreen] onDone failed", t);
            this.onClose();
        }
    }

    private void onCancel() {
        try {
            LOG.info("[RavenNamingScreen] onCancel: closing without sending name (ravenEntityId={})", (Object)this.ravenEntityId);
            this.onClose();
        }
        catch (Throwable t) {
            LOG.error("[RavenNamingScreen] onCancel failed", t);
            this.onClose();
        }
    }

    public void onClose() {
        try {
            Minecraft mc = this.minecraft;
            if (mc != null) {
                mc.setScreen(null);
            }
        }
        catch (Throwable t) {
            LOG.error("[RavenNamingScreen] onClose failed", t);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

