/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.raven.render.model;

import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.z2six.featheredfriend.client.raven.RavenVisuals;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import net.z2six.featheredfriend.entity.raven.RavenVariant;
import org.slf4j.Logger;
import software.bernie.geckolib.model.GeoModel;

public class RavenGeoModel
extends GeoModel<RavenEntity> {
    private static final Logger LOG = LogUtils.getLogger();

    public ResourceLocation getModelResource(RavenEntity animatable) {
        try {
            RavenVariant v = animatable != null ? animatable.getVariant() : RavenVariant.NORMAL;
            return RavenGeoModel.DYNCATCH(RavenVisuals.model(v), RavenVisuals.model(RavenVariant.NORMAL));
        }
        catch (Throwable t) {
            LOG.error("[RavenGeoModel] getModelResource failed, defaulting to NORMAL model", t);
            return RavenVisuals.model(RavenVariant.NORMAL);
        }
    }

    public ResourceLocation getTextureResource(RavenEntity animatable) {
        try {
            RavenVariant v = animatable != null ? animatable.getVariant() : RavenVariant.NORMAL;
            return RavenGeoModel.DYNCATCH(RavenVisuals.texture(v), RavenVisuals.texture(RavenVariant.NORMAL));
        }
        catch (Throwable t) {
            LOG.error("[RavenGeoModel] getTextureResource failed, defaulting to NORMAL texture", t);
            return RavenVisuals.texture(RavenVariant.NORMAL);
        }
    }

    public ResourceLocation getAnimationResource(RavenEntity animatable) {
        try {
            RavenVariant v = animatable != null ? animatable.getVariant() : RavenVariant.NORMAL;
            return RavenGeoModel.DYNCATCH(RavenVisuals.animation(v), RavenVisuals.animation(RavenVariant.NORMAL));
        }
        catch (Throwable t) {
            LOG.error("[RavenGeoModel] getAnimationResource failed, defaulting to NORMAL animation", t);
            return RavenVisuals.animation(RavenVariant.NORMAL);
        }
    }

    private static ResourceLocation DYNCATCH(ResourceLocation value, ResourceLocation fallback) {
        return value != null ? value : fallback;
    }
}

