/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.raven.render;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.z2six.featheredfriend.client.raven.render.model.RavenGeoModel;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import net.z2six.featheredfriend.entity.raven.modules.Teleportation;
import org.slf4j.Logger;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.Color;

public class RavenRenderer
extends GeoEntityRenderer<RavenEntity> {
    private static final Logger LOG = LogUtils.getLogger();

    public RavenRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new RavenGeoModel());
        try {
            this.shadowRadius = 0.25f;
        }
        catch (Throwable t) {
            LOG.error("[RavenRenderer] Failed to set shadowRadius", t);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("[RavenRenderer] Constructed (translucent+alpha override active).");
        }
    }

    public RenderType getRenderType(RavenEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        try {
            return RenderType.entityTranslucent((ResourceLocation)texture);
        }
        catch (Throwable t) {
            if (animatable != null && animatable.tickCount % 80 == 0) {
                LOG.warn("[RavenRenderer] getRenderType failed safely; falling back to GeoEntityRenderer: {}", (Object)t.toString());
            }
            return super.getRenderType((Entity)animatable, texture, bufferSource, partialTick);
        }
    }

    public Color getRenderColor(RavenEntity animatable, float partialTick, int packedLight) {
        try {
            if (animatable == null) {
                return Color.WHITE;
            }
            Teleportation tp = null;
            try {
                tp = animatable.getTeleportation();
            }
            catch (Throwable ignored) {
                tp = null;
            }
            int a = 255;
            if (tp != null) {
                try {
                    a = tp.getTeleportFadeAlphaPublic(animatable);
                }
                catch (Throwable t) {
                    a = 255;
                    if (animatable.tickCount % 80 == 0) {
                        LOG.warn("[RavenRenderer] getRenderColor: getTeleportFadeAlphaPublic failed safely: {}", (Object)t.toString());
                    }
                }
            } else if (animatable.tickCount % 200 == 0) {
                LOG.warn("[RavenRenderer] getRenderColor: teleportation module is null for id={} pos={}", (Object)animatable.getId(), (Object)animatable.position());
            }
            if (a < 0) {
                a = 0;
            }
            if (a > 255) {
                a = 255;
            }
            Color c = Color.ofRGBA((int)255, (int)255, (int)255, (int)a);
            if (a != 0 && a != 255 && animatable.tickCount % 10 == 0) {
                LOG.debug("[RavenRenderer] Fade active: id={} alpha={} pos={} phaseHint={}", new Object[]{animatable.getId(), a, animatable.position(), "render"});
            }
            return c;
        }
        catch (Throwable t) {
            if (animatable != null && animatable.tickCount % 80 == 0) {
                LOG.warn("[RavenRenderer] getRenderColor failed safely: {}", (Object)t.toString());
            }
            return Color.WHITE;
        }
    }
}

