/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.particle;

import com.mojang.logging.LogUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class FeatherParticle
extends TextureSheetParticle {
    private static final Logger LOG = LogUtils.getLogger();
    private static final double SPAWN_RADIUS = 0.6;
    private static final double SPAWN_Y_JITTER = 0.15;
    private static final double BASE_OUTWARD_SPEED = 0.06;
    private static final double OUTWARD_SPEED_RANDOM_FACTOR = 0.05;
    private static final double INITIAL_UPWARD_SPEED = 0.08;
    private static final double FEATHER_GRAVITY_PER_TICK = 0.015;
    private static final double HORIZONTAL_DRAG = 0.92;
    private static final double VERTICAL_DRAG = 0.96;
    private static final int FEATHER_LIFETIME_MIN_TICKS = 26;
    private static final int FEATHER_LIFETIME_MAX_TICKS = 42;
    private static final float FEATHER_BASE_SCALE = 0.18f;
    private static final float FEATHER_SCALE_VARIATION = 0.05f;
    private static final float FEATHER_MAX_SWING_DEG = 90.0f;
    private static final float FEATHER_SWING_SPEED_DEG_PER_TICK = 7.0f;
    private final SpriteSet sprites;
    private final float maxSwingRad;
    private final float swingSpeedRadPerTick;

    private FeatherParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, SpriteSet sprites) {
        super(level, x, y, z, dx, dy, dz);
        this.sprites = sprites;
        RandomSource rnd = level.random;
        double angle = rnd.nextDouble() * (Math.PI * 2);
        double radius = rnd.nextDouble() * 0.6;
        Vec3 center = new Vec3(x, y, z);
        double px = center.x + Math.cos(angle) * radius;
        double pz = center.z + Math.sin(angle) * radius;
        double py = center.y + (rnd.nextDouble() * 2.0 - 1.0) * 0.15;
        this.setPos(px, py, pz);
        double dirX = px - center.x;
        double dirZ = pz - center.z;
        double len = Math.sqrt(dirX * dirX + dirZ * dirZ);
        if (len < 1.0E-4) {
            double tmpAngle = rnd.nextDouble() * (Math.PI * 2);
            dirX = Math.cos(tmpAngle);
            dirZ = Math.sin(tmpAngle);
            len = 1.0;
        }
        double outwardBase = 0.06;
        double outwardJitter = 0.05 * rnd.nextDouble();
        double outward = outwardBase + outwardJitter;
        this.xd = (dirX /= len) * outward;
        this.zd = (dirZ /= len) * outward;
        this.yd = 0.08 * (0.75 + rnd.nextDouble() * 0.5);
        this.quadSize = 0.18f + (float)((rnd.nextDouble() * 2.0 - 1.0) * (double)0.05f);
        this.lifetime = Mth.nextInt((RandomSource)rnd, (int)26, (int)42);
        this.gravity = 0.0f;
        this.roll = 0.0f;
        this.oRoll = 0.0f;
        this.maxSwingRad = 1.5707964f;
        this.swingSpeedRadPerTick = 0.12217305f;
        this.setSpriteFromAge(this.sprites);
    }

    public void tick() {
        try {
            this.xo = this.x;
            this.yo = this.y;
            this.zo = this.z;
            this.oRoll = this.roll;
            ++this.age;
            if (this.age >= this.lifetime) {
                this.remove();
                return;
            }
            float phase = (float)this.age * this.swingSpeedRadPerTick;
            this.roll = this.maxSwingRad * Mth.sin((float)phase);
            this.xd *= 0.92;
            this.zd *= 0.92;
            this.yd -= 0.015;
            this.yd *= 0.96;
            this.move(this.xd, this.yd, this.zd);
            this.setSpriteFromAge(this.sprites);
        }
        catch (Throwable t) {
            if (this.level != null && this.level.getGameTime() % 200L == 0L) {
                LOG.warn("[FeatherParticle] tick failed safely: {}", (Object)t.toString());
            }
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static final class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            try {
                return new FeatherParticle(level, x, y, z, dx, dy, dz, this.sprites);
            }
            catch (Throwable t) {
                if (level != null && level.getGameTime() % 200L == 0L) {
                    LOG.warn("[FeatherParticle.Provider] createParticle failed safely: {}", (Object)t.toString());
                }
                return null;
            }
        }
    }
}

