/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.particle;

import com.mojang.logging.LogUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.slf4j.Logger;

public class EnderpopParticle
extends TextureSheetParticle {
    private static final Logger LOG = LogUtils.getLogger();
    private final SpriteSet sprites;
    private final float rollRad;
    private final int totalLifetime;
    private final float baseSize;
    private final float sizeJitter;

    protected EnderpopParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, int lifetimeTicks, SpriteSet sprites) {
        super(level, x, y, z, xd, yd, zd);
        int lt;
        this.sprites = sprites;
        this.totalLifetime = lt = lifetimeTicks > 0 ? lifetimeTicks : 10;
        this.lifetime = lt;
        this.xd = xd * 0.15;
        this.yd = yd * 0.15;
        this.zd = zd * 0.15;
        this.gravity = 0.0f;
        this.friction = 0.85f;
        this.baseSize = 0.55f;
        this.sizeJitter = 0.25f;
        this.quadSize = this.baseSize;
        RandomSource r = this.random != null ? this.random : RandomSource.create();
        this.rollRad = r.nextFloat() * ((float)Math.PI * 2);
        this.alpha = 0.0f;
        try {
            this.setSpriteFromAge(this.sprites);
        }
        catch (Throwable t) {
            LOG.warn("[EnderpopParticle] setSpriteFromAge failed safely: {}", (Object)t.toString());
        }
    }

    public void tick() {
        block2: {
            super.tick();
            try {
                this.setSpriteFromAge(this.sprites);
                this.oRoll = this.roll;
                this.roll = this.rollRad;
                float p = (float)this.age / (float)Math.max(1, this.totalLifetime);
                p = Mth.clamp((float)p, (float)0.0f, (float)1.0f);
                float fadeEdge = 0.18f;
                float a = p < fadeEdge ? p / fadeEdge : (p > 1.0f - fadeEdge ? (1.0f - p) / fadeEdge : 1.0f);
                float pop = 1.0f + (float)Math.sin(Mth.clamp((float)(p / 0.5f), (float)0.0f, (float)1.0f) * (float)Math.PI) * this.sizeJitter;
                this.quadSize = this.baseSize * pop;
                this.alpha = Mth.clamp((float)a, (float)0.0f, (float)1.0f);
                this.xd *= 0.6;
                this.yd *= 0.6;
                this.zd *= 0.6;
            }
            catch (Throwable t) {
                if (this.age % 10 != 0) break block2;
                LOG.warn("[EnderpopParticle] tick failed safely: {}", (Object)t.toString());
            }
        }
    }

    public int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            int lifetimeTicks = 10;
            return new EnderpopParticle(level, x, y, z, xd, yd, zd, lifetimeTicks, this.sprites);
        }
    }
}

