/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.network;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.z2six.featheredfriend.client.knownplayers.KnownPlayersClientCache;
import net.z2six.featheredfriend.client.screen.RavenNamingScreen;
import net.z2six.featheredfriend.network.FFNetwork;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class FFNetworkClientHandlers {
    private static final Logger LOG = LogUtils.getLogger();

    private FFNetworkClientHandlers() {
    }

    public static void handleKnownPlayersOnClient(@NotNull FFNetwork.KnownPlayersPayload payload, @NotNull IPayloadContext context) {
        try {
            KnownPlayersClientCache cache = KnownPlayersClientCache.getInstance();
            cache.replaceAllFromServer(payload.players());
            LOG.debug("[FFNetworkClientHandlers] Updated client known-players cache: {} entries", (Object)payload.players().size());
        }
        catch (Throwable t) {
            LOG.error("[FFNetworkClientHandlers] handleKnownPlayersOnClient failed", t);
        }
    }

    public static void handleOpenRavenNameScreenOnClient(@NotNull FFNetwork.OpenRavenNameScreenPayload payload, @NotNull IPayloadContext context) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                return;
            }
            if (mc.player == null) {
                return;
            }
            if (mc.level == null) {
                return;
            }
            int id = payload.ravenEntityId();
            LOG.debug("[FFNetworkClientHandlers] Opening RavenNamingScreen for ravenEntityId={}", (Object)id);
            mc.setScreen((Screen)new RavenNamingScreen(id));
        }
        catch (Throwable t) {
            LOG.error("[FFNetworkClientHandlers] handleOpenRavenNameScreenOnClient failed", t);
        }
    }
}

