/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.knownplayers;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.z2six.featheredfriend.network.FFNetwork;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class KnownPlayersClientCache {
    private static final Logger LOG = LogUtils.getLogger();
    private static final KnownPlayersClientCache INSTANCE = new KnownPlayersClientCache();
    private final Map<UUID, String> knownNames = new ConcurrentHashMap<UUID, String>();
    private volatile long lastOnlineRefreshClientTick = -1L;

    public static KnownPlayersClientCache getInstance() {
        return INSTANCE;
    }

    private KnownPlayersClientCache() {
        LOG.debug("[KnownPlayersClientCache] Singleton created");
    }

    public synchronized void replaceAllFromServer(@NotNull Collection<FFNetwork.KnownPlayerInfo> newEntries) {
        try {
            this.knownNames.clear();
            int kept = 0;
            for (FFNetwork.KnownPlayerInfo info : newEntries) {
                if (info == null) continue;
                UUID uuid = info.uuid();
                String name = info.name();
                if (uuid == null || name == null || name.isBlank()) continue;
                this.knownNames.put(uuid, name);
                ++kept;
            }
            LOG.info("[KnownPlayersClientCache] replaceAllFromServer: now tracking {} known players", (Object)kept);
            this.refreshOnlineNow();
        }
        catch (Throwable t) {
            LOG.error("[KnownPlayersClientCache] replaceAllFromServer failed", t);
        }
    }

    public synchronized void upsert(@Nullable UUID uuid, @Nullable String name) {
        if (uuid == null) {
            return;
        }
        if (name == null || name.isBlank()) {
            return;
        }
        try {
            this.knownNames.put(uuid, name);
        }
        catch (Throwable t) {
            LOG.error("[KnownPlayersClientCache] upsert failed for uuid={}", (Object)uuid, (Object)t);
        }
    }

    public void requestRefreshFromServer() {
        try {
            FFNetwork.sendRequestKnownPlayersToServer();
        }
        catch (Throwable t) {
            LOG.error("[KnownPlayersClientCache] requestRefreshFromServer failed", t);
        }
    }

    @NotNull
    public synchronized List<KnownPlayerEntry> getAllPlayersSorted() {
        try {
            this.refreshOnlinePeriodically();
            Set<UUID> onlineNow = this.getOnlineUuidsFromConnection();
            ArrayList<KnownPlayerEntry> out = new ArrayList<KnownPlayerEntry>(this.knownNames.size());
            for (Map.Entry<UUID, String> e : this.knownNames.entrySet()) {
                UUID uuid = e.getKey();
                String name = e.getValue();
                if (uuid == null || name == null || name.isBlank()) continue;
                boolean online = onlineNow.contains(uuid);
                out.add(new KnownPlayerEntry(uuid, name, online));
            }
            out.sort(Comparator.comparing(KnownPlayerEntry::getName, String.CASE_INSENSITIVE_ORDER));
            return out;
        }
        catch (Throwable t) {
            LOG.error("[KnownPlayersClientCache] getAllPlayersSorted failed", t);
            return List.of();
        }
    }

    public synchronized void refreshFromClientConnection() {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.getConnection() == null) {
                return;
            }
            Collection infoList = mc.getConnection().getOnlinePlayers();
            if (infoList == null) {
                return;
            }
            int added = 0;
            for (PlayerInfo info : infoList) {
                if (info == null || info.getProfile() == null) continue;
                UUID uuid = info.getProfile().getId();
                String name = info.getProfile().getName();
                if (uuid == null || name == null || name.isBlank()) continue;
                if (!this.knownNames.containsKey(uuid)) {
                    ++added;
                }
                this.knownNames.put(uuid, name);
            }
            if (added > 0) {
                LOG.debug("[KnownPlayersClientCache] refreshFromClientConnection: added {} online players into known list", (Object)added);
            }
            this.refreshOnlineNow();
        }
        catch (Throwable t) {
            LOG.error("[KnownPlayersClientCache] refreshFromClientConnection failed", t);
        }
    }

    private void refreshOnlinePeriodically() {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.player == null) {
                return;
            }
            long tick = mc.player.tickCount;
            if (this.lastOnlineRefreshClientTick >= 0L && tick - this.lastOnlineRefreshClientTick < 10L) {
                return;
            }
            this.lastOnlineRefreshClientTick = tick;
            Set<UUID> online = this.getOnlineUuidsFromConnection();
            LOG.debug("[KnownPlayersClientCache] refreshOnlinePeriodically: onlineCount={} knownCount={}", (Object)online.size(), (Object)this.knownNames.size());
        }
        catch (Throwable t) {
            LOG.error("[KnownPlayersClientCache] refreshOnlinePeriodically failed", t);
        }
    }

    private void refreshOnlineNow() {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.player == null) {
                return;
            }
            this.lastOnlineRefreshClientTick = mc.player.tickCount;
        }
        catch (Throwable t) {
            LOG.error("[KnownPlayersClientCache] refreshOnlineNow failed", t);
        }
    }

    @NotNull
    private Set<UUID> getOnlineUuidsFromConnection() {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.getConnection() == null) {
                return Set.of();
            }
            Collection infoList = mc.getConnection().getOnlinePlayers();
            if (infoList == null) {
                return Set.of();
            }
            HashSet<UUID> out = new HashSet<UUID>();
            for (PlayerInfo info : infoList) {
                UUID uuid;
                if (info == null || info.getProfile() == null || (uuid = info.getProfile().getId()) == null) continue;
                out.add(uuid);
            }
            return out;
        }
        catch (Throwable t) {
            LOG.error("[KnownPlayersClientCache] getOnlineUuidsFromConnection failed", t);
            return Set.of();
        }
    }

    public static final class KnownPlayerEntry {
        private final UUID uuid;
        private final String name;
        private final boolean online;

        public KnownPlayerEntry(@NotNull UUID uuid, @NotNull String name, boolean online) {
            this.uuid = uuid;
            this.name = name;
            this.online = online;
        }

        @NotNull
        public UUID getUuid() {
            return this.uuid;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public boolean isOnline() {
            return this.online;
        }
    }
}

