/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.gui.widget;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.z2six.featheredfriend.item.SealStampItem;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class SealStampSelectionOverlay {
    private static final Logger LOG = LogUtils.getLogger();
    private static FavoriteStampKey GLOBAL_FAVORITE = null;
    private final Minecraft minecraft;
    private final Font font;
    private final SelectionCallback callback;
    private int x;
    private int y;
    private final int width;
    private final int height;
    private boolean active = false;
    private final List<Entry> entries = new ArrayList<Entry>();
    private int selectedIndex = -1;
    private int hoverIndex = -1;
    private static final int GRID_PADDING = 4;
    private static final int SLOT_SIZE = 18;
    private static final int LABEL_HEIGHT = 12;
    private static final int LABEL_MARGIN_BOTTOM = 2;

    public SealStampSelectionOverlay(@NotNull Minecraft minecraft, @NotNull Font font, int x, int y, int width, int height, @NotNull SelectionCallback callback) {
        this.minecraft = minecraft;
        this.font = font;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.callback = callback;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (!active) {
            this.hoverIndex = -1;
        }
    }

    public void rebuildEntriesAndAutoSelectFavorite() {
        try {
            ItemStack offhand;
            this.entries.clear();
            this.selectedIndex = -1;
            this.hoverIndex = -1;
            LocalPlayer player = this.minecraft.player;
            if (player == null) {
                LOG.warn("[SealStampSelectionOverlay] rebuildEntries: player is null");
                return;
            }
            Inventory inv = player.getInventory();
            int added = 0;
            for (int slot = 0; slot < inv.items.size() && added < 9; ++slot) {
                ItemStack stack = (ItemStack)inv.items.get(slot);
                if (stack == null || stack.isEmpty() || !(stack.getItem() instanceof SealStampItem)) continue;
                this.entries.add(new Entry(slot, stack.copy()));
                ++added;
            }
            if (added < 9 && (offhand = player.getOffhandItem()) != null && !offhand.isEmpty() && offhand.getItem() instanceof SealStampItem) {
                this.entries.add(new Entry(37, offhand.copy()));
                ++added;
            }
            LOG.debug("[SealStampSelectionOverlay] rebuildEntries: found {} SealStampItem stacks", (Object)this.entries.size());
            if (GLOBAL_FAVORITE != null && !this.entries.isEmpty()) {
                for (int i = 0; i < this.entries.size(); ++i) {
                    Entry e = this.entries.get(i);
                    FavoriteStampKey key = this.extractFavoriteKey(e.stack);
                    if (key == null || !key.equals(GLOBAL_FAVORITE)) continue;
                    this.selectedIndex = i;
                    LOG.debug("[SealStampSelectionOverlay] Auto-selected favourite stamp at index {}: {}", (Object)i, (Object)key);
                    if (this.callback != null) {
                        this.callback.onStampSelected(e.slotIndex, e.stack.copy());
                    }
                    return;
                }
                LOG.debug("[SealStampSelectionOverlay] Favourite stamp not present in current entries");
            }
        }
        catch (Throwable t) {
            LOG.error("[SealStampSelectionOverlay] rebuildEntriesAndAutoSelectFavorite failed", t);
            this.entries.clear();
            this.selectedIndex = -1;
            this.hoverIndex = -1;
        }
    }

    public void tick() {
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.active) {
            return;
        }
        try {
            int x0 = this.x;
            int y0 = this.y;
            int x1 = x0 + this.width;
            int y1 = y0 + this.height;
            guiGraphics.fill(x0, y0, x1, y1, -1073741824);
            guiGraphics.fill(x0, y0, x1, y0 + 1, -1);
            guiGraphics.fill(x0, y1 - 1, x1, y1, -1);
            guiGraphics.fill(x0, y0, x0 + 1, y1, -1);
            guiGraphics.fill(x1 - 1, y0, x1, y1, -1);
            String labelText = "Choose Seal Stamp";
            int lw = this.font.width(labelText);
            int labelX = x0 + (this.width - lw) / 2;
            int labelY = y0 + 2;
            guiGraphics.drawString(this.font, labelText, labelX, labelY, 0xFFFFFF, false);
            int gridLeft = x0 + 4;
            int gridTop = y0 + 12 + 2 + 4;
            this.hoverIndex = -1;
            for (int i = 0; i < this.entries.size(); ++i) {
                boolean hovered;
                Entry e = this.entries.get(i);
                int row = i / 3;
                int col = i % 3;
                int sx = gridLeft + col * 18;
                int sy = gridTop + row * 18;
                int slotX1 = sx + 16;
                int slotY1 = sy + 16;
                boolean bl = hovered = mouseX >= sx && mouseX < slotX1 && mouseY >= sy && mouseY < slotY1;
                if (hovered) {
                    this.hoverIndex = i;
                }
                int bgColor = hovered ? -2130706433 : 0x40000000;
                guiGraphics.fill(sx - 1, sy - 1, sx + 17, sy + 17, bgColor);
                guiGraphics.fill(sx, sy, sx + 16, sy + 16, -14671840);
                guiGraphics.renderItem(e.stack, sx, sy);
                guiGraphics.renderItemDecorations(this.font, e.stack, sx, sy);
                if (i == this.selectedIndex) {
                    int selColor = -10496;
                    guiGraphics.fill(sx - 1, sy - 1, sx + 17, sy, selColor);
                    guiGraphics.fill(sx - 1, sy + 16, sx + 17, sy + 17, selColor);
                    guiGraphics.fill(sx - 1, sy, sx, sy + 16, selColor);
                    guiGraphics.fill(sx + 16, sy, sx + 17, sy + 16, selColor);
                }
                if (!this.isFavoriteEntry(e)) continue;
                guiGraphics.drawString(this.font, "\u2605", sx + 10, sy - 2, -10496, false);
            }
        }
        catch (Throwable t) {
            LOG.error("[SealStampSelectionOverlay] render failed", t);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.active) {
            return false;
        }
        try {
            int x0 = this.x;
            int y0 = this.y;
            int x1 = x0 + this.width;
            int y1 = y0 + this.height;
            if (mouseX < (double)x0 || mouseX >= (double)x1 || mouseY < (double)y0 || mouseY >= (double)y1) {
                return false;
            }
            int gridLeft = x0 + 4;
            int gridTop = y0 + 12 + 2 + 4;
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry e = this.entries.get(i);
                int row = i / 3;
                int col = i % 3;
                int sx = gridLeft + col * 18;
                int sy = gridTop + row * 18;
                int slotX1 = sx + 16;
                int slotY1 = sy + 16;
                if (!(mouseX >= (double)sx) || !(mouseX < (double)slotX1) || !(mouseY >= (double)sy) || !(mouseY < (double)slotY1)) continue;
                if (button == 0) {
                    this.selectedIndex = i;
                    LOG.debug("[SealStampSelectionOverlay] Slot {} selected (logical slotIndex={})", (Object)i, (Object)e.slotIndex);
                    if (this.callback != null) {
                        this.callback.onStampSelected(e.slotIndex, e.stack.copy());
                    }
                } else if (button == 1) {
                    FavoriteStampKey key = this.extractFavoriteKey(e.stack);
                    if (key == null) {
                        LOG.warn("[SealStampSelectionOverlay] Right-click favourite toggle: stamp has no SealStamp data");
                    } else if (GLOBAL_FAVORITE != null && GLOBAL_FAVORITE.equals(key)) {
                        LOG.debug("[SealStampSelectionOverlay] Favourite cleared: {}", (Object)key);
                        GLOBAL_FAVORITE = null;
                    } else {
                        LOG.debug("[SealStampSelectionOverlay] Favourite set to: {}", (Object)key);
                        GLOBAL_FAVORITE = key;
                    }
                }
                return true;
            }
            return true;
        }
        catch (Throwable t) {
            LOG.error("[SealStampSelectionOverlay] mouseClicked failed", t);
            return true;
        }
    }

    private boolean isFavoriteEntry(@NotNull Entry entry) {
        if (GLOBAL_FAVORITE == null) {
            return false;
        }
        FavoriteStampKey key = this.extractFavoriteKey(entry.stack);
        return key != null && key.equals(GLOBAL_FAVORITE);
    }

    private FavoriteStampKey extractFavoriteKey(@NotNull ItemStack stack) {
        try {
            if (stack.isEmpty() || !(stack.getItem() instanceof SealStampItem)) {
                return null;
            }
            CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag root = data.copyTag();
            if (root == null) {
                return null;
            }
            CompoundTag seal = root.getCompound("SealStamp");
            if (seal == null || seal.isEmpty()) {
                return null;
            }
            String owner = seal.getString("Owner");
            long seed = seal.getLong("Seed");
            int slices = seal.getInt("Slices");
            int shapeSet = seal.getInt("ShapeSet");
            return new FavoriteStampKey(owner, seed, slices, shapeSet);
        }
        catch (Throwable t) {
            LOG.error("[SealStampSelectionOverlay] extractFavoriteKey failed", t);
            return null;
        }
    }

    public static interface SelectionCallback {
        public void onStampSelected(int var1, @NotNull ItemStack var2);

        default public void onOverlayClosedWithoutSelection() {
        }
    }

    private static final class Entry {
        final int slotIndex;
        final ItemStack stack;

        Entry(int slotIndex, @NotNull ItemStack stack) {
            this.slotIndex = slotIndex;
            this.stack = stack;
        }
    }

    private static final class FavoriteStampKey {
        final String owner;
        final long seed;
        final int slices;
        final int shapeSet;

        FavoriteStampKey(String owner, long seed, int slices, int shapeSet) {
            this.owner = owner;
            this.seed = seed;
            this.slices = slices;
            this.shapeSet = shapeSet;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FavoriteStampKey)) {
                return false;
            }
            FavoriteStampKey other = (FavoriteStampKey)o;
            return this.seed == other.seed && this.slices == other.slices && this.shapeSet == other.shapeSet && (this.owner == null && other.owner == null || this.owner != null && this.owner.equals(other.owner));
        }

        public int hashCode() {
            int result = this.owner != null ? this.owner.hashCode() : 0;
            result = 31 * result + Long.hashCode(this.seed);
            result = 31 * result + this.slices;
            result = 31 * result + this.shapeSet;
            return result;
        }

        public String toString() {
            return "FavoriteStampKey{owner='" + this.owner + "', seed=" + this.seed + ", slices=" + this.slices + ", shapeSet=" + this.shapeSet + "}";
        }
    }
}

