/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.gui.widget;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.z2six.featheredfriend.client.gui.widget.MultiLineScrollTextWidget;
import net.z2six.featheredfriend.client.knownplayers.KnownPlayersClientCache;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class RecipientOverlay {
    private static final Logger LOG = LogUtils.getLogger();
    private final Minecraft minecraft;
    private final Font font;
    private final SelectionCallback callback;
    private int x;
    private int y;
    private final int width;
    private final int height;
    private boolean active = false;
    private static final int PADDING = 6;
    private static final int HEADER_HEIGHT = 12;
    private static final int FILTER_HEIGHT = 14;
    private static final int ENTRY_HEIGHT = 14;
    private static final int ENTRY_SPACING = 2;
    private final MultiLineScrollTextWidget filterField;
    private List<KnownPlayersClientCache.KnownPlayerEntry> allPlayers = new ArrayList<KnownPlayersClientCache.KnownPlayerEntry>();
    private List<KnownPlayersClientCache.KnownPlayerEntry> visiblePlayers = new ArrayList<KnownPlayersClientCache.KnownPlayerEntry>();

    public RecipientOverlay(@NotNull Minecraft minecraft, @NotNull Font font, int x, int y, int width, int height, @NotNull SelectionCallback callback) {
        this.minecraft = minecraft;
        this.font = font;
        this.callback = callback;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.filterField = new MultiLineScrollTextWidget(font, x + 6, y + 6 + 12, width - 12, 14, 64, 1, (Component)Component.literal((String)"Filter players..."));
        try {
            this.filterField.setTextColor(-1);
            LOG.debug("[RecipientOverlay] Set filterField text color to 0xFFFFFFFF (white)");
        }
        catch (Throwable t) {
            LOG.error("[RecipientOverlay] Failed to set filterField text color", t);
        }
        LOG.debug("[RecipientOverlay] Created at ({},{}) size=({},{})", new Object[]{x, y, width, height});
    }

    public boolean isActive() {
        return this.active;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.filterField.setX(x + 6);
        this.filterField.setY(y + 6 + 12);
    }

    public void open() {
        try {
            this.active = true;
            LOG.debug("[RecipientOverlay] open()");
            this.filterField.setText("");
            this.filterField.setFocused(true);
            try {
                KnownPlayersClientCache.getInstance().requestRefreshFromServer();
                LOG.debug("[RecipientOverlay] Requested known player refresh from server");
            }
            catch (Throwable t) {
                LOG.error("[RecipientOverlay] Failed to request known players from server", t);
            }
            this.reloadFromClientCache();
        }
        catch (Throwable t) {
            LOG.error("[RecipientOverlay] open() failed", t);
        }
    }

    public void close(boolean notifyCallback) {
        if (!this.active) {
            return;
        }
        try {
            this.active = false;
            LOG.debug("[RecipientOverlay] close() notifyCallback={}", (Object)notifyCallback);
            this.filterField.setFocused(false);
            if (notifyCallback && this.callback != null) {
                this.callback.onOverlayClosedWithoutSelection();
            }
        }
        catch (Throwable t) {
            LOG.error("[RecipientOverlay] close() failed", t);
        }
    }

    public boolean isMouseOverOverlay(double mouseX, double mouseY) {
        if (!this.active) {
            return false;
        }
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public void tick() {
        if (!this.active) {
            return;
        }
        try {
            this.filterField.tick();
            this.reloadFromClientCache();
            this.updateFilter();
        }
        catch (Throwable t) {
            LOG.error("[RecipientOverlay] tick() failed", t);
        }
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (!this.active) {
            return false;
        }
        try {
            boolean handled = this.filterField.charTyped(codePoint, modifiers);
            if (handled) {
                this.updateFilter();
                return true;
            }
        }
        catch (Throwable t) {
            LOG.error("[RecipientOverlay] charTyped failed", t);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.active) {
            return false;
        }
        try {
            if (keyCode == 256) {
                this.close(true);
                return true;
            }
            if (keyCode == 69) {
                return true;
            }
            boolean handled = this.filterField.keyPressed(keyCode, scanCode, modifiers);
            if (handled) {
                this.updateFilter();
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            LOG.error("[RecipientOverlay] keyPressed failed", t);
            return false;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.active || button != 0) {
            return false;
        }
        try {
            if (!this.isMouseOverOverlay(mouseX, mouseY)) {
                this.close(true);
                LOG.debug("[RecipientOverlay] Click outside overlay -> closing");
                return true;
            }
            int mouseYInt = (int)mouseY;
            int listTop = this.y + 6 + 12 + 14 + 6;
            int index = (mouseYInt - listTop) / 16;
            if (index >= 0 && index < this.visiblePlayers.size()) {
                KnownPlayersClientCache.KnownPlayerEntry entry = this.visiblePlayers.get(index);
                if (entry != null && entry.getUuid() != null && entry.getName() != null && !entry.getName().isBlank()) {
                    if (this.callback != null) {
                        this.callback.onPlayerSelected(entry.getUuid(), entry.getName());
                    }
                    this.close(false);
                    return true;
                }
                LOG.warn("[RecipientOverlay] Clicked invalid entry index={} entry={}", (Object)index, (Object)entry);
            }
            this.filterField.mouseClicked(mouseX, mouseY, button);
            return true;
        }
        catch (Throwable t) {
            LOG.error("[RecipientOverlay] mouseClicked failed", t);
            return false;
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.active) {
            return;
        }
        try {
            int listTop;
            guiGraphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, -1073741824);
            guiGraphics.fill(this.x + 1, this.y + 1, this.x + this.width - 1, this.y + this.height - 1, -1071504862);
            this.filterField.render(guiGraphics, mouseX, mouseY, partialTick);
            int currentY = listTop = this.y + 6 + 12 + 14 + 6;
            for (KnownPlayersClientCache.KnownPlayerEntry entry : this.visiblePlayers) {
                if (currentY + 14 <= this.y + this.height - 6) {
                    this.renderEntry(guiGraphics, entry, currentY);
                    currentY += 16;
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            LOG.error("[RecipientOverlay] render() failed", t);
        }
    }

    private void reloadFromClientCache() {
        try {
            KnownPlayersClientCache cache = KnownPlayersClientCache.getInstance();
            cache.refreshFromClientConnection();
            List<KnownPlayersClientCache.KnownPlayerEntry> players = cache.getAllPlayersSorted();
            this.allPlayers = new ArrayList<KnownPlayersClientCache.KnownPlayerEntry>(players);
            this.allPlayers.sort(Comparator.comparing(KnownPlayersClientCache.KnownPlayerEntry::getName, String.CASE_INSENSITIVE_ORDER));
            this.visiblePlayers = new ArrayList<KnownPlayersClientCache.KnownPlayerEntry>(this.allPlayers);
            LOG.debug("[RecipientOverlay] reloadFromClientCache: {} players", (Object)this.allPlayers.size());
        }
        catch (Throwable t) {
            LOG.error("[RecipientOverlay] reloadFromClientCache failed", t);
            this.allPlayers = new ArrayList<KnownPlayersClientCache.KnownPlayerEntry>();
            this.visiblePlayers = new ArrayList<KnownPlayersClientCache.KnownPlayerEntry>();
        }
    }

    private void updateFilter() {
        try {
            String lower;
            String filter = this.filterField.getText();
            String string = lower = filter == null ? "" : filter.toLowerCase(Locale.ROOT);
            if (lower.isEmpty()) {
                this.visiblePlayers = new ArrayList<KnownPlayersClientCache.KnownPlayerEntry>(this.allPlayers);
                return;
            }
            ArrayList<KnownPlayersClientCache.KnownPlayerEntry> filtered = new ArrayList<KnownPlayersClientCache.KnownPlayerEntry>();
            for (KnownPlayersClientCache.KnownPlayerEntry p : this.allPlayers) {
                if (p == null || p.getName() == null || !p.getName().toLowerCase(Locale.ROOT).contains(lower)) continue;
                filtered.add(p);
            }
            this.visiblePlayers = filtered;
        }
        catch (Throwable t) {
            LOG.error("[RecipientOverlay] updateFilter failed", t);
        }
    }

    private void renderEntry(@NotNull GuiGraphics g, @NotNull KnownPlayersClientCache.KnownPlayerEntry entry, int yTop) {
        int xLeft = this.x + 6;
        int xRight = this.x + this.width - 6;
        g.fill(xLeft, yTop, xRight, yTop + 14, -2145246686);
        int headSize = 10;
        int headX = xLeft + 2;
        int headY = yTop + 2;
        g.fill(headX, headY, headX + headSize, headY + headSize, -11184811);
        int dotRadius = 3;
        int dotCx = xRight - 6;
        int dotCy = yTop + 7;
        int dotColor = entry.isOnline() ? -16711936 : -65536;
        g.fill(dotCx - dotRadius, dotCy - dotRadius, dotCx + dotRadius, dotCy + dotRadius, dotColor);
        g.drawString(this.font, entry.getName(), headX + headSize + 4, yTop + 3, -1, false);
    }

    public static interface SelectionCallback {
        public void onPlayerSelected(UUID var1, String var2);

        public void onOverlayClosedWithoutSelection();
    }
}

