/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.gui.widget;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MultiLineScrollTextWidget
extends AbstractWidget {
    private static final Logger LOG = LogUtils.getLogger();
    private final Font font;
    private final int maxChars;
    private final int maxLines;
    private final Component placeholder;
    private boolean editable = true;
    private String text = "";
    private int cursorIndex = 0;
    private int tickCount = 0;
    private int textColor = 0;
    private int placeholderColor = 0x707070;
    private int alpha = 255;
    private final List<LineInfo> visualLines = new ArrayList<LineInfo>();
    @Nullable
    private ResourceLocation customFontId;
    private final boolean allowNewlines;
    private int selectionStart = -1;
    private int selectionEnd = -1;
    private int selectionAnchor = -1;
    private final HashMap<Integer, Integer> charWidthCache = new HashMap();

    public MultiLineScrollTextWidget(@NotNull Font font, int x, int y, int width, int height, int maxChars, int maxLines, @NotNull Component placeholder) {
        this(font, x, y, width, height, maxChars, maxLines, placeholder, null, true);
    }

    public MultiLineScrollTextWidget(@NotNull Font font, int x, int y, int width, int height, int maxChars, int maxLines, @NotNull Component placeholder, @Nullable ResourceLocation customFontId) {
        this(font, x, y, width, height, maxChars, maxLines, placeholder, customFontId, true);
    }

    public MultiLineScrollTextWidget(@NotNull Font font, int x, int y, int width, int height, int maxChars, int maxLines, @NotNull Component placeholder, @Nullable ResourceLocation customFontId, boolean allowNewlines) {
        super(x, y, width, height, placeholder);
        this.font = font;
        this.maxChars = Math.max(1, maxChars);
        this.maxLines = Math.max(1, maxLines);
        this.placeholder = placeholder;
        this.customFontId = customFontId;
        this.allowNewlines = allowNewlines;
        this.setFocused(false);
        this.active = true;
        this.visible = true;
        LOG.debug("[MultiLineScrollTextWidget] Created at ({},{}) size=({},{}) maxChars={} maxLines={} fontId={} allowNewlines={}", new Object[]{x, y, width, height, this.maxChars, this.maxLines, this.customFontId, this.allowNewlines});
        this.reflowLines();
    }

    public void tick() {
        ++this.tickCount;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        if (newText == null) {
            newText = "";
        }
        if (newText.length() > this.maxChars) {
            newText = newText.substring(0, this.maxChars);
        }
        this.text = newText;
        this.cursorIndex = Math.min(this.cursorIndex, this.text.length());
        this.clearSelection();
        this.reflowLines();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setCustomFontId(@Nullable ResourceLocation fontId) {
        this.customFontId = fontId;
        try {
            this.charWidthCache.clear();
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] Failed to clear font caches", t);
        }
        LOG.debug("[MultiLineScrollTextWidget] setCustomFontId -> {}", (Object)fontId);
    }

    public void setTextColor(int argb) {
        try {
            this.textColor = argb;
            LOG.debug("[MultiLineScrollTextWidget] setTextColor -> 0x{}", (Object)Integer.toHexString(argb));
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] setTextColor failed", t);
        }
    }

    public void setPlaceholderColor(int rgb) {
        try {
            this.placeholderColor = rgb;
            LOG.debug("[MultiLineScrollTextWidget] setPlaceholderColor -> 0x{}", (Object)Integer.toHexString(rgb));
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] setPlaceholderColor failed", t);
        }
    }

    public void setAlpha(int alpha) {
        try {
            if (alpha < 0) {
                alpha = 0;
            }
            if (alpha > 255) {
                alpha = 255;
            }
            this.alpha = alpha;
            LOG.debug("[MultiLineScrollTextWidget] setAlpha -> {}", (Object)this.alpha);
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] setAlpha failed", t);
        }
    }

    private boolean hasSelection() {
        return this.selectionStart >= 0 && this.selectionEnd > this.selectionStart && this.selectionEnd <= this.text.length();
    }

    public void setCursorToEnd() {
        try {
            this.moveCursorToEnd(false);
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] setCursorToEnd failed", t);
        }
    }

    private void clearSelection() {
        this.selectionStart = -1;
        this.selectionEnd = -1;
        this.selectionAnchor = -1;
    }

    private void selectAll() {
        if (this.text.isEmpty()) {
            this.clearSelection();
            this.cursorIndex = 0;
            return;
        }
        this.selectionStart = 0;
        this.selectionEnd = this.text.length();
        this.selectionAnchor = 0;
        this.cursorIndex = this.text.length();
    }

    private void deleteSelection() {
        if (!this.hasSelection()) {
            return;
        }
        try {
            int start = this.selectionStart;
            int end = this.selectionEnd;
            String before = MultiLineScrollTextWidget.safeSubstring(this.text, 0, start);
            String after = MultiLineScrollTextWidget.safeSubstring(this.text, end, this.text.length());
            this.text = before + after;
            this.cursorIndex = start;
            this.clearSelection();
            LOG.debug("[MultiLineScrollTextWidget] deleteSelection: newText='{}'", (Object)this.text);
            this.reflowLines();
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] deleteSelection failed", t);
        }
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        try {
            if (this.text.isEmpty() && !this.isFocused()) {
                this.drawStringWithFont(guiGraphics, this.placeholder, this.getX() + 2, this.getY() + 2, this.placeholderColor);
                return;
            }
            this.reflowLines();
            int lineY = this.getY() + 2;
            int lineIndex = 0;
            for (LineInfo info : this.visualLines) {
                int lineEnd;
                if (lineIndex >= this.maxLines) break;
                int lineStart = info.start();
                String line = MultiLineScrollTextWidget.safeSubstring(this.text, lineStart, lineEnd = info.end());
                if (!line.isEmpty() && line.charAt(line.length() - 1) == '\n') {
                    line = line.substring(0, line.length() - 1);
                    --lineEnd;
                }
                if (this.hasSelection()) {
                    int overlapEnd;
                    int selStart = this.selectionStart;
                    int selEnd = this.selectionEnd;
                    int overlapStart = Math.max(lineStart, selStart);
                    if (overlapStart < (overlapEnd = Math.min(lineEnd, selEnd))) {
                        String beforeSelection = MultiLineScrollTextWidget.safeSubstring(this.text, lineStart, overlapStart);
                        String selectedPart = MultiLineScrollTextWidget.safeSubstring(this.text, overlapStart, overlapEnd);
                        if (!selectedPart.isEmpty() && selectedPart.charAt(selectedPart.length() - 1) == '\n') {
                            selectedPart = selectedPart.substring(0, selectedPart.length() - 1);
                        }
                        Component beforeComp = this.applyCustomFont((Component)Component.literal((String)beforeSelection));
                        Component selectedComp = this.applyCustomFont((Component)Component.literal((String)selectedPart));
                        int baseX = this.getX() + 2;
                        int x0 = baseX + this.font.width((FormattedText)beforeComp);
                        int x1 = x0 + this.font.width((FormattedText)selectedComp);
                        int y0 = lineY;
                        Objects.requireNonNull(this.font);
                        int y1 = lineY + 9;
                        guiGraphics.fill(x0, y0, x1, y1, -2140755201);
                    }
                }
                this.drawStringWithFont(guiGraphics, (Component)Component.literal((String)line), this.getX() + 2, lineY, this.textColor);
                Objects.requireNonNull(this.font);
                lineY += 9;
                ++lineIndex;
            }
            if (this.isFocused() && this.tickCount / 6 % 2 == 0) {
                this.drawCaret(guiGraphics);
            }
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] renderWidget failed", t);
        }
    }

    private void drawCaret(@NotNull GuiGraphics guiGraphics) {
        try {
            int caretX = this.getX() + 2;
            int caretY = this.getY() + 2;
            this.reflowLines();
            if (this.allowNewlines && !this.text.isEmpty() && this.text.charAt(this.text.length() - 1) == '\n' && this.cursorIndex == this.text.length() && !this.visualLines.isEmpty()) {
                int lineIdx = this.visualLines.size();
                caretX = this.getX() + 2;
                int n = this.getY() + 2;
                Objects.requireNonNull(this.font);
                int top = caretY = n + lineIdx * 9;
                Objects.requireNonNull(this.font);
                int bottom = caretY + 9;
                guiGraphics.fill(caretX, top, caretX + 1, bottom, -16777216);
                return;
            }
            int lineIdx = 0;
            boolean placed = false;
            for (LineInfo info : this.visualLines) {
                if (lineIdx >= this.maxLines) break;
                int start = info.start();
                int end = info.end();
                if (this.cursorIndex < start) break;
                if (this.cursorIndex > end || this.cursorIndex == end && end > start && this.text.charAt(end - 1) == '\n') {
                    ++lineIdx;
                    continue;
                }
                String beforeCaret = MultiLineScrollTextWidget.safeSubstring(this.text, start, this.cursorIndex);
                if (!beforeCaret.isEmpty() && beforeCaret.charAt(beforeCaret.length() - 1) == '\n') {
                    beforeCaret = beforeCaret.substring(0, beforeCaret.length() - 1);
                }
                Component beforeComp = this.applyCustomFont((Component)Component.literal((String)beforeCaret));
                int width = this.font.width((FormattedText)beforeComp);
                caretX = this.getX() + 2 + width;
                int n = this.getY() + 2;
                Objects.requireNonNull(this.font);
                caretY = n + lineIdx * 9;
                placed = true;
                break;
            }
            if (!placed) {
                Component fullComp = this.applyCustomFont((Component)Component.literal((String)this.text));
                caretX = this.getX() + 2 + this.font.width((FormattedText)fullComp);
                caretY = this.getY() + 2;
            }
            int top = caretY;
            Objects.requireNonNull(this.font);
            int bottom = caretY + 9;
            guiGraphics.fill(caretX, top, caretX + 1, bottom, -16777216);
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] drawCaret failed", t);
        }
    }

    private void drawStringWithFont(@NotNull GuiGraphics guiGraphics, @NotNull Component base, int x, int y, int color) {
        Component toDraw = this.applyCustomFont(base);
        int argb = this.alpha << 24 | color & 0xFFFFFF;
        guiGraphics.drawString(this.font, toDraw, x, y, argb, false);
    }

    private void drawStringWithFont(@NotNull GuiGraphics guiGraphics, @NotNull Component base, int x, int y, int color, boolean shadow) {
        Component toDraw = this.applyCustomFont(base);
        int argb = this.alpha << 24 | color & 0xFFFFFF;
        guiGraphics.drawString(this.font, toDraw, x, y, argb, shadow);
    }

    private int measureCharWidth(char c) {
        try {
            int fontHash = this.customFontId != null ? this.customFontId.hashCode() : 0;
            int key = fontHash * 31 ^ c;
            Integer cached = this.charWidthCache.get(key);
            if (cached != null) {
                return cached;
            }
            Component comp = this.applyCustomFont((Component)Component.literal((String)String.valueOf(c)));
            int w = this.font.width((FormattedText)comp);
            this.charWidthCache.put(key, w);
            return w;
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] measureCharWidth failed, falling back to vanilla width", t);
            try {
                return this.font.width(String.valueOf(c));
            }
            catch (Throwable ignored) {
                return 0;
            }
        }
    }

    private Component applyCustomFont(@NotNull Component base) {
        if (this.customFontId == null) {
            return base;
        }
        try {
            MutableComponent mutable = base.copy();
            Style style = mutable.getStyle().withFont(this.customFontId);
            mutable.setStyle(style);
            return mutable;
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] applyCustomFont failed, falling back to default font", t);
            return base;
        }
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (!(this.isFocused() && this.active && this.editable)) {
            return false;
        }
        if (codePoint == '\r') {
            return false;
        }
        if (codePoint == '\n') {
            if (!this.allowNewlines) {
                return false;
            }
            try {
                if (!this.canInsertNewlineHere()) {
                    return true;
                }
                this.insertText("\n");
                return true;
            }
            catch (Throwable t) {
                LOG.error("[MultiLineScrollTextWidget] charTyped newline failed", t);
                return false;
            }
        }
        if (!MultiLineScrollTextWidget.isAllowedCharacter(codePoint)) {
            return false;
        }
        try {
            if (this.text.length() >= this.maxChars) {
                return true;
            }
            this.insertText(String.valueOf(codePoint));
            return true;
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] charTyped failed", t);
            return false;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!(this.isFocused() && this.active && this.editable)) {
            return false;
        }
        boolean ctrl = Screen.hasControlDown();
        boolean shift = Screen.hasShiftDown();
        try {
            return switch (keyCode) {
                case 257, 335 -> {
                    if (this.allowNewlines) {
                        if (!this.canInsertNewlineHere()) {
                            yield true;
                        }
                        this.insertText("\n");
                        yield true;
                    }
                    yield false;
                }
                case 259 -> {
                    if (ctrl) {
                        this.deletePreviousWord();
                    } else {
                        this.deleteFromCursor(-1);
                    }
                    yield true;
                }
                case 261 -> {
                    if (ctrl) {
                        this.deleteNextWord();
                    } else {
                        this.deleteFromCursor(1);
                    }
                    yield true;
                }
                case 263 -> {
                    this.moveCursorByWordOrChar(-1, ctrl, shift);
                    yield true;
                }
                case 262 -> {
                    this.moveCursorByWordOrChar(1, ctrl, shift);
                    yield true;
                }
                case 265 -> {
                    this.moveCaretVertically(-1);
                    yield true;
                }
                case 264 -> {
                    this.moveCaretVertically(1);
                    yield true;
                }
                case 268 -> {
                    this.moveCursorToStart(shift);
                    yield true;
                }
                case 269 -> {
                    this.moveCursorToEnd(shift);
                    yield true;
                }
                case 65 -> {
                    if (ctrl) {
                        this.selectAll();
                        yield true;
                    }
                    yield false;
                }
                case 67 -> {
                    if (ctrl) {
                        this.copySelectionToClipboard();
                        yield true;
                    }
                    yield false;
                }
                case 88 -> {
                    if (ctrl) {
                        this.cutSelectionToClipboard();
                        yield true;
                    }
                    yield false;
                }
                case 86 -> {
                    if (ctrl) {
                        this.pasteFromClipboard();
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] keyPressed failed", t);
            return false;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean inside;
        if (!this.active || !this.visible) {
            return false;
        }
        if (button != 0) {
            return false;
        }
        boolean bl = inside = mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height);
        if (!inside) {
            return false;
        }
        try {
            this.setFocused(true);
            int indexAtClick = this.getIndexAtPosition(mouseX, mouseY);
            this.cursorIndex = Math.max(0, Math.min(indexAtClick, this.text.length()));
            this.clearSelection();
            this.selectionAnchor = this.cursorIndex;
            return true;
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] mouseClicked failed", t);
            return false;
        }
    }

    private static boolean isAllowedCharacter(char c) {
        return c >= ' ' && c != '\u007f';
    }

    private boolean canInsertNewlineHere() {
        try {
            if (this.text.isEmpty()) {
                return true;
            }
            this.reflowLines();
            if (this.cursorIndex == this.text.length() && this.visualLines.size() >= this.maxLines) {
                LOG.debug("[MultiLineScrollTextWidget] Blocking newline: caret at end and maxLines already used");
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] canInsertNewlineHere failed, allowing newline by default", t);
            return true;
        }
    }

    private int getIndexAtPosition(double mouseX, double mouseY) {
        int relX;
        int lineEnd;
        LineInfo info;
        int lineStart;
        String line;
        if (this.text.isEmpty() || this.visualLines.isEmpty()) {
            return this.text.length();
        }
        int baseX = this.getX() + 2;
        int baseY = this.getY() + 2;
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        int relY = (int)Math.floor(mouseY - (double)baseY);
        int lineIdx = relY <= 0 ? 0 : relY / lineHeight;
        if (lineIdx < 0) {
            lineIdx = 0;
        }
        if (lineIdx >= this.visualLines.size()) {
            lineIdx = this.visualLines.size() - 1;
        }
        if (!(line = MultiLineScrollTextWidget.safeSubstring(this.text, lineStart = (info = this.visualLines.get(lineIdx)).start(), lineEnd = info.end())).isEmpty() && line.charAt(line.length() - 1) == '\n') {
            line = line.substring(0, line.length() - 1);
            --lineEnd;
        }
        if ((relX = (int)Math.floor(mouseX - (double)baseX)) <= 0) {
            return lineStart;
        }
        int currentX = 0;
        int lastIndex = lineStart;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            Component comp = this.applyCustomFont((Component)Component.literal((String)String.valueOf(c)));
            int w = this.font.width((FormattedText)comp);
            if (relX < currentX + w / 2) {
                return lineStart + i;
            }
            currentX += w;
            lastIndex = lineStart + i + 1;
        }
        return lastIndex;
    }

    private void moveCaretVertically(int direction) {
        try {
            boolean endsWithNewline;
            int lineEnd;
            int targetLineIdx;
            LineInfo info;
            this.reflowLines();
            if (this.visualLines.isEmpty()) {
                return;
            }
            if (this.allowNewlines && !this.text.isEmpty() && this.text.charAt(this.text.length() - 1) == '\n' && this.cursorIndex == this.text.length() && !this.visualLines.isEmpty()) {
                boolean endsWithNewline2;
                int lineEnd2;
                int currentLineIdx = this.visualLines.size();
                int columnX = 0;
                int targetLineIdx2 = currentLineIdx + direction;
                if (targetLineIdx2 < 0 || targetLineIdx2 >= this.visualLines.size()) {
                    return;
                }
                LineInfo targetInfo = this.visualLines.get(targetLineIdx2);
                int lineStart = targetInfo.start();
                String lineText = MultiLineScrollTextWidget.safeSubstring(this.text, lineStart, lineEnd2 = targetInfo.end());
                boolean bl = endsWithNewline2 = !lineText.isEmpty() && lineText.charAt(lineText.length() - 1) == '\n';
                if (endsWithNewline2) {
                    lineText = lineText.substring(0, lineText.length() - 1);
                }
                int runningX = 0;
                int bestIndex = lineStart;
                int bestDiff = Math.abs(columnX);
                for (int i = 0; i <= lineText.length(); ++i) {
                    int diff;
                    if (i > 0) {
                        char c = lineText.charAt(i - 1);
                        Component comp = this.applyCustomFont((Component)Component.literal((String)String.valueOf(c)));
                        runningX += this.font.width((FormattedText)comp);
                    }
                    if ((diff = Math.abs(runningX - columnX)) > bestDiff) continue;
                    bestDiff = diff;
                    bestIndex = lineStart + i;
                }
                this.updateCursorAndSelection(bestIndex, false);
                return;
            }
            int currentLineIdx = 0;
            int columnX = 0;
            boolean found = false;
            for (int i = 0; i < this.visualLines.size(); ++i) {
                info = this.visualLines.get(i);
                int start = info.start();
                int end = info.end();
                if (this.cursorIndex < start) break;
                if (this.cursorIndex > end || this.cursorIndex == end && end > start && this.text.charAt(end - 1) == '\n') continue;
                String beforeCaret = MultiLineScrollTextWidget.safeSubstring(this.text, start, this.cursorIndex);
                if (!beforeCaret.isEmpty() && beforeCaret.charAt(beforeCaret.length() - 1) == '\n') {
                    beforeCaret = beforeCaret.substring(0, beforeCaret.length() - 1);
                }
                Component comp = this.applyCustomFont((Component)Component.literal((String)beforeCaret));
                columnX = this.font.width((FormattedText)comp);
                currentLineIdx = i;
                found = true;
                break;
            }
            if (!found) {
                int lastIdx = this.visualLines.size() - 1;
                info = this.visualLines.get(lastIdx);
                String beforeCaret = MultiLineScrollTextWidget.safeSubstring(this.text, info.start(), this.cursorIndex);
                if (!beforeCaret.isEmpty() && beforeCaret.charAt(beforeCaret.length() - 1) == '\n') {
                    beforeCaret = beforeCaret.substring(0, beforeCaret.length() - 1);
                }
                Component comp = this.applyCustomFont((Component)Component.literal((String)beforeCaret));
                columnX = this.font.width((FormattedText)comp);
                currentLineIdx = lastIdx;
            }
            if ((targetLineIdx = currentLineIdx + direction) < 0 || targetLineIdx >= this.visualLines.size()) {
                return;
            }
            LineInfo targetInfo = this.visualLines.get(targetLineIdx);
            int lineStart = targetInfo.start();
            String lineText = MultiLineScrollTextWidget.safeSubstring(this.text, lineStart, lineEnd = targetInfo.end());
            boolean bl = endsWithNewline = !lineText.isEmpty() && lineText.charAt(lineText.length() - 1) == '\n';
            if (endsWithNewline) {
                lineText = lineText.substring(0, lineText.length() - 1);
            }
            int runningX = 0;
            int bestIndex = lineStart;
            int bestDiff = Math.abs(columnX);
            for (int i = 0; i <= lineText.length(); ++i) {
                int diff;
                if (i > 0) {
                    char c = lineText.charAt(i - 1);
                    Component comp = this.applyCustomFont((Component)Component.literal((String)String.valueOf(c)));
                    runningX += this.font.width((FormattedText)comp);
                }
                if ((diff = Math.abs(runningX - columnX)) > bestDiff) continue;
                bestDiff = diff;
                bestIndex = lineStart + i;
            }
            this.updateCursorAndSelection(bestIndex, false);
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] moveCaretVertically failed", t);
        }
    }

    private void insertText(@NotNull String toInsert) {
        int remaining;
        if (toInsert.isEmpty()) {
            return;
        }
        if (this.hasSelection()) {
            this.deleteSelection();
        }
        if ((remaining = this.maxChars - this.text.length()) <= 0) {
            return;
        }
        int allowed = Math.min(toInsert.length(), remaining);
        String insert = toInsert.substring(0, allowed);
        if (!this.wouldFitWithInsertion(insert)) {
            LOG.debug("[MultiLineScrollTextWidget] insertText blocked because it would overflow the text box");
            return;
        }
        String before = MultiLineScrollTextWidget.safeSubstring(this.text, 0, this.cursorIndex);
        String after = MultiLineScrollTextWidget.safeSubstring(this.text, this.cursorIndex, this.text.length());
        this.text = before + insert + after;
        this.cursorIndex += insert.length();
        this.clearSelection();
        this.selectionAnchor = this.cursorIndex;
        LOG.debug("[MultiLineScrollTextWidget] insertText: newText='{}'", (Object)this.text);
        this.reflowLines();
    }

    private void deleteFromCursor(int direction) {
        if (this.text.isEmpty()) {
            return;
        }
        if (this.hasSelection()) {
            this.deleteSelection();
            return;
        }
        if (direction < 0) {
            if (this.cursorIndex <= 0) {
                return;
            }
            String before = MultiLineScrollTextWidget.safeSubstring(this.text, 0, this.cursorIndex - 1);
            String after = MultiLineScrollTextWidget.safeSubstring(this.text, this.cursorIndex, this.text.length());
            this.text = before + after;
            --this.cursorIndex;
        } else if (direction > 0) {
            if (this.cursorIndex >= this.text.length()) {
                return;
            }
            String before = MultiLineScrollTextWidget.safeSubstring(this.text, 0, this.cursorIndex);
            String after = MultiLineScrollTextWidget.safeSubstring(this.text, this.cursorIndex + 1, this.text.length());
            this.text = before + after;
        }
        LOG.debug("[MultiLineScrollTextWidget] deleteFromCursor: newText='{}'", (Object)this.text);
        this.reflowLines();
    }

    private void moveCursorByWordOrChar(int direction, boolean ctrl, boolean shift) {
        int newIndex = ctrl ? this.findWordBoundary(direction) : this.cursorIndex + direction;
        newIndex = Math.max(0, Math.min(newIndex, this.text.length()));
        this.updateCursorAndSelection(newIndex, shift);
    }

    private void updateCursorAndSelection(int newIndex, boolean shift) {
        if (!shift) {
            this.cursorIndex = newIndex;
            this.clearSelection();
            this.selectionAnchor = newIndex;
        } else {
            if (this.selectionAnchor < 0) {
                this.selectionAnchor = this.cursorIndex;
            }
            this.cursorIndex = newIndex;
            this.selectionStart = Math.min(this.selectionAnchor, this.cursorIndex);
            this.selectionEnd = Math.max(this.selectionAnchor, this.cursorIndex);
        }
    }

    private void moveCursorToStart(boolean shift) {
        try {
            this.reflowLines();
            if (this.visualLines.isEmpty()) {
                this.updateCursorAndSelection(0, shift);
                return;
            }
            int targetIndex = 0;
            boolean found = false;
            for (LineInfo info : this.visualLines) {
                int start = info.start();
                int end = info.end();
                if (this.cursorIndex < start) break;
                if (this.cursorIndex > end || this.cursorIndex == end && end > start && this.text.charAt(end - 1) == '\n') continue;
                targetIndex = start;
                found = true;
                break;
            }
            if (!found) {
                targetIndex = 0;
            }
            this.updateCursorAndSelection(targetIndex, shift);
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] moveCursorToStart(line) failed", t);
            this.updateCursorAndSelection(0, shift);
        }
    }

    private void moveCursorToStart() {
        this.moveCursorToStart(false);
    }

    private void moveCursorToEnd(boolean shift) {
        this.updateCursorAndSelection(this.text.length(), shift);
    }

    private void moveCursorToEnd() {
        this.moveCursorToEnd(false);
    }

    private int findWordBoundary(int direction) {
        int i;
        if (this.text.isEmpty()) {
            return 0;
        }
        int len = this.text.length();
        int idx = this.cursorIndex;
        if (direction < 0) {
            int i2;
            if (idx <= 0) {
                return 0;
            }
            for (i2 = idx; i2 > 0 && Character.isWhitespace(this.text.charAt(i2 - 1)); --i2) {
            }
            while (i2 > 0 && !Character.isWhitespace(this.text.charAt(i2 - 1))) {
                --i2;
            }
            return i2;
        }
        if (idx >= len) {
            return len;
        }
        for (i = idx; i < len && Character.isWhitespace(this.text.charAt(i)); ++i) {
        }
        while (i < len && !Character.isWhitespace(this.text.charAt(i))) {
            ++i;
        }
        return i;
    }

    private void deletePreviousWord() {
        if (this.text.isEmpty()) {
            return;
        }
        if (this.hasSelection()) {
            this.deleteSelection();
            return;
        }
        int newPos = this.findWordBoundary(-1);
        if (newPos == this.cursorIndex) {
            return;
        }
        try {
            String before = MultiLineScrollTextWidget.safeSubstring(this.text, 0, newPos);
            String after = MultiLineScrollTextWidget.safeSubstring(this.text, this.cursorIndex, this.text.length());
            this.text = before + after;
            this.cursorIndex = newPos;
            this.clearSelection();
            this.selectionAnchor = this.cursorIndex;
            LOG.debug("[MultiLineScrollTextWidget] deletePreviousWord: newText='{}'", (Object)this.text);
            this.reflowLines();
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] deletePreviousWord failed", t);
        }
    }

    private void deleteNextWord() {
        if (this.text.isEmpty()) {
            return;
        }
        if (this.hasSelection()) {
            this.deleteSelection();
            return;
        }
        int newPos = this.findWordBoundary(1);
        if (newPos == this.cursorIndex) {
            return;
        }
        try {
            String before = MultiLineScrollTextWidget.safeSubstring(this.text, 0, this.cursorIndex);
            String after = MultiLineScrollTextWidget.safeSubstring(this.text, newPos, this.text.length());
            this.text = before + after;
            this.clearSelection();
            this.selectionAnchor = this.cursorIndex;
            LOG.debug("[MultiLineScrollTextWidget] deleteNextWord: newText='{}'", (Object)this.text);
            this.reflowLines();
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] deleteNextWord failed", t);
        }
    }

    private void copySelectionToClipboard() {
        if (!this.hasSelection()) {
            return;
        }
        try {
            String selected = MultiLineScrollTextWidget.safeSubstring(this.text, this.selectionStart, this.selectionEnd);
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                return;
            }
            mc.keyboardHandler.setClipboard(selected);
            LOG.debug("[MultiLineScrollTextWidget] Copied selection to clipboard");
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] copySelectionToClipboard failed", t);
        }
    }

    private void cutSelectionToClipboard() {
        if (!this.hasSelection()) {
            return;
        }
        try {
            String selected = MultiLineScrollTextWidget.safeSubstring(this.text, this.selectionStart, this.selectionEnd);
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                return;
            }
            mc.keyboardHandler.setClipboard(selected);
            LOG.debug("[MultiLineScrollTextWidget] Cut selection to clipboard");
            this.deleteSelection();
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] cutSelectionToClipboard failed", t);
        }
    }

    private void pasteFromClipboard() {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                return;
            }
            String clip = mc.keyboardHandler.getClipboard();
            if (clip == null || clip.isEmpty()) {
                return;
            }
            clip = clip.replace("\r\n", "\n").replace('\r', '\n');
            if (!this.allowNewlines) {
                clip = clip.replace("\n", " ");
            }
            this.insertText(clip);
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] pasteFromClipboard failed", t);
        }
    }

    private boolean wouldFitWithInsertion(@NotNull String toInsert) {
        try {
            if (toInsert.isEmpty()) {
                return false;
            }
            int remaining = this.maxChars - this.text.length();
            if (remaining <= 0) {
                return false;
            }
            int allowed = Math.min(toInsert.length(), remaining);
            String insert = toInsert.substring(0, allowed);
            String before = MultiLineScrollTextWidget.safeSubstring(this.text, 0, this.cursorIndex);
            String after = MultiLineScrollTextWidget.safeSubstring(this.text, this.cursorIndex, this.text.length());
            String candidate = before + insert + after;
            return this.wouldFitText(candidate);
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] wouldFitWithInsertion failed", t);
            return false;
        }
    }

    private boolean wouldFitText(@NotNull String candidate) {
        if (candidate.isEmpty()) {
            return true;
        }
        int maxWidth = this.width - 4;
        if (maxWidth <= 0) {
            return false;
        }
        int len = candidate.length();
        int idx = 0;
        int lines = 0;
        while (idx < len) {
            int lineEnd;
            if (++lines > this.maxLines) {
                return false;
            }
            int lineStart = idx;
            int lastSpace = -1;
            int currentWidth = 0;
            for (lineEnd = idx; lineEnd < len; ++lineEnd) {
                char c = candidate.charAt(lineEnd);
                if (c == '\n') {
                    ++lineEnd;
                    break;
                }
                int charWidth = this.measureCharWidth(c);
                if (currentWidth + charWidth > maxWidth) {
                    if (lastSpace <= lineStart) break;
                    lineEnd = lastSpace + 1;
                    break;
                }
                currentWidth += charWidth;
                if (c != ' ') continue;
                lastSpace = lineEnd;
            }
            if (lineEnd == lineStart) {
                lineEnd = Math.min(lineStart + 1, len);
            }
            idx = lineEnd;
        }
        return true;
    }

    private void moveCursor(int delta) {
        int newIndex = this.cursorIndex + delta;
        this.cursorIndex = newIndex = Math.max(0, Math.min(newIndex, this.text.length()));
        this.clearSelection();
        this.selectionAnchor = this.cursorIndex;
    }

    private void reflowLines() {
        try {
            this.visualLines.clear();
            if (this.text.isEmpty()) {
                return;
            }
            int maxWidth = this.width - 4;
            if (maxWidth <= 0) {
                return;
            }
            int idx = 0;
            String t = this.text;
            while (idx < t.length() && this.visualLines.size() < this.maxLines) {
                int lineEnd;
                int lineStart = idx;
                int lastSpace = -1;
                int currentWidth = 0;
                for (lineEnd = idx; lineEnd < t.length(); ++lineEnd) {
                    char c = t.charAt(lineEnd);
                    if (c == '\n') {
                        ++lineEnd;
                        break;
                    }
                    int charWidth = this.measureCharWidth(c);
                    if (currentWidth + charWidth > maxWidth) {
                        if (lastSpace <= lineStart) break;
                        lineEnd = lastSpace + 1;
                        break;
                    }
                    currentWidth += charWidth;
                    if (c != ' ') continue;
                    lastSpace = lineEnd;
                }
                if (lineEnd == lineStart) {
                    lineEnd = Math.min(lineStart + 1, t.length());
                }
                this.visualLines.add(new LineInfo(lineStart, lineEnd));
                idx = lineEnd;
            }
        }
        catch (Throwable t) {
            LOG.error("[MultiLineScrollTextWidget] reflowLines failed", t);
        }
    }

    private static String safeSubstring(String s, int start, int end) {
        int e0;
        int len = s.length();
        int s0 = Math.max(0, Math.min(start, len));
        if (s0 >= (e0 = Math.max(0, Math.min(end, len)))) {
            return "";
        }
        return s.substring(s0, e0);
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    private record LineInfo(int start, int end) {
    }
}

