/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.z2six.featheredfriend.sigil.SealSigilGenerator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class WaxSealVisualizer {
    private static final Logger LOG = LogUtils.getLogger();
    private static final ResourceLocation WAX_SEAL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"textures/gui/stampscreen/wax_seal.png");
    private static final int WAX_SEAL_TEXTURE_WIDTH = 39;
    private static final int WAX_SEAL_TEXTURE_HEIGHT = 38;
    private static final int GOLD_DISC_COLOR = -2047904;
    private boolean waxEnabled = true;
    private int shapeFillColor = -4702658;
    private boolean shapeEnableHighlight = true;
    private boolean shapeEnableShadow = true;
    private int shapeHighlightEdgeMaxRadius = 1;
    private int shapeShadowEdgeMaxRadius = 3;
    private int shapeHighlightColor = -2921886;
    private int shapeShadowColor = -8183500;
    private int shapeHighlightDirection = 6;
    private int shapeShadowDirection = 8;

    public WaxSealVisualizer setWaxEnabled(boolean enabled) {
        this.waxEnabled = enabled;
        return this;
    }

    public WaxSealVisualizer setShapeFillColor(int argb) {
        this.shapeFillColor = argb;
        return this;
    }

    public WaxSealVisualizer setShapeEnableHighlight(boolean enabled) {
        this.shapeEnableHighlight = enabled;
        return this;
    }

    public WaxSealVisualizer setShapeEnableShadow(boolean enabled) {
        this.shapeEnableShadow = enabled;
        return this;
    }

    public WaxSealVisualizer setShapeHighlightEdgeMaxRadius(int px) {
        this.shapeHighlightEdgeMaxRadius = Math.max(0, px);
        return this;
    }

    public WaxSealVisualizer setShapeShadowEdgeMaxRadius(int px) {
        this.shapeShadowEdgeMaxRadius = Math.max(0, px);
        return this;
    }

    public WaxSealVisualizer setShapeHighlightColor(int argb) {
        this.shapeHighlightColor = argb;
        return this;
    }

    public WaxSealVisualizer setShapeShadowColor(int argb) {
        this.shapeShadowColor = argb;
        return this;
    }

    public WaxSealVisualizer setShapeHighlightDirection(int dir1to8) {
        this.shapeHighlightDirection = WaxSealVisualizer.clampDir(dir1to8);
        return this;
    }

    public WaxSealVisualizer setShapeShadowDirection(int dir1to8) {
        this.shapeShadowDirection = WaxSealVisualizer.clampDir(dir1to8);
        return this;
    }

    private static int clampDir(int d) {
        if (d < 1) {
            return 1;
        }
        if (d > 8) {
            return 8;
        }
        return d;
    }

    public void render(@NotNull GuiGraphics gg, int centerX, int centerY, int previewX, int previewY, int previewWidth, int previewHeight, int sigilRadius, float waxScale, @NotNull SealSigilGenerator.SigilPattern pattern) {
        try {
            if (this.waxEnabled) {
                this.renderWaxSeal(gg, centerX, centerY, waxScale);
            }
            this.renderSigilGlyph(gg, centerX, centerY, previewX, previewY, previewWidth, previewHeight, sigilRadius, pattern);
        }
        catch (Throwable t) {
            LOG.error("[WaxSealVisualizer] render failed", t);
        }
    }

    public void renderShapesOnly(@NotNull GuiGraphics gg, int centerX, int centerY, int previewX, int previewY, int previewWidth, int previewHeight, int sigilRadius, float unusedScale, @NotNull SealSigilGenerator.SigilPattern pattern) {
        try {
            this.renderSigilGlyph(gg, centerX, centerY, previewX, previewY, previewWidth, previewHeight, sigilRadius, pattern);
        }
        catch (Throwable t) {
            LOG.error("[WaxSealVisualizer] renderShapesOnly failed", t);
        }
    }

    private void renderWaxSeal(@NotNull GuiGraphics gg, int centerX, int centerY, float scale) {
        try {
            int sealWidth = Math.round(39.0f * scale);
            int sealHeight = Math.round(38.0f * scale);
            int sealX = centerX - sealWidth / 2;
            int sealY = centerY - sealHeight / 2;
            ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
            boolean hasTexture = false;
            try {
                hasTexture = resourceManager.getResource(WAX_SEAL_TEXTURE).isPresent();
            }
            catch (Throwable t) {
                LOG.error("[WaxSealVisualizer] renderWaxSeal: resource lookup failed", t);
            }
            if (hasTexture) {
                gg.blit(WAX_SEAL_TEXTURE, sealX, sealY, sealWidth, sealHeight, 0.0f, 0.0f, 39, 38, 39, 38);
            } else {
                int radius = Math.min(sealWidth, sealHeight) / 2;
                if (radius <= 0) {
                    return;
                }
                int rSq = radius * radius;
                for (int dy = -radius; dy <= radius; ++dy) {
                    int dySq = dy * dy;
                    for (int dx = -radius; dx <= radius; ++dx) {
                        if (dx * dx + dySq > rSq) continue;
                        int x = centerX + dx;
                        int y = centerY + dy;
                        gg.fill(x, y, x + 1, y + 1, -2047904);
                    }
                }
            }
        }
        catch (Throwable t) {
            LOG.error("[WaxSealVisualizer] renderWaxSeal failed", t);
        }
    }

    private void renderSigilGlyph(@NotNull GuiGraphics gg, int centerX, int centerY, int previewX, int previewY, int previewWidth, int previewHeight, int sigilRadius, @NotNull SealSigilGenerator.SigilPattern pattern) {
        block44: {
            try {
                int distSq;
                int size = pattern.getSize();
                if (size <= 0) {
                    return;
                }
                boolean[][] disc = pattern.getDiscMask();
                boolean[][] shapes = pattern.getShapeMask();
                if (shapes == null) {
                    return;
                }
                WaxSealVisualizer.resetShaderColorForGui();
                int sigilRadiusSq = sigilRadius * sigilRadius;
                int patternRadius = size / 2;
                int boxLeft = previewX;
                int boxTop = previewY;
                int boxRight = previewX + previewWidth;
                int boxBottom = previewY + previewHeight;
                boolean[][] highlightPixels = this.shapeEnableHighlight ? new boolean[size][size] : null;
                boolean[][] shadowPixels = this.shapeEnableShadow ? new boolean[size][size] : null;
                int maxHighlightRadius = this.shapeEnableHighlight ? Math.max(1, this.shapeHighlightEdgeMaxRadius) : 0;
                int maxShadowRadius = this.shapeEnableShadow ? Math.max(1, this.shapeShadowEdgeMaxRadius) : 0;
                int[] shadowStep = WaxSealVisualizer.directionToUnitOffset(this.shapeShadowDirection);
                int sxStep = shadowStep[0];
                int syStep = shadowStep[1];
                int[] highlightStep = WaxSealVisualizer.directionToUnitOffset(this.shapeHighlightDirection);
                int hxStep = highlightStep[0];
                int hyStep = highlightStep[1];
                float hxNormX = hxStep;
                float hxNormY = hyStep;
                float hxLen = (float)Math.sqrt(hxNormX * hxNormX + hxNormY * hxNormY);
                if (hxLen > 1.0E-4f) {
                    hxNormX /= hxLen;
                    hxNormY /= hxLen;
                } else {
                    hxNormX = 0.0f;
                    hxNormY = 0.0f;
                }
                float sxNormX = sxStep;
                float sxNormY = syStep;
                float sxLen = (float)Math.sqrt(sxNormX * sxNormX + sxNormY * sxNormY);
                if (sxLen > 1.0E-4f) {
                    sxNormX /= sxLen;
                    sxNormY /= sxLen;
                } else {
                    sxNormX = 0.0f;
                    sxNormY = 0.0f;
                }
                try {
                    boolean[] shapeRow;
                    int py;
                    boolean[][] edgeMask = new boolean[size][size];
                    for (py = 0; py < size; ++py) {
                        shapeRow = shapes[py];
                        if (shapeRow == null) continue;
                        boolean[] discRow = disc != null && py >= 0 && py < disc.length ? disc[py] : null;
                        for (int px = 0; px < size; ++px) {
                            if (!shapeRow[px] || discRow != null && !discRow[px]) continue;
                            boolean isEdge = false;
                            for (int oy = -1; oy <= 1 && !isEdge; ++oy) {
                                for (int ox = -1; ox <= 1 && !isEdge; ++ox) {
                                    if (ox == 0 && oy == 0) continue;
                                    int nx = px + ox;
                                    int ny = py + oy;
                                    boolean insideNeighbor = false;
                                    if (nx >= 0 && nx < size && ny >= 0 && ny < size) {
                                        boolean[] shapeRowN = shapes[ny];
                                        boolean insideShapeNeighbor = shapeRowN != null && nx < shapeRowN.length && shapeRowN[nx];
                                        boolean insideDiscNeighbor = true;
                                        if (disc != null && ny >= 0 && ny < disc.length) {
                                            boolean[] discRowN = disc[ny];
                                            insideDiscNeighbor = discRowN != null && nx >= 0 && nx < discRowN.length ? discRowN[nx] : false;
                                        }
                                        boolean bl = insideNeighbor = insideShapeNeighbor && insideDiscNeighbor;
                                    }
                                    if (insideNeighbor) continue;
                                    isEdge = true;
                                }
                            }
                            edgeMask[py][px] = isEdge;
                        }
                    }
                    for (py = 0; py < size; ++py) {
                        boolean[] edgeRow;
                        shapeRow = shapes[py];
                        if (shapeRow == null || (edgeRow = edgeMask[py]) == null) continue;
                        boolean[] discRow = disc != null && py >= 0 && py < disc.length ? disc[py] : null;
                        block15: for (int px = 0; px < size; ++px) {
                            boolean[] discRowN;
                            boolean insideDiscNeighbor;
                            boolean insideShapeNeighbor;
                            boolean[] shapeRowN;
                            int ny;
                            int nx;
                            boolean useShadow;
                            if (!shapeRow[px] || !edgeRow[px] || discRow != null && !discRow[px]) continue;
                            float outX = 0.0f;
                            float outY = 0.0f;
                            for (int oy = -1; oy <= 1; ++oy) {
                                for (int ox = -1; ox <= 1; ++ox) {
                                    if (ox == 0 && oy == 0) continue;
                                    int nx2 = px + ox;
                                    int ny2 = py + oy;
                                    boolean insideNeighbor = false;
                                    if (nx2 >= 0 && nx2 < size && ny2 >= 0 && ny2 < size) {
                                        boolean[] shapeRowN2 = shapes[ny2];
                                        boolean insideShapeNeighbor2 = shapeRowN2 != null && nx2 < shapeRowN2.length && shapeRowN2[nx2];
                                        boolean insideDiscNeighbor2 = true;
                                        if (disc != null && ny2 >= 0 && ny2 < disc.length) {
                                            boolean[] discRowN2 = disc[ny2];
                                            insideDiscNeighbor2 = discRowN2 != null && nx2 >= 0 && nx2 < discRowN2.length ? discRowN2[nx2] : false;
                                        }
                                        boolean bl = insideNeighbor = insideShapeNeighbor2 && insideDiscNeighbor2;
                                    }
                                    if (insideNeighbor) continue;
                                    outX += (float)ox;
                                    outY += (float)oy;
                                }
                            }
                            float outLen = (float)Math.sqrt(outX * outX + outY * outY);
                            if (outLen > 1.0E-4f) {
                                outX /= outLen;
                                outY /= outLen;
                            } else if (this.shapeEnableShadow && (sxNormX != 0.0f || sxNormY != 0.0f)) {
                                outX = sxNormX;
                                outY = sxNormY;
                            } else {
                                if (!this.shapeEnableHighlight || hxNormX == 0.0f && hxNormY == 0.0f) continue;
                                outX = hxNormX;
                                outY = hxNormY;
                            }
                            float dotHighlight = this.shapeEnableHighlight ? outX * hxNormX + outY * hxNormY : -3.4028235E38f;
                            float dotShadow = this.shapeEnableShadow ? outX * sxNormX + outY * sxNormY : -3.4028235E38f;
                            boolean useHighlight = this.shapeEnableHighlight && (!this.shapeEnableShadow || dotHighlight >= dotShadow);
                            boolean bl = useShadow = this.shapeEnableShadow && (!this.shapeEnableHighlight || dotShadow > dotHighlight);
                            if (useHighlight && highlightPixels != null && maxHighlightRadius > 0) {
                                for (int k = 1; k <= maxHighlightRadius; ++k) {
                                    nx = px + hxStep * k;
                                    ny = py + hyStep * k;
                                    if (nx < 0 || nx >= size || ny < 0 || ny >= size) break;
                                    shapeRowN = shapes[ny];
                                    boolean bl2 = insideShapeNeighbor = shapeRowN != null && nx < shapeRowN.length && shapeRowN[nx];
                                    if (insideShapeNeighbor) break;
                                    insideDiscNeighbor = true;
                                    if (disc != null && ny >= 0 && ny < disc.length) {
                                        discRowN = disc[ny];
                                        insideDiscNeighbor = discRowN != null && nx >= 0 && nx < discRowN.length ? discRowN[nx] : false;
                                    }
                                    if (!insideDiscNeighbor) break;
                                    highlightPixels[ny][nx] = true;
                                }
                            }
                            if (!useShadow || shadowPixels == null || maxShadowRadius <= 0) continue;
                            for (int k = 1; k <= maxShadowRadius; ++k) {
                                nx = px + sxStep * k;
                                ny = py + syStep * k;
                                if (nx < 0 || nx >= size || ny < 0 || ny >= size) continue block15;
                                shapeRowN = shapes[ny];
                                boolean bl3 = insideShapeNeighbor = shapeRowN != null && nx < shapeRowN.length && shapeRowN[nx];
                                if (insideShapeNeighbor) continue block15;
                                insideDiscNeighbor = true;
                                if (disc != null && ny >= 0 && ny < disc.length) {
                                    discRowN = disc[ny];
                                    insideDiscNeighbor = discRowN != null && nx >= 0 && nx < discRowN.length ? discRowN[nx] : false;
                                }
                                if (!insideDiscNeighbor) continue block15;
                                shadowPixels[ny][nx] = true;
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.error("[WaxSealVisualizer] renderSigilGlyph: edge-based analysis (highlight/shadow) failed", t);
                }
                try {
                    for (int py = 0; py < size; ++py) {
                        boolean[] shapeRow = shapes[py];
                        if (shapeRow == null) continue;
                        boolean[] discRow = disc != null && py >= 0 && py < disc.length ? disc[py] : null;
                        for (int px = 0; px < size; ++px) {
                            int dy;
                            int dx;
                            int distSq2;
                            if (!shapeRow[px] || discRow != null && !discRow[px] || (distSq2 = (dx = px - patternRadius) * dx + (dy = py - patternRadius) * dy) > sigilRadiusSq) continue;
                            int sx = centerX + dx;
                            int sy = centerY + dy;
                            if (sx < boxLeft || sy < boxTop || sx >= boxRight || sy >= boxBottom) continue;
                            gg.fill(sx, sy, sx + 1, sy + 1, this.shapeFillColor);
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.error("[WaxSealVisualizer] renderSigilGlyph: base shape fill failed", t);
                }
                if (this.shapeEnableHighlight && highlightPixels != null) {
                    try {
                        for (int py = 0; py < size; ++py) {
                            boolean[] row = highlightPixels[py];
                            if (row == null) continue;
                            for (int px = 0; px < size; ++px) {
                                int dy;
                                int dx;
                                if (!row[px] || (distSq = (dx = px - patternRadius) * dx + (dy = py - patternRadius) * dy) > sigilRadiusSq) continue;
                                int sx = centerX + dx;
                                int sy = centerY + dy;
                                if (sx < boxLeft || sy < boxTop || sx >= boxRight || sy >= boxBottom) continue;
                                gg.fill(sx, sy, sx + 1, sy + 1, this.shapeHighlightColor);
                            }
                        }
                    }
                    catch (Throwable t) {
                        LOG.error("[WaxSealVisualizer] renderSigilGlyph: highlight overlay failed", t);
                    }
                }
                if (!this.shapeEnableShadow || shadowPixels == null) break block44;
                try {
                    for (int py = 0; py < size; ++py) {
                        boolean[] row = shadowPixels[py];
                        if (row == null) continue;
                        for (int px = 0; px < size; ++px) {
                            int dy;
                            int dx;
                            if (!row[px] || (distSq = (dx = px - patternRadius) * dx + (dy = py - patternRadius) * dy) > sigilRadiusSq) continue;
                            int sx = centerX + dx;
                            int sy = centerY + dy;
                            if (sx < boxLeft || sy < boxTop || sx >= boxRight || sy >= boxBottom) continue;
                            gg.fill(sx, sy, sx + 1, sy + 1, this.shapeShadowColor);
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.error("[WaxSealVisualizer] renderSigilGlyph: shadow overlay failed", t);
                }
            }
            catch (Throwable t) {
                LOG.error("[WaxSealVisualizer] renderSigilGlyph failed", t);
            }
        }
    }

    private static void resetShaderColorForGui() {
        try {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        catch (Throwable t) {
            LOG.error("[WaxSealVisualizer] resetShaderColorForGui failed", t);
        }
    }

    private static int[] directionToUnitOffset(int dir) {
        int dx;
        return new int[]{dx, switch (dir) {
            case 1 -> {
                dx = 0;
                yield 1;
            }
            case 2 -> {
                dx = -1;
                yield 0;
            }
            case 3 -> {
                dx = 0;
                yield -1;
            }
            case 4 -> {
                dx = 1;
                yield 0;
            }
            case 5 -> {
                dx = -1;
                yield 1;
            }
            case 6 -> {
                dx = -1;
                yield -1;
            }
            case 7 -> {
                dx = 1;
                yield -1;
            }
            case 8 -> {
                dx = 1;
                yield 1;
            }
            default -> {
                dx = 1;
                yield 1;
            }
        }};
    }
}

