/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.slf4j.Logger;

public class SigilEtchingParticle {
    private static final Logger LOG = LogUtils.getLogger();
    private static final ResourceLocation PARTICLE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"textures/gui/texture_etching16x.png");
    private static boolean textureCheckDone = false;
    private static boolean hasTexture = false;
    private static final float SIZE_BASE = 8.0f;
    private static final float SIZE_VARIATION = 0.6f;
    private static final int LIFETIME_MIN = 12;
    private static final int LIFETIME_RANGE = 10;
    private static final double BASE_SPEED = 0.5;
    private static final double SPEED_VARIATION = 0.6;
    private static final double DOWNWARD_HEMISPHERE_PROBABILITY = 0.8;
    private static final double GRAVITY = 0.1;
    private static final double FRICTION = 0.94;
    private double x;
    private double y;
    private double vx;
    private double vy;
    private int age;
    private final int maxAge;
    private final float size;
    private float alpha;
    private float angleDeg;
    private final float angularVelocityDeg;

    public static SigilEtchingParticle createForCarve(RandomSource random, int centerX, int centerY, int radius) {
        try {
            if (radius <= 0) {
                return null;
            }
            double spawnAngle = random.nextDouble() * Math.PI * 2.0;
            double spawnRadius = (double)radius * Math.sqrt(random.nextDouble());
            double x = (double)centerX + spawnRadius * Math.cos(spawnAngle);
            double y = (double)centerY + spawnRadius * Math.sin(spawnAngle);
            double roll = random.nextDouble();
            double dirAngle = roll < 0.8 ? random.nextDouble() * Math.PI : Math.PI + random.nextDouble() * Math.PI;
            double speed = 0.5 + random.nextDouble() * 0.6;
            double vx = Math.cos(dirAngle) * speed;
            double vy = Math.sin(dirAngle) * speed;
            int lifetime = 12 + random.nextInt(11);
            float size = 8.0f * (0.8f + random.nextFloat() * 0.6f);
            float initialAngleDeg = random.nextFloat() * 360.0f;
            float angularVelocityDeg = (random.nextFloat() - 0.5f) * 40.0f;
            return new SigilEtchingParticle(x, y, vx, vy, size, lifetime, initialAngleDeg, angularVelocityDeg);
        }
        catch (Throwable t) {
            LOG.error("[SigilEtchingParticle] createForCarve failed", t);
            return null;
        }
    }

    private SigilEtchingParticle(double x, double y, double vx, double vy, float size, int maxAge, float initialAngleDeg, float angularVelocityDeg) {
        this.x = x;
        this.y = y;
        this.vx = vx;
        this.vy = vy;
        this.size = size <= 0.0f ? 1.0f : size;
        this.maxAge = Math.max(1, maxAge);
        this.age = 0;
        this.alpha = 1.0f;
        this.angleDeg = initialAngleDeg;
        this.angularVelocityDeg = angularVelocityDeg;
    }

    public void tick() {
        try {
            ++this.age;
            if (this.age >= this.maxAge) {
                this.alpha = 0.0f;
                return;
            }
            this.x += this.vx;
            this.y += this.vy;
            this.vy += 0.1;
            this.vx *= 0.94;
            this.vy *= 0.94;
            this.angleDeg += this.angularVelocityDeg;
            float lifeFrac = (float)this.age / (float)this.maxAge;
            this.alpha = 1.0f - lifeFrac;
            if (this.alpha < 0.0f) {
                this.alpha = 0.0f;
            }
        }
        catch (Throwable t) {
            LOG.error("[SigilEtchingParticle] tick failed", t);
            this.alpha = 0.0f;
        }
    }

    public boolean isAlive() {
        return this.age < this.maxAge && this.alpha > 0.01f;
    }

    public void render(GuiGraphics guiGraphics, float partialTick) {
        try {
            if (!this.isAlive()) {
                return;
            }
            SigilEtchingParticle.ensureTextureChecked();
            int drawSize = Math.max(1, Math.round(this.size));
            int half = drawSize / 2;
            int drawX = (int)Math.round(this.x);
            int drawY = (int)Math.round(this.y);
            float a = Math.max(0.0f, Math.min(1.0f, this.alpha));
            if (hasTexture) {
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                poseStack.translate((float)drawX, (float)drawY, 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.angleDeg));
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
                guiGraphics.blit(PARTICLE_TEXTURE, -half, -half, drawSize, drawSize, 0.0f, 0.0f, 16, 16, 16, 16);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.popPose();
            } else {
                int x0 = drawX - half;
                int y0 = drawY - half;
                int x1 = drawX + half;
                int y1 = drawY + half;
                int rgb = 9132587;
                int alphaInt = (int)(a * 255.0f) & 0xFF;
                int argb = alphaInt << 24 | rgb & 0xFFFFFF;
                guiGraphics.fill(x0, y0, x1, y1, argb);
            }
        }
        catch (Throwable t) {
            LOG.error("[SigilEtchingParticle] render failed", t);
        }
    }

    private static void ensureTextureChecked() {
        if (textureCheckDone) {
            return;
        }
        textureCheckDone = true;
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.getResourceManager() == null) {
                hasTexture = false;
                return;
            }
            hasTexture = mc.getResourceManager().getResource(PARTICLE_TEXTURE).isPresent();
            LOG.debug("[SigilEtchingParticle] texture_etching16x present: {}", (Object)hasTexture);
        }
        catch (Throwable t) {
            LOG.error("[SigilEtchingParticle] ensureTextureChecked failed", t);
            hasTexture = false;
        }
    }
}

