/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.gui;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.z2six.featheredfriend.client.gui.SigilEtchingParticle;
import net.z2six.featheredfriend.client.gui.WaxSealVisualizer;
import net.z2six.featheredfriend.client.gui.widget.MultiLineScrollTextWidget;
import net.z2six.featheredfriend.item.SealStampCarveLogic;
import net.z2six.featheredfriend.item.SealStampItem;
import net.z2six.featheredfriend.neoforge.menu.SealStampMenu;
import net.z2six.featheredfriend.network.SealStampCarveResultPacket;
import net.z2six.featheredfriend.sigil.SealSigilGenerator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SealStampScreen
extends AbstractContainerScreen<SealStampMenu> {
    private static final Logger LOG = LogUtils.getLogger();
    private static final ResourceLocation GOTHIC_FONT_ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"gothic12");
    private static final ResourceLocation STAMP_UI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"textures/gui/stampscreen/stamp_ui.png");
    private static final int GUI_WIDTH = 272;
    private static final int GUI_HEIGHT = 160;
    private static final int SECRET_WIDTH = 130;
    private static final int SECRET_HEIGHT = 28;
    private static final int SECRET_MAX_CHARS = 52;
    private static final int SECRET_MAX_LINES = 2;
    private static final int SECRET_Y = 22;
    private static final int SECRET_X_OFFSET = -35;
    private static final int LEFT_COLUMN_X = 26;
    private static final int LEFT_COLUMN_FIRST_Y = 54;
    private static final int DROPDOWN_WIDTH = 101;
    private static final int DROPDOWN_HEIGHT = 16;
    private static final int CONTROL_VERTICAL_GAP = 6;
    private static final int CARVE_WIDTH = 100;
    private static final int CARVE_HEIGHT = 15;
    private static final int SCALE_WIDTH = 100;
    private static final int SCALE_HEIGHT = 15;
    private static final boolean DEBUG_BUTTON_BORDERS = false;
    private static final int PREVIEW_WIDTH = 160;
    private static final int PREVIEW_HEIGHT = 120;
    private static final int PREVIEW_RIGHT_MARGIN = 0;
    private static final int PREVIEW_TOP_Y = 46;
    private static final int PREVIEW_LABEL_OFFSET_Y = -12;
    private static final float WAX_SEAL_SCREEN_SCALE = 3.0f;
    private static final int SIGIL_BASE_DIAMETER_PIXELS = 100;
    private static final float SIGIL_RADIUS_SCALE = 0.85f;
    private static final int SIGIL_RADIUS = 42;
    private static final int MIN_SLICES = 2;
    private static final int MAX_SLICES = 8;
    private static final String[] STYLE_NAMES = new String[]{"Medieval", "Fantasy", "Floral"};
    private static final int SHAPE_FILL_COLOR = -9551057;
    private static final boolean SHAPE_ENABLE_HIGHLIGHT = true;
    private static final boolean SHAPE_ENABLE_SHADOW = true;
    private static final int SHAPE_HIGHLIGHT_EDGE_MAX_RADIUS = 1;
    private static final int SHAPE_SHADOW_EDGE_MAX_RADIUS = 1;
    private static final int SHAPE_HIGHLIGHT_COLOR = -11061978;
    private static final int SHAPE_SHADOW_COLOR = -3040422;
    private static final int SHAPE_HIGHLIGHT_DIRECTION = 6;
    private static final int SHAPE_SHADOW_DIRECTION = 8;
    private MultiLineScrollTextWidget secretField;
    private Button etchingsButton;
    private Button styleButton;
    private Button carveButton;
    private AbstractWidget scaleButton;
    private int currentSlices = 6;
    private int currentStyleIndex = 0;
    private final RandomSource random = RandomSource.createNewThreadLocalInstance();
    private final List<SigilEtchingParticle> particles = new ArrayList<SigilEtchingParticle>();
    private SealSigilGenerator.SigilPattern currentPattern;
    private boolean[][] currentDiscMask;
    private boolean[][] currentShapeMask;
    private int currentPatternSize;
    private String lastSecretForSigil = "";
    private final SealStampCarveLogic carveLogic = new SealStampCarveLogic();
    private boolean carveButtonDisabled = false;
    private final int stampSlot;
    private final WaxSealVisualizer visualizer = new WaxSealVisualizer().setShapeFillColor(-9551057).setShapeEnableHighlight(true).setShapeEnableShadow(true).setShapeHighlightEdgeMaxRadius(1).setShapeShadowEdgeMaxRadius(1).setShapeHighlightColor(-11061978).setShapeShadowColor(-3040422).setShapeHighlightDirection(6).setShapeShadowDirection(8);

    public SealStampScreen(@NotNull SealStampMenu menu, @NotNull Inventory playerInventory, @NotNull Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 272;
        this.imageHeight = 160;
        this.stampSlot = menu.getStampSlotIndex();
        this.titleLabelX = 10000;
        this.titleLabelY = 10000;
        this.inventoryLabelX = 10000;
        this.inventoryLabelY = 10000;
        LOG.debug("[SealStampScreen] ctor: SIGIL_BASE_DIAMETER_PIXELS={} SIGIL_RADIUS_SCALE={} -> SIGIL_RADIUS={} | WAX_SEAL_SCREEN_SCALE={} | highlightEnabled={} highlightRadius={} highlightDir={} | shadowEnabled={} shadowRadius={} shadowDir={} | stampSlot={}", new Object[]{100, Float.valueOf(0.85f), 42, Float.valueOf(3.0f), true, 1, 6, true, 1, 8, this.stampSlot});
    }

    protected void init() {
        super.init();
        LOG.debug("[SealStampScreen] init at leftPos={}, topPos={}", (Object)this.leftPos, (Object)this.topPos);
        this.clearWidgets();
        this.renderables.clear();
        this.children().clear();
        int guiCenterX = this.leftPos + this.imageWidth / 2;
        int secretX = guiCenterX + -35 - 65;
        int secretY = this.topPos + 22;
        this.secretField = new MultiLineScrollTextWidget(this.font, secretX, secretY, 130, 28, 52, 2, this.gothic("Secret passphrase"));
        this.secretField.setCustomFontId(GOTHIC_FONT_ID);
        this.secretField.setEditable(true);
        this.secretField.setPlaceholderColor(0xEFEFEF);
        this.secretField.setTextColor(-1);
        this.addRenderableWidget((GuiEventListener)this.secretField);
        int colX = this.leftPos + 26;
        int rowY = this.topPos + 54;
        this.etchingsButton = Button.builder((Component)Component.empty(), b -> this.cycleSlices()).bounds(colX, rowY, 101, 16).build();
        this.etchingsButton.setAlpha(0.0f);
        this.addRenderableWidget((GuiEventListener)this.etchingsButton);
        this.styleButton = Button.builder((Component)Component.empty(), b -> this.cycleStyle()).bounds(colX, rowY += 22, 101, 16).build();
        this.styleButton.setAlpha(0.0f);
        this.addRenderableWidget((GuiEventListener)this.styleButton);
        this.carveButton = Button.builder((Component)Component.empty(), b -> this.onCarveClicked()).bounds(colX, rowY += 22, 100, 15).build();
        this.carveButton.setAlpha(0.0f);
        this.addRenderableWidget((GuiEventListener)this.carveButton);
        rowY += 21;
        try {
            Minecraft mc = Minecraft.getInstance();
            Options options = mc.options;
            this.scaleButton = options.guiScale().createButton(options, colX, rowY, 100);
            this.scaleButton.setAlpha(0.0f);
            this.addRenderableWidget((GuiEventListener)this.scaleButton);
            LOG.debug("[SealStampScreen] Added (invisible) GUI scale button at x={}, y={}", (Object)colX, (Object)rowY);
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] Failed to create GUI scale button", t);
            this.scaleButton = null;
        }
        this.updateButtonLabels();
        this.updateScaleButtonLabelFromOptions();
        try {
            this.lastSecretForSigil = this.secretField != null ? this.safeString(this.secretField.getText()) : "";
            this.regenerateSigilPattern();
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] Initial sigil generation failed", t);
        }
    }

    private void drawDebugBorder(GuiGraphics guiGraphics, AbstractWidget widget, int argb) {
    }

    private void updateButtonLabels() {
        try {
            if (this.etchingsButton != null) {
                this.etchingsButton.setMessage(this.gothic("Etchings: " + this.currentSlices));
            }
            if (this.styleButton != null) {
                String styleName = STYLE_NAMES[Math.max(0, Math.min(this.currentStyleIndex, STYLE_NAMES.length - 1))];
                this.styleButton.setMessage(this.gothic("Style: " + styleName));
            }
            if (this.carveButton != null) {
                this.carveButton.setMessage(this.gothic("Carve"));
                this.carveButton.active = !this.carveButtonDisabled;
            }
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] updateButtonLabels failed", t);
        }
    }

    private void updateScaleButtonLabelFromOptions() {
        if (this.scaleButton == null) {
            return;
        }
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.options == null) {
                return;
            }
            int scale = (Integer)mc.options.guiScale().get();
            String scaleLabel = scale == 0 ? "Auto" : Integer.toString(scale);
            this.scaleButton.setMessage(this.gothic("Scale: " + scaleLabel));
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] updateScaleButtonLabelFromOptions failed", t);
        }
    }

    private void cycleSlices() {
        try {
            ++this.currentSlices;
            if (this.currentSlices > 8) {
                this.currentSlices = 2;
            }
            LOG.debug("[SealStampScreen] cycleSlices -> {}", (Object)this.currentSlices);
            this.updateButtonLabels();
            this.regenerateSigilPattern();
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] cycleSlices failed", t);
        }
    }

    private void cycleStyle() {
        try {
            ++this.currentStyleIndex;
            if (this.currentStyleIndex >= STYLE_NAMES.length) {
                this.currentStyleIndex = 0;
            }
            LOG.debug("[SealStampScreen] cycleStyle -> {} ({})", (Object)this.currentStyleIndex, (Object)STYLE_NAMES[this.currentStyleIndex]);
            this.updateButtonLabels();
            this.regenerateSigilPattern();
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] cycleStyle failed", t);
        }
    }

    private void regenerateSigilPattern() {
        try {
            SealSigilGenerator.SigilPattern pattern;
            String secret = "";
            if (this.secretField != null) {
                secret = this.safeString(this.secretField.getText());
            }
            int slices = this.currentSlices;
            int shapeSetIndex = Math.max(0, Math.min(this.currentStyleIndex, STYLE_NAMES.length - 1));
            long seed = SealSigilGenerator.computeSeedFromSecretOnly(secret);
            int radius = 42;
            this.currentPattern = pattern = SealSigilGenerator.generateFromSeed(seed, radius, slices, shapeSetIndex);
            this.currentPatternSize = pattern.getSize();
            this.currentDiscMask = pattern.getDiscMask();
            this.currentShapeMask = pattern.getShapeMask();
            this.lastSecretForSigil = secret;
            int discCount = this.countTrue(this.currentDiscMask);
            int shapeCount = this.countTrue(this.currentShapeMask);
            LOG.debug("[SealStampScreen] regenerateSigilPattern: seed={} radius={} size={} slices={} shapeSetIndex={} discPixels={} shapePixels={}", new Object[]{seed, radius, this.currentPatternSize, slices, shapeSetIndex, discCount, shapeCount});
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] regenerateSigilPattern failed", t);
            this.currentPattern = null;
            this.currentDiscMask = null;
            this.currentShapeMask = null;
            this.currentPatternSize = 0;
        }
    }

    private int countTrue(boolean[][] mask) {
        if (mask == null || mask.length == 0) {
            return 0;
        }
        int count = 0;
        try {
            for (boolean[] row : mask) {
                if (row == null) continue;
                for (boolean b : row) {
                    if (!b) continue;
                    ++count;
                }
            }
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] countTrue failed", t);
        }
        return count;
    }

    private void onCarveClicked() {
        try {
            if (this.carveLogic.isCarving()) {
                LOG.debug("[SealStampScreen] Carve click ignored: carve animation already active");
                return;
            }
            if (this.carveButton == null) {
                LOG.warn("[SealStampScreen] Carve clicked but carveButton is null");
                return;
            }
            String secret = this.safeString(this.secretField != null ? this.secretField.getText() : "");
            long seed = SealSigilGenerator.computeSeedFromSecretOnly(secret);
            int slices = this.currentSlices;
            int style = this.currentStyleIndex;
            int effectiveSlot = SealStampScreen.computeSealStampSlot(Minecraft.getInstance());
            LOG.info("[SealStampScreen] Carve START \u2192 menuStampSlot={} effectiveStampSlot={} seed={} slices={} style={} secret='{}'", new Object[]{this.stampSlot, effectiveSlot, seed, slices, style, secret});
            this.carveButtonDisabled = true;
            this.carveButton.active = false;
            this.carveLogic.beginCarve(seed, slices, style);
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] onCarveClicked failed", t);
        }
    }

    protected void containerTick() {
        super.containerTick();
        try {
            if (this.secretField != null) {
                this.secretField.tick();
                String currentSecret = this.safeString(this.secretField.getText());
                if (!currentSecret.equals(this.lastSecretForSigil)) {
                    LOG.debug("[SealStampScreen] Secret changed; regenerating sigil");
                    this.regenerateSigilPattern();
                }
            }
            if (!this.particles.isEmpty()) {
                for (int i = this.particles.size() - 1; i >= 0; --i) {
                    SigilEtchingParticle p = this.particles.get(i);
                    p.tick();
                    if (p.isAlive()) continue;
                    this.particles.remove(i);
                }
            }
            this.updateScaleButtonLabelFromOptions();
            this.carveLogic.tick(new SealStampCarveLogic.Callback(){

                @Override
                public void onBurst(int burstIndex) {
                    try {
                        LOG.debug("[SealStampScreen] Carve burst #{} at tick={}", (Object)burstIndex, (Object)SealStampScreen.this.carveLogic.getElapsedTicks());
                        SealStampScreen.this.spawnCarveParticles(80);
                    }
                    catch (Throwable t) {
                        LOG.error("[SealStampScreen] carve burst callback failed", t);
                    }
                }

                @Override
                public void onFinished(long seed, int slices, int style) {
                    try {
                        Minecraft mc = Minecraft.getInstance();
                        if (mc == null || mc.player == null) {
                            LOG.error("[SealStampScreen] onFinished: Minecraft or player is null; aborting packet send");
                            return;
                        }
                        int effectiveSlot = SealStampScreen.computeSealStampSlot(mc);
                        if (effectiveSlot < 0) {
                            LOG.error("[SealStampScreen] Carve FINISHED but could not locate a SealStampItem in player hands/inventory; aborting write");
                            SealStampScreen.this.carveButtonDisabled = false;
                            if (SealStampScreen.this.carveButton != null) {
                                SealStampScreen.this.carveButton.active = true;
                            }
                            return;
                        }
                        String ownerName = mc.player.getGameProfile().getName();
                        LOG.info("[SealStampScreen] Carve FINISHED \u2192 sending SealStampCarveResultPacket (stampSlot={} owner='{}')", (Object)effectiveSlot, (Object)ownerName);
                        PacketDistributor.sendToServer((CustomPacketPayload)new SealStampCarveResultPacket(effectiveSlot, seed, slices, style, ownerName), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        try {
                            mc.player.closeContainer();
                            mc.setScreen(null);
                        }
                        catch (Throwable closeError) {
                            LOG.error("[SealStampScreen] Failed to close container after carve", closeError);
                        }
                    }
                    catch (Throwable t) {
                        LOG.error("[SealStampScreen] carve finished callback failed", t);
                    }
                }
            });
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] containerTick failed", t);
        }
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        try {
            guiGraphics.blit(STAMP_UI_TEXTURE, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, 0.0f, 0.0f, 272, 160, 272, 160);
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] renderBg failed", t);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        try {
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
            super.render(guiGraphics, mouseX, mouseY, partialTick);
            this.renderPreviewArea(guiGraphics);
            this.renderParticles(guiGraphics, partialTick);
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] render failed", t);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    private void renderPreviewArea(@NotNull GuiGraphics guiGraphics) {
        try {
            int previewX = this.leftPos + this.imageWidth - 0 - 160;
            int previewY = this.topPos + 46;
            int centerX = previewX + 80;
            int centerY = previewY + 60;
            if (this.currentPattern != null) {
                this.visualizer.renderShapesOnly(guiGraphics, centerX, centerY, previewX, previewY, 160, 120, 42, 3.0f, this.currentPattern);
            }
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] renderPreviewArea failed", t);
        }
    }

    private void spawnCarveParticles(int count) {
        try {
            if (count <= 0) {
                return;
            }
            int previewX = this.leftPos + this.imageWidth - 0 - 160;
            int previewY = this.topPos + 46;
            int centerX = previewX + 80;
            int centerY = previewY + 60;
            int radius = 42;
            if (radius <= 0) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                SigilEtchingParticle p = SigilEtchingParticle.createForCarve(this.random, centerX, centerY, radius);
                if (p == null) continue;
                this.particles.add(p);
            }
            LOG.debug("[SealStampScreen] spawnCarveParticles: spawned {} particles (total now {})", (Object)count, (Object)this.particles.size());
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] spawnCarveParticles failed", t);
        }
    }

    private void renderParticles(@NotNull GuiGraphics guiGraphics, float partialTick) {
        try {
            if (this.particles.isEmpty()) {
                return;
            }
            for (SigilEtchingParticle p : this.particles) {
                p.render(guiGraphics, partialTick);
            }
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] renderParticles failed", t);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        try {
            if (keyCode == 69 || keyCode == 82 || keyCode == 85) {
                LOG.debug("[SealStampScreen] keyPressed: swallowed keyCode={} to avoid closing GUI", (Object)keyCode);
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] keyPressed failed", t);
            return false;
        }
    }

    private Component gothic(String text) {
        try {
            MutableComponent c = Component.literal((String)text);
            Style style = c.getStyle().withFont(GOTHIC_FONT_ID);
            c.setStyle(style);
            return c;
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] gothic() failed, falling back to plain text", t);
            return Component.literal((String)text);
        }
    }

    private String safeString(String s) {
        return s == null ? "" : s;
    }

    private static int computeSealStampSlot(Minecraft mc) {
        try {
            if (mc == null || mc.player == null) {
                return -1;
            }
            LocalPlayer player = mc.player;
            if (player.getMainHandItem().getItem() instanceof SealStampItem) {
                return 36;
            }
            if (player.getOffhandItem().getItem() instanceof SealStampItem) {
                return 37;
            }
            Inventory inv = player.getInventory();
            for (int i = 0; i < inv.items.size(); ++i) {
                ItemStack stack = (ItemStack)inv.items.get(i);
                if (stack.isEmpty() || !(stack.getItem() instanceof SealStampItem)) continue;
                return i;
            }
            return -1;
        }
        catch (Throwable t) {
            LOG.error("[SealStampScreen] computeSealStampSlot failed", t);
            return -1;
        }
    }
}

