/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Constructor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.z2six.featheredfriend.client.gui.WaxSealVisualizer;
import net.z2six.featheredfriend.client.gui.widget.MultiLineScrollTextWidget;
import net.z2six.featheredfriend.neoforge.menu.ScrollViewMenu;
import net.z2six.featheredfriend.network.FFNetwork;
import net.z2six.featheredfriend.sigil.SealSigilGenerator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ScrollViewScreen
extends AbstractContainerScreen<ScrollViewMenu> {
    private static final Logger LOG = LogUtils.getLogger();
    private static final ResourceLocation SCROLL_GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"textures/gui/scroll_sealing.png");
    private static final ResourceLocation SCROLL_CLOSING_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"textures/gui/scrollscreen/scroll_closing.png");
    private static final ResourceLocation SCROLL_CLOSING_TEXTURE_ZOOM = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"textures/gui/scrollscreen/scroll_closing.png");
    private static final ResourceLocation GOTHIC_FONT_ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"gothic12");
    private static final int SCROLL_FRAME_WIDTH = 240;
    private static final int SCROLL_FRAME_HEIGHT = 208;
    private static final int SCROLL_TOTAL_FRAMES = 7;
    private ViewPhase viewPhase = ViewPhase.CLOSED_IDLE;
    private int viewPhaseTicks = 0;
    private static final int OPENING_ANIM_TICKS = 20;
    private static final boolean DEBUG_SHOW_WAX_GIZMO = false;
    private static final int WAX_BOX_X = 94;
    private static final int WAX_BOX_Y = 74;
    private static final int WAX_BOX_WIDTH = 36;
    private static final int WAX_BOX_HEIGHT = 36;
    private static final int WAX_BOX_COLOR = -2130771968;
    private static final float WAX_SIGIL_RADIUS_SCALE = 0.85f;
    private static final int ZOOM_WAX_BOX_X = 50;
    private static final int ZOOM_WAX_BOX_Y = 30;
    private static final int ZOOM_WAX_BOX_WIDTH = 125;
    private static final int ZOOM_WAX_BOX_HEIGHT = 125;
    private static final int WAX_SIGIL_CENTER_OFFSET_X = 0;
    private static final int WAX_SIGIL_CENTER_OFFSET_Y = 0;
    private static final float HOVER_ZOOM_SCALE = 3.5f;
    private static final int ZOOM_SIGIL_RADIUS_PIXELS = 42;
    private boolean zoomActive = false;
    private static final int GUI_WIDTH = 240;
    private static final int GUI_HEIGHT = 200;
    private static final int DATE_X = 30;
    private static final int DATE_Y = 18;
    private static final int DATE_WIDTH = 200;
    private static final int DATE_HEIGHT = 14;
    private static final int DATE_MAX_CHARS = 64;
    private static final int RECIPIENT_X = 30;
    private static final int RECIPIENT_Y = 36;
    private static final int RECIPIENT_WIDTH = 125;
    private static final int RECIPIENT_HEIGHT = 14;
    private static final int RECIPIENT_MAX_CHARS = 64;
    private static final int MESSAGE_X = 30;
    private static final int MESSAGE_Y = 62;
    private static final int MESSAGE_WIDTH = 125;
    private static final int MESSAGE_HEIGHT = 64;
    private static final int MESSAGE_MAX_CHARS = 512;
    private static final int MESSAGE_MAX_LINES = 12;
    private static final int SIGNATURE_X = 85;
    private static final int SIGNATURE_Y = 180;
    private static final int SIGNATURE_WIDTH = 208;
    private static final int SIGNATURE_HEIGHT = 14;
    private static final int SIGNATURE_MAX_CHARS = 128;
    private static final int PEARL_ICON_X = 202;
    private static final int PEARL_ICON_Y = 18;
    private static final int PEARL_ICON_SIZE = 16;
    private static final ResourceLocation PEARL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"textures/gui/scrollscreen/pearl.png");
    private static final int PEARL_FRAME_WIDTH = 32;
    private static final int PEARL_FRAME_HEIGHT = 32;
    private static final int PEARL_HOVER_FRAME = 7;
    private static final int PEARL_X = 183;
    private static final int PEARL_Y = 10;
    private MultiLineScrollTextWidget dateWidget;
    private MultiLineScrollTextWidget recipientWidget;
    private MultiLineScrollTextWidget messageWidget;
    private MultiLineScrollTextWidget signatureWidget;
    private String dateText = "";
    private String recipientText = "";
    private String messageText = "";
    private String signatureText = "";
    private boolean hasAttachments = false;
    private final WaxSealVisualizer waxSealVisualizer = new WaxSealVisualizer();
    private SealSigilGenerator.SigilPattern smallSigilPattern = null;
    private SealSigilGenerator.SigilPattern zoomSigilPattern = null;
    private ItemStack sealedScrollStack = ItemStack.EMPTY;
    private boolean requestedClose = false;
    private boolean sealBreakRequested = false;
    private long sealedSeed = 0L;
    private String sealedRecipientUUID = "";
    private String sealedDateText = "";
    private String sealedSenderName = "";

    public ScrollViewScreen(@NotNull ScrollViewMenu menu, @NotNull Inventory playerInventory, @NotNull Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 240;
        this.imageHeight = 200;
        this.titleLabelX = 10000;
        this.titleLabelY = 10000;
        try {
            LOG.debug("[ScrollViewScreen] Constructed (client). menuClass={} containerId={}", (Object)(menu != null ? menu.getClass().getName() : "null"), (Object)(menu != null ? menu.containerId : -1));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private ScrollViewMenu getViewMenu() {
        AbstractContainerMenu m = this.menu;
        if (m instanceof ScrollViewMenu) {
            ScrollViewMenu vm = (ScrollViewMenu)m;
            return vm;
        }
        return null;
    }

    protected void init() {
        super.init();
        try {
            LOG.debug("[ScrollViewScreen] init at leftPos={}, topPos={} (client). containerId={}", new Object[]{this.leftPos, this.topPos, this.menu != null ? ((ScrollViewMenu)this.menu).containerId : -1});
            this.clearWidgets();
            this.viewPhase = ViewPhase.CLOSED_IDLE;
            this.viewPhaseTicks = 0;
            this.zoomActive = false;
            this.requestedClose = false;
            this.sealBreakRequested = false;
            this.sealedSeed = 0L;
            this.sealedRecipientUUID = "";
            this.sealedDateText = "";
            this.sealedSenderName = "";
            this.dateText = "";
            this.recipientText = "";
            this.messageText = "";
            this.signatureText = "";
            this.hasAttachments = false;
            this.sealedScrollStack = ItemStack.EMPTY;
            this.smallSigilPattern = null;
            this.zoomSigilPattern = null;
            this.loadFromHeldSealedScroll();
            this.initWidgetsFromCache();
            if (this.sealedScrollStack != null && !this.sealedScrollStack.isEmpty() && this.isOpenedScrollStack(this.sealedScrollStack)) {
                LOG.debug("[ScrollViewScreen] init: detected scroll_opened -> forcing OPEN_IDLE (skip wax view)");
                this.viewPhase = ViewPhase.OPEN_IDLE;
                this.viewPhaseTicks = 20;
                this.zoomActive = false;
                this.setWidgetsVisible(true);
            } else {
                this.viewPhase = ViewPhase.CLOSED_IDLE;
                this.viewPhaseTicks = 0;
                this.zoomActive = false;
                this.setWidgetsVisible(false);
            }
            try {
                ResourceLocation key = this.sealedScrollStack != null && !this.sealedScrollStack.isEmpty() ? BuiltInRegistries.ITEM.getKey((Object)this.sealedScrollStack.getItem()) : null;
                LOG.info("[ScrollViewScreen] init summary: itemKey={} viewPhase={} hasAttachments={} sealBreakRequested={}", new Object[]{key, this.viewPhase, this.hasAttachments, this.sealBreakRequested});
            }
            catch (Throwable key) {}
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] init failed", t);
        }
    }

    private void loadFromHeldSealedScroll() {
        try {
            ListTag attachments;
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.player == null) {
                LOG.warn("[ScrollViewScreen] loadFromHeldSealedScroll: Minecraft or player is null");
                return;
            }
            ItemStack hand = mc.player.getMainHandItem();
            if (hand == null || hand.isEmpty()) {
                hand = mc.player.getOffhandItem();
            }
            if (hand == null || hand.isEmpty()) {
                LOG.warn("[ScrollViewScreen] loadFromHeldSealedScroll: both hands empty");
                return;
            }
            this.sealedScrollStack = hand.copy();
            LOG.debug("[ScrollViewScreen] Using scroll stack from hand: item={} count={}", (Object)BuiltInRegistries.ITEM.getKey((Object)this.sealedScrollStack.getItem()), (Object)this.sealedScrollStack.getCount());
            CustomData customData = (CustomData)hand.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag root = customData.copyTag();
            if (root == null || !root.contains("SealedScroll")) {
                LOG.warn("[ScrollViewScreen] SealedScroll NBT compound missing on held item");
                return;
            }
            CompoundTag seal = root.getCompound("SealedScroll");
            this.dateText = ScrollViewScreen.safeTagString(seal, "DateText");
            this.recipientText = ScrollViewScreen.safeTagString(seal, "RecipientText");
            this.messageText = ScrollViewScreen.safeTagString(seal, "MessageText");
            this.signatureText = ScrollViewScreen.safeTagString(seal, "SignatureText");
            try {
                this.sealedSeed = seal.contains("Seed") ? seal.getLong("Seed") : 0L;
            }
            catch (Throwable tSeed) {
                LOG.error("[ScrollViewScreen] Failed to read SealedScroll.Seed for fingerprint", tSeed);
                this.sealedSeed = 0L;
            }
            try {
                this.sealedRecipientUUID = ScrollViewScreen.safeTagString(seal, "RecipientUUID");
            }
            catch (Throwable tRec) {
                LOG.error("[ScrollViewScreen] Failed to read SealedScroll.RecipientUUID for fingerprint", tRec);
                this.sealedRecipientUUID = "";
            }
            try {
                this.sealedDateText = this.dateText != null ? this.dateText : "";
            }
            catch (Throwable tDt) {
                LOG.error("[ScrollViewScreen] Failed to set sealedDateText fingerprint", tDt);
                this.sealedDateText = "";
            }
            try {
                this.sealedSenderName = ScrollViewScreen.safeTagString(seal, "SenderName");
            }
            catch (Throwable tSn) {
                LOG.error("[ScrollViewScreen] Failed to read SealedScroll.SenderName for fingerprint", tSn);
                this.sealedSenderName = "";
            }
            this.hasAttachments = seal.contains("Attachments", 9) ? (attachments = seal.getList("Attachments", 10)) != null && !attachments.isEmpty() : false;
            try {
                long seed = seal.getLong("Seed");
                int slices = seal.getInt("Slices");
                int style = seal.getInt("Style");
                int smallRadius = Math.max(6, (int)((float)Math.min(36, 36) * 0.5f * 0.85f));
                int zoomRadius = Math.max(6, 42);
                this.smallSigilPattern = SealSigilGenerator.generateFromSeed(seed, smallRadius, slices, style);
                this.zoomSigilPattern = SealSigilGenerator.generateFromSeed(seed, zoomRadius, slices, style);
                LOG.debug("[ScrollViewScreen] Sigils built: seed={} slices={} style={} smallR={} zoomR={}", new Object[]{seed, slices, style, smallRadius, zoomRadius});
            }
            catch (Throwable tSigil) {
                LOG.error("[ScrollViewScreen] Failed to build sigil patterns", tSigil);
                this.smallSigilPattern = null;
                this.zoomSigilPattern = null;
            }
            LOG.debug("[ScrollViewScreen] Loaded text. hasAttachments={} date='{}' recipient='{}' msgLen={} sig='{}' fingerprint(seed={}, recipientUUID='{}', sender='{}')", new Object[]{this.hasAttachments, this.dateText, this.recipientText, this.messageText != null ? this.messageText.length() : 0, this.signatureText, this.sealedSeed, this.sealedRecipientUUID, this.sealedSenderName});
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] loadFromHeldSealedScroll failed", t);
        }
    }

    private static String safeTagString(@NotNull CompoundTag tag, @NotNull String key) {
        try {
            if (!tag.contains(key)) {
                return "";
            }
            return tag.getString(key);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] safeTagString failed for key='{}'", (Object)key, (Object)t);
            return "";
        }
    }

    private void initWidgetsFromCache() {
        try {
            this.dateWidget = new MultiLineScrollTextWidget(this.font, this.leftPos + 30, this.topPos + 18, 200, 14, 64, 1, (Component)Component.literal((String)"Date"), GOTHIC_FONT_ID, false);
            this.dateWidget.setEditable(false);
            this.dateWidget.setText(this.dateText != null ? this.dateText : "");
            this.addRenderableWidget((GuiEventListener)this.dateWidget);
            this.recipientWidget = new MultiLineScrollTextWidget(this.font, this.leftPos + 30, this.topPos + 36, 125, 14, 64, 1, (Component)Component.literal((String)"Dear Recipient"), GOTHIC_FONT_ID, false);
            this.recipientWidget.setEditable(false);
            this.recipientWidget.setText(this.recipientText != null ? this.recipientText : "");
            this.addRenderableWidget((GuiEventListener)this.recipientWidget);
            this.messageWidget = new MultiLineScrollTextWidget(this.font, this.leftPos + 30, this.topPos + 62, 125, 64, 512, 12, (Component)Component.literal((String)""), GOTHIC_FONT_ID, true);
            this.messageWidget.setEditable(false);
            this.messageWidget.setText(this.messageText != null ? this.messageText : "");
            this.addRenderableWidget((GuiEventListener)this.messageWidget);
            this.signatureWidget = new MultiLineScrollTextWidget(this.font, this.leftPos + 85, this.topPos + 180, 208, 14, 128, 2, (Component)Component.literal((String)"Signature"), GOTHIC_FONT_ID, false);
            this.signatureWidget.setEditable(false);
            this.signatureWidget.setText(this.signatureText != null ? this.signatureText : "");
            this.addRenderableWidget((GuiEventListener)this.signatureWidget);
            this.setWidgetsVisible(false);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] initWidgetsFromCache failed", t);
        }
    }

    private void setWidgetsVisible(boolean visible) {
        if (this.dateWidget != null) {
            this.dateWidget.visible = visible;
        }
        if (this.recipientWidget != null) {
            this.recipientWidget.visible = visible;
        }
        if (this.messageWidget != null) {
            this.messageWidget.visible = visible;
        }
        if (this.signatureWidget != null) {
            this.signatureWidget.visible = visible;
        }
    }

    private boolean isMouseInWaxAreaSmall(double mouseX, double mouseY) {
        int x0 = this.leftPos + 94;
        int y0 = this.topPos + 74;
        int x1 = x0 + 36;
        int y1 = y0 + 36;
        return mouseX >= (double)x0 && mouseX < (double)x1 && mouseY >= (double)y0 && mouseY < (double)y1;
    }

    private boolean isMouseInWaxAreaZoom(double mouseX, double mouseY) {
        int x0 = this.leftPos + 50;
        int y0 = this.topPos + 30;
        int x1 = x0 + 125;
        int y1 = y0 + 125;
        return mouseX >= (double)x0 && mouseX < (double)x1 && mouseY >= (double)y0 && mouseY < (double)y1;
    }

    private boolean isMouseInPearlIcon(double mouseX, double mouseY) {
        try {
            int x0 = this.leftPos + 183;
            int y0 = this.topPos + 10;
            int x1 = x0 + 32;
            int y1 = y0 + 32;
            return mouseX >= (double)x0 && mouseX < (double)x1 && mouseY >= (double)y0 && mouseY < (double)y1;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] isMouseInPearlIcon failed", t);
            return false;
        }
    }

    protected void containerTick() {
        super.containerTick();
        try {
            if (this.dateWidget != null) {
                this.dateWidget.tick();
            }
            if (this.recipientWidget != null) {
                this.recipientWidget.tick();
            }
            if (this.messageWidget != null) {
                this.messageWidget.tick();
            }
            if (this.signatureWidget != null) {
                this.signatureWidget.tick();
            }
            this.tickViewPhase();
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] containerTick failed", t);
        }
    }

    private void tickViewPhase() {
        try {
            switch (this.viewPhase.ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    ++this.viewPhaseTicks;
                    if (this.viewPhaseTicks < 20) break;
                    this.viewPhaseTicks = 20;
                    this.viewPhase = ViewPhase.OPEN_IDLE;
                    this.setWidgetsVisible(true);
                    LOG.debug("[ScrollViewScreen] Opening animation finished -> OPEN_IDLE");
                    break;
                }
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] tickViewPhase failed", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        block14: {
            try {
                boolean shouldZoom;
                boolean canZoom;
                boolean inSmallWax = this.isMouseInWaxAreaSmall(mouseX, mouseY);
                boolean inZoomWax = this.isMouseInWaxAreaZoom(mouseX, mouseY);
                boolean bl = canZoom = this.viewPhase == ViewPhase.CLOSED_IDLE;
                if (!canZoom) {
                    if (this.zoomActive) {
                        LOG.debug("[ScrollViewScreen] renderBg: Disabling zoomActive (viewPhase={})", (Object)this.viewPhase);
                    }
                    this.zoomActive = false;
                } else if (!this.zoomActive) {
                    if (inSmallWax) {
                        this.zoomActive = true;
                        LOG.debug("[ScrollViewScreen] renderBg: Zoom entered via SMALL gizmo");
                    }
                } else if (!inZoomWax) {
                    this.zoomActive = false;
                    LOG.debug("[ScrollViewScreen] renderBg: Zoom exited by leaving ZOOM gizmo");
                }
                boolean bl2 = shouldZoom = this.zoomActive && canZoom;
                if (shouldZoom) {
                    PoseStack pose = guiGraphics.pose();
                    pose.pushPose();
                    try {
                        int centerX = this.leftPos + 94 + 18;
                        int centerY = this.topPos + 74 + 18;
                        pose.translate((float)centerX, (float)centerY, 0.0f);
                        pose.scale(3.5f, 3.5f, 1.0f);
                        pose.translate((float)(-centerX), (float)(-centerY), 0.0f);
                        this.renderAnimatedScroll(guiGraphics, true);
                    }
                    finally {
                        pose.popPose();
                    }
                    this.renderWaxSeal(guiGraphics, mouseX, mouseY, partialTick, true);
                    break block14;
                }
                this.renderAnimatedScroll(guiGraphics, false);
                this.renderWaxSeal(guiGraphics, mouseX, mouseY, partialTick, false);
            }
            catch (Throwable t) {
                LOG.error("[ScrollViewScreen] renderBg failed, falling back to simple fill", t);
                guiGraphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -1057623848);
            }
        }
    }

    private void renderAnimatedScroll(@NotNull GuiGraphics guiGraphics, boolean zoomed) {
        int frameIndex;
        ResourceLocation texture;
        switch (this.viewPhase.ordinal()) {
            case 0: {
                texture = zoomed ? SCROLL_CLOSING_TEXTURE_ZOOM : SCROLL_CLOSING_TEXTURE;
                frameIndex = 6;
                break;
            }
            case 1: {
                texture = zoomed ? SCROLL_CLOSING_TEXTURE_ZOOM : SCROLL_CLOSING_TEXTURE;
                int totalTicks = Math.max(1, 20);
                int currentTicks = Math.min(this.viewPhaseTicks, totalTicks);
                float progress = totalTicks == 0 ? 1.0f : (float)currentTicks / (float)totalTicks;
                int closedIndex = 6;
                frameIndex = closedIndex - (int)(progress * 6.0f);
                if (frameIndex < 0) {
                    frameIndex = 0;
                }
                if (frameIndex < 7) break;
                frameIndex = 6;
                break;
            }
            case 2: {
                texture = zoomed ? SCROLL_CLOSING_TEXTURE_ZOOM : SCROLL_CLOSING_TEXTURE;
                frameIndex = 0;
                break;
            }
            default: {
                guiGraphics.blit(SCROLL_GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
                return;
            }
        }
        int textureWidth = 1680;
        int textureHeight = 208;
        int u = frameIndex * 240;
        boolean v = false;
        guiGraphics.blit(texture, this.leftPos, this.topPos, (float)u, (float)v, 240, 208, textureWidth, textureHeight);
    }

    private void renderWaxSeal(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick, boolean zoomView) {
        try {
            if (this.viewPhase != ViewPhase.CLOSED_IDLE) {
                return;
            }
            if (zoomView) {
                if (this.zoomSigilPattern == null) {
                    return;
                }
                this.renderZoomWaxSeal(g);
            } else {
                if (this.smallSigilPattern == null) {
                    return;
                }
                this.renderSmallWaxSeal(g);
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] renderWaxSeal failed", t);
        }
    }

    private void renderSmallWaxSeal(@NotNull GuiGraphics g) {
        try {
            if (this.smallSigilPattern == null) {
                return;
            }
            int smallClipX = this.leftPos + 94;
            int smallClipY = this.topPos + 74;
            int smallClipW = 36;
            int smallClipH = 36;
            int smallCenterX = smallClipX + 18 + 0;
            int smallCenterY = smallClipY + 18 + 0;
            int smallRadiusPx = Math.max(6, (int)((float)Math.min(36, 36) * 0.5f * 0.85f));
            this.waxSealVisualizer.renderShapesOnly(g, smallCenterX, smallCenterY, smallClipX, smallClipY, 36, 36, smallRadiusPx, 1.0f, this.smallSigilPattern);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] renderSmallWaxSeal failed", t);
        }
    }

    private void renderZoomWaxSeal(@NotNull GuiGraphics g) {
        try {
            if (this.zoomSigilPattern == null) {
                return;
            }
            int zoomClipX = this.leftPos + 50;
            int zoomClipY = this.topPos + 30;
            int zoomClipW = 125;
            int zoomClipH = 125;
            int zoomCenterX = zoomClipX + 62 + 0;
            int zoomCenterY = zoomClipY + 62 + 0;
            int zoomRadiusPx = Math.max(6, 42);
            this.waxSealVisualizer.renderShapesOnly(g, zoomCenterX, zoomCenterY, zoomClipX, zoomClipY, 125, 125, zoomRadiusPx, 1.0f, this.zoomSigilPattern);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] renderZoomWaxSeal failed", t);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        try {
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
            super.render(guiGraphics, mouseX, mouseY, partialTick);
            this.renderAttachmentsPearlIcon(guiGraphics, mouseX, mouseY);
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] render failed", t);
        }
    }

    private void renderAttachmentsPearlIcon(@NotNull GuiGraphics g, int mouseX, int mouseY) {
        try {
            int frameIndex;
            if (this.viewPhase != ViewPhase.OPEN_IDLE) {
                return;
            }
            if (!this.shouldShowPearlIcon()) {
                return;
            }
            boolean hovered = this.isMouseInPearlIcon(mouseX, mouseY);
            int n = frameIndex = hovered ? 7 : 6;
            if (frameIndex < 0) {
                frameIndex = 0;
            }
            if (frameIndex > 10) {
                frameIndex = 10;
            }
            int x = this.leftPos + 183;
            int y = this.topPos + 10;
            boolean u = false;
            int v = frameIndex * 32;
            if (hovered) {
                LOG.debug("[ScrollViewScreen] renderAttachmentsPearlIcon: hovered=true frameIndex={} at ({},{})", new Object[]{frameIndex, x, y});
            }
            g.blit(PEARL_TEXTURE, x, y, (float)u, (float)v, 32, 32, 32, 352);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] renderAttachmentsPearlIcon failed", t);
        }
    }

    private boolean shouldShowPearlIcon() {
        block5: {
            try {
                ScrollViewMenu vm = this.getViewMenu();
                if (vm == null) break block5;
                try {
                    if (vm.hasAnyAttachmentsInContainer()) {
                        return true;
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable t) {
                LOG.error("[ScrollViewScreen] shouldShowPearlIcon: menu check failed", t);
            }
        }
        return this.hasAttachments;
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return false;
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.hoveredSlot = null;
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        try {
            if (this.viewPhase == ViewPhase.OPEN_IDLE && this.shouldShowPearlIcon() && this.isMouseInPearlIcon(mouseX, mouseY)) {
                guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)"Attachments"), mouseX, mouseY);
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] renderTooltip: pearl tooltip failed", t);
        }
    }

    private void requestProperClose(@NotNull String reason) {
        try {
            if (this.requestedClose) {
                LOG.debug("[ScrollViewScreen] requestProperClose: already requested; ignoring (reason={})", (Object)reason);
                return;
            }
            this.requestedClose = true;
            Minecraft mc = this.minecraft;
            int containerId = this.menu != null ? ((ScrollViewMenu)this.menu).containerId : -1;
            LOG.info("[ScrollViewScreen] requestProperClose(reason='{}') containerId={} player={} (client)", new Object[]{reason, containerId, mc != null && mc.player != null ? mc.player.getGameProfile().getName() : "null"});
            if (mc != null && mc.player != null) {
                try {
                    mc.player.closeContainer();
                    LOG.info("[ScrollViewScreen] closeContainer() called (client). containerId={}", (Object)containerId);
                }
                catch (Throwable tClose) {
                    LOG.error("[ScrollViewScreen] closeContainer() failed; falling back to setScreen(null)", tClose);
                }
            } else {
                LOG.warn("[ScrollViewScreen] requestProperClose: mc/player null; cannot close container properly");
            }
            try {
                if (mc != null) {
                    mc.setScreen(null);
                    LOG.debug("[ScrollViewScreen] setScreen(null) executed (client)");
                }
            }
            catch (Throwable tScreen) {
                LOG.error("[ScrollViewScreen] setScreen(null) failed", tScreen);
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] requestProperClose failed", t);
        }
    }

    public void onClose() {
        try {
            LOG.debug("[ScrollViewScreen] onClose() invoked (client). requestedClose={}", (Object)this.requestedClose);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.requestProperClose("onClose");
        try {
            super.onClose();
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] super.onClose() failed", t);
        }
    }

    private boolean openAttachmentInventoryScreen(@NotNull String reason) {
        try {
            Minecraft mc = this.minecraft;
            if (mc == null) {
                LOG.warn("[ScrollViewScreen] openAttachmentInventoryScreen: mc is null");
                return false;
            }
            if (mc.player == null) {
                LOG.warn("[ScrollViewScreen] openAttachmentInventoryScreen: player is null");
                return false;
            }
            if (this.menu == null) {
                LOG.warn("[ScrollViewScreen] openAttachmentInventoryScreen: menu is null");
                return false;
            }
            if (this.viewPhase != ViewPhase.OPEN_IDLE) {
                LOG.debug("[ScrollViewScreen] openAttachmentInventoryScreen: ignored (viewPhase={})", (Object)this.viewPhase);
                return false;
            }
            if (!this.shouldShowPearlIcon()) {
                LOG.debug("[ScrollViewScreen] openAttachmentInventoryScreen: ignored (no attachments)");
                return false;
            }
            Inventory inv = null;
            try {
                inv = this.menu != null ? ((ScrollViewMenu)this.menu).getPlayerInventory() : null;
            }
            catch (Throwable ignored) {
                inv = null;
            }
            if (inv == null) {
                try {
                    inv = this.minecraft != null && this.minecraft.player != null ? this.minecraft.player.getInventory() : null;
                }
                catch (Throwable ignored) {
                    inv = null;
                }
            }
            if (inv == null) {
                LOG.warn("[ScrollViewScreen] openAttachmentInventoryScreen: could not resolve player inventory");
                return false;
            }
            Screen attachment = ScrollViewScreen.createAttachmentScreenReflective((ScrollViewMenu)this.menu, inv, (Component)Component.literal((String)"Attachments"), this);
            if (attachment == null) {
                LOG.error("[ScrollViewScreen] openAttachmentInventoryScreen: failed to construct attachment screen (reason={})", (Object)reason);
                return false;
            }
            LOG.info("[ScrollViewScreen] Opening attachment inventory screen (reason={}) containerId={}", (Object)reason, (Object)((ScrollViewMenu)this.menu).containerId);
            mc.setScreen(attachment);
            return true;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] openAttachmentInventoryScreen failed", t);
            return false;
        }
    }

    private boolean isOpenedScrollStack(@NotNull ItemStack stack) {
        try {
            if (stack.isEmpty()) {
                return false;
            }
            ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            if (key == null) {
                return false;
            }
            boolean opened = "scroll_opened".equals(key.getPath());
            if (opened) {
                LOG.debug("[ScrollViewScreen] isOpenedScrollStack: true (itemKey={})", (Object)key);
            }
            return opened;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] isOpenedScrollStack failed", t);
            return false;
        }
    }

    private boolean isSealedScrollStack(@NotNull ItemStack stack) {
        try {
            if (stack.isEmpty()) {
                return false;
            }
            ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            if (key == null) {
                return false;
            }
            boolean sealed = "scroll_sealed".equals(key.getPath());
            if (sealed) {
                LOG.debug("[ScrollViewScreen] isSealedScrollStack: true (itemKey={})", (Object)key);
            }
            return sealed;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] isSealedScrollStack failed", t);
            return false;
        }
    }

    private static Screen createAttachmentScreenReflective(@NotNull ScrollViewMenu menu, @NotNull Inventory inv, @NotNull Component title, @NotNull ScrollViewScreen parent) {
        try {
            Object o;
            Constructor<?> c;
            Class<?> cls = Class.forName("net.z2six.featheredfriend.client.gui.ScrollViewAttachmentInventoryScreen");
            try {
                c = cls.getConstructor(ScrollViewMenu.class, Inventory.class, Component.class, Screen.class);
                o = c.newInstance(new Object[]{menu, inv, title, parent});
                if (o instanceof Screen) {
                    Screen s = (Screen)o;
                    LOG.debug("[ScrollViewScreen] Attachment screen constructed via (menu, inv, title, Screen)");
                    return s;
                }
            }
            catch (Throwable t1) {
                LOG.debug("[ScrollViewScreen] Attachment screen ctor (menu, inv, title, Screen) not usable: {}", (Object)t1.toString());
            }
            try {
                c = cls.getConstructor(ScrollViewMenu.class, Inventory.class, Component.class, ScrollViewScreen.class);
                o = c.newInstance(new Object[]{menu, inv, title, parent});
                if (o instanceof Screen) {
                    Screen s = (Screen)o;
                    LOG.debug("[ScrollViewScreen] Attachment screen constructed via (menu, inv, title, ScrollViewScreen)");
                    return s;
                }
            }
            catch (Throwable t2) {
                LOG.debug("[ScrollViewScreen] Attachment screen ctor (menu, inv, title, ScrollViewScreen) not usable: {}", (Object)t2.toString());
            }
            try {
                c = cls.getConstructor(ScrollViewMenu.class, Inventory.class, Component.class);
                o = c.newInstance(menu, inv, title);
                if (o instanceof Screen) {
                    Screen s = (Screen)o;
                    LOG.debug("[ScrollViewScreen] Attachment screen constructed via (menu, inv, title)");
                    return s;
                }
            }
            catch (Throwable t3) {
                LOG.debug("[ScrollViewScreen] Attachment screen ctor (menu, inv, title) not usable: {}", (Object)t3.toString());
            }
            LOG.error("[ScrollViewScreen] No compatible constructor found for ScrollViewAttachmentInventoryScreen");
            return null;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] Failed to reflectively load/construct ScrollViewAttachmentInventoryScreen", t);
            return null;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        try {
            if (button == 0 && this.viewPhase == ViewPhase.OPEN_IDLE && this.shouldShowPearlIcon() && this.isMouseInPearlIcon(mouseX, mouseY)) {
                LOG.info("[ScrollViewScreen] Pearl clicked -> open attachment inventory (client)");
                if (this.openAttachmentInventoryScreen("pearlClick")) {
                    return true;
                }
            }
            if (button == 0 && this.viewPhase == ViewPhase.CLOSED_IDLE) {
                boolean inSmallWax = this.isMouseInWaxAreaSmall(mouseX, mouseY);
                boolean inZoomWax = this.isMouseInWaxAreaZoom(mouseX, mouseY);
                boolean shouldOpen = false;
                if (!this.zoomActive && inSmallWax) {
                    shouldOpen = true;
                } else if (this.zoomActive && inZoomWax) {
                    shouldOpen = true;
                }
                if (shouldOpen) {
                    if (!this.sealBreakRequested) {
                        int slotHint = this.resolveHeldScrollSlotHint();
                        LOG.info("[ScrollViewScreen] Seal break click -> sending BreakSealPacket (slotHint={} seed={} recipientUUID='{}' date='{}' sender='{}')", new Object[]{slotHint, this.sealedSeed, this.sealedRecipientUUID, this.sealedDateText, this.sealedSenderName});
                        FFNetwork.sendBreakSealToServer(slotHint, this.sealedSeed, this.sealedRecipientUUID != null ? this.sealedRecipientUUID : "", this.sealedDateText != null ? this.sealedDateText : "", this.sealedSenderName != null ? this.sealedSenderName : "");
                        boolean clientSwapped = this.optimisticClientSwapToOpened(slotHint);
                        LOG.info("[ScrollViewScreen] Client-side optimistic swap result={} (slotHint={})", (Object)clientSwapped, (Object)slotHint);
                        this.sealBreakRequested = true;
                    } else {
                        LOG.debug("[ScrollViewScreen] Seal break click but request already sent; ignoring duplicate");
                    }
                    LOG.debug("[ScrollViewScreen] Wax clicked (zoomActive={}) -> starting OPENING animation", (Object)this.zoomActive);
                    this.viewPhase = ViewPhase.OPENING;
                    this.viewPhaseTicks = 0;
                    this.zoomActive = false;
                    return true;
                }
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] mouseClicked failed", t);
            return false;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        try {
            if (keyCode == 256 || keyCode == 69 || keyCode == 82 || keyCode == 85) {
                LOG.info("[ScrollViewScreen] keyPressed {} -> requestProperClose()", (Object)keyCode);
                this.requestProperClose("keyPressed:" + keyCode);
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] keyPressed failed", t);
            return false;
        }
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot != null) {
            LOG.debug("[ScrollViewScreen] slotClicked ignored: slotId={} type={} button={}", new Object[]{slotId, type, mouseButton});
        }
    }

    private int resolveHeldScrollSlotHint() {
        try {
            Minecraft mc = this.minecraft;
            if (mc == null || mc.player == null) {
                LOG.warn("[ScrollViewScreen] resolveHeldScrollSlotHint: mc/player null");
                return -1;
            }
            if (this.sealedScrollStack == null || this.sealedScrollStack.isEmpty()) {
                LOG.warn("[ScrollViewScreen] resolveHeldScrollSlotHint: sealedScrollStack snapshot empty");
                return -1;
            }
            ItemStack main = mc.player.getMainHandItem();
            if (ScrollViewScreen.isLikelySameScroll(main, this.sealedScrollStack)) {
                return 36;
            }
            ItemStack off = mc.player.getOffhandItem();
            if (ScrollViewScreen.isLikelySameScroll(off, this.sealedScrollStack)) {
                return 37;
            }
            try {
                for (int i = 0; i < mc.player.getInventory().items.size(); ++i) {
                    ItemStack s = (ItemStack)mc.player.getInventory().items.get(i);
                    if (!ScrollViewScreen.isLikelySameScroll(s, this.sealedScrollStack)) continue;
                    return i;
                }
            }
            catch (Throwable tInv) {
                LOG.error("[ScrollViewScreen] resolveHeldScrollSlotHint: inventory scan failed", tInv);
            }
            return -1;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] resolveHeldScrollSlotHint failed", t);
            return -1;
        }
    }

    private static boolean isLikelySameScroll(ItemStack a, ItemStack b) {
        try {
            if (a == null || b == null) {
                return false;
            }
            if (a.isEmpty() || b.isEmpty()) {
                return false;
            }
            if (a.getItem() != b.getItem()) {
                return false;
            }
            CustomData acd = (CustomData)a.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CustomData bcd = (CustomData)b.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag at = acd.copyTag();
            CompoundTag bt = bcd.copyTag();
            if (at == null && bt == null) {
                return true;
            }
            if (at == null || bt == null) {
                return false;
            }
            return at.equals((Object)bt);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] isLikelySameScroll failed; returning false", t);
            return false;
        }
    }

    private boolean optimisticClientSwapToOpened(int slotHint) {
        try {
            Minecraft mc = this.minecraft;
            if (mc == null || mc.player == null) {
                LOG.warn("[ScrollViewScreen] optimisticClientSwapToOpened: mc/player null");
                return false;
            }
            Item openedItem = ScrollViewScreen.resolveItemByPath("scroll_opened");
            Item sealedItem = ScrollViewScreen.resolveItemByPath("scroll_sealed");
            if (openedItem == null || openedItem == Items.AIR) {
                LOG.error("[ScrollViewScreen] optimisticClientSwapToOpened: scroll_opened not found");
                return false;
            }
            if (sealedItem == null || sealedItem == Items.AIR) {
                LOG.error("[ScrollViewScreen] optimisticClientSwapToOpened: scroll_sealed not found");
                return false;
            }
            TargetSlot target = this.findClientTargetSealedScrollByHintOrScan(mc, sealedItem, slotHint);
            if (target == null) {
                LOG.warn("[ScrollViewScreen] optimisticClientSwapToOpened: could not find target sealed scroll (slotHint={})", (Object)slotHint);
                return false;
            }
            if (target.stack == null || target.stack.isEmpty() || target.stack.getItem() != sealedItem) {
                LOG.warn("[ScrollViewScreen] optimisticClientSwapToOpened: target not scroll_sealed (found item={})", target.stack != null ? BuiltInRegistries.ITEM.getKey((Object)target.stack.getItem()) : "null");
                return false;
            }
            if (!this.matchesFingerprintClient(target.stack)) {
                LOG.warn("[ScrollViewScreen] optimisticClientSwapToOpened: target does not match fingerprint; refusing swap");
                return false;
            }
            ItemStack opened = new ItemStack((ItemLike)openedItem, 1);
            boolean copied = ScrollViewScreen.copySealedScrollDataWithoutAttachmentsClient(target.stack, opened);
            if (!copied) {
                LOG.warn("[ScrollViewScreen] optimisticClientSwapToOpened: failed to copy SealedScroll data; still swapping item type");
            }
            switch (target.location.ordinal()) {
                case 0: {
                    mc.player.setItemInHand(InteractionHand.MAIN_HAND, opened);
                    break;
                }
                case 1: {
                    mc.player.setItemInHand(InteractionHand.OFF_HAND, opened);
                    break;
                }
                case 2: {
                    if (target.invIndex < 0 || target.invIndex >= mc.player.getInventory().items.size()) {
                        LOG.error("[ScrollViewScreen] optimisticClientSwapToOpened: invalid inventory index {}", (Object)target.invIndex);
                        return false;
                    }
                    mc.player.getInventory().items.set(target.invIndex, (Object)opened);
                }
            }
            LOG.info("[ScrollViewScreen] optimisticClientSwapToOpened: swapped {} -> {} at {}", new Object[]{BuiltInRegistries.ITEM.getKey((Object)sealedItem), BuiltInRegistries.ITEM.getKey((Object)openedItem), target.description});
            return true;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] optimisticClientSwapToOpened failed", t);
            return false;
        }
    }

    private TargetSlot findClientTargetSealedScrollByHintOrScan(@NotNull Minecraft mc, @NotNull Item sealedItem, int slotHint) {
        try {
            TargetSlot hinted = this.getClientStackByHint(mc, slotHint);
            if (hinted != null && hinted.stack != null && !hinted.stack.isEmpty() && hinted.stack.getItem() == sealedItem) {
                return hinted;
            }
            ItemStack main = mc.player.getMainHandItem();
            if (main != null && !main.isEmpty() && main.getItem() == sealedItem && this.matchesFingerprintClient(main)) {
                return new TargetSlot(TargetLocation.MAIN_HAND, -1, main, "MAIN_HAND(scan)");
            }
            ItemStack off = mc.player.getOffhandItem();
            if (off != null && !off.isEmpty() && off.getItem() == sealedItem && this.matchesFingerprintClient(off)) {
                return new TargetSlot(TargetLocation.OFF_HAND, -1, off, "OFF_HAND(scan)");
            }
            for (int i = 0; i < mc.player.getInventory().items.size(); ++i) {
                ItemStack s = (ItemStack)mc.player.getInventory().items.get(i);
                if (s == null || s.isEmpty() || s.getItem() != sealedItem || !this.matchesFingerprintClient(s)) continue;
                return new TargetSlot(TargetLocation.INVENTORY, i, s, "INVENTORY(scan:" + i + ")");
            }
            return null;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] findClientTargetSealedScrollByHintOrScan failed", t);
            return null;
        }
    }

    private TargetSlot getClientStackByHint(@NotNull Minecraft mc, int slotHint) {
        try {
            if (slotHint == 36) {
                return new TargetSlot(TargetLocation.MAIN_HAND, -1, mc.player.getMainHandItem(), "MAIN_HAND(36)");
            }
            if (slotHint == 37) {
                return new TargetSlot(TargetLocation.OFF_HAND, -1, mc.player.getOffhandItem(), "OFF_HAND(37)");
            }
            if (slotHint >= 0 && slotHint < mc.player.getInventory().items.size()) {
                return new TargetSlot(TargetLocation.INVENTORY, slotHint, (ItemStack)mc.player.getInventory().items.get(slotHint), "INVENTORY(" + slotHint + ")");
            }
            return null;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] getClientStackByHint failed", t);
            return null;
        }
    }

    private boolean matchesFingerprintClient(@NotNull ItemStack stack) {
        try {
            boolean ok;
            CustomData cd = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag root = cd.copyTag();
            if (root == null || root.isEmpty()) {
                return false;
            }
            if (!root.contains("SealedScroll", 10)) {
                return false;
            }
            CompoundTag seal = root.getCompound("SealedScroll");
            long seed = 0L;
            try {
                if (seal.contains("Seed")) {
                    seed = seal.getLong("Seed");
                }
            }
            catch (Throwable ignored) {
                seed = 0L;
            }
            String recUuid = "";
            String date = "";
            String sender = "";
            try {
                if (seal.contains("RecipientUUID")) {
                    recUuid = seal.getString("RecipientUUID");
                }
            }
            catch (Throwable ignored) {
                recUuid = "";
            }
            try {
                if (seal.contains("DateText")) {
                    date = seal.getString("DateText");
                }
            }
            catch (Throwable ignored) {
                date = "";
            }
            try {
                if (seal.contains("SenderName")) {
                    sender = seal.getString("SenderName");
                }
            }
            catch (Throwable ignored) {
                sender = "";
            }
            boolean bl = ok = seed == this.sealedSeed && ScrollViewScreen.safeEq(recUuid, this.sealedRecipientUUID) && ScrollViewScreen.safeEq(date, this.sealedDateText) && ScrollViewScreen.safeEq(sender, this.sealedSenderName);
            if (!ok) {
                LOG.debug("[ScrollViewScreen] matchesFingerprintClient mismatch: candidate(seed={} recUuid='{}' date='{}' sender='{}') vs screen(seed={} recUuid='{}' date='{}' sender='{}')", new Object[]{seed, ScrollViewScreen.safeLog(recUuid), ScrollViewScreen.safeLog(date), ScrollViewScreen.safeLog(sender), this.sealedSeed, ScrollViewScreen.safeLog(this.sealedRecipientUUID), ScrollViewScreen.safeLog(this.sealedDateText), ScrollViewScreen.safeLog(this.sealedSenderName)});
            }
            return ok;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] matchesFingerprintClient failed", t);
            return false;
        }
    }

    private static boolean copySealedScrollDataWithoutAttachmentsClient(@NotNull ItemStack sealed, @NotNull ItemStack opened) {
        try {
            CustomData sealedCd = (CustomData)sealed.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag sealedRoot = sealedCd.copyTag();
            if (sealedRoot == null || sealedRoot.isEmpty()) {
                return false;
            }
            if (!sealedRoot.contains("SealedScroll", 10)) {
                return false;
            }
            CompoundTag sealedSeal = sealedRoot.getCompound("SealedScroll");
            if (sealedSeal == null) {
                return false;
            }
            CompoundTag openedRoot = new CompoundTag();
            CompoundTag openedSeal = sealedSeal.copy();
            if (openedSeal.contains("Attachments")) {
                try {
                    openedSeal.remove("Attachments");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            openedRoot.put("SealedScroll", (Tag)openedSeal);
            opened.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)openedRoot));
            return true;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] copySealedScrollDataWithoutAttachmentsClient failed", t);
            return false;
        }
    }

    private static Item resolveItemByPath(@NotNull String path) {
        try {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)path);
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            if (item == null) {
                LOG.error("[ScrollViewScreen] resolveItemByPath: item {} is null", (Object)id);
                return Items.AIR;
            }
            if (item == Items.AIR) {
                LOG.warn("[ScrollViewScreen] resolveItemByPath: item {} returned as AIR", (Object)id);
            }
            return item;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewScreen] resolveItemByPath failed for path='{}'", (Object)path, (Object)t);
            return Items.AIR;
        }
    }

    private static boolean safeEq(String a, String b) {
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        return a.equals(b);
    }

    private static String safeLog(String s) {
        if (s == null) {
            return "null";
        }
        if (s.length() <= 120) {
            return s;
        }
        return s.substring(0, 120) + "...";
    }

    private static enum ViewPhase {
        CLOSED_IDLE,
        OPENING,
        OPEN_IDLE;

    }

    private static final class TargetSlot {
        final TargetLocation location;
        final int invIndex;
        final ItemStack stack;
        final String description;

        TargetSlot(TargetLocation location, int invIndex, ItemStack stack, String description) {
            this.location = location;
            this.invIndex = invIndex;
            this.stack = stack;
            this.description = description;
        }
    }

    private static enum TargetLocation {
        MAIN_HAND,
        OFF_HAND,
        INVENTORY;

    }
}

