/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.gui;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.z2six.featheredfriend.client.gui.ScrollViewScreen;
import net.z2six.featheredfriend.neoforge.menu.ScrollViewMenu;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ScrollViewAttachmentInventoryScreen
extends AbstractContainerScreen<ScrollViewMenu> {
    private static final Logger LOG = LogUtils.getLogger();
    private static final ResourceLocation INVENTORY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"textures/gui/scrollscreen/inventory.png");
    private static final int TEX_W = 176;
    private static final int TEX_H = 128;
    private static final int FADE_TICKS_TOTAL = 10;
    private int fadeTicks = 0;
    private boolean closing = false;
    private boolean closeActionPerformed = false;
    private final ScrollViewScreen parent;

    public ScrollViewAttachmentInventoryScreen(@NotNull ScrollViewMenu menu, @NotNull Inventory playerInventory, @NotNull Component title, @NotNull ScrollViewScreen parent) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.parent = parent;
        this.configureDimensions();
        LOG.debug("[ScrollViewAttachmentInventoryScreen] ctor(menu, inv, title, parent) containerId={} parentPresent=true", (Object)this.safeContainerId());
    }

    public ScrollViewAttachmentInventoryScreen(@NotNull ScrollViewMenu menu, @NotNull Inventory playerInventory, @NotNull Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.parent = null;
        this.configureDimensions();
        LOG.debug("[ScrollViewAttachmentInventoryScreen] ctor(menu, inv, title) containerId={} parentPresent=false", (Object)this.safeContainerId());
    }

    private void configureDimensions() {
        this.imageWidth = 176;
        this.imageHeight = 128;
        this.titleLabelX = 10000;
        this.titleLabelY = 10000;
        this.inventoryLabelX = 10000;
        this.inventoryLabelY = 10000;
    }

    private int safeContainerId() {
        try {
            return this.menu != null ? ((ScrollViewMenu)this.menu).containerId : -1;
        }
        catch (Throwable ignored) {
            return -1;
        }
    }

    public static void handlePearlClicked(@NotNull Minecraft mc) {
        try {
            ScrollViewScreen sv;
            if (mc.player == null) {
                LOG.warn("[ScrollViewAttachmentInventoryScreen] handlePearlClicked: player null");
                return;
            }
            AbstractContainerMenu abstractContainerMenu = mc.player.containerMenu;
            if (!(abstractContainerMenu instanceof ScrollViewMenu)) {
                LOG.warn("[ScrollViewAttachmentInventoryScreen] handlePearlClicked: containerMenu is not ScrollViewMenu (got: {})", (Object)(mc.player.containerMenu != null ? mc.player.containerMenu.getClass().getName() : "null"));
                return;
            }
            ScrollViewMenu menu = (ScrollViewMenu)abstractContainerMenu;
            Screen current = mc.screen;
            ScrollViewScreen parent = current instanceof ScrollViewScreen ? (sv = (ScrollViewScreen)current) : null;
            LOG.info("[ScrollViewAttachmentInventoryScreen] handlePearlClicked: opening attachment screen containerId={} parentPresent={}", (Object)menu.containerId, (Object)(parent != null ? 1 : 0));
            if (parent != null) {
                mc.setScreen((Screen)new ScrollViewAttachmentInventoryScreen(menu, mc.player.getInventory(), (Component)Component.literal((String)""), parent));
            } else {
                mc.setScreen((Screen)new ScrollViewAttachmentInventoryScreen(menu, mc.player.getInventory(), (Component)Component.literal((String)"")));
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewAttachmentInventoryScreen] handlePearlClicked failed", t);
        }
    }

    protected void init() {
        super.init();
        try {
            LOG.debug("[ScrollViewAttachmentInventoryScreen] init leftPos={} topPos={} w={} h={} containerId={} parentPresent={}", new Object[]{this.leftPos, this.topPos, this.imageWidth, this.imageHeight, this.safeContainerId(), this.parent != null});
            this.fadeTicks = 0;
            this.closing = false;
            this.closeActionPerformed = false;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewAttachmentInventoryScreen] init failed", t);
        }
    }

    protected void containerTick() {
        super.containerTick();
        try {
            if (!this.closing) {
                if (this.fadeTicks < 10) {
                    ++this.fadeTicks;
                }
            } else if (this.fadeTicks > 0) {
                --this.fadeTicks;
            } else {
                this.performCloseAction();
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewAttachmentInventoryScreen] containerTick failed", t);
        }
    }

    private float fadeProgress01() {
        try {
            float v = (float)this.fadeTicks / 10.0f;
            if (v < 0.0f) {
                v = 0.0f;
            }
            if (v > 1.0f) {
                v = 1.0f;
            }
            return v;
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewAttachmentInventoryScreen] fadeProgress01 failed", t);
            return 1.0f;
        }
    }

    private void startClosing(@NotNull String reason) {
        try {
            if (this.closing) {
                LOG.debug("[ScrollViewAttachmentInventoryScreen] startClosing ignored (already closing) reason={}", (Object)reason);
                return;
            }
            this.closing = true;
            LOG.debug("[ScrollViewAttachmentInventoryScreen] startClosing reason={} containerId={}", (Object)reason, (Object)this.safeContainerId());
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewAttachmentInventoryScreen] startClosing failed", t);
        }
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        try {
            guiGraphics.blit(INVENTORY_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 176, 128);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewAttachmentInventoryScreen] renderBg failed", t);
            guiGraphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -1073741824);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        try {
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
            super.render(guiGraphics, mouseX, mouseY, partialTick);
            float fade = this.fadeProgress01();
            float overlayAlpha = 1.0f - fade;
            if (overlayAlpha > 0.0f) {
                int a;
                if (overlayAlpha > 1.0f) {
                    overlayAlpha = 1.0f;
                }
                if ((a = (int)(overlayAlpha * 255.0f)) < 0) {
                    a = 0;
                }
                if (a > 255) {
                    a = 255;
                }
                int color = a << 24;
                guiGraphics.fill(0, 0, this.width, this.height, color);
            }
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewAttachmentInventoryScreen] render failed", t);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        try {
            if (this.closing) {
                return true;
            }
            if (button == 0) {
                boolean inside;
                boolean bl = inside = mouseX >= (double)this.leftPos && mouseX < (double)(this.leftPos + this.imageWidth) && mouseY >= (double)this.topPos && mouseY < (double)(this.topPos + this.imageHeight);
                if (!inside) {
                    LOG.debug("[ScrollViewAttachmentInventoryScreen] mouseClicked outside GUI -> closing");
                    this.startClosing("mouseOutside");
                    return true;
                }
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewAttachmentInventoryScreen] mouseClicked failed", t);
            return false;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        try {
            if (this.closing) {
                return true;
            }
            if (keyCode == 256 || keyCode == 69 || keyCode == 82 || keyCode == 85) {
                LOG.debug("[ScrollViewAttachmentInventoryScreen] keyPressed {} -> closing", (Object)keyCode);
                this.startClosing("key:" + keyCode);
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewAttachmentInventoryScreen] keyPressed failed", t);
            return false;
        }
    }

    public void onClose() {
        try {
            LOG.debug("[ScrollViewAttachmentInventoryScreen] onClose invoked; starting fade-out (parentPresent={})", (Object)(this.parent != null ? 1 : 0));
            this.startClosing("onClose");
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewAttachmentInventoryScreen] onClose failed; forcing close action", t);
            this.performCloseAction();
        }
    }

    private void performCloseAction() {
        if (this.closeActionPerformed) {
            return;
        }
        this.closeActionPerformed = true;
        try {
            Minecraft mc = this.minecraft;
            if (mc == null) {
                LOG.warn("[ScrollViewAttachmentInventoryScreen] performCloseAction: minecraft null -> nothing to do");
                return;
            }
            if (this.parent != null) {
                LOG.info("[ScrollViewAttachmentInventoryScreen] performCloseAction: returning to parent ScrollViewScreen (same instance) containerId={}", (Object)this.safeContainerId());
                mc.setScreen((Screen)this.parent);
                return;
            }
            LOG.warn("[ScrollViewAttachmentInventoryScreen] performCloseAction: parent missing -> closing container as fallback containerId={}", (Object)this.safeContainerId());
            try {
                if (mc.player != null) {
                    mc.player.closeContainer();
                }
            }
            catch (Throwable tClose) {
                LOG.error("[ScrollViewAttachmentInventoryScreen] performCloseAction: closeContainer failed", tClose);
            }
            try {
                mc.setScreen(null);
            }
            catch (Throwable tScreen) {
                LOG.error("[ScrollViewAttachmentInventoryScreen] performCloseAction: setScreen(null) failed", tScreen);
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollViewAttachmentInventoryScreen] performCloseAction failed", t);
        }
    }
}

