/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.z2six.featheredfriend.client.ClientCalendarEvents;
import net.z2six.featheredfriend.client.gui.EnderPearlInventoryScreen;
import net.z2six.featheredfriend.client.gui.WaxSealVisualizer;
import net.z2six.featheredfriend.client.gui.widget.MultiLineScrollTextWidget;
import net.z2six.featheredfriend.client.gui.widget.RecipientOverlay;
import net.z2six.featheredfriend.client.gui.widget.SealStampSelectionOverlay;
import net.z2six.featheredfriend.item.SealStampItem;
import net.z2six.featheredfriend.neoforge.menu.ScrollSealingMenu;
import net.z2six.featheredfriend.network.FFNetwork;
import net.z2six.featheredfriend.sigil.SealSigilGenerator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ScrollSealingScreen
extends AbstractContainerScreen<ScrollSealingMenu> {
    private static final Logger LOG = LogUtils.getLogger();
    private static final ResourceLocation SCROLL_GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"textures/gui/scroll_sealing.png");
    private static final ResourceLocation SCROLL_OPENING_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"textures/gui/scrollscreen/scroll_opening.png");
    private static final ResourceLocation SCROLL_CLOSING_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"textures/gui/scrollscreen/scroll_closing.png");
    private static final ResourceLocation SCROLL_CLOSING_TEXTURE_ZOOM = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"textures/gui/scrollscreen/scroll_closing.png");
    private static final ResourceLocation PEARL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"textures/gui/scrollscreen/pearl.png");
    private static final ResourceLocation GOTHIC_FONT_ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"gothic12");
    private static final int SCROLL_FRAME_WIDTH = 240;
    private static final int SCROLL_FRAME_HEIGHT = 208;
    private static final int SCROLL_TOTAL_FRAMES = 7;
    private ScrollAnimPhase scrollAnimPhase = ScrollAnimPhase.OPENING;
    private static final int PEARL_FRAME_WIDTH = 32;
    private static final int PEARL_FRAME_HEIGHT = 32;
    private static final int PEARL_TOTAL_FRAMES = 11;
    private static final int PEARL_PHASE_A_START_FRAME = 0;
    private static final int PEARL_PHASE_A_END_FRAME = 6;
    private static final int PEARL_PHASE_B_HOVER_FRAME = 7;
    private static final int PEARL_PHASE_C_START_FRAME = 8;
    private static final int PEARL_PHASE_C_END_FRAME = 10;
    private static final int PEARL_PHASE_A_TICKS_PER_FRAME = 2;
    private static final int PEARL_PHASE_C_TICKS_PER_FRAME = 2;
    private static final int PEARL_X = 183;
    private static final int PEARL_Y = 10;
    private static final int PEARL_WIDTH = 32;
    private static final int PEARL_HEIGHT = 32;
    private PearlPhase pearlPhase = PearlPhase.HIDDEN;
    private int pearlPhaseTicks = 0;
    private static final int INTRO_DELAY_TICKS = 10;
    private static final int INTRO_FADE_TICKS = 30;
    private static final int OUTRO_FADE_TICKS = 30;
    private static final int OUTRO_DELAY_TICKS = 10;
    private UiPhase uiPhase = UiPhase.INTRO_DELAY;
    private int uiPhaseTicks = 0;
    private static final int GUI_WIDTH = 240;
    private static final int GUI_HEIGHT = 200;
    private static final int DATE_X = 30;
    private static final int DATE_Y = 18;
    private static final int DATE_WIDTH = 200;
    private static final int DATE_HEIGHT = 14;
    private static final int DATE_MAX_CHARS = 64;
    private static final int RECIPIENT_X = 30;
    private static final int RECIPIENT_Y = 36;
    private static final int RECIPIENT_WIDTH = 125;
    private static final int RECIPIENT_HEIGHT = 14;
    private static final int RECIPIENT_MAX_CHARS = 64;
    private static final int MESSAGE_X = 30;
    private static final int MESSAGE_Y = 62;
    private static final int MESSAGE_WIDTH = 150;
    private static final int MESSAGE_HEIGHT = 64;
    private static final int MESSAGE_MAX_CHARS = 512;
    private static final int MESSAGE_MAX_LINES = 12;
    private static final int SIGNATURE_X = 85;
    private static final int SIGNATURE_Y = 180;
    private static final int SIGNATURE_WIDTH = 208;
    private static final int SIGNATURE_HEIGHT = 14;
    private static final int SIGNATURE_MAX_CHARS = 128;
    private static final int SIGNATURE_PLACEHOLDER_COLOR_DEFAULT = 0x707070;
    private static final int SIGNATURE_PLACEHOLDER_COLOR_HOVER = 0;
    private final WaxSealVisualizer waxSealVisualizer = new WaxSealVisualizer();
    private SealSigilGenerator.SigilPattern hoverSigilPattern = null;
    private SealSigilGenerator.SigilPattern placedSigilPattern = null;
    private SealSigilGenerator.SigilPattern placedSigilPatternZoom = null;
    private static final int PLACED_FADE_TICKS_TOTAL = 20;
    private int placedFadeTicks = -1;
    private boolean placedSealShown = false;
    private static final boolean DEBUG_SHOW_WAX_GIZMO = false;
    private static final int WAX_BOX_X = 94;
    private static final int WAX_BOX_Y = 74;
    private static final int WAX_BOX_WIDTH = 36;
    private static final int WAX_BOX_HEIGHT = 36;
    private static final int WAX_BOX_COLOR = -2130771968;
    private static final float WAX_SIGIL_RADIUS_SCALE = 0.85f;
    private boolean zoomActive = false;
    private static final int ZOOM_WAX_BOX_X = 50;
    private static final int ZOOM_WAX_BOX_Y = 30;
    private static final int ZOOM_WAX_BOX_WIDTH = 125;
    private static final int ZOOM_WAX_BOX_HEIGHT = 125;
    private static final int WAX_SIGIL_CENTER_OFFSET_X = 0;
    private static final int WAX_SIGIL_CENTER_OFFSET_Y = 0;
    private static final float HOVER_ZOOM_SCALE = 3.5f;
    private static final int ZOOM_SIGIL_RADIUS_PIXELS = 42;
    private MultiLineScrollTextWidget dateWidget;
    private MultiLineScrollTextWidget recipientField;
    private MultiLineScrollTextWidget messageWidget;
    private MultiLineScrollTextWidget signatureWidget;
    private SealStampSelectionOverlay sealStampOverlay;
    private boolean sealStampSelectionStarted = false;
    private boolean sealStampTargetMode = false;
    private int sealStampSlotIndex = -1;
    private ItemStack sealStampStackForRender = ItemStack.EMPTY;
    private UUID selectedRecipientUuid = null;
    private UUID signerUuid = null;
    private RecipientOverlay recipientOverlay;

    public ScrollSealingScreen(@NotNull ScrollSealingMenu menu, @NotNull Inventory playerInventory, @NotNull Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 240;
        this.imageHeight = 200;
        this.titleLabelX = 10000;
        this.titleLabelY = 10000;
    }

    private ScrollSealingMenu getScrollMenu() {
        return (ScrollSealingMenu)this.menu;
    }

    protected void init() {
        super.init();
        LOG.debug("[ScrollSealingScreen] init at leftPos={}, topPos={}", (Object)this.leftPos, (Object)this.topPos);
        this.clearWidgets();
        this.scrollAnimPhase = ScrollAnimPhase.OPENING;
        this.uiPhase = UiPhase.INTRO_DELAY;
        this.uiPhaseTicks = 0;
        this.pearlPhase = PearlPhase.HIDDEN;
        this.pearlPhaseTicks = 0;
        this.dateWidget = new MultiLineScrollTextWidget(this.font, this.leftPos + 30, this.topPos + 18, 200, 14, 64, 1, (Component)Component.literal((String)"Date"), GOTHIC_FONT_ID, false);
        this.dateWidget.setEditable(false);
        this.dateWidget.setText("");
        this.addRenderableWidget((GuiEventListener)this.dateWidget);
        this.recipientField = new MultiLineScrollTextWidget(this.font, this.leftPos + 30, this.topPos + 36, 125, 14, 64, 1, (Component)Component.literal((String)"Dear Recipient"), GOTHIC_FONT_ID, false);
        this.addRenderableWidget((GuiEventListener)this.recipientField);
        this.messageWidget = new MultiLineScrollTextWidget(this.font, this.leftPos + 30, this.topPos + 62, 150, 64, 512, 12, (Component)Component.literal((String)"Click here to write your message..."), GOTHIC_FONT_ID, true);
        this.addRenderableWidget((GuiEventListener)this.messageWidget);
        this.signatureWidget = new MultiLineScrollTextWidget(this.font, this.leftPos + 85, this.topPos + 180, 208, 14, 128, 2, (Component)Component.literal((String)"Signature"), GOTHIC_FONT_ID, false);
        this.signatureWidget.setText("");
        this.signatureWidget.setEditable(false);
        this.signatureWidget.setPlaceholderColor(0x707070);
        this.addRenderableWidget((GuiEventListener)this.signatureWidget);
        if (this.dateWidget != null) {
            this.dateWidget.visible = false;
        }
        if (this.recipientField != null) {
            this.recipientField.visible = false;
        }
        if (this.messageWidget != null) {
            this.messageWidget.visible = false;
        }
        if (this.signatureWidget != null) {
            this.signatureWidget.visible = false;
        }
        int overlayWidth = 180;
        int overlayHeight = 90;
        int overlayX = this.leftPos + 30;
        int overlayY = this.topPos + 36 + 14 + 4;
        this.recipientOverlay = new RecipientOverlay(Minecraft.getInstance(), this.font, overlayX, overlayY, overlayWidth, overlayHeight, new RecipientOverlay.SelectionCallback(){

            @Override
            public void onPlayerSelected(UUID uuid, String name) {
                LOG.debug("[ScrollSealingScreen] Recipient selected: {} ({})", (Object)name, (Object)uuid);
                ScrollSealingScreen.this.selectedRecipientUuid = uuid;
                ScrollSealingScreen.this.recipientField.setText("Dear " + name + ",");
                ScrollSealingScreen.this.recipientField.setCursorToEnd();
                ScrollSealingScreen.this.saveEditorStateToMenu();
            }

            @Override
            public void onOverlayClosedWithoutSelection() {
                LOG.debug("[ScrollSealingScreen] Recipient overlay closed without selection");
            }
        });
        int stampOverlayWidth = 170;
        int stampOverlayHeight = 62;
        int stampOverlayX = this.leftPos + (240 - stampOverlayWidth) / 2;
        int stampOverlayY = this.topPos + 62 + 64 + 10;
        this.sealStampOverlay = new SealStampSelectionOverlay(Minecraft.getInstance(), this.font, stampOverlayX, stampOverlayY, stampOverlayWidth, stampOverlayHeight, new SealStampSelectionOverlay.SelectionCallback(){

            @Override
            public void onStampSelected(int slotIndex, @NotNull ItemStack stack) {
                LOG.debug("[ScrollSealingScreen] Seal stamp selected: slotIndex={} stack={}", (Object)slotIndex, (Object)stack);
                ScrollSealingScreen.this.sealStampSlotIndex = slotIndex;
                ScrollSealingScreen.this.sealStampStackForRender = stack.copy();
                ScrollSealingScreen.this.sealStampTargetMode = !ScrollSealingScreen.this.sealStampStackForRender.isEmpty();
            }

            @Override
            public void onOverlayClosedWithoutSelection() {
                LOG.debug("[ScrollSealingScreen] Seal stamp overlay closed without selection");
                ScrollSealingScreen.this.sealStampTargetMode = false;
                ScrollSealingScreen.this.sealStampSlotIndex = -1;
                ScrollSealingScreen.this.sealStampStackForRender = ItemStack.EMPTY;
            }
        });
        this.sealStampOverlay.setActive(false);
        this.sealStampSelectionStarted = false;
        this.restoreEditorStateFromMenu();
        ScrollSealingMenu m = this.getScrollMenu();
        if (m.isClientSkipIntroAnimation()) {
            this.uiPhase = UiPhase.IDLE;
            this.uiPhaseTicks = 0;
            this.scrollAnimPhase = ScrollAnimPhase.OPEN_STILL;
            this.pearlPhase = PearlPhase.IDLE;
            this.pearlPhaseTicks = 0;
            if (this.dateWidget != null) {
                this.dateWidget.visible = true;
                this.fillDateWidgetIfNeeded();
            }
            if (this.recipientField != null) {
                this.recipientField.visible = true;
            }
            if (this.messageWidget != null) {
                this.messageWidget.visible = true;
            }
            if (this.signatureWidget != null) {
                this.signatureWidget.visible = true;
            }
            this.setWidgetsAlpha(1.0f);
            this.setWidgetsInteractive(true);
            m.setClientSkipIntroAnimation(false);
            LOG.debug("[ScrollSealingScreen] init: skipping intro animation (return from pearl inventory)");
        } else {
            this.setWidgetsAlpha(0.0f);
            this.setWidgetsInteractive(false);
            LOG.debug("[ScrollSealingScreen] init complete: scrollAnimPhase={}, uiPhase={}, pearlPhase={}", new Object[]{this.scrollAnimPhase, this.uiPhase, this.pearlPhase});
        }
    }

    private void renderZoomWaxSeal(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        try {
            SealSigilGenerator.SigilPattern zoomPattern;
            if (this.uiPhase != UiPhase.SEALED) {
                return;
            }
            boolean inZoomArea = this.isMouseInWaxAreaZoom(mouseX, mouseY);
            int zoomClipX = this.leftPos + 50;
            int zoomClipY = this.topPos + 30;
            int zoomClipW = 125;
            int zoomClipH = 125;
            int zoomCenterX = zoomClipX + 62 + 0;
            int zoomCenterY = zoomClipY + 62 + 0;
            SealSigilGenerator.SigilPattern patternForZoom = null;
            if (this.placedSealShown && this.placedSigilPatternZoom != null) {
                patternForZoom = this.placedSigilPatternZoom;
            } else if (this.sealStampTargetMode && this.sealStampSlotIndex >= 0 && this.sealStampStackForRender != null && !this.sealStampStackForRender.isEmpty() && inZoomArea && (zoomPattern = this.buildZoomPatternFromStamp(this.sealStampStackForRender)) != null) {
                patternForZoom = zoomPattern;
            }
            if (patternForZoom == null) {
                return;
            }
            try {
                this.waxSealVisualizer.renderShapesOnly(g, zoomCenterX, zoomCenterY, zoomClipX, zoomClipY, 125, 125, 42, 1.0f, patternForZoom);
            }
            catch (Throwable drawErr) {
                LOG.error("[ScrollSealingScreen] renderZoomWaxSeal: shapes-only zoom impression failed", drawErr);
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] renderZoomWaxSeal failed", t);
        }
    }

    private void renderWaxSeal(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick, boolean zoomView) {
        try {
            if (zoomView) {
                this.renderZoomWaxSeal(g, mouseX, mouseY, partialTick);
            } else {
                this.renderSmallWaxSeal(g, mouseX, mouseY, partialTick);
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] renderWaxSeal (wrapper) failed", t);
        }
    }

    private void renderSmallWaxSeal(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        try {
            if (this.uiPhase != UiPhase.SEALED) {
                return;
            }
            boolean inWaxArea = this.isMouseInWaxAreaSmall(mouseX, mouseY);
            int smallClipX = this.leftPos + 94;
            int smallClipY = this.topPos + 74;
            int smallClipW = 36;
            int smallClipH = 36;
            int smallCenterX = smallClipX + 18 + 0;
            int smallCenterY = smallClipY + 18 + 0;
            int smallRadiusPx = Math.max(6, (int)((float)Math.min(36, 36) * 0.5f * 0.85f));
            SealSigilGenerator.SigilPattern patternForSmall = null;
            if (this.placedSealShown && this.placedSigilPattern != null) {
                patternForSmall = this.placedSigilPattern;
            } else if (this.sealStampTargetMode && this.sealStampSlotIndex >= 0 && this.sealStampStackForRender != null && !this.sealStampStackForRender.isEmpty() && inWaxArea) {
                if (this.hoverSigilPattern == null) {
                    this.hoverSigilPattern = this.buildPatternFromStamp(this.sealStampStackForRender);
                }
                if (this.hoverSigilPattern != null) {
                    patternForSmall = this.hoverSigilPattern;
                }
            }
            if (patternForSmall == null) {
                return;
            }
            try {
                this.waxSealVisualizer.renderShapesOnly(g, smallCenterX, smallCenterY, smallClipX, smallClipY, 36, 36, smallRadiusPx, 1.0f, patternForSmall);
            }
            catch (Throwable drawErr) {
                LOG.error("[ScrollSealingScreen] renderSmallWaxSeal: shapes-only impression failed", drawErr);
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] renderSmallWaxSeal failed", t);
        }
    }

    private SealSigilGenerator.SigilPattern buildPatternFromStamp(@NotNull ItemStack stampStack) {
        try {
            if (stampStack == null || stampStack.isEmpty() || !(stampStack.getItem() instanceof SealStampItem)) {
                LOG.debug("[ScrollSealingScreen] buildPatternFromStamp: not a SealStampItem");
                return null;
            }
            CustomData data = (CustomData)stampStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag root = data.copyTag();
            if (root == null || !root.contains("SealStamp")) {
                LOG.debug("[ScrollSealingScreen] buildPatternFromStamp: missing SealStamp tag");
                return null;
            }
            CompoundTag seal = root.getCompound("SealStamp");
            long seed = seal.getLong("Seed");
            int slices = seal.getInt("Slices");
            int style = seal.getInt("ShapeSet");
            int radiusPx = Math.max(6, (int)((float)Math.min(36, 36) * 0.5f * 0.85f));
            SealSigilGenerator.SigilPattern pattern = SealSigilGenerator.generateFromSeed(seed, radiusPx, slices, style);
            LOG.debug("[ScrollSealingScreen] buildPatternFromStamp -> pattern ok (seed={} slices={} style={} radius={})", new Object[]{seed, slices, style, radiusPx});
            return pattern;
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] buildPatternFromStamp failed", t);
            return null;
        }
    }

    private void saveEditorStateToMenu() {
        try {
            ScrollSealingMenu m = this.getScrollMenu();
            m.setClientDateText(this.dateWidget != null ? this.dateWidget.getText() : "");
            m.setClientRecipientText(this.recipientField != null ? this.recipientField.getText() : "");
            m.setClientMessageText(this.messageWidget != null ? this.messageWidget.getText() : "");
            m.setClientSignatureText(this.signatureWidget != null ? this.signatureWidget.getText() : "");
            m.setClientRecipientUUID(this.selectedRecipientUuid != null ? this.selectedRecipientUuid.toString() : "");
            LOG.debug("[ScrollSealingScreen] Editor state saved to menu (including recipient UUID)");
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] saveEditorStateToMenu failed", t);
        }
    }

    private void restoreEditorStateFromMenu() {
        try {
            String st;
            String mt;
            String rt;
            String dt;
            ScrollSealingMenu m = this.getScrollMenu();
            if (this.dateWidget != null && !(dt = m.getClientDateText()).isEmpty()) {
                this.dateWidget.setText(dt);
                this.dateWidget.setCursorToEnd();
            }
            if (this.recipientField != null && !(rt = m.getClientRecipientText()).isEmpty()) {
                this.recipientField.setText(rt);
                this.recipientField.setCursorToEnd();
            }
            this.selectedRecipientUuid = null;
            String storedUuid = m.getClientRecipientUUID();
            if (storedUuid != null && !storedUuid.isEmpty()) {
                try {
                    this.selectedRecipientUuid = UUID.fromString(storedUuid);
                    LOG.debug("[ScrollSealingScreen] Restored recipient UUID from menu: {}", (Object)storedUuid);
                }
                catch (IllegalArgumentException uuidErr) {
                    LOG.error("[ScrollSealingScreen] Invalid stored recipient UUID '{}'", (Object)storedUuid, (Object)uuidErr);
                    this.selectedRecipientUuid = null;
                }
            }
            if (this.messageWidget != null && !(mt = m.getClientMessageText()).isEmpty()) {
                this.messageWidget.setText(mt);
                this.messageWidget.setCursorToEnd();
            }
            if (this.signatureWidget != null && !(st = m.getClientSignatureText()).isEmpty()) {
                this.signatureWidget.setText(st);
                this.signatureWidget.setCursorToEnd();
            }
            LOG.debug("[ScrollSealingScreen] Editor state restored from menu (including recipient UUID)");
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] restoreEditorStateFromMenu failed", t);
        }
    }

    private void openRecipientOverlayIfEmpty() {
        if (this.recipientOverlay == null) {
            return;
        }
        String txt = this.recipientField.getText();
        if (txt == null || txt.isEmpty()) {
            LOG.debug("[ScrollSealingScreen] Opening recipient overlay, clearing previous UUID");
            this.selectedRecipientUuid = null;
            this.recipientOverlay.setPosition(this.leftPos + 30, this.topPos + 36 + 14 + 4);
            this.recipientOverlay.open();
        }
    }

    private SealSigilGenerator.SigilPattern buildZoomPatternFromStamp(@NotNull ItemStack stampStack) {
        try {
            if (stampStack == null || stampStack.isEmpty() || !(stampStack.getItem() instanceof SealStampItem)) {
                LOG.debug("[ScrollSealingScreen] buildZoomPatternFromStamp: not a SealStampItem");
                return null;
            }
            CustomData data = (CustomData)stampStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag root = data.copyTag();
            if (root == null || !root.contains("SealStamp")) {
                LOG.debug("[ScrollSealingScreen] buildZoomPatternFromStamp: missing SealStamp tag");
                return null;
            }
            CompoundTag seal = root.getCompound("SealStamp");
            long seed = seal.getLong("Seed");
            int slices = seal.getInt("Slices");
            int style = seal.getInt("ShapeSet");
            int radiusPx = Math.max(6, 42);
            SealSigilGenerator.SigilPattern pattern = SealSigilGenerator.generateFromSeed(seed, radiusPx, slices, style);
            LOG.debug("[ScrollSealingScreen] buildZoomPatternFromStamp -> pattern ok (seed={} slices={} style={} radius={})", new Object[]{seed, slices, style, radiusPx});
            return pattern;
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] buildZoomPatternFromStamp failed", t);
            return null;
        }
    }

    private boolean isMouseInWaxAreaSmall(double mouseX, double mouseY) {
        int x0 = this.leftPos + 94;
        int y0 = this.leftPos + 0;
        y0 = this.topPos + 74;
        int x1 = x0 + 36;
        int y1 = y0 + 36;
        return mouseX >= (double)x0 && mouseX < (double)x1 && mouseY >= (double)y0 && mouseY < (double)y1;
    }

    private boolean isMouseInWaxAreaZoom(double mouseX, double mouseY) {
        int x0 = this.leftPos + 50;
        int y0 = this.topPos + 30;
        int x1 = x0 + 125;
        int y1 = y0 + 125;
        return mouseX >= (double)x0 && mouseX < (double)x1 && mouseY >= (double)y0 && mouseY < (double)y1;
    }

    private String computeCurrentDateString() {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.level == null) {
                LOG.warn("[ScrollSealingScreen] computeCurrentDateString: Minecraft/level not ready, using fallback");
                return "Unknown Date";
            }
            long dayTime = mc.level.getDayTime();
            long ticksPerDay = 24000L;
            if (ticksPerDay <= 0L) {
                LOG.warn("[ScrollSealingScreen] computeCurrentDateString: FFCalendarConfig.TICKS_PER_DAY <= 0 ({}), using 24000 fallback", (Object)ticksPerDay);
                ticksPerDay = 24000L;
            }
            long dayIndex = dayTime / ticksPerDay;
            Component dateComponent = ClientCalendarEvents.buildDateMessage(dayIndex);
            return dateComponent.getString();
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] computeCurrentDateString failed", t);
            return "Unknown Date";
        }
    }

    private void fillDateWidgetIfNeeded() {
        if (this.dateWidget == null) {
            return;
        }
        try {
            String current = this.dateWidget.getText();
            if (current != null && !current.isEmpty()) {
                return;
            }
            String dateString = this.computeCurrentDateString();
            this.dateWidget.setText(dateString);
            this.dateWidget.setCursorToEnd();
            LOG.debug("[ScrollSealingScreen] Date widget filled with '{}'", (Object)dateString);
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] fillDateWidgetIfNeeded failed", t);
        }
    }

    private void onSignButtonClicked() {
        try {
            String signerName;
            String recipientText;
            if (this.uiPhase != UiPhase.IDLE) {
                LOG.debug("[ScrollSealingScreen] onSignButtonClicked ignored: uiPhase={}", (Object)this.uiPhase);
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.player == null || mc.level == null) {
                LOG.warn("[ScrollSealingScreen] onSignButtonClicked: Minecraft/level/player not ready");
                return;
            }
            if (this.selectedRecipientUuid == null) {
                LOG.info("[ScrollSealingScreen] onSignButtonClicked: No recipient UUID set, aborting sign");
                return;
            }
            String string = recipientText = this.recipientField != null ? this.recipientField.getText() : null;
            if (recipientText == null || recipientText.trim().isEmpty()) {
                LOG.info("[ScrollSealingScreen] onSignButtonClicked: Recipient field is empty, aborting sign");
                return;
            }
            String dateString = this.computeCurrentDateString();
            this.signerUuid = mc.player.getUUID();
            String fullSignature = signerName = mc.player.getGameProfile().getName();
            if (this.signatureWidget != null) {
                this.signatureWidget.setText(fullSignature);
                this.signatureWidget.setCursorToEnd();
            }
            this.saveEditorStateToMenu();
            LOG.info("[ScrollSealingScreen] Scroll signed by {} ({}) on {}", new Object[]{signerName, this.signerUuid, dateString});
            this.beginOutroFade();
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] onSignButtonClicked failed", t);
        }
    }

    private void beginOutroFade() {
        if (this.uiPhase == UiPhase.OUTRO_FADE_OUT || this.uiPhase == UiPhase.SEALED) {
            return;
        }
        this.uiPhase = UiPhase.OUTRO_FADE_OUT;
        this.uiPhaseTicks = 0;
        this.setWidgetsInteractive(false);
        this.pearlPhase = PearlPhase.DISAPPEARING;
        this.pearlPhaseTicks = 0;
        LOG.debug("[ScrollSealingScreen] beginOutroFade -> uiPhase={}, pearlPhase={}", (Object)this.uiPhase, (Object)this.pearlPhase);
    }

    private void tickUiPhase() {
        switch (this.uiPhase.ordinal()) {
            case 0: {
                ++this.uiPhaseTicks;
                if (this.uiPhaseTicks < 10) break;
                this.uiPhase = UiPhase.INTRO_FADE_IN;
                this.uiPhaseTicks = 0;
                this.scrollAnimPhase = ScrollAnimPhase.OPEN_STILL;
                this.pearlPhase = PearlPhase.INSTANTIATING;
                this.pearlPhaseTicks = 0;
                LOG.debug("[ScrollSealingScreen] Intro delay finished -> INTRO_FADE_IN");
                break;
            }
            case 1: {
                ++this.uiPhaseTicks;
                if (this.uiPhaseTicks == 1) {
                    this.setWidgetsAlpha(0.0f);
                    if (this.dateWidget != null) {
                        this.dateWidget.visible = true;
                        this.fillDateWidgetIfNeeded();
                    }
                    if (this.recipientField != null) {
                        this.recipientField.visible = true;
                    }
                    if (this.messageWidget != null) {
                        this.messageWidget.visible = true;
                    }
                    if (this.signatureWidget != null) {
                        this.signatureWidget.visible = true;
                    }
                }
                float t = (float)this.uiPhaseTicks / 30.0f;
                float alpha = Math.min(1.0f, Math.max(0.0f, t));
                this.setWidgetsAlpha(alpha);
                if (this.uiPhaseTicks < 30) break;
                this.setWidgetsAlpha(1.0f);
                this.setWidgetsInteractive(true);
                this.uiPhase = UiPhase.IDLE;
                this.uiPhaseTicks = 0;
                LOG.debug("[ScrollSealingScreen] Intro fade finished -> IDLE");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                ++this.uiPhaseTicks;
                float t = (float)this.uiPhaseTicks / 30.0f;
                float alpha = 1.0f - t;
                alpha = Math.min(1.0f, Math.max(0.0f, alpha));
                this.setWidgetsAlpha(alpha);
                if (this.uiPhaseTicks < 30) break;
                this.setWidgetsAlpha(0.0f);
                this.setWidgetsInteractive(false);
                if (this.dateWidget != null) {
                    this.dateWidget.visible = false;
                }
                if (this.recipientField != null) {
                    this.recipientField.visible = false;
                }
                if (this.messageWidget != null) {
                    this.messageWidget.visible = false;
                }
                if (this.signatureWidget != null) {
                    this.signatureWidget.visible = false;
                }
                this.uiPhase = UiPhase.SEALED;
                this.uiPhaseTicks = 0;
                this.scrollAnimPhase = ScrollAnimPhase.CLOSING;
                LOG.debug("[ScrollSealingScreen] Outro fade finished -> SEALED");
                break;
            }
            case 4: {
                ++this.uiPhaseTicks;
                if (this.uiPhaseTicks < 10) break;
                if (this.scrollAnimPhase == ScrollAnimPhase.CLOSING) {
                    this.scrollAnimPhase = ScrollAnimPhase.CLOSED_STILL;
                    LOG.debug("[ScrollSealingScreen] Closing animation completed within OUTRO_DELAY_TICKS");
                }
                this.uiPhaseTicks = 10;
                if (this.sealStampSelectionStarted) break;
                this.sealStampSelectionStarted = true;
                if (this.sealStampOverlay != null) {
                    int stampOverlayX = this.leftPos + (240 - this.sealStampOverlay.getWidth()) / 2;
                    int stampOverlayY = this.topPos + 62 + 64 + 10;
                    this.sealStampOverlay.setPosition(stampOverlayX, stampOverlayY);
                    this.sealStampOverlay.setActive(true);
                    this.sealStampOverlay.rebuildEntriesAndAutoSelectFavorite();
                    LOG.debug("[ScrollSealingScreen] Seal stamp overlay activated for sealing");
                    break;
                }
                LOG.warn("[ScrollSealingScreen] SEALED phase reached but sealStampOverlay is null");
            }
        }
    }

    private void setWidgetsAlpha(float alpha) {
        int a = (int)(alpha * 255.0f);
        if (a < 0) {
            a = 0;
        }
        if (a > 255) {
            a = 255;
        }
        if (this.dateWidget != null) {
            this.dateWidget.setAlpha(a);
        }
        if (this.recipientField != null) {
            this.recipientField.setAlpha(a);
        }
        if (this.messageWidget != null) {
            this.messageWidget.setAlpha(a);
        }
        if (this.signatureWidget != null) {
            this.signatureWidget.setAlpha(a);
        }
    }

    private void setWidgetsInteractive(boolean enabled) {
        if (this.recipientField != null) {
            this.recipientField.setEditable(enabled);
        }
        if (this.messageWidget != null) {
            this.messageWidget.setEditable(enabled);
        }
        if (!enabled) {
            if (this.recipientField != null) {
                this.recipientField.setFocused(false);
            }
            if (this.messageWidget != null) {
                this.messageWidget.setFocused(false);
            }
        }
    }

    private boolean isUiInteractive() {
        return this.uiPhase == UiPhase.IDLE;
    }

    private void tickPearl() {
        switch (this.pearlPhase.ordinal()) {
            case 0: 
            case 2: 
            case 4: {
                break;
            }
            case 1: {
                ++this.pearlPhaseTicks;
                int frames = 7;
                int totalTicks = frames * Math.max(1, 2);
                if (this.pearlPhaseTicks < totalTicks) break;
                this.pearlPhase = PearlPhase.IDLE;
                this.pearlPhaseTicks = 0;
                LOG.debug("[ScrollSealingScreen] Pearl instantiation finished -> IDLE");
                break;
            }
            case 3: {
                ++this.pearlPhaseTicks;
                int frames = 3;
                int totalTicks = frames * Math.max(1, 2);
                if (this.pearlPhaseTicks < totalTicks) break;
                this.pearlPhase = PearlPhase.GONE;
                this.pearlPhaseTicks = 0;
                LOG.debug("[ScrollSealingScreen] Pearl disappearing finished -> GONE");
                break;
            }
        }
    }

    private boolean isPearlClickable() {
        return this.pearlPhase == PearlPhase.IDLE && this.isUiInteractive();
    }

    protected void containerTick() {
        block16: {
            super.containerTick();
            try {
                if (this.dateWidget != null) {
                    this.dateWidget.tick();
                }
                if (this.recipientField != null) {
                    this.recipientField.tick();
                }
                if (this.messageWidget != null) {
                    this.messageWidget.tick();
                }
                if (this.signatureWidget != null) {
                    this.signatureWidget.tick();
                }
                if (this.recipientOverlay != null && this.recipientOverlay.isActive()) {
                    this.recipientOverlay.tick();
                }
                if (this.sealStampOverlay != null && this.sealStampOverlay.isActive()) {
                    this.sealStampOverlay.tick();
                }
                this.tickUiPhase();
                this.tickPearl();
                if (!this.placedSealShown || this.placedFadeTicks < 0) break block16;
                if (this.placedFadeTicks < 20) {
                    ++this.placedFadeTicks;
                    break block16;
                }
                try {
                    Minecraft mc = Minecraft.getInstance();
                    if (mc != null) {
                        if (mc.player != null) {
                            mc.player.closeContainer();
                        }
                        mc.setScreen(null);
                    }
                }
                catch (Throwable closeErr) {
                    LOG.error("[ScrollSealingScreen] Failed to close after admiration fade", closeErr);
                }
                finally {
                    this.placedFadeTicks = -1;
                }
            }
            catch (Throwable t) {
                LOG.error("[ScrollSealingScreen] containerTick failed", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        try {
            boolean canZoomPhase;
            boolean inSmallWax = this.isMouseInWaxAreaSmall(mouseX, mouseY);
            boolean inZoomWax = this.isMouseInWaxAreaZoom(mouseX, mouseY);
            boolean bl = canZoomPhase = this.uiPhase == UiPhase.SEALED && (!this.placedSealShown || this.placedFadeTicks < 0);
            if (!canZoomPhase) {
                if (this.zoomActive) {
                    LOG.debug("[ScrollSealingScreen] renderBg: Disabling zoomActive (phase not eligible)");
                }
                this.zoomActive = false;
            } else if (!this.zoomActive) {
                if (inSmallWax) {
                    this.zoomActive = true;
                    LOG.debug("[ScrollSealingScreen] renderBg: Zoom entered via SMALL gizmo");
                }
            } else if (!inZoomWax) {
                this.zoomActive = false;
                LOG.debug("[ScrollSealingScreen] renderBg: Zoom exited by leaving ZOOM gizmo");
            }
            boolean shouldZoom = this.zoomActive;
            if (shouldZoom) {
                PoseStack pose = guiGraphics.pose();
                pose.pushPose();
                try {
                    int centerX = this.leftPos + 94 + 18;
                    int centerY = this.topPos + 74 + 18;
                    pose.translate((float)centerX, (float)centerY, 0.0f);
                    pose.scale(3.5f, 3.5f, 1.0f);
                    pose.translate((float)(-centerX), (float)(-centerY), 0.0f);
                    this.renderAnimatedScroll(guiGraphics, true);
                    this.renderPearl(guiGraphics, mouseX, mouseY);
                }
                finally {
                    pose.popPose();
                }
                this.renderWaxSeal(guiGraphics, mouseX, mouseY, partialTick, true);
            } else {
                this.renderAnimatedScroll(guiGraphics, false);
                this.renderWaxSeal(guiGraphics, mouseX, mouseY, partialTick, false);
                this.renderPearl(guiGraphics, mouseX, mouseY);
            }
            if (this.uiPhase != UiPhase.SEALED) return;
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] renderBg failed, falling back to simple fill", t);
            guiGraphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -1057623848);
        }
    }

    private void renderAnimatedScroll(GuiGraphics guiGraphics) {
        this.renderAnimatedScroll(guiGraphics, false);
    }

    private void renderAnimatedScroll(GuiGraphics guiGraphics, boolean zoomed) {
        int frameIndex;
        ResourceLocation textureToUse;
        switch (this.scrollAnimPhase.ordinal()) {
            case 0: {
                textureToUse = SCROLL_OPENING_TEXTURE;
                int totalTicks = Math.max(1, 10);
                int currentTicks = Math.min(this.uiPhaseTicks, totalTicks);
                float progress = totalTicks == 0 ? 1.0f : (float)currentTicks / (float)totalTicks;
                frameIndex = (int)(progress * 6.0f);
                if (frameIndex < 0) {
                    frameIndex = 0;
                }
                if (frameIndex < 7) break;
                frameIndex = 6;
                break;
            }
            case 1: {
                textureToUse = SCROLL_OPENING_TEXTURE;
                frameIndex = 6;
                break;
            }
            case 2: {
                textureToUse = zoomed ? SCROLL_CLOSING_TEXTURE_ZOOM : SCROLL_CLOSING_TEXTURE;
                int totalTicks = Math.max(1, 10);
                int currentTicks = Math.min(this.uiPhaseTicks, totalTicks);
                float progress = totalTicks == 0 ? 1.0f : (float)currentTicks / (float)totalTicks;
                frameIndex = (int)(progress * 6.0f);
                if (frameIndex < 0) {
                    frameIndex = 0;
                }
                if (frameIndex < 7) break;
                frameIndex = 6;
                break;
            }
            case 3: {
                textureToUse = zoomed ? SCROLL_CLOSING_TEXTURE_ZOOM : SCROLL_CLOSING_TEXTURE;
                frameIndex = 6;
                break;
            }
            default: {
                guiGraphics.blit(SCROLL_GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
                return;
            }
        }
        int textureWidth = 1680;
        int textureHeight = 208;
        int u = frameIndex * 240;
        boolean v = false;
        guiGraphics.blit(textureToUse, this.leftPos, this.topPos, (float)u, (float)v, 240, 208, textureWidth, textureHeight);
    }

    private void renderPearl(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int frameIndex;
        boolean hovered;
        if (this.pearlPhase == PearlPhase.HIDDEN || this.pearlPhase == PearlPhase.GONE) {
            return;
        }
        boolean bl = hovered = this.isMouseOverPearlIcon(mouseX, mouseY) && this.isUiInteractive();
        if (hovered && this.pearlPhase == PearlPhase.IDLE) {
            frameIndex = 7;
        } else {
            switch (this.pearlPhase.ordinal()) {
                case 1: {
                    int frames = 7;
                    int ticksPerFrame = Math.max(1, 2);
                    int maxTicks = frames * ticksPerFrame;
                    int clampedTicks = Math.min(this.pearlPhaseTicks, maxTicks - 1);
                    int offset = clampedTicks / ticksPerFrame;
                    frameIndex = 0 + offset;
                    break;
                }
                case 2: {
                    frameIndex = 6;
                    break;
                }
                case 3: {
                    int frames = 3;
                    int ticksPerFrame = Math.max(1, 2);
                    int maxTicks = frames * ticksPerFrame;
                    int clampedTicks = Math.min(this.pearlPhaseTicks, maxTicks - 1);
                    int offset = clampedTicks / ticksPerFrame;
                    frameIndex = 8 + offset;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (frameIndex < 0 || frameIndex >= 11) {
            return;
        }
        int textureWidth = 32;
        int textureHeight = 352;
        boolean u = false;
        int v = frameIndex * 32;
        int x = this.leftPos + 183;
        int y = this.topPos + 10;
        guiGraphics.blit(PEARL_TEXTURE, x, y, (float)u, (float)v, 32, 32, textureWidth, textureHeight);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        try {
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
            super.render(guiGraphics, mouseX, mouseY, partialTick);
            if (this.signatureWidget != null && this.uiPhase == UiPhase.IDLE) {
                boolean hoverSignature = this.isMouseOverSignature(mouseX, mouseY) && this.signatureWidget.getText().isEmpty();
                this.signatureWidget.setPlaceholderColor(hoverSignature ? 0 : 0x707070);
            }
            if (this.recipientOverlay != null && this.recipientOverlay.isActive()) {
                this.recipientOverlay.render(guiGraphics, mouseX, mouseY, partialTick);
            }
            if (this.sealStampOverlay != null && this.sealStampOverlay.isActive()) {
                this.sealStampOverlay.render(guiGraphics, mouseX, mouseY, partialTick);
            }
            if (this.sealStampTargetMode && this.sealStampSlotIndex >= 0 && this.sealStampStackForRender != null && !this.sealStampStackForRender.isEmpty()) {
                try {
                    int iconX = mouseX - 8;
                    int iconY = mouseY - 8;
                    guiGraphics.renderItem(this.sealStampStackForRender, iconX, iconY);
                    guiGraphics.renderItemDecorations(this.font, this.sealStampStackForRender, iconX, iconY);
                }
                catch (Throwable t) {
                    LOG.error("[ScrollSealingScreen] Failed to render seal stamp cursor", t);
                }
            }
            if (this.placedSealShown && this.placedFadeTicks >= 0) {
                float t = Math.min(1.0f, (float)this.placedFadeTicks / 20.0f);
                int alpha = (int)(t * 255.0f);
                if (alpha < 0) {
                    alpha = 0;
                }
                if (alpha > 255) {
                    alpha = 255;
                }
                int color = alpha << 24;
                guiGraphics.fill(0, 0, this.width, this.height, color);
            }
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] render failed", t);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return false;
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.hoveredSlot = null;
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        try {
            boolean consumedStamp;
            boolean consumed;
            if (this.placedSealShown && this.placedFadeTicks >= 0) {
                return true;
            }
            if (this.recipientOverlay != null && this.recipientOverlay.isActive() && (consumed = this.recipientOverlay.mouseClicked(mouseX, mouseY, button))) {
                return true;
            }
            if (this.sealStampOverlay != null && this.sealStampOverlay.isActive() && this.uiPhase == UiPhase.SEALED && (consumedStamp = this.sealStampOverlay.mouseClicked(mouseX, mouseY, button))) {
                if (this.sealStampTargetMode && this.sealStampStackForRender != null && !this.sealStampStackForRender.isEmpty()) {
                    this.hoverSigilPattern = null;
                }
                return true;
            }
            if (this.uiPhase == UiPhase.SEALED && this.sealStampTargetMode && this.sealStampSlotIndex >= 0 && this.sealStampStackForRender != null && !this.sealStampStackForRender.isEmpty()) {
                boolean inZoomWaxArea = this.isMouseInWaxAreaZoom(mouseX, mouseY);
                if (button == 0) {
                    if (inZoomWaxArea) {
                        LOG.info("[ScrollSealingScreen] Zoom wax area clicked with selected stamp: slotIndex={} stack={}", (Object)this.sealStampSlotIndex, (Object)this.sealStampStackForRender);
                        try {
                            String recipientUUIDStr;
                            Minecraft mc = Minecraft.getInstance();
                            if (mc == null || mc.player == null) {
                                LOG.error("[ScrollSealingScreen] Cannot seal: Minecraft or player is null");
                                return true;
                            }
                            ItemStack actualStamp = ItemStack.EMPTY;
                            if (this.sealStampSlotIndex >= 0 && this.sealStampSlotIndex <= 35) {
                                if (this.sealStampSlotIndex < mc.player.getInventory().items.size()) {
                                    actualStamp = (ItemStack)mc.player.getInventory().items.get(this.sealStampSlotIndex);
                                }
                            } else if (this.sealStampSlotIndex == 37) {
                                actualStamp = mc.player.getOffhandItem();
                            } else {
                                LOG.warn("[ScrollSealingScreen] Unexpected stamp slot index {} (expected 0..35 or 37)", (Object)this.sealStampSlotIndex);
                            }
                            if (actualStamp.isEmpty() || !(actualStamp.getItem() instanceof SealStampItem)) {
                                LOG.error("[ScrollSealingScreen] Selected stack is not a valid SealStampItem; aborting seal");
                                return true;
                            }
                            if (!SealStampItem.isEtched(actualStamp)) {
                                LOG.error("[ScrollSealingScreen] Selected SealStampItem is not etched; aborting seal");
                                return true;
                            }
                            String senderName = "";
                            long seed = 0L;
                            int slices = 0;
                            int style = 0;
                            try {
                                CustomData cd = (CustomData)actualStamp.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                                CompoundTag root = cd.copyTag();
                                if (root == null || !root.contains("SealStamp")) {
                                    LOG.error("[ScrollSealingScreen] SealStamp CustomData missing on etched stamp; aborting");
                                    return true;
                                }
                                CompoundTag seal = root.getCompound("SealStamp");
                                senderName = seal.getString("Owner");
                                seed = seal.getLong("Seed");
                                slices = seal.getInt("Slices");
                                style = seal.getInt("ShapeSet");
                            }
                            catch (Throwable te) {
                                LOG.error("[ScrollSealingScreen] Failed extracting SealStamp CustomData", te);
                                return true;
                            }
                            String dateText = "";
                            if (this.dateWidget != null) {
                                try {
                                    dateText = this.dateWidget.getText();
                                }
                                catch (Throwable tDate) {
                                    LOG.error("[ScrollSealingScreen] Failed to read date widget text, falling back to computeCurrentDateString()", tDate);
                                    dateText = "";
                                }
                            }
                            if (dateText == null || dateText.isEmpty()) {
                                dateText = this.computeCurrentDateString();
                            }
                            String recipientText = this.recipientField != null ? this.recipientField.getText() : "";
                            String messageText = this.messageWidget != null ? this.messageWidget.getText() : "";
                            String signatureText = this.signatureWidget != null ? this.signatureWidget.getText() : "";
                            String string = recipientUUIDStr = this.selectedRecipientUuid != null ? this.selectedRecipientUuid.toString() : "";
                            if (recipientUUIDStr.isEmpty()) {
                                LOG.error("[ScrollSealingScreen] No recipient UUID set; aborting seal");
                                return true;
                            }
                            String recipientTextRaw = this.recipientField != null ? this.recipientField.getText() : "";
                            String recipientNameResolved = "";
                            if (recipientTextRaw != null) {
                                String mid;
                                String t = recipientTextRaw.trim();
                                String lower = t.toLowerCase(Locale.ROOT);
                                recipientNameResolved = lower.startsWith("dear ") && t.endsWith(",") ? (mid = t.substring(5, Math.max(5, t.length() - 1)).trim()) : t;
                            }
                            if (recipientText.length() > 32760) {
                                recipientText = recipientText.substring(0, 32760);
                            }
                            if (messageText.length() > 32760) {
                                messageText = messageText.substring(0, 32760);
                            }
                            if (signatureText.length() > 32760) {
                                signatureText = signatureText.substring(0, 32760);
                            }
                            if (recipientNameResolved.length() > 250) {
                                recipientNameResolved = recipientNameResolved.substring(0, 250);
                            }
                            this.saveEditorStateToMenu();
                            LOG.debug("[ScrollSealingScreen] Sending WaxSealPacket (admire fade after): date='{}' rec='{}' uuid={} seed={} slices={} style={} sender='{}'", new Object[]{dateText, recipientNameResolved, recipientUUIDStr, seed, slices, style, senderName});
                            FFNetwork.sendWaxSealToServer(this.sealStampSlotIndex, dateText != null ? dateText : "", recipientNameResolved, recipientUUIDStr, recipientText != null ? recipientText : "", messageText != null ? messageText : "", signatureText != null ? signatureText : "", seed, slices, style, senderName);
                            try {
                                this.placedSigilPattern = this.buildPatternFromStamp(actualStamp);
                                this.placedSigilPatternZoom = this.buildZoomPatternFromStamp(actualStamp);
                                this.hoverSigilPattern = null;
                                this.placedSealShown = this.placedSigilPattern != null;
                                this.placedFadeTicks = 0;
                                this.sealStampTargetMode = false;
                                this.sealStampSlotIndex = -1;
                                this.sealStampStackForRender = ItemStack.EMPTY;
                                if (this.sealStampOverlay != null) {
                                    this.sealStampOverlay.setActive(false);
                                }
                            }
                            catch (Throwable placeErr) {
                                LOG.error("[ScrollSealingScreen] Failed to start admiration fade", placeErr);
                            }
                        }
                        catch (Throwable sealErr) {
                            LOG.error("[ScrollSealingScreen] Exception during wax sealing click handling", sealErr);
                        }
                        return true;
                    }
                    LOG.debug("[ScrollSealingScreen] Deselecting seal stamp via LMB outside zoom wax area");
                    this.sealStampTargetMode = false;
                    this.sealStampSlotIndex = -1;
                    this.sealStampStackForRender = ItemStack.EMPTY;
                    this.hoverSigilPattern = null;
                    return true;
                }
                if (button == 1) {
                    LOG.debug("[ScrollSealingScreen] Deselecting seal stamp via RMB");
                    this.sealStampTargetMode = false;
                    this.sealStampSlotIndex = -1;
                    this.sealStampStackForRender = ItemStack.EMPTY;
                    this.hoverSigilPattern = null;
                    return true;
                }
            }
            if (button == 0 && this.signatureWidget != null && this.isUiInteractive() && this.signatureWidget.getText().isEmpty() && this.isMouseOverSignature(mouseX, mouseY)) {
                this.onSignButtonClicked();
                return true;
            }
            if (button == 0 && this.isMouseOverPearlIcon(mouseX, mouseY) && this.isPearlClickable()) {
                this.saveEditorStateToMenu();
                this.onEnderPearlClicked();
                return true;
            }
            boolean result = super.mouseClicked(mouseX, mouseY, button);
            if (this.recipientField != null && this.recipientField.isFocused()) {
                String txt = this.recipientField.getText();
                if (txt == null || txt.isEmpty()) {
                    this.openRecipientOverlayIfEmpty();
                } else if (this.recipientOverlay != null && this.recipientOverlay.isActive()) {
                    this.recipientOverlay.close(true);
                }
            } else if (this.recipientOverlay != null && this.recipientOverlay.isActive()) {
                this.recipientOverlay.close(true);
            }
            this.saveEditorStateToMenu();
            return result;
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] mouseClicked failed", t);
            return false;
        }
    }

    private boolean isMouseOverPearlIcon(double mouseX, double mouseY) {
        int x0 = this.leftPos + 183;
        int y0 = this.topPos + 10;
        int x1 = x0 + 32;
        int y1 = y0 + 32;
        return mouseX >= (double)x0 && mouseX < (double)x1 && mouseY >= (double)y0 && mouseY < (double)y1;
    }

    private boolean isMouseOverSignature(double mouseX, double mouseY) {
        if (this.signatureWidget == null) {
            return false;
        }
        int x0 = this.signatureWidget.getX();
        int y0 = this.signatureWidget.getY();
        int x1 = x0 + this.signatureWidget.getWidth();
        int y1 = y0 + this.signatureWidget.getHeight();
        return mouseX >= (double)x0 && mouseX < (double)x1 && mouseY >= (double)y0 && mouseY < (double)y1;
    }

    private void onEnderPearlClicked() {
        try {
            if (!this.isPearlClickable()) {
                LOG.debug("[ScrollSealingScreen] Ender pearl click ignored; pearlPhase={} uiPhase={}", (Object)this.pearlPhase, (Object)this.uiPhase);
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            EnderPearlInventoryScreen.handlePearlClicked(mc);
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] onEnderPearlClicked failed", t);
        }
    }

    public boolean charTyped(char codePoint, int modifiers) {
        try {
            if (this.recipientOverlay != null && this.recipientOverlay.isActive() && this.recipientOverlay.charTyped(codePoint, modifiers)) {
                return true;
            }
            boolean handled = false;
            if (this.recipientField != null && this.recipientField.isFocused()) {
                handled |= this.recipientField.charTyped(codePoint, modifiers);
            }
            if (this.messageWidget != null && this.messageWidget.isFocused()) {
                handled |= this.messageWidget.charTyped(codePoint, modifiers);
            }
            if (handled) {
                this.saveEditorStateToMenu();
            }
            return handled || super.charTyped(codePoint, modifiers);
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] charTyped failed", t);
            return false;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        try {
            if (this.placedSealShown && this.placedFadeTicks >= 0) {
                return true;
            }
            if (this.recipientOverlay != null && this.recipientOverlay.isActive() && this.recipientOverlay.keyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode == 69 || keyCode == 82 || keyCode == 85) {
                return true;
            }
            boolean handled = false;
            if (this.recipientField != null && this.recipientField.isFocused()) {
                handled |= this.recipientField.keyPressed(keyCode, scanCode, modifiers);
            }
            if (this.messageWidget != null && this.messageWidget.isFocused()) {
                handled |= this.messageWidget.keyPressed(keyCode, scanCode, modifiers);
            }
            if (handled) {
                this.saveEditorStateToMenu();
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] keyPressed failed", t);
            return false;
        }
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot != null) {
            LOG.debug("[ScrollSealingScreen] slotClicked ignored: slotId={} type={} button={}", new Object[]{slotId, type, mouseButton});
        }
    }

    private void onSealClickedPlaceholder() {
        try {
            LOG.info("[ScrollSealingScreen] Seal placeholder clicked. RecipientUUID={} SignerUUID={}", (Object)this.selectedRecipientUuid, (Object)this.signerUuid);
        }
        catch (Throwable t) {
            LOG.error("[ScrollSealingScreen] onSealClickedPlaceholder failed", t);
        }
    }

    private static enum ScrollAnimPhase {
        OPENING,
        OPEN_STILL,
        CLOSING,
        CLOSED_STILL;

    }

    private static enum PearlPhase {
        HIDDEN,
        INSTANTIATING,
        IDLE,
        DISAPPEARING,
        GONE;

    }

    private static enum UiPhase {
        INTRO_DELAY,
        INTRO_FADE_IN,
        IDLE,
        OUTRO_FADE_OUT,
        SEALED;

    }
}

