/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.gui;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import net.z2six.featheredfriend.config.FFClientConfig;
import net.z2six.featheredfriend.network.FFPayloads;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class FeatheredFriendSettingsScreen
extends Screen {
    private static final Logger LOG = LogUtils.getLogger();
    private boolean autoSummonOnScroll;
    private boolean chatDisabled;
    private boolean hasServerSettings = false;
    private boolean canEditChat = false;
    private Button autoSummonButton;
    private Button chatDisabledButton;

    public FeatheredFriendSettingsScreen() {
        super((Component)Component.literal((String)"FeatheredFriend Settings"));
    }

    protected void init() {
        super.init();
        LOG.info("[FeatheredFriendSettingsScreen] init()");
        this.loadFromCacheAndMaybeRequestSync();
        int centerX = this.width / 2;
        int y = this.height / 4;
        this.autoSummonButton = Button.builder((Component)this.textForAutoSummon(), btn -> {
            this.autoSummonOnScroll = !this.autoSummonOnScroll;
            btn.setMessage(this.textForAutoSummon());
            try {
                FFClientConfig.setAutoSummonOnScroll(this.autoSummonOnScroll);
                FFClientConfig.save();
                LOG.info("[FeatheredFriendSettingsScreen] Updated client config autoSummonOnScroll -> {}", (Object)this.autoSummonOnScroll);
            }
            catch (Throwable t) {
                LOG.error("[FeatheredFriendSettingsScreen] Failed to update autoSummonOnScroll client config", t);
            }
        }).bounds(centerX - 100, y, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.autoSummonButton);
        y += 24;
        if (this.canEditChat) {
            this.chatDisabledButton = Button.builder((Component)this.textForChatDisabled(), btn -> {
                boolean newValue;
                this.chatDisabled = newValue = !this.chatDisabled;
                btn.setMessage(this.textForChatDisabled());
                try {
                    if (!this.hasServerSettings) {
                        LOG.warn("[FeatheredFriendSettingsScreen] Chat toggled but server settings not synced yet; requesting sync instead");
                        this.requestServerSettings();
                        return;
                    }
                    if (!this.isConnectionReady()) {
                        LOG.warn("[FeatheredFriendSettingsScreen] Connection not ready; cannot send chat toggle right now");
                        return;
                    }
                    PacketDistributor.sendToServer((CustomPacketPayload)new FFPayloads.SetChatDisabledPayload(newValue), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    LOG.info("[FeatheredFriendSettingsScreen] Sent SetChatDisabledPayload -> {}", (Object)newValue);
                }
                catch (Throwable t) {
                    LOG.error("[FeatheredFriendSettingsScreen] Failed to send chatDisabled toggle", t);
                }
            }).bounds(centerX - 100, y, 200, 20).build();
            this.chatDisabledButton.active = this.hasServerSettings && this.isConnectionReady();
            this.addRenderableWidget((GuiEventListener)this.chatDisabledButton);
            y += 24;
        } else {
            this.chatDisabledButton = null;
        }
        Button done = Button.builder((Component)Component.literal((String)"Done"), btn -> this.onClose()).bounds(centerX - 75, this.height - 40, 150, 20).build();
        this.addRenderableWidget((GuiEventListener)done);
    }

    public void onServerSettingsUpdated() {
        try {
            LOG.info("[FeatheredFriendSettingsScreen] onServerSettingsUpdated()");
            this.refreshFromCacheOnly();
            if (this.autoSummonButton != null) {
                this.autoSummonButton.setMessage(this.textForAutoSummon());
            }
            if (this.chatDisabledButton != null) {
                this.chatDisabledButton.setMessage(this.textForChatDisabled());
                boolean bl = this.chatDisabledButton.active = this.hasServerSettings && this.canEditChat && this.isConnectionReady();
            }
            if (this.chatDisabledButton == null && this.canEditChat) {
                LOG.info("[FeatheredFriendSettingsScreen] Chat button absent but perms now true; rebuilding widgets");
                this.tryRebuildWidgets();
            }
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendSettingsScreen] onServerSettingsUpdated failed safely", t);
        }
    }

    private void tryRebuildWidgets() {
        try {
            this.clearWidgets();
            this.init();
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendSettingsScreen] tryRebuildWidgets failed safely", t);
        }
    }

    private boolean isConnectionReady() {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                return false;
            }
            if (mc.player == null) {
                return false;
            }
            if (mc.level == null) {
                return false;
            }
            return mc.getConnection() != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private void requestServerSettings() {
        try {
            if (!this.isConnectionReady()) {
                LOG.warn("[FeatheredFriendSettingsScreen] requestServerSettings skipped: connection not ready");
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new FFPayloads.RequestServerSettingsPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            LOG.info("[FeatheredFriendSettingsScreen] Requested server settings sync");
        }
        catch (Throwable t) {
            LOG.warn("[FeatheredFriendSettingsScreen] requestServerSettings failed safely: {}", (Object)t.toString());
        }
    }

    private void refreshFromCacheOnly() {
        try {
            this.autoSummonOnScroll = FFClientConfig.isAutoSummonOnScroll();
            this.hasServerSettings = FFPayloads.ClientState.hasSynced();
            if (this.hasServerSettings) {
                this.chatDisabled = FFPayloads.ClientState.isChatDisabled();
                this.canEditChat = FFPayloads.ClientState.canEditChat();
            } else {
                this.chatDisabled = true;
                this.canEditChat = false;
            }
            LOG.debug("[FeatheredFriendSettingsScreen] refreshFromCacheOnly: hasServerSettings={} autoSummon={} chatDisabled={} canEditChat={}", new Object[]{this.hasServerSettings, this.autoSummonOnScroll, this.chatDisabled, this.canEditChat});
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendSettingsScreen] refreshFromCacheOnly failed safely", t);
        }
    }

    private void loadFromCacheAndMaybeRequestSync() {
        try {
            this.refreshFromCacheOnly();
            if (!this.hasServerSettings) {
                if (this.isConnectionReady()) {
                    LOG.info("[FeatheredFriendSettingsScreen] No synced server settings yet; requesting sync");
                    this.requestServerSettings();
                } else {
                    LOG.info("[FeatheredFriendSettingsScreen] No synced server settings yet; connection not ready (client tick will sync)");
                }
            }
        }
        catch (Throwable t) {
            this.hasServerSettings = false;
            this.canEditChat = false;
            this.chatDisabled = true;
            this.autoSummonOnScroll = true;
            LOG.error("[FeatheredFriendSettingsScreen] loadFromCacheAndMaybeRequestSync failed safely", t);
        }
    }

    private Component textForAutoSummon() {
        return Component.literal((String)("Auto-summon raven on scroll: " + (this.autoSummonOnScroll ? "ON" : "OFF")));
    }

    private Component textForChatDisabled() {
        if (!this.hasServerSettings) {
            return Component.literal((String)"Disable global player chat: (syncing...)");
        }
        return Component.literal((String)("Disable global player chat: " + (this.chatDisabled ? "ON" : "OFF")));
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        try {
            String status = this.hasServerSettings ? "Server settings synced" : "Waiting for server settings...";
            guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)status), this.width / 2, 44, 0xAAAAAA);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isPauseScreen() {
        return true;
    }
}

