/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.gui;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.z2six.featheredfriend.client.gui.ScrollSealingScreen;
import net.z2six.featheredfriend.neoforge.menu.ScrollSealingMenu;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class EnderPearlInventoryScreen
extends AbstractContainerScreen<ScrollSealingMenu> {
    private static final Logger LOG = LogUtils.getLogger();
    private static final ResourceLocation INVENTORY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"textures/gui/scrollscreen/inventory.png");
    private static final int FADE_TICKS_TOTAL = 10;
    private int fadeTicks = 0;
    private boolean closing = false;
    private boolean closeActionPerformed = false;

    public EnderPearlInventoryScreen(@NotNull ScrollSealingMenu menu, @NotNull Inventory playerInventory, @NotNull Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 128;
        this.titleLabelX = 10000;
        this.titleLabelY = 10000;
        this.inventoryLabelX = 10000;
        this.inventoryLabelY = 10000;
    }

    public static void handlePearlClicked(Minecraft mc) {
        try {
            if (mc == null) {
                LOG.warn("[EnderPearlInventoryScreen] handlePearlClicked: Minecraft instance is null");
                return;
            }
            if (mc.player == null) {
                LOG.warn("[EnderPearlInventoryScreen] handlePearlClicked: player is null");
                return;
            }
            AbstractContainerMenu abstractContainerMenu = mc.player.containerMenu;
            if (!(abstractContainerMenu instanceof ScrollSealingMenu)) {
                LOG.warn("[EnderPearlInventoryScreen] handlePearlClicked: current containerMenu is not ScrollSealingMenu (got: {})", (Object)mc.player.containerMenu.getClass().getName());
                return;
            }
            ScrollSealingMenu menu = (ScrollSealingMenu)abstractContainerMenu;
            LOG.debug("[EnderPearlInventoryScreen] Opening attachment inventory for player={}", (Object)mc.player.getGameProfile().getName());
            mc.setScreen((Screen)new EnderPearlInventoryScreen(menu, mc.player.getInventory(), (Component)Component.literal((String)"")));
        }
        catch (Throwable t) {
            LOG.error("[EnderPearlInventoryScreen] handlePearlClicked failed", t);
        }
    }

    protected void init() {
        super.init();
        try {
            LOG.debug("[EnderPearlInventoryScreen] init at leftPos={}, topPos={}", (Object)this.leftPos, (Object)this.topPos);
            this.fadeTicks = 0;
            this.closing = false;
            this.closeActionPerformed = false;
        }
        catch (Throwable t) {
            LOG.error("[EnderPearlInventoryScreen] init failed", t);
        }
    }

    private float getFadeProgress() {
        float t = (float)this.fadeTicks / 10.0f;
        if (t < 0.0f) {
            t = 0.0f;
        }
        if (t > 1.0f) {
            t = 1.0f;
        }
        return t;
    }

    private void startClosing() {
        if (this.closing) {
            return;
        }
        LOG.debug("[EnderPearlInventoryScreen] startClosing: beginning fade-out");
        this.closing = true;
    }

    private void performCloseToScroll() {
        if (this.closeActionPerformed) {
            return;
        }
        this.closeActionPerformed = true;
        try {
            Minecraft mc = this.minecraft;
            if (mc == null || mc.player == null) {
                LOG.warn("[EnderPearlInventoryScreen] performCloseToScroll: minecraft or player null, delegating to super.onClose");
                super.onClose();
                return;
            }
            ScrollSealingMenu menu = (ScrollSealingMenu)this.menu;
            if (menu != null) {
                menu.setClientSkipIntroAnimation(true);
            }
            LOG.debug("[EnderPearlInventoryScreen] performCloseToScroll: reopening ScrollSealingScreen instead of closing container");
            mc.setScreen((Screen)new ScrollSealingScreen((ScrollSealingMenu)this.menu, mc.player.getInventory(), (Component)Component.literal((String)"Scroll Sealing")));
        }
        catch (Throwable t) {
            LOG.error("[EnderPearlInventoryScreen] performCloseToScroll failed; falling back to super.onClose", t);
            super.onClose();
        }
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        try {
            guiGraphics.blit(INVENTORY_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 176, 128);
        }
        catch (Throwable t) {
            LOG.error("[EnderPearlInventoryScreen] renderBg failed, falling back to simple fill", t);
            guiGraphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -1073741824);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        try {
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
            super.render(guiGraphics, mouseX, mouseY, partialTick);
            float fadeProgress = this.getFadeProgress();
            float overlayAlpha = 1.0f - fadeProgress;
            if (overlayAlpha > 0.0f) {
                int alphaInt;
                if (overlayAlpha > 1.0f) {
                    overlayAlpha = 1.0f;
                }
                if ((alphaInt = (int)(overlayAlpha * 255.0f)) < 0) {
                    alphaInt = 0;
                }
                if (alphaInt > 255) {
                    alphaInt = 255;
                }
                int color = alphaInt << 24;
                guiGraphics.fill(0, 0, this.width, this.height, color);
            }
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
        catch (Throwable t) {
            LOG.error("[EnderPearlInventoryScreen] render failed", t);
        }
    }

    protected void containerTick() {
        super.containerTick();
        try {
            if (!this.closing) {
                if (this.fadeTicks < 10) {
                    ++this.fadeTicks;
                }
            } else if (this.fadeTicks > 0) {
                --this.fadeTicks;
            } else {
                this.performCloseToScroll();
            }
        }
        catch (Throwable t) {
            LOG.error("[EnderPearlInventoryScreen] containerTick failed", t);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        try {
            if (this.closing) {
                return true;
            }
            if (button == 0 && (mouseX < (double)this.leftPos || mouseX >= (double)(this.leftPos + this.imageWidth) || mouseY < (double)this.topPos || mouseY >= (double)(this.topPos + this.imageHeight))) {
                LOG.debug("[EnderPearlInventoryScreen] Click outside GUI -> starting fade-out / return to ScrollSealingScreen");
                this.startClosing();
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
        catch (Throwable t) {
            LOG.error("[EnderPearlInventoryScreen] mouseClicked failed", t);
            return false;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        try {
            if (this.closing) {
                return true;
            }
            if (keyCode == 256 || keyCode == 69 || keyCode == 82 || keyCode == 85) {
                LOG.debug("[EnderPearlInventoryScreen] keyPressed {} -> starting fade-out / return to ScrollSealingScreen", (Object)keyCode);
                this.startClosing();
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        catch (Throwable t) {
            LOG.error("[EnderPearlInventoryScreen] keyPressed failed", t);
            return false;
        }
    }

    public void onClose() {
        try {
            LOG.debug("[EnderPearlInventoryScreen] onClose invoked externally; delegating to super");
            super.onClose();
        }
        catch (Throwable t) {
            LOG.error("[EnderPearlInventoryScreen] onClose failed", t);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }
}

