/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client.gui;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.z2six.featheredfriend.client.gui.widget.MultiLineScrollTextWidget;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class CalendarDayPopupOverlay {
    private static final Logger LOG = LogUtils.getLogger();
    private static final int FADE_IN_TICKS = 20;
    private static final int HOLD_TICKS = 60;
    private static final int FADE_OUT_TICKS = 20;
    private final MultiLineScrollTextWidget widget;
    private final int totalLifetimeTicks;
    private int ageTicks = 0;
    private boolean finished = false;

    public CalendarDayPopupOverlay(@NotNull Font font, @NotNull ResourceLocation gothicFontId, @NotNull String text, int screenWidth, int screenHeight) {
        this.totalLifetimeTicks = 100;
        if (text.isEmpty()) {
            LOG.warn("[CalendarDayPopupOverlay] Created with empty text; overlay will immediately finish");
            this.widget = null;
            this.finished = true;
            return;
        }
        try {
            MutableComponent comp = Component.literal((String)text);
            int textWidth = font.width((FormattedText)comp);
            Objects.requireNonNull(font);
            int textHeight = 9;
            int paddingX = 8;
            int paddingY = 4;
            int widgetWidth = textWidth + paddingX;
            int widgetHeight = textHeight + paddingY;
            int x = (screenWidth - widgetWidth) / 2;
            int y = screenHeight / 4;
            this.widget = new MultiLineScrollTextWidget(font, x, y, widgetWidth, widgetHeight, 128, 1, (Component)Component.empty(), gothicFontId, false);
            this.widget.setEditable(false);
            this.widget.setText(text);
            this.widget.setCursorToEnd();
            this.widget.setTextColor(0xFFFFFF);
            LOG.debug("[CalendarDayPopupOverlay] Created overlay for text='{}' at ({}, {}) size=({}x{})", new Object[]{text, x, y, widgetWidth, widgetHeight});
        }
        catch (Throwable t) {
            LOG.error("[CalendarDayPopupOverlay] Failed to create internal widget", t);
            throw t;
        }
    }

    public void tick() {
        if (this.finished || this.widget == null) {
            return;
        }
        try {
            ++this.ageTicks;
            this.widget.tick();
            if (this.ageTicks >= this.totalLifetimeTicks) {
                this.finished = true;
                LOG.debug("[CalendarDayPopupOverlay] Lifetime ended; marking overlay finished");
            }
        }
        catch (Throwable t) {
            LOG.error("[CalendarDayPopupOverlay] tick failed", t);
            this.finished = true;
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, float partialTick) {
        if (this.finished || this.widget == null) {
            return;
        }
        try {
            float alpha = this.computeAlpha();
            int alphaInt = Math.max(0, Math.min(255, (int)(alpha * 255.0f)));
            int color = alphaInt << 24 | 0xFFFFFF;
            this.widget.setTextColor(color);
            this.widget.render(guiGraphics, 0, 0, partialTick);
        }
        catch (Throwable t) {
            LOG.error("[CalendarDayPopupOverlay] render failed", t);
            this.finished = true;
        }
    }

    private float computeAlpha() {
        if (this.ageTicks <= 0) {
            return 0.0f;
        }
        if (this.ageTicks < 20) {
            return (float)this.ageTicks / 20.0f;
        }
        int afterFadeIn = this.ageTicks - 20;
        if (afterFadeIn < 60) {
            return 1.0f;
        }
        int afterHold = afterFadeIn - 60;
        if (afterHold >= 20) {
            return 0.0f;
        }
        float remaining = (float)(20 - afterHold) / 20.0f;
        return Math.max(0.0f, Math.min(1.0f, remaining));
    }

    public boolean isFinished() {
        return this.finished;
    }

    public int getAgeTicks() {
        return this.ageTicks;
    }
}

