/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.z2six.featheredfriend.client.gui.FeatheredFriendSettingsScreen;
import net.z2six.featheredfriend.network.FFNetwork;
import net.z2six.featheredfriend.world.TamedRavenScrollWatcher;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class FFKeyBindings {
    private static final Logger LOG = LogUtils.getLogger();
    private static KeyMapping OPEN_SETTINGS_KEY;
    private static KeyMapping WHISTLE_KEY;

    private FFKeyBindings() {
    }

    public static void register(@NotNull IEventBus modEventBus) {
        try {
            modEventBus.addListener(FFKeyBindings::onRegisterKeyMappings);
            NeoForge.EVENT_BUS.addListener(FFKeyBindings::onClientTick);
            LOG.info("[FFKeyBindings] Registered key mapping + client tick listeners.");
        }
        catch (Throwable t) {
            LOG.error("[FFKeyBindings] register() failed safely", t);
        }
    }

    private static void onRegisterKeyMappings(@NotNull RegisterKeyMappingsEvent event) {
        try {
            String category = "key.categories.featheredfriend";
            OPEN_SETTINGS_KEY = new KeyMapping("key.featheredfriend.open_settings", InputConstants.Type.KEYSYM, -1, "key.categories.featheredfriend");
            WHISTLE_KEY = new KeyMapping("key.featheredfriend.whistle", InputConstants.Type.KEYSYM, -1, "key.categories.featheredfriend");
            event.register(OPEN_SETTINGS_KEY);
            event.register(WHISTLE_KEY);
            LOG.info("[FFKeyBindings] Registered key mappings: open_settings, whistle.");
        }
        catch (Throwable t) {
            LOG.error("[FFKeyBindings] onRegisterKeyMappings failed safely", t);
        }
    }

    private static void onClientTick(@NotNull ClientTickEvent.Post event) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                return;
            }
            LocalPlayer player = mc.player;
            if (player == null) {
                return;
            }
            if (OPEN_SETTINGS_KEY != null) {
                while (OPEN_SETTINGS_KEY.consumeClick()) {
                    try {
                        LOG.info("[FFKeyBindings] Open-settings key pressed by '{}'", (Object)player.getGameProfile().getName());
                        mc.setScreen((Screen)new FeatheredFriendSettingsScreen());
                    }
                    catch (Throwable t) {
                        LOG.error("[FFKeyBindings] Failed to open settings screen", t);
                    }
                }
            }
            if (WHISTLE_KEY != null) {
                while (WHISTLE_KEY.consumeClick()) {
                    FFKeyBindings.handleWhistleKey(mc, player);
                }
            }
        }
        catch (Throwable t) {
            LOG.error("[FFKeyBindings] onClientTick failed safely", t);
        }
    }

    private static void handleWhistleKey(@NotNull Minecraft mc, @NotNull LocalPlayer player) {
        try {
            boolean holdingClientSide = false;
            try {
                holdingClientSide = TamedRavenScrollWatcher.isHoldingSealedScroll((Player)player);
            }
            catch (Throwable t) {
                LOG.warn("[FFKeyBindings] Whistle: failed to check isHoldingSealedScroll client-side for player='{}': {}", (Object)player.getGameProfile().getName(), (Object)t.toString());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("[FFKeyBindings] Whistle key pressed: sending request to server (clientHoldingSealedScroll={}) player='{}'", (Object)holdingClientSide, (Object)player.getGameProfile().getName());
            } else {
                LOG.info("[FFKeyBindings] Whistle key pressed: sending request to server player='{}'", (Object)player.getGameProfile().getName());
            }
            try {
                FFNetwork.sendWhistleForRaven();
                LOG.info("[FFKeyBindings] Sent whistle request packet for player='{}'", (Object)player.getGameProfile().getName());
            }
            catch (Throwable netErr) {
                LOG.error("[FFKeyBindings] Failed to send whistle packet for player='{}' (safe): {}", (Object)player.getGameProfile().getName(), (Object)netErr.toString());
                try {
                    player.displayClientMessage((Component)Component.literal((String)"[FeatheredFriend] Failed to whistle for your raven (network error)."), true);
                }
                catch (Throwable msgErr) {
                    LOG.warn("[FFKeyBindings] Failed to show whistle error message to '{}': {}", (Object)player.getGameProfile().getName(), (Object)msgErr.toString());
                }
            }
        }
        catch (Throwable t) {
            LOG.error("[FFKeyBindings] handleWhistleKey failed safely", t);
        }
    }
}

