/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import net.z2six.featheredfriend.network.FFPayloads;
import org.slf4j.Logger;

public final class FFClientSyncEvents {
    private static final Logger LOG = LogUtils.getLogger();
    private static volatile boolean REGISTERED = false;
    private static volatile boolean REQUEST_PENDING = false;
    private static volatile boolean REQUEST_SENT_THIS_SESSION = false;

    private FFClientSyncEvents() {
    }

    public static void registerGameBus() {
        try {
            if (REGISTERED) {
                LOG.debug("[FFClientSyncEvents] already registered; skipping");
                return;
            }
            NeoForge.EVENT_BUS.register(FFClientSyncEvents.class);
            REGISTERED = true;
            LOG.info("[FFClientSyncEvents] Registered on NeoForge EVENT_BUS");
        }
        catch (Throwable t) {
            LOG.error("[FFClientSyncEvents] registerGameBus failed safely", t);
        }
    }

    @SubscribeEvent
    public static void onClientLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        try {
            REQUEST_PENDING = true;
            REQUEST_SENT_THIS_SESSION = false;
            try {
                FFPayloads.ClientState.clear();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LOG.info("[FFClientSyncEvents] LoggingIn: marked settings request pending");
        }
        catch (Throwable t) {
            LOG.error("[FFClientSyncEvents] onClientLoggingIn failed safely", t);
        }
    }

    @SubscribeEvent
    public static void onClientLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        try {
            REQUEST_PENDING = false;
            REQUEST_SENT_THIS_SESSION = false;
            try {
                FFPayloads.ClientState.clear();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LOG.info("[FFClientSyncEvents] LoggingOut: cleared pending flags + cache");
        }
        catch (Throwable t) {
            LOG.error("[FFClientSyncEvents] onClientLoggingOut failed safely", t);
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        try {
            if (!REQUEST_PENDING || REQUEST_SENT_THIS_SESSION) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                return;
            }
            LocalPlayer player = mc.player;
            if (player == null) {
                return;
            }
            if (mc.level == null) {
                return;
            }
            if (mc.getConnection() == null) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new FFPayloads.RequestServerSettingsPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            REQUEST_SENT_THIS_SESSION = true;
            REQUEST_PENDING = false;
            LOG.info("[FFClientSyncEvents] Sent RequestServerSettingsPayload (safe tick)");
        }
        catch (Throwable t) {
            LOG.error("[FFClientSyncEvents] onClientTick failed safely; will retry next tick", t);
        }
    }
}

