/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client;

import com.mojang.logging.LogUtils;
import org.slf4j.Logger;

public final class FFClientSettingsCache {
    private static final Logger LOG = LogUtils.getLogger();
    private static volatile boolean hasServerSettings = false;
    private static volatile boolean chatDisabled = true;
    private static volatile boolean canEditChat = false;
    private static volatile long lastUpdateMillis = 0L;

    public static boolean hasServerSettings() {
        return hasServerSettings;
    }

    public static boolean isChatDisabled() {
        return chatDisabled;
    }

    public static boolean canEditChat() {
        return canEditChat;
    }

    public static long getLastUpdateMillis() {
        return lastUpdateMillis;
    }

    public static void applyFromServer(boolean newChatDisabled, boolean newCanEditChat) {
        try {
            hasServerSettings = true;
            chatDisabled = newChatDisabled;
            canEditChat = newCanEditChat;
            lastUpdateMillis = System.currentTimeMillis();
            LOG.info("[FFClientSettingsCache] Updated from server: chatDisabled={} canEditChat={}", (Object)chatDisabled, (Object)canEditChat);
        }
        catch (Throwable t) {
            LOG.error("[FFClientSettingsCache] applyFromServer failed safely", t);
        }
    }

    private FFClientSettingsCache() {
    }
}

