/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client;

import com.mojang.logging.LogUtils;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.z2six.featheredfriend.client.gui.ScrollSealingScreen;
import net.z2six.featheredfriend.client.gui.ScrollViewScreen;
import net.z2six.featheredfriend.client.gui.SealStampScreen;
import net.z2six.featheredfriend.neoforge.menu.ScrollSealingMenu;
import net.z2six.featheredfriend.neoforge.menu.ScrollViewMenu;
import net.z2six.featheredfriend.neoforge.menu.SealStampMenu;
import net.z2six.featheredfriend.registry.FFNeoForgeMenus;
import org.slf4j.Logger;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD, modid="featheredfriend")
public final class ClientScreens {
    private static final Logger LOG = LogUtils.getLogger();

    private ClientScreens() {
    }

    @SubscribeEvent
    public static void onRegisterMenuScreens(RegisterMenuScreensEvent event) {
        LOG.info("[ClientScreens] onRegisterMenuScreens fired for modId='{}'", (Object)"featheredfriend");
        try {
            LOG.info("[ClientScreens] Registering screen for menu type: {} (scroll_sealing)", (Object)FFNeoForgeMenus.SCROLL_SEALING_MENU.get().toString());
            event.register(FFNeoForgeMenus.SCROLL_SEALING_MENU.get(), (menu, inv, title) -> new ScrollSealingScreen((ScrollSealingMenu)menu, inv, title));
            LOG.info("[ClientScreens] Successfully registered ScrollSealingScreen");
        }
        catch (Throwable t) {
            LOG.error("[ClientScreens] Failed to register ScrollSealingScreen", t);
        }
        try {
            LOG.info("[ClientScreens] Registering screen for menu type: {} (seal_stamp)", (Object)FFNeoForgeMenus.SEAL_STAMP_MENU.get().toString());
            event.register(FFNeoForgeMenus.SEAL_STAMP_MENU.get(), (menu, inv, title) -> new SealStampScreen((SealStampMenu)menu, inv, title));
            LOG.info("[ClientScreens] Successfully registered SealStampScreen");
        }
        catch (Throwable t) {
            LOG.error("[ClientScreens] Failed to register SealStampScreen", t);
        }
        try {
            LOG.info("[ClientScreens] Registering screen for menu type: {} (scroll_view)", (Object)FFNeoForgeMenus.SCROLL_VIEW_MENU.get().toString());
            event.register(FFNeoForgeMenus.SCROLL_VIEW_MENU.get(), (menu, inv, title) -> new ScrollViewScreen((ScrollViewMenu)menu, inv, title));
            LOG.info("[ClientScreens] Successfully registered ScrollViewScreen");
        }
        catch (Throwable t) {
            LOG.error("[ClientScreens] Failed to register ScrollViewScreen", t);
        }
    }
}

