/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.client;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.z2six.featheredfriend.config.FFCalendarConfig;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@EventBusSubscriber(modid="featheredfriend", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public final class ClientCalendarEvents {
    private static final Logger LOG = LogUtils.getLogger();
    private static final int FADE_IN_TICKS = 20;
    private static final int HOLD_TICKS = 60;
    private static final int FADE_OUT_TICKS = 20;
    private static final int TOTAL_TICKS = 100;
    private static long lastSeenDayIndex = -1L;
    private static Component currentMessage = null;
    private static int popupAgeTicks = 0;
    private static boolean popupActive = false;
    private static final ResourceLocation GOTHIC_FONT_ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"gothic12");

    private ClientCalendarEvents() {
    }

    @SubscribeEvent
    public static void onClientTick(@NotNull ClientTickEvent.Post event) {
        try {
            long dayIndex;
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.level == null || mc.player == null) {
                return;
            }
            long dayTime = mc.level.getDayTime();
            long ticksPerDay = 24000L;
            if (ticksPerDay <= 0L) {
                LOG.warn("[ClientCalendarEvents] FFCalendarConfig.TICKS_PER_DAY <= 0 ({}), using 24000 fallback", (Object)ticksPerDay);
                ticksPerDay = 24000L;
            }
            if ((dayIndex = dayTime / ticksPerDay) != lastSeenDayIndex) {
                long old = lastSeenDayIndex;
                lastSeenDayIndex = dayIndex;
                LOG.info("[ClientCalendarEvents] Detected new day: oldDayIndex={} newDayIndex={}", (Object)old, (Object)dayIndex);
                Component msg = ClientCalendarEvents.buildDateMessage(dayIndex);
                ClientCalendarEvents.startPopup(msg);
            }
            if (popupActive && ++popupAgeTicks >= 100) {
                popupActive = false;
                currentMessage = null;
                popupAgeTicks = 0;
                LOG.debug("[ClientCalendarEvents] Popup finished");
            }
        }
        catch (Throwable t) {
            LOG.error("[ClientCalendarEvents] onClientTick failed", t);
        }
    }

    @SubscribeEvent
    public static void onRenderGui(@NotNull RenderGuiEvent.Post event) {
        try {
            if (!popupActive || currentMessage == null) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.player == null || mc.level == null) {
                return;
            }
            if (mc.options.hideGui) {
                return;
            }
            int alpha = ClientCalendarEvents.computeCurrentAlpha();
            if (alpha <= 0) {
                return;
            }
            GuiGraphics g = event.getGuiGraphics();
            Font font = mc.font;
            MutableComponent styled = currentMessage.copy().setStyle(Style.EMPTY.withFont(GOTHIC_FONT_ID));
            int screenWidth = mc.getWindow().getGuiScaledWidth();
            int textWidth = font.width((FormattedText)styled);
            Objects.requireNonNull(font);
            int textHeight = 9;
            int x = (screenWidth - textWidth) / 2;
            int y = 24;
            int argb = alpha << 24 | 0xFFFFFF;
            int shadowArgb = alpha << 24 | 0x101010;
            g.drawString(font, (Component)styled, x + 1, y + 1, shadowArgb, false);
            g.drawString(font, (Component)styled, x, y, argb, false);
            ClientCalendarEvents.drawDecorativeOrnament(g, x, y, textWidth, textHeight, alpha);
        }
        catch (Throwable t) {
            LOG.error("[ClientCalendarEvents] onRenderGui failed", t);
        }
    }

    private static void startPopup(@NotNull Component message) {
        try {
            currentMessage = message;
            popupAgeTicks = 0;
            popupActive = true;
            LOG.info("[ClientCalendarEvents] Starting popup with message='{}'", (Object)message.getString());
        }
        catch (Throwable t) {
            LOG.error("[ClientCalendarEvents] startPopup failed", t);
        }
    }

    private static int computeCurrentAlpha() {
        try {
            if (!popupActive) {
                return 0;
            }
            int t = popupAgeTicks;
            if (t < 0 || t >= 100) {
                return 0;
            }
            if (t < 20) {
                float f = (float)t / 20.0f;
                int alpha = (int)(f * 255.0f);
                return Math.max(0, Math.min(255, alpha));
            }
            if (t < 80) {
                return 255;
            }
            int outT = t - 20 - 60;
            float f = 1.0f - (float)outT / 20.0f;
            int alpha = (int)(f * 255.0f);
            return Math.max(0, Math.min(255, alpha));
        }
        catch (Throwable t) {
            LOG.error("[ClientCalendarEvents] computeCurrentAlpha failed", t);
            return 0;
        }
    }

    private static void drawDecorativeOrnament(@NotNull GuiGraphics g, int textX, int textY, int textWidth, int textHeight, int alpha) {
        try {
            if (alpha <= 0) {
                return;
            }
            int ornamentColor = alpha << 24 | 0xE0D0B0;
            int centerY = textY + textHeight / 2;
            int gap = 6;
            int barLength = 40;
            int barThickness = 2;
            int leftBarEndX = textX - gap;
            int leftBarStartX = leftBarEndX - barLength;
            int rightBarStartX = textX + textWidth + gap;
            int rightBarEndX = rightBarStartX + barLength;
            int barTop = centerY - barThickness / 2;
            int barBottom = barTop + barThickness;
            g.fill(leftBarStartX, barTop, leftBarEndX, barBottom, ornamentColor);
            g.fill(rightBarStartX, barTop, rightBarEndX, barBottom, ornamentColor);
            g.fill(leftBarEndX, barTop - 1, leftBarEndX + 1, barTop, ornamentColor);
            g.fill(leftBarEndX, barBottom, leftBarEndX + 1, barBottom + 1, ornamentColor);
            g.fill(rightBarStartX - 1, barTop - 1, rightBarStartX, barTop, ornamentColor);
            g.fill(rightBarStartX - 1, barBottom, rightBarStartX, barBottom + 1, ornamentColor);
            int centerX = textX + textWidth / 2;
            int diamondY = textY + textHeight + 3;
            g.fill(centerX, diamondY - 1, centerX + 1, diamondY + 2, ornamentColor);
            g.fill(centerX - 1, diamondY, centerX + 2, diamondY + 1, ornamentColor);
        }
        catch (Throwable t) {
            LOG.error("[ClientCalendarEvents] drawDecorativeOrnament failed", t);
        }
    }

    @NotNull
    public static Component buildDateMessage(long dayIndex) {
        try {
            long totalDaysPerYear;
            int daysPerMonth = FFCalendarConfig.getDaysPerMonth();
            int monthsPerYear = FFCalendarConfig.MONTHS_PER_YEAR;
            if (daysPerMonth <= 0) {
                LOG.warn("[ClientCalendarEvents] buildDateMessage: daysPerMonth <= 0 ({}), falling back to {}", (Object)daysPerMonth, (Object)28);
                daysPerMonth = 28;
            }
            if (monthsPerYear <= 0) {
                LOG.warn("[ClientCalendarEvents] buildDateMessage: monthsPerYear <= 0 ({}), falling back to 8", (Object)monthsPerYear);
                monthsPerYear = 8;
            }
            if ((totalDaysPerYear = (long)daysPerMonth * (long)monthsPerYear) <= 0L) {
                LOG.warn("[ClientCalendarEvents] buildDateMessage: totalDaysPerYear <= 0, forcing safe fallback");
                totalDaysPerYear = (long)daysPerMonth * 8L;
            }
            if (dayIndex < 0L) {
                LOG.warn("[ClientCalendarEvents] buildDateMessage: dayIndex < 0 ({}), clamping to 0", (Object)dayIndex);
                dayIndex = 0L;
            }
            long yearIndex = dayIndex / totalDaysPerYear;
            int yearNumber = (int)(yearIndex + 1L);
            int dayOfYear = (int)(dayIndex % totalDaysPerYear);
            int monthIndex = dayOfYear / daysPerMonth;
            int dayOfMonth = dayOfYear % daysPerMonth + 1;
            if (monthIndex < 0) {
                monthIndex = 0;
            } else if (monthIndex >= monthsPerYear) {
                monthIndex = monthsPerYear - 1;
            }
            String monthName = FFCalendarConfig.getMonthName(monthIndex);
            String suffix = FFCalendarConfig.getYearSuffix();
            String text = "Day " + dayOfMonth + " of " + monthName + ", " + yearNumber + " " + suffix;
            return Component.literal((String)text);
        }
        catch (Throwable t) {
            LOG.error("[ClientCalendarEvents] buildDateMessage failed, using fallback text", t);
            return Component.literal((String)"A New Day Dawns");
        }
    }
}

